/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.TreeMap;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABoxTest;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ISearchVol;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSegRTreeTest;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.RTree;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.TrimmedCurve3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.AModelObj;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.CloneMap;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Edge;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.EdgeUse;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.FaceLoop;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.NmtUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Triangulation;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Vertex;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.CollResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Model
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static final int SEARCHACTION_ADD = 0;
    public static final int SEARCHACTION_UPDATE = 1;
    public static final int SEARCHACTION_REMOVE = 2;
    public static final double POINT_TOL = 1.0E-6;
    public static final double CURVE_TOL = 2.0E-6;
    static final boolean DEBUG = false;
    private transient GeomSearcher<Face> d_faceSearch = Model.newSearcher();
    private transient GeomSearcher<Edge> d_edgeSearch = Model.newSearcher();
    private transient GeomSearcher<Vertex> d_vertSearch = Model.newSearcher();
    private Group d_mainGroup = new Group(-1, LinkedIdentityHashSet.class);
    public static double t_pointInFace = 0.0;
    public static int t_nPointInFace = 0;

    private static <T extends AModelObj> GeomSearcher<T> newSearcher() {
        return new TreeSearcher();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (Face face : this.d_mainGroup.faces) {
            face.writeTopology(out);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.writeTopology(out);
        }
        for (Vertex vert : this.d_mainGroup.verts) {
            vert.writeTopology(out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (Face face : this.d_mainGroup.faces) {
            face.readTopology(in);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.readTopology(in);
        }
        for (Vertex vert : this.d_mainGroup.verts) {
            vert.readTopology(in);
        }
        this.d_faceSearch = Model.newSearcher();
        this.d_edgeSearch = Model.newSearcher();
        this.d_vertSearch = Model.newSearcher();
        for (Face face : this.d_mainGroup.faces) {
            this.updateFaceSearch(face, 0);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            this.updateEdgeSearch(edge, 0);
        }
        for (Vertex vert : this.d_mainGroup.verts) {
            this.updateVertexSearch(vert, 0);
        }
    }

    public void addGroupId(int groupid) {
        for (Vertex vert : this.d_mainGroup.verts) {
            vert.addGroup(groupid);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.addGroup(groupid);
        }
        for (Face face : this.d_mainGroup.faces) {
            face.addGroup(groupid);
        }
    }

    public void removeGroupIds(int ... groupids) {
        for (Vertex vert : this.d_mainGroup.verts) {
            vert.removeGroups(groupids);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.removeGroups(groupids);
        }
        for (Face face : this.d_mainGroup.faces) {
            face.removeGroups(groupids);
        }
    }

    public Object clone() {
        Model clone;
        try {
            clone = (Model)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.d_mainGroup = new Group(this.d_mainGroup.id, LinkedIdentityHashSet.class);
        CloneMap cloneMap = new CloneMap();
        for (Vertex vert : this.d_mainGroup.verts) {
            Vertex vclone = (Vertex)vert.clone();
            cloneMap.put(vert, vclone);
            clone.d_mainGroup.verts.add(vclone);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            Edge eclone = edge.clone(cloneMap);
            cloneMap.put(edge, eclone);
            eclone.buildConnections();
            clone.d_mainGroup.edges.add(eclone);
        }
        for (Face face : this.d_mainGroup.faces) {
            Face fclone = face.clone(cloneMap);
            cloneMap.put(face, fclone);
            fclone.buildConnections();
            clone.d_mainGroup.faces.add(fclone);
        }
        clone.d_vertSearch = this.d_vertSearch.clone(cloneMap.getVertMap());
        clone.d_edgeSearch = this.d_edgeSearch.clone(cloneMap.getEdgeMap());
        clone.d_faceSearch = this.d_faceSearch.clone(cloneMap.getFaceMap());
        return clone;
    }

    public void clear() {
        this.d_faceSearch.clear();
        this.d_edgeSearch.clear();
        this.d_vertSearch.clear();
        this.d_mainGroup.clear();
    }

    public Collection<Face> getFaces() {
        return this.d_mainGroup.faces;
    }

    public Collection<Edge> getEdges() {
        return this.d_mainGroup.edges;
    }

    public Collection<Vertex> getVerts() {
        return this.d_mainGroup.verts;
    }

    public AABox getBoundingBox() {
        AABox bb = new AABox();
        bb.add(this.d_vertSearch.getBounds());
        bb.add(this.d_edgeSearch.getBounds());
        bb.add(this.d_faceSearch.getBounds());
        return bb;
    }

    public void divideEdges(double maxEdgeLength) {
        Edge[] edges;
        if (maxEdgeLength == Double.MAX_VALUE || Double.isInfinite(maxEdgeLength) || maxEdgeLength <= 0.0) {
            return;
        }
        for (Edge edge : edges = this.d_mainGroup.edges.toArray(new Edge[this.d_mainGroup.edges.size()])) {
            this.divideEdge(edge, maxEdgeLength);
        }
    }

    private void divideEdge(Edge edge, double maxLength) {
        double totalLength = edge.curve.length();
        if (totalLength > maxLength) {
            double numDiv = totalLength / maxLength;
            double floor = Math.floor(numDiv);
            double rem = numDiv - floor;
            numDiv = theUtil.gt0(rem, 1.0E-6) ? floor + 1.0 : floor;
            IParametric3D originalCurve = edge.curve;
            int[] groups = edge.groups;
            double[] ts = new double[(int)numDiv - 1];
            Vertex[] verts = new Vertex[ts.length];
            int m = 1;
            while ((double)m < numDiv) {
                double t;
                ts[m - 1] = t = (double)m / numDiv;
                verts[m - 1] = this.addVertexToRegion(originalCurve.get(t), groups);
                ++m;
            }
            this.addVerticesToEdge(edge, ts, verts);
        }
    }

    public Triangulation triangulate(double minEdgeAngleDeg) {
        LinkedHashMap<Point3d, Integer> pointIxMap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> resultTris = new ArrayList<Integer>();
        for (Face face : this.d_mainGroup.faces) {
            face.triangulate(minEdgeAngleDeg, pointIxMap, resultTris);
        }
        return new Triangulation(pointIxMap.keySet().toArray(new Point3d[pointIxMap.size()]), theUtil.toIntArray(resultTris));
    }

    public void addEdges(int groupid, Collection<? extends IParametric3D> curves) {
        Model tempModel = new Model();
        for (IParametric3D iParametric3D : curves) {
            this.addEdge(groupid, iParametric3D, tempModel);
        }
    }

    public void addEdge(int groupid, IParametric3D curve) {
        Model tempModel = new Model();
        this.addEdge(groupid, curve, tempModel);
    }

    private boolean addEdge(int groupid, IParametric3D curve, Model tempModel) {
        if (curve.length() < 1.0E-6) {
            return false;
        }
        Point3d p1 = curve.get(0.0);
        Point3d p2 = curve.get(1.0);
        tempModel.clear();
        Vertex v1 = tempModel.addVertexToRegion(p1, groupid);
        Vertex v2 = tempModel.addVertexToRegion(p2, groupid);
        tempModel.addEdgeToRegion(curve, v1, v2, groupid);
        this.merge(tempModel);
        return true;
    }

    public void addFace(Face face, int ... groupid) {
        int[] groups;
        Model tempModel = new Model();
        IdentityHashMap<Vertex, Vertex> vertMap = new IdentityHashMap<Vertex, Vertex>();
        IdentityHashMap<Edge, Edge> edgeMap = new IdentityHashMap<Edge, Edge>();
        for (FaceLoop loop : face.edgeLoops) {
            for (Vertex vert : loop.getVerts()) {
                if (vertMap.containsKey(vert)) continue;
                groups = groupid.length == 0 ? vert.groups : groupid;
                Vertex vert2 = tempModel.addVertexToRegion(vert.loc, groups);
                vertMap.put(vert, vert2);
            }
        }
        for (FaceLoop loop : face.edgeLoops) {
            for (EdgeUse eu : loop.edges) {
                if (edgeMap.containsKey(eu.edge)) continue;
                groups = groupid.length == 0 ? eu.edge.groups : groupid;
                Edge edge = tempModel.addEdgeToRegion(eu.edge.curve, (Vertex)vertMap.get(eu.edge.v1), (Vertex)vertMap.get(eu.edge.v2), groups);
                edgeMap.put(eu.edge, edge);
            }
        }
        ArrayList<Vertex> singleVertLoops = new ArrayList<Vertex>();
        ArrayList<EdgeUse> edges = new ArrayList<EdgeUse>();
        for (FaceLoop loop : face.edgeLoops) {
            if (loop.vert != null) {
                singleVertLoops.add((Vertex)vertMap.get(loop.vert));
            }
            for (EdgeUse eu : loop.edges) {
                Edge edge = (Edge)edgeMap.get(eu.edge);
                edges.add(new EdgeUse(edge, eu.orient));
            }
        }
        int[] groups2 = groupid.length == 0 ? face.groups : groupid;
        tempModel.addFaceToRegion(face.plane, edges, singleVertLoops, groups2);
        this.merge(tempModel);
    }

    public void deleteFace(Face face, boolean deleteDanglingEdges, boolean deleteDanglingVerts) {
        this.updateFaceSearch(face, 2);
        face.clearConnections();
        this.d_mainGroup.faces.remove(face);
        if (deleteDanglingEdges || deleteDanglingVerts) {
            for (FaceLoop loop : face.edgeLoops) {
                if (loop.vert != null && deleteDanglingVerts && !loop.vert.isConnected()) {
                    this.deleteVertex(loop.vert);
                    continue;
                }
                for (EdgeUse eu : loop.edges) {
                    if (eu.edge.isConnected()) continue;
                    this.deleteEdge(eu.edge, deleteDanglingVerts);
                }
            }
        }
    }

    public void deleteEdge(Edge edge, boolean deleteDanglingVerts) {
        assert (edge.faces.isEmpty());
        this.updateEdgeSearch(edge, 2);
        edge.clearConnections();
        this.d_mainGroup.edges.remove(edge);
        if (deleteDanglingVerts) {
            if (!edge.v1.isConnected()) {
                this.deleteVertex(edge.v1);
            }
            if (!edge.v2.isConnected()) {
                this.deleteVertex(edge.v2);
            }
        }
    }

    public void deleteVertex(Vertex vert) {
        assert (vert.edges.isEmpty() && vert.face == null);
        this.updateVertexSearch(vert, 2);
        this.d_mainGroup.verts.remove(vert);
    }

    public boolean addPolygonFace(int groupid, Plane3d plane, Point3d ... points) {
        if ((points = Util3D.deleteDupPoints(2.0E-6, true, points)).length < 3) {
            return false;
        }
        if (points.length == 3) {
            Vector3d dir1 = Util3D.vector(points[0], points[1]);
            double distSq = Inter3D.distSqToNearestPtOnLine(points[0], dir1, points[2]);
            if (distSq < 1.0E-6) {
                return false;
            }
            Model tempMod = new Model();
            Vertex v1 = tempMod.addVertexToRegion(points[0], groupid);
            Vertex v2 = tempMod.addVertexToRegion(points[1], groupid);
            Vertex v3 = tempMod.addVertexToRegion(points[2], groupid);
            Edge e1 = tempMod.addEdgeToRegion(new LineSeg3D(points[0], points[1]), v1, v2, groupid);
            Edge e2 = tempMod.addEdgeToRegion(new LineSeg3D(points[1], points[2]), v2, v3, groupid);
            Edge e3 = tempMod.addEdgeToRegion(new LineSeg3D(points[2], points[0]), v3, v1, groupid);
            EdgeUse eu1 = new EdgeUse(e1, true);
            EdgeUse eu2 = new EdgeUse(e2, true);
            EdgeUse eu3 = new EdgeUse(e3, true);
            tempMod.addFaceToRegion(plane, Arrays.asList(eu1, eu2, eu3), (List<Vertex>)Collections.EMPTY_LIST, false, groupid);
            this.merge(tempMod);
            return true;
        }
        if (Util3D.isConvex(1.0E-6, points)) {
            Model tempMod = new Model();
            Vertex[] verts = new Vertex[points.length];
            for (int m = 0; m < points.length; ++m) {
                verts[m] = tempMod.addVertexToRegion(points[m], groupid);
            }
            ArrayList<EdgeUse> eus = new ArrayList<EdgeUse>(points.length);
            for (int m = 0; m < points.length; ++m) {
                int n = (m + 1) % points.length;
                Point3d p1 = points[m];
                Point3d p2 = points[n];
                Vertex v1 = verts[m];
                Vertex v2 = verts[n];
                Edge edge = tempMod.addEdgeToRegion(new LineSeg3D(p1, p2), v1, v2, groupid);
                eus.add(new EdgeUse(edge, true));
            }
            tempMod.addFaceToRegion(plane, eus, (List<Vertex>)Collections.EMPTY_LIST, false, groupid);
            this.merge(tempMod);
            return true;
        }
        return this.addFace(groupid, plane, NmtUtil.toCurves(points));
    }

    public boolean addFace(int groupid, Plane3d plane, Collection<? extends IParametric3D> boundary) {
        Matrix4d wpXform = Util.getWorldToLocalXform(plane);
        AABox bb = new AABox();
        for (IParametric3D iParametric3D : boundary) {
            bb.add(Util3D.xform(wpXform, iParametric3D.get(0.0)));
            bb.add(Util3D.xform(wpXform, iParametric3D.get(1.0)));
        }
        if (bb.getMinX() >= bb.getMaxX() || bb.getMinY() >= bb.getMaxY()) {
            return false;
        }
        double width = bb.getMaxX() - bb.getMinX();
        double height = bb.getMaxY() - bb.getMinY();
        bb.set(new Point3d(bb.getMinX() - width * 0.5, bb.getMinY() - height * 0.5, 0.0), new Point3d(bb.getMaxX() + width * 0.5, bb.getMaxY() + height * 0.5, 0.0));
        Matrix4d pwXform = Util.getLocalToWorldXform(plane);
        Point3d[] aaLocalBoundaryPoints = new Point3d[]{Util3D.xformEq(pwXform, new Point3d(bb.getMinX(), bb.getMinY(), 0.0)), Util3D.xformEq(pwXform, new Point3d(bb.getMaxX(), bb.getMinY(), 0.0)), Util3D.xformEq(pwXform, new Point3d(bb.getMaxX(), bb.getMaxY(), 0.0)), Util3D.xformEq(pwXform, new Point3d(bb.getMinX(), bb.getMaxY(), 0.0))};
        int outerid = groupid == 0 ? Integer.MAX_VALUE : 0;
        Model tempModel = new Model();
        Vertex[] aaLocalBoundaryVerts = new Vertex[4];
        for (int m = 0; m < 4; ++m) {
            aaLocalBoundaryVerts[m] = tempModel.addVertexToRegion(aaLocalBoundaryPoints[m], outerid);
        }
        ArrayList<EdgeUse> aaLocalBoundaryEdges = new ArrayList<EdgeUse>(4);
        for (int m = 0; m < 4; ++m) {
            Vertex v1 = aaLocalBoundaryVerts[m];
            Vertex v2 = aaLocalBoundaryVerts[(m + 1) % 4];
            LineSeg3D curve = new LineSeg3D(v1.loc, v2.loc);
            Edge edge = tempModel.addEdgeToRegion(curve, v1, v2, outerid);
            aaLocalBoundaryEdges.add(new EdgeUse(edge, true));
        }
        tempModel.addFaceToRegion(plane, aaLocalBoundaryEdges, (List<Vertex>)Collections.EMPTY_LIST, outerid);
        tempModel.addEdges(groupid, boundary);
        Face outerFace = null;
        for (Edge edge : tempModel.getEdges()) {
            if (edge.groups.length != 1 || edge.groups[0] != outerid || edge.faces.isEmpty()) continue;
            assert (edge.faces.size() == 1);
            outerFace = edge.faces.get(0);
            break;
        }
        Map<Face, Integer> faceClasses = Model.classifyFaces(tempModel, outerFace);
        boolean faceFound = false;
        for (Map.Entry<Face, Integer> entry : faceClasses.entrySet()) {
            if (entry.getValue() % 2 == 0) continue;
            this.addFace(entry.getKey(), groupid);
            faceFound = true;
        }
        return faceFound;
    }

    private static Map<Face, Integer> classifyFaces(Model model, Face outerFace) {
        IdentityHashMap<Face, Integer> faceClassMap = new IdentityHashMap<Face, Integer>();
        Stack<Face> neighbors = new Stack<Face>();
        Stack<Face> working = new Stack<Face>();
        working.push(outerFace);
        int level = 0;
        while (!working.isEmpty()) {
            Face face = (Face)working.pop();
            if (!faceClassMap.containsKey(face)) {
                faceClassMap.put(face, level);
                for (FaceLoop loop : face.edgeLoops) {
                    for (EdgeUse eu : loop.edges) {
                        for (Face adjFace : eu.edge.faces) {
                            if (adjFace == face || faceClassMap.containsKey(adjFace)) continue;
                            neighbors.push(adjFace);
                        }
                    }
                }
            }
            if (!working.isEmpty()) continue;
            ++level;
            Stack<Face> temp = working;
            working = neighbors;
            neighbors = temp;
        }
        return faceClassMap;
    }

    private static Point3d findPointInLoop(Plane3d plane, List<IParametric3D> loop) {
        for (IParametric3D curve1 : loop) {
            Point3d p1 = curve1.get(0.0);
            for (IParametric3D curve2 : loop) {
                Point3d p2 = curve2.get(0.5);
                Point3d mid = Util3D.getMidPoint(p1, p2);
                if (Model.pointOnLoop(mid, loop) || !Model.pointInLoop(loop, plane, mid)) continue;
                return mid;
            }
        }
        return null;
    }

    public Point3d findPointInFace(Face face) {
        List<EdgeUse> edges = face.getEdges();
        for (int m = 0; m < edges.size(); ++m) {
            Point3d p1 = edges.get((int)m).edge.curve.get(0.0);
            for (int n = 0; n < edges.size(); ++n) {
                Point3d p2;
                Point3d mid;
                if (m == n || Model.compare(mid = Util3D.getMidPoint(p1, p2 = edges.get((int)n).edge.curve.get(0.5)), p1) || Model.compare(mid, p2) || this.pointOnBoundary(mid, face) || this.pointInFace(face, mid) == null) continue;
                return mid;
            }
        }
        return null;
    }

    private static List<IParametric3D> getSegs(Map<Point3d, List<IParametric3D>> map, Point3d p) {
        List<IParametric3D> segs = map.get(p);
        if (segs == null) {
            segs = new ArrayList<IParametric3D>();
            map.put(p, segs);
        }
        return segs;
    }

    private void addToGroups(AModelObj obj, int ... groupIds) {
        obj.addGroups(groupIds);
        this.d_mainGroup.add(obj);
    }

    public Group getGroup(int id) {
        return this.getGroup(id, true, true, true);
    }

    public Group getGroup(int id, boolean faces, boolean edges, boolean verts) {
        Group group = new Group(id, ArrayList.class);
        if (faces) {
            for (Face face : this.d_mainGroup.faces) {
                if (!face.partOfGroup(id)) continue;
                group.faces.add(face);
            }
        }
        if (edges) {
            for (Edge edge : this.d_mainGroup.edges) {
                if (!edge.partOfGroup(id)) continue;
                group.edges.add(edge);
            }
        }
        if (verts) {
            for (Vertex vert : this.d_mainGroup.verts) {
                if (!vert.partOfGroup(id)) continue;
                group.verts.add(vert);
            }
        }
        return group;
    }

    private Edge[] addVerticesToEdge(Edge edge, double[] t, Vertex[] verts) {
        assert (t.length == verts.length);
        Edge[] newEdges = new Edge[verts.length];
        double prevt = 0.0;
        Edge prevEdge = edge;
        for (int m = 0; m < t.length; ++m) {
            double currt = t[m];
            Vertex currVert = verts[m];
            double modt = (currt - prevt) / (1.0 - prevt);
            newEdges[m] = this.addVertexToEdge(prevEdge, modt, currVert);
            prevEdge = newEdges[m];
            prevt = currt;
        }
        return newEdges;
    }

    private Edge addVertexToEdge(Edge edge, double t, Vertex vert) {
        Vertex oldVert = edge.v2;
        TrimmedCurve3D subCurve1 = new TrimmedCurve3D(edge.curve, 0.0, t);
        TrimmedCurve3D subCurve2 = new TrimmedCurve3D(edge.curve, t, 1.0);
        edge.curve = subCurve1;
        edge.v2 = vert;
        oldVert.edges.remove(edge);
        vert.addEdge(edge);
        this.updateEdgeSearch(edge, 1);
        Edge newEdge = this.addEdgeToRegion(subCurve2, vert, oldVert, edge.groups);
        newEdge.faces.addAll(edge.faces);
        vert.addEdge(newEdge);
        for (Face face : edge.faces) {
            boolean internal = face.isInternalEdge(edge);
            for (FaceLoop loop : face.edgeLoops) {
                ListIterator<EdgeUse> euit = loop.edges.listIterator();
                while (euit.hasNext()) {
                    EdgeUse use = euit.next();
                    if (use.edge != edge) continue;
                    EdgeUse newUse = new EdgeUse(newEdge, use.orient);
                    if (!use.orient) {
                        euit.set(newUse);
                        euit.add(use);
                        continue;
                    }
                    euit.add(newUse);
                }
            }
            if (internal) {
                face.addInternalEdge(newEdge);
            }
            if (face.isValid()) continue;
            System.err.println("0a Invalid face orient");
        }
        return newEdge;
    }

    public boolean removeVertexFromEdges(Vertex sharedVert) {
        if (sharedVert.edges.size() != 2) {
            return false;
        }
        Edge edge1 = sharedVert.edges.get(0);
        Edge edge2 = sharedVert.edges.get(1);
        Vertex v1 = sharedVert == edge1.v1 ? edge1.v2 : edge1.v1;
        Vertex v2 = sharedVert == edge2.v1 ? edge2.v2 : edge2.v1;
        LineSeg3D mergedCurve = new LineSeg3D(v1.loc, v2.loc);
        Edge newEdge = this.addEdgeToRegion(mergedCurve, v1, v2, NmtUtil.mergeGroupIds(edge1.groups, edge2.groups));
        if (!edge1.faces.isEmpty()) {
            assert (!edge2.faces.isEmpty());
            for (Face face : edge1.faces) {
                boolean internal = face.isInternalEdge(edge1);
                assert (internal == face.isInternalEdge(edge2));
                if (internal) {
                    face.removeInternalEdge(edge1);
                    face.removeInternalEdge(edge2);
                }
                for (FaceLoop loop : face.edgeLoops) {
                    for (int m = 0; m < loop.edges.size(); ++m) {
                        int ix1 = m;
                        int ix2 = (m + 1) % loop.edges.size();
                        EdgeUse eu1 = loop.edges.get(ix1);
                        EdgeUse eu2 = loop.edges.get(ix2);
                        if ((eu1.edge != edge1 || eu2.edge != edge2) && (eu1.edge != edge2 || eu2.edge != edge1)) continue;
                        boolean orient = eu1.v1() == v1;
                        EdgeUse neweu = new EdgeUse(newEdge, orient);
                        if (ix2 > ix1) {
                            loop.edges.remove(ix2);
                            loop.edges.remove(ix1);
                            loop.edges.add(ix1, neweu);
                            continue;
                        }
                        loop.edges.remove(ix1);
                        loop.edges.remove(ix2);
                        loop.edges.add(ix1 - 1, neweu);
                    }
                }
                newEdge.faces.add(face);
                if (internal) {
                    face.addInternalEdge(newEdge);
                }
                if (face.isValid()) continue;
                System.err.println("0x29384f Invalid face");
            }
        }
        edge1.faces.clear();
        edge2.faces.clear();
        this.deleteEdge(edge1, false);
        this.deleteEdge(edge2, false);
        this.deleteVertex(sharedVert);
        return true;
    }

    private void addVertexToFace(Face face, Vertex vert) {
        FaceLoop loop = new FaceLoop();
        loop.vert = vert;
        vert.face = face;
        face.edgeLoops.add(loop);
    }

    public void removeVertexFromFace(Vertex vert) {
        assert (vert.edges.isEmpty() && vert.face != null);
        for (int m = 0; m < vert.face.edgeLoops.size(); ++m) {
            if (vert.face.edgeLoops.get((int)m).vert != vert) continue;
            vert.face.edgeLoops.remove(m);
            break;
        }
        vert.face = null;
        this.deleteVertex(vert);
    }

    private Vertex addVertexToRegion(Point3d loc, int ... groupid) {
        Vertex vert = new Vertex(loc);
        this.addToGroups(vert, groupid);
        this.updateVertexSearch(vert, 0);
        return vert;
    }

    private Face addEdgeToFace(Face face, Edge edge, FaceEdgeInsert v1Insert, FaceEdgeInsert v2Insert) {
        edge.addFace(face);
        FaceLoop v1Loop = v1Insert.loop;
        int v1ix = v1Insert.edgeIx;
        FaceLoop v2Loop = v2Insert.loop;
        int v2ix = v2Insert.edgeIx;
        Face newFace = null;
        if (v1Loop.vert != null && v2Loop.vert != null) {
            v1Loop.removeFace(face);
            v2Loop.removeFace(face);
            face.edgeLoops.remove(v1Loop);
            face.edgeLoops.remove(v2Loop);
            FaceLoop newLoop = new FaceLoop();
            newLoop.edges.add(new EdgeUse(edge, true));
            newLoop.edges.add(new EdgeUse(edge, false));
            face.edgeLoops.add(newLoop);
            face.addInternalEdge(edge);
            if (!face.isValid()) {
                System.err.println("0 Invalid face orient");
            }
        } else if (v1Loop.vert != null) {
            v1Loop.removeFace(face);
            face.edgeLoops.remove(v1Loop);
            ListIterator<EdgeUse> it = v2Loop.edges.listIterator(v2ix);
            it.add(new EdgeUse(edge, false));
            it.add(new EdgeUse(edge, true));
            face.addInternalEdge(edge);
            if (!face.isValid()) {
                System.err.println("4 Invalid face orient");
            }
        } else if (v2Loop.vert != null) {
            v2Loop.removeFace(face);
            face.edgeLoops.remove(v2Loop);
            ListIterator<EdgeUse> it = v1Loop.edges.listIterator(v1ix);
            it.add(new EdgeUse(edge, true));
            it.add(new EdgeUse(edge, false));
            face.addInternalEdge(edge);
            if (!face.isValid()) {
                System.err.println("5 Invalid face orient");
            }
        } else if (v1Loop != v2Loop) {
            ListIterator<EdgeUse> itv1 = v1Loop.edges.listIterator(v1ix);
            ListIterator<EdgeUse> itv2 = v2ix == v2Loop.edges.size() ? v2Loop.edges.listIterator() : v2Loop.edges.listIterator(v2ix);
            itv1.add(new EdgeUse(edge, true));
            for (int m = 0; m < v2Loop.edges.size(); ++m) {
                EdgeUse nextUse = itv2.next();
                itv1.add(nextUse);
                if (itv2.hasNext()) continue;
                itv2 = v2Loop.edges.listIterator();
            }
            itv1.add(new EdgeUse(edge, false));
            if (v2Loop == face.outerLoop()) {
                face.edgeLoops.remove(v1Loop);
                face.edgeLoops.set(0, v1Loop);
            } else {
                face.edgeLoops.remove(v2Loop);
            }
            face.addInternalEdge(edge);
            if (!face.isValid()) {
                System.err.println("1 Invalid face orient");
            }
        } else {
            boolean outer;
            face.clearConnections();
            FaceLoop origloop = v1Loop;
            boolean bl = outer = origloop == face.outerLoop();
            if (v2ix == origloop.edges.size()) {
                v2ix = 0;
            }
            if (v1ix == origloop.edges.size()) {
                v1ix = 0;
            }
            ListIterator<EdgeUse> itv2 = origloop.edges.listIterator(v2ix);
            ArrayList<EdgeUse> newLoop1 = new ArrayList<EdgeUse>();
            newLoop1.add(new EdgeUse(edge, true));
            while (itv2.nextIndex() != v1ix) {
                newLoop1.add(itv2.next());
                if (itv2.hasNext()) continue;
                itv2 = origloop.edges.listIterator();
            }
            ListIterator<EdgeUse> itv1 = origloop.edges.listIterator(v1ix);
            ArrayList<EdgeUse> newLoop2 = new ArrayList<EdgeUse>();
            newLoop2.add(new EdgeUse(edge, false));
            while (itv1.nextIndex() != v2ix) {
                newLoop2.add(itv1.next());
                if (itv1.hasNext()) continue;
                itv1 = origloop.edges.listIterator();
            }
            if (!outer && NmtUtil.getFaceOrient(newLoop1, face.plane) != 2) {
                ArrayList<EdgeUse> temp = newLoop2;
                newLoop2 = newLoop1;
                newLoop1 = temp;
            }
            FaceLoop origReplLoop = new FaceLoop();
            origReplLoop.edges.addAll(newLoop1);
            face.edgeLoops.remove(origloop);
            if (outer) {
                face.edgeLoops.add(0, origReplLoop);
            } else {
                face.edgeLoops.add(origReplLoop);
            }
            newFace = this.addFaceToRegion(face.plane, newLoop2, (List<Vertex>)Collections.EMPTY_LIST, true, face.groups);
            FaceLoop[] loops = face.edgeLoops.toArray(new FaceLoop[face.edgeLoops.size()]);
            ArrayList<FaceLoop> moveLoops = new ArrayList<FaceLoop>(loops.length);
            for (FaceLoop loop : loops) {
                if (loop == origReplLoop) continue;
                Vertex loopVert = Model.findVertex(loop);
                if (this.pointInFace(newFace, loopVert.loc) == null) continue;
                moveLoops.add(loop);
            }
            if (!moveLoops.isEmpty()) {
                for (FaceLoop moveLoop : moveLoops) {
                    face.edgeLoops.remove(moveLoop);
                    newFace.edgeLoops.add(moveLoop);
                    moveLoop.addFace(newFace);
                }
            }
            face.buildConnections();
            for (Edge iedge : new ArrayList<Edge>(face.getInternalEdges())) {
                boolean f1 = iedge.faces.contains(face);
                boolean f2 = iedge.faces.contains(newFace);
                if (f1 && f2) {
                    face.removeInternalEdge(iedge);
                    continue;
                }
                if (!f2) continue;
                face.removeInternalEdge(iedge);
                newFace.addInternalEdge(iedge);
            }
            if (outer) {
                face.invalidateBounds();
                this.updateFaceSearch(face, 1);
            }
            if (!face.isValid()) {
                System.err.println("2 Invalid face orient");
            }
            if (!newFace.isValid()) {
                System.err.println("3 Invalid face orient");
            }
        }
        return newFace;
    }

    private static Vertex findVertex(FaceLoop loop) {
        if (loop.vert != null) {
            return loop.vert;
        }
        assert (!loop.edges.isEmpty());
        return loop.edges.get(0).v1();
    }

    public boolean removeEdgeFromFaces(Edge sharedEdge) {
        boolean outer2;
        if (sharedEdge.faces.size() != 2) {
            return false;
        }
        Face face1 = sharedEdge.faces.get(0);
        Face face2 = sharedEdge.faces.get(1);
        FaceEdgeInsert del1 = Model.findFaceEdgeDeletion(face1, sharedEdge);
        if (del1 == null) {
            return false;
        }
        FaceEdgeInsert del2 = Model.findFaceEdgeDeletion(face2, sharedEdge);
        if (del2 == null) {
            return false;
        }
        assert (!face1.isInternalEdge(sharedEdge) && !face2.isInternalEdge(sharedEdge));
        face1.clearConnections();
        face2.clearConnections();
        if (face2.outerLoop() != del2.loop) {
            assert (face1.outerLoop() == del1.loop);
            FaceEdgeInsert temp = del2;
            del2 = del1;
            del1 = temp;
            Face tempf = face1;
            face1 = face2;
            face2 = tempf;
        }
        boolean outer1 = face1.outerLoop() == del1.loop;
        boolean bl = outer2 = face2.outerLoop() == del2.loop;
        assert (outer2);
        ListIterator<EdgeUse> euit1 = del1.loop.edges.listIterator(del1.edgeIx);
        EdgeUse eu1 = euit1.next();
        if (!euit1.hasNext()) {
            euit1 = del1.loop.edges.listIterator();
        }
        ListIterator<EdgeUse> euit2 = del2.loop.edges.listIterator(del2.edgeIx);
        EdgeUse eu2 = euit2.next();
        ArrayList<EdgeUse> newLoop = new ArrayList<EdgeUse>(del1.loop.edges.size() + del2.loop.edges.size() - 2);
        if (eu1.orient != eu2.orient) {
            if (!euit2.hasNext()) {
                euit2 = del2.loop.edges.listIterator();
            }
            while (euit2.nextIndex() != del2.edgeIx) {
                newLoop.add(euit2.next());
                if (euit2.hasNext()) continue;
                euit2 = del2.loop.edges.listIterator();
            }
        } else {
            euit2.previous();
            if (!euit2.hasPrevious()) {
                euit2 = del2.loop.edges.listIterator(del2.loop.edges.size());
            }
            while (euit2.previousIndex() != del2.edgeIx) {
                newLoop.add(euit2.previous().reverse());
                if (euit2.hasPrevious()) continue;
                euit2 = del2.loop.edges.listIterator(del2.loop.edges.size());
            }
        }
        while (euit1.nextIndex() != del1.edgeIx) {
            newLoop.add(euit1.next());
            if (euit1.hasNext()) continue;
            euit1 = del1.loop.edges.listIterator();
        }
        FaceLoop newFaceLoop = new FaceLoop();
        newFaceLoop.edges.addAll(newLoop);
        if (outer1) {
            face1.edgeLoops.set(0, newFaceLoop);
        } else {
            face1.edgeLoops.remove(del1.loop);
            face1.edgeLoops.add(newFaceLoop);
        }
        for (int m = 1; m < face2.edgeLoops.size(); ++m) {
            face1.edgeLoops.add(face2.edgeLoops.get(m));
        }
        face1.addGroups(face2.groups);
        this.deleteFace(face2, false, false);
        sharedEdge.faces.clear();
        this.deleteEdge(sharedEdge, false);
        face1.recalcInternalEdges();
        face1.buildConnections();
        face1.invalidateBounds();
        this.updateFaceSearch(face1, 1);
        return true;
    }

    public boolean removeEdgeFromFace(Edge edge) {
        assert (edge.faces.size() == 1);
        Face face = edge.faces.get(0);
        FaceLoop loop = null;
        int ix1 = -1;
        int ix2 = -1;
        for (FaceLoop floop : face.edgeLoops) {
            for (int m = 0; m < floop.edges.size(); ++m) {
                if (floop.edges.get((int)m).edge != edge) continue;
                loop = floop;
                if (ix1 == -1) {
                    ix1 = m;
                    continue;
                }
                ix2 = m;
                break;
            }
            if (loop == null) continue;
            break;
        }
        if (loop == null || ix1 == -1 || ix2 == -1) {
            return false;
        }
        assert (face.isInternalEdge(edge));
        face.clearConnections();
        EdgeUse eu1 = loop.edges.get(ix1);
        boolean v1Shared = (ix2 + 1) % loop.edges.size() == ix1;
        boolean v2Shared = (ix1 + 1) % loop.edges.size() == ix2;
        FaceLoop loop1 = new FaceLoop();
        FaceLoop loop2 = new FaceLoop();
        if (v1Shared && v2Shared) {
            loop1.vert = eu1.v1();
            loop2.vert = eu1.v2();
            assert (loop != face.outerLoop());
            face.edgeLoops.remove(loop);
            face.edgeLoops.add(loop1);
            face.edgeLoops.add(loop2);
        } else if (v1Shared || v2Shared) {
            int i2;
            int i1;
            if (v1Shared) {
                loop1.vert = eu1.v1();
                i1 = ix1;
                i2 = ix2;
            } else {
                loop1.vert = eu1.v2();
                i1 = ix2;
                i2 = ix1;
            }
            int m = (i1 + 1) % loop.edges.size();
            while (m != i2) {
                loop2.edges.add(loop.edges.get(m));
                m = (m + 1) % loop.edges.size();
            }
            if (loop == face.outerLoop()) {
                face.edgeLoops.set(0, loop2);
            } else {
                face.edgeLoops.remove(loop);
                face.edgeLoops.add(loop2);
            }
            face.edgeLoops.add(loop1);
        } else {
            int m = (ix1 + 1) % loop.edges.size();
            while (m != ix2) {
                loop1.edges.add(loop.edges.get(m));
                m = (m + 1) % loop.edges.size();
            }
            m = (ix2 + 1) % loop.edges.size();
            while (m != ix1) {
                loop2.edges.add(loop.edges.get(m));
                m = (m + 1) % loop.edges.size();
            }
            if (loop == face.outerLoop()) {
                boolean loop1Outer = false;
                boolean bl = loop1Outer = loop1.isOpen() && NmtUtil.getFaceOrient(loop1.edges, face.plane) == 1;
                if (loop1Outer) {
                    face.edgeLoops.set(0, loop1);
                    face.edgeLoops.add(loop2);
                } else {
                    face.edgeLoops.set(0, loop2);
                    face.edgeLoops.add(loop1);
                }
            } else {
                face.edgeLoops.remove(loop);
                face.edgeLoops.add(loop1);
                face.edgeLoops.add(loop2);
            }
        }
        edge.faces.clear();
        face.buildConnections();
        if (edge.faces.isEmpty()) {
            this.deleteEdge(edge, false);
            face.removeInternalEdge(edge);
        }
        if (!face.isValid()) {
            System.err.println("0x923984 invalid face");
        }
        return true;
    }

    private static FaceEdgeInsert findFaceEdgeDeletion(Face face, Edge edge) {
        for (FaceLoop loop : face.edgeLoops) {
            for (int m = 0; m < loop.edges.size(); ++m) {
                EdgeUse eu = loop.edges.get(m);
                if (eu.edge != edge) continue;
                return new FaceEdgeInsert(loop, m);
            }
        }
        return null;
    }

    private static FaceEdgeInsert[] findInsertPos(Face face, Vertex v1, Vertex v2, IParametric3D curve) {
        FaceEdgeInsert insert1 = Model.findInsertPos(face, v1, curve, true);
        if (insert1 == null) {
            return null;
        }
        FaceEdgeInsert insert2 = Model.findInsertPos(face, v2, curve, false);
        if (insert2 == null) {
            return null;
        }
        return new FaceEdgeInsert[]{insert1, insert2};
    }

    private static FaceEdgeInsert findInsertPos(Face face, Vertex vert, IParametric3D curve, boolean curveOrient) {
        Vector3d newDir;
        FaceEdgeInsert insert = new FaceEdgeInsert();
        for (FaceLoop loop : face.edgeLoops) {
            if (loop.vert != vert) continue;
            insert.loop = loop;
            insert.edgeIx = 0;
            return insert;
        }
        Vector3d normal = face.plane.getNormal();
        double minAngle = Double.MAX_VALUE;
        if (curveOrient) {
            newDir = curve.getTangent(0.0);
        } else {
            newDir = curve.getTangent(1.0);
            newDir.negate();
        }
        for (FaceLoop loop : face.edgeLoops) {
            if (loop.vert != null) continue;
            ListIterator<EdgeUse> it = loop.edges.listIterator();
            while (it.hasNext()) {
                EdgeUse eu = it.next();
                if (eu.v2() != vert) continue;
                Vector3d edgeDir = eu.curve().getTangent(1.0);
                edgeDir.negate();
                double angle = Util3D.angle0To2PI(newDir, edgeDir, normal);
                if (!(angle < minAngle)) continue;
                minAngle = angle;
                insert.loop = loop;
                insert.edgeIx = it.nextIndex();
            }
        }
        if (insert.loop == null) {
            return null;
        }
        EdgeUse eu2 = insert.edgeIx == insert.loop.edges.size() ? insert.loop.edges.get(0) : insert.loop.edges.get(insert.edgeIx);
        double angle = Util3D.angle0To2PI(newDir, eu2.getTangent(0.0), normal);
        if (angle < minAngle) {
            return null;
        }
        return insert;
    }

    private Edge addEdgeToRegion(IParametric3D curve, Vertex v1, Vertex v2, int ... groupid) {
        Edge edge = new Edge(v1, v2, curve);
        this.addToGroups(edge, groupid);
        edge.buildConnections();
        this.updateEdgeSearch(edge, 0);
        return edge;
    }

    private Face addFaceToRegion(Plane3d plane, List<EdgeUse> edges, List<Vertex> singleVerts, int ... groupid) {
        return this.addFaceToRegion(plane, edges, singleVerts, true, groupid);
    }

    private Face addFaceToRegion(Plane3d plane, List<EdgeUse> edges, List<Vertex> singleVerts, boolean recalcInternalEdges, int ... groupid) {
        ArrayList<FaceLoop> loops = new ArrayList<FaceLoop>();
        assert (!edges.isEmpty());
        FaceLoop currLoop = new FaceLoop();
        EdgeUse prevEdge = edges.get(0);
        currLoop.edges.add(prevEdge);
        for (int m = 1; m < edges.size(); ++m) {
            EdgeUse currEdge = edges.get(m);
            if (currEdge.v1() != prevEdge.v2()) {
                loops.add(currLoop);
                currLoop = new FaceLoop();
            }
            currLoop.edges.add(currEdge);
            prevEdge = currEdge;
        }
        loops.add(currLoop);
        for (Vertex vert : singleVerts) {
            FaceLoop loop = new FaceLoop();
            loop.vert = vert;
            loops.add(loop);
        }
        Face face = new Face(plane, loops, recalcInternalEdges);
        this.addToGroups(face, groupid);
        face.buildConnections();
        this.updateFaceSearch(face, 0);
        return face;
    }

    public void updateVertexSearch(Vertex vert, int updateAction) {
        this.updateSearch(this.d_vertSearch, vert, updateAction);
    }

    public void updateEdgeSearch(Edge edge, int updateAction) {
        this.updateSearch(this.d_edgeSearch, edge, updateAction);
    }

    public void updateFaceSearch(Face face, int updateAction) {
        this.updateSearch(this.d_faceSearch, face, updateAction);
    }

    private <T extends AModelObj> void updateSearch(GeomSearcher<T> searcher, T obj, int updateAction) {
        switch (updateAction) {
            case 0: {
                searcher.add(obj);
                break;
            }
            case 1: {
                searcher.update(obj);
                break;
            }
            case 2: {
                searcher.remove(obj);
            }
        }
    }

    public List<Vertex> findVerts(AABox searchBox) {
        return Model.find(this.d_vertSearch, searchBox);
    }

    public List<Vertex> findVerts(ITest<AABox> test) {
        return Model.find(this.d_vertSearch, test);
    }

    public List<Edge> findEdges(AABox searchBox) {
        return Model.find(this.d_edgeSearch, searchBox);
    }

    public List<Edge> findEdge(ITest<AABox> test) {
        return Model.find(this.d_edgeSearch, test);
    }

    public List<Face> findFaces(AABox searchBox) {
        return Model.find(this.d_faceSearch, searchBox);
    }

    public List<Face> findFaces(ITest<AABox> test) {
        return Model.find(this.d_faceSearch, test);
    }

    private static <T extends AModelObj> List<T> find(GeomSearcher<T> searcher, AABox searchBox) {
        return searcher.find(new AABoxTest(searchBox, 1.0E-6));
    }

    private static <T extends AModelObj> List<T> find(GeomSearcher<T> searcher, ITest<AABox> test) {
        return searcher.find(test);
    }

    public Face findFace(Point3d loc) {
        Face closestFace = null;
        double closestDist = Double.MAX_VALUE;
        for (Face face : this.findFaces(new AABox(loc, loc))) {
            double dist;
            Point3d p = this.pointInFace(face, loc);
            if (p == null || !((dist = p.distanceSquared(loc)) < closestDist)) continue;
            closestFace = face;
            closestDist = dist;
        }
        return closestFace;
    }

    public void merge(Model model) {
        int elcount1 = this.d_mainGroup.verts.size() + this.d_mainGroup.edges.size() + this.d_mainGroup.faces.size();
        int elcount2 = model.d_mainGroup.verts.size() + model.d_mainGroup.edges.size() + model.d_mainGroup.faces.size();
        if (elcount2 > elcount1) {
            model.forceMerge(this);
            Cloneable temp = this.d_edgeSearch;
            this.d_edgeSearch = model.d_edgeSearch;
            model.d_edgeSearch = temp;
            temp = this.d_faceSearch;
            this.d_faceSearch = model.d_faceSearch;
            model.d_faceSearch = temp;
            temp = this.d_vertSearch;
            this.d_vertSearch = model.d_vertSearch;
            model.d_vertSearch = temp;
            temp = this.d_mainGroup;
            this.d_mainGroup = model.d_mainGroup;
            model.d_mainGroup = (Group)temp;
        } else {
            this.forceMerge(model);
        }
    }

    public void forceMerge(Model model) {
        LinkedIdentityHashMap<Vertex, Vertex> m1Verts = new LinkedIdentityHashMap<Vertex, Vertex>();
        LinkedIdentityHashMap<Vertex, Vertex> m2Verts = new LinkedIdentityHashMap<Vertex, Vertex>();
        LinkedIdentityHashMap<Edge, Edge> m1Edges = new LinkedIdentityHashMap<Edge, Edge>();
        LinkedIdentityHashMap<Edge, Edge> m2Edges = new LinkedIdentityHashMap<Edge, Edge>();
        LinkedIdentityHashMap<Face, Face> m2Faces = new LinkedIdentityHashMap<Face, Face>();
        for (Vertex vert : model.d_mainGroup.verts) {
            Model.setMate(m2Verts, vert, null);
        }
        for (Edge edge : model.d_mainGroup.edges) {
            Model.setMate(m2Edges, edge, null);
        }
        for (Face face : model.d_mainGroup.faces) {
            Model.setMate(m2Faces, face, null);
        }
        Stack<Edge> edgeStack = new Stack<Edge>();
        Stack<Face> faceStack = new Stack<Face>();
        Model.vv(this, model, m1Verts, m2Verts);
        Model.ve(this, model, m1Verts, m2Verts, m1Edges, m2Edges);
        Model.vf(this, model, m1Verts, m2Verts, m2Faces);
        Model.vr(this, model, m1Verts, m2Verts);
        Model.ee(this, model, edgeStack, m1Verts, m2Verts, m1Edges, m2Edges);
        Model.ef(this, model, edgeStack, faceStack, m1Verts, m2Verts, m1Edges, m2Edges, m2Faces);
        Model.er(this, model, m2Verts, m2Edges);
        Model.ff(this, model, faceStack, m1Verts, m2Verts, m1Edges, m2Edges, m2Faces);
        Model.fr(this, model, m2Verts, m2Edges, m2Faces);
    }

    private static <T> void setMate(Map<T, T> map, T v1, T v2) {
        map.put(v1, v2);
    }

    private static <T> void setMates(Map<T, T> map1, Map<T, T> map2, T v1, T v2) {
        map1.put(v1, v2);
        map2.put(v2, v1);
    }

    private static <T> T getMate(Map<T, T> map, T v) {
        return map.get(v);
    }

    private void debugFindVert(Point3d p, int debugid) {
    }

    private static void vv(Model model1, Model model2, Map<Vertex, Vertex> m1Verts, Map<Vertex, Vertex> m2Verts) {
        for (Vertex vert2 : m2Verts.keySet()) {
            Vertex vert1 = model1.findVertex(vert2.loc);
            if (vert1 == null) continue;
            Model.setMates(m1Verts, m2Verts, vert1, vert2);
            vert1.addGroups(vert2.groups);
            vert2.addGroups(vert1.groups);
        }
    }

    private static void ve(Model model1, Model model2, Map<Vertex, Vertex> m1Verts, Map<Vertex, Vertex> m2Verts, Map<Edge, Edge> m1Edges, Map<Edge, Edge> m2Edges) {
        LinkedIdentityHashSet nearV1s = new LinkedIdentityHashSet();
        for (Edge edge : m2Edges.keySet()) {
            for (Vertex vert1 : model1.findVerts(edge.getBounds())) {
                if (m1Verts.get(vert1) != null) continue;
                nearV1s.add(vert1);
            }
        }
        for (Vertex vertex : nearV1s) {
            double closestT = 0.0;
            Point3d closestPoint = null;
            Edge closestEdge = null;
            double closestDist = 1.0E-6;
            for (Edge edge2 : model2.findEdges(vertex.getBounds())) {
                double nearestT = edge2.curve.getClosestT(vertex.loc);
                Point3d pOnCurve = edge2.curve.get(nearestT);
                double dist = pOnCurve.distance(vertex.loc);
                if (!(dist <= closestDist)) continue;
                closestDist = dist;
                closestEdge = edge2;
                closestPoint = pOnCurve;
                closestT = nearestT;
            }
            if (closestEdge == null) continue;
            model2.debugFindVert(closestPoint, 600116);
            int[] mergedGroupIds = NmtUtil.mergeGroupIds(vertex.groups, closestEdge.groups);
            vertex.groups = mergedGroupIds;
            Vertex newVert = model2.addVertexToRegion(closestPoint, mergedGroupIds);
            Edge newEdge = model2.addVertexToEdge(closestEdge, closestT, newVert);
            Model.setMates(m1Verts, m2Verts, vertex, newVert);
            Model.setMate(m2Edges, newEdge, null);
        }
        for (Map.Entry entry : m2Verts.entrySet()) {
            if (entry.getValue() != null) continue;
            Vertex vert2 = (Vertex)entry.getKey();
            double closestT = 0.0;
            Point3d closestPoint = null;
            Edge closestEdge = null;
            double closestDist = 1.0E-6;
            for (Edge edge1 : model1.findEdges(vert2.getBounds())) {
                double nearestT = edge1.curve.getClosestT(vert2.loc);
                Point3d pOnCurve = edge1.curve.get(nearestT);
                double dist = pOnCurve.distance(vert2.loc);
                if (!(dist <= closestDist)) continue;
                closestDist = dist;
                closestEdge = edge1;
                closestPoint = pOnCurve;
                closestT = nearestT;
            }
            if (closestEdge == null) continue;
            model1.debugFindVert(closestPoint, 593789949);
            int[] mergedGroupIds = NmtUtil.mergeGroupIds(vert2.groups, closestEdge.groups);
            vert2.groups = mergedGroupIds;
            Vertex newVert = model1.addVertexToRegion(closestPoint, mergedGroupIds);
            Edge newEdge = model1.addVertexToEdge(closestEdge, closestT, newVert);
            Model.setMates(m1Verts, m2Verts, newVert, vert2);
            Model.setMate(m1Edges, newEdge, null);
        }
    }

    private static void vf(Model model1, Model model2, Map<Vertex, Vertex> m1Verts, Map<Vertex, Vertex> m2Verts, Map<Face, Face> m2Faces) {
        LinkedIdentityHashMap<Vertex, ArrayList<Face>> nearV1Faces = new LinkedIdentityHashMap<Vertex, ArrayList<Face>>();
        for (Face face : m2Faces.keySet()) {
            for (Vertex vert1 : model1.findVerts(face.getBounds())) {
                if (m1Verts.get(vert1) != null) continue;
                ArrayList<Face> faces = (ArrayList<Face>)nearV1Faces.get(vert1);
                if (faces == null) {
                    faces = new ArrayList<Face>(2);
                    nearV1Faces.put(vert1, faces);
                }
                faces.add(face);
            }
        }
        for (Map.Entry entry : nearV1Faces.entrySet()) {
            Vertex vert1 = (Vertex)entry.getKey();
            List nearFaces2 = (List)entry.getValue();
            double closestDist = Double.MAX_VALUE;
            Point3d closestPointInFace = null;
            Object closestFace = null;
            for (Face face2 : nearFaces2) {
                double dist;
                Point3d pInFace = model2.pointInFace(face2, vert1.loc);
                if (pInFace == null || !((dist = pInFace.distance(vert1.loc)) < closestDist)) continue;
                closestDist = dist;
                closestPointInFace = pInFace;
                closestFace = face2;
            }
            if (closestFace == null) continue;
            model2.debugFindVert(closestPointInFace, 153352767);
            int[] mergedGroupIds = NmtUtil.mergeGroupIds(vert1.groups, ((Face)closestFace).groups);
            vert1.groups = mergedGroupIds;
            Vertex newVert = model2.addVertexToRegion(closestPointInFace, mergedGroupIds);
            model2.addVertexToFace((Face)closestFace, newVert);
            Model.setMates(m1Verts, m2Verts, vert1, newVert);
        }
        for (Map.Entry entry : m2Verts.entrySet()) {
            if (entry.getValue() != null) continue;
            Vertex vert2 = (Vertex)entry.getKey();
            double closestDist = Double.MAX_VALUE;
            Point3d closestPointInFace = null;
            Face closestFace = null;
            for (Face face1 : model1.findFaces(vert2.getBounds())) {
                double dist;
                Point3d pInFace = model1.pointInFace(face1, vert2.loc);
                if (pInFace == null || !((dist = pInFace.distance(vert2.loc)) < closestDist)) continue;
                closestDist = dist;
                closestPointInFace = pInFace;
                closestFace = face1;
            }
            if (closestFace == null) continue;
            model1.debugFindVert(closestPointInFace, 35882234);
            int[] mergedGroupIds = NmtUtil.mergeGroupIds(vert2.groups, closestFace.groups);
            Vertex newVert = model1.addVertexToRegion(closestPointInFace, mergedGroupIds);
            vert2.groups = mergedGroupIds;
            model1.addVertexToFace(closestFace, newVert);
            Model.setMates(m1Verts, m2Verts, newVert, vert2);
        }
    }

    private static void vr(Model model1, Model model2, Map<Vertex, Vertex> m1Verts, Map<Vertex, Vertex> m2Verts) {
        for (Map.Entry<Vertex, Vertex> entry : m2Verts.entrySet()) {
            if (entry.getValue() != null) continue;
            Vertex vert2 = entry.getKey();
            model1.debugFindVert(vert2.loc, 215290);
            Vertex newVert = model1.addVertexToRegion(vert2.loc, vert2.groups);
            Model.setMates(m1Verts, m2Verts, newVert, vert2);
        }
    }

    private static void ee(Model model1, Model model2, Stack<Edge> edgeStack, Map<Vertex, Vertex> m1Verts, Map<Vertex, Vertex> m2Verts, Map<Edge, Edge> m1Edges, Map<Edge, Edge> m2Edges) {
        for (Map.Entry<Edge, Edge> entry : m2Edges.entrySet()) {
            if (entry.getValue() != null) continue;
            edgeStack.push(entry.getKey());
        }
        block1: while (!edgeStack.isEmpty()) {
            Edge edge2 = edgeStack.pop();
            List<Edge> nearEdges = model1.findEdges(edge2.getBounds());
            boolean equivFound = false;
            for (Edge edge1 : nearEdges) {
                if (!Model.compare(edge1, edge2, m1Verts)) continue;
                edge1.addGroups(edge2.groups);
                edge2.addGroups(edge1.groups);
                Model.setMates(m1Edges, m2Edges, edge1, edge2);
                equivFound = true;
                break;
            }
            if (equivFound) continue;
            for (Edge edge1 : nearEdges) {
                double[] isect = Model.isect(edge1.curve, edge2.curve);
                if (isect == null || isect.length <= 0) continue;
                Point3d isect1 = edge1.curve.get(isect[0]);
                Point3d isect2 = edge2.curve.get(isect[1]);
                if (Model.compare(isect1, edge1.curve.get(0.0)) || Model.compare(isect1, edge1.curve.get(1.0)) || Model.compare(isect2, edge2.curve.get(0.0)) || Model.compare(isect2, edge2.curve.get(1.0))) continue;
                int[] mergedGroupIds = NmtUtil.mergeGroupIds(edge1.groups, edge2.groups);
                model1.debugFindVert(isect1, 65167);
                Vertex v1 = model1.addVertexToRegion(isect1, mergedGroupIds);
                Edge ne1 = model1.addVertexToEdge(edge1, isect[0], v1);
                model2.debugFindVert(isect2, 63485);
                Vertex v2 = model2.addVertexToRegion(isect2, mergedGroupIds);
                Edge ne2 = model2.addVertexToEdge(edge2, isect[1], v2);
                Model.setMates(m1Verts, m2Verts, v1, v2);
                Model.setMate(m1Edges, ne1, null);
                Model.setMate(m2Edges, ne2, null);
                edgeStack.push(edge2);
                edgeStack.push(ne2);
                continue block1;
            }
        }
    }

    private static void ef(Model model1, Model model2, Stack<Edge> edgeStack, Stack<Face> faceStack, Map<Vertex, Vertex> m1Verts, Map<Vertex, Vertex> m2Verts, Map<Edge, Edge> m1Edges, Map<Edge, Edge> m2Edges, Map<Face, Face> m2Faces) {
        int[] mergedGroupIds;
        Point3d isectLoc;
        Point3d cp2;
        Point3d cp1;
        double[] isects;
        FaceEdgeInsert[] inserts;
        Vertex vt;
        Vertex vh;
        for (Face face : m2Faces.keySet()) {
            faceStack.push(face);
        }
        while (!faceStack.isEmpty()) {
            Face face2 = faceStack.pop();
            for (Edge edge1 : model1.findEdges(face2.getBounds())) {
                if (m1Edges.get(edge1) != null) continue;
                if (Model.curveOnSurface(edge1.curve, face2)) {
                    vh = Model.getMate(m1Verts, edge1.v1);
                    vt = Model.getMate(m1Verts, edge1.v2);
                    if (vh == null || vt == null || (inserts = Model.findInsertPos(face2, vh, vt, edge1.curve)) == null) continue;
                    int[] nArray = NmtUtil.mergeGroupIds(edge1.groups, face2.groups);
                    edge1.groups = nArray;
                    Edge newEdge = model2.addEdgeToRegion(edge1.curve, vh, vt, nArray);
                    Face newFace = model2.addEdgeToFace(face2, newEdge, inserts[0], inserts[1]);
                    Model.setMates(m1Edges, m2Edges, edge1, newEdge);
                    if (newFace == null) continue;
                    Model.setMate(m2Faces, newFace, null);
                    faceStack.push(newFace);
                    continue;
                }
                isects = model2.isect(edge1.curve, face2);
                if (isects == null || isects.length <= 0) continue;
                cp1 = edge1.curve.get(0.0);
                cp2 = edge1.curve.get(1.0);
                assert (isects.length == 1);
                for (double isect : isects) {
                    isectLoc = edge1.curve.get(isect);
                    if (Model.compare(isectLoc, cp1) || Model.compare(isectLoc, cp2)) continue;
                    mergedGroupIds = NmtUtil.mergeGroupIds(edge1.groups, face2.groups);
                    model1.debugFindVert(isectLoc, 2751);
                    Vertex nv1 = model1.addVertexToRegion(isectLoc, mergedGroupIds);
                    Edge ne1 = model1.addVertexToEdge(edge1, isect, nv1);
                    model2.debugFindVert(isectLoc, 403279);
                    Vertex nv2 = model2.addVertexToRegion(isectLoc, mergedGroupIds);
                    model2.addVertexToFace(face2, nv2);
                    Model.setMates(m1Verts, m2Verts, nv1, nv2);
                    Model.setMate(m1Edges, ne1, null);
                }
            }
        }
        for (Map.Entry entry : m2Edges.entrySet()) {
            if (entry.getValue() != null) continue;
            edgeStack.push((Edge)entry.getKey());
        }
        block5: while (!edgeStack.isEmpty()) {
            Edge edge2 = edgeStack.pop();
            for (Face face1 : model1.findFaces(edge2.getBounds())) {
                if (Model.curveOnSurface(edge2.curve, face1)) {
                    vh = Model.getMate(m2Verts, edge2.v1);
                    vt = Model.getMate(m2Verts, edge2.v2);
                    if (vh == null || vt == null) {
                        System.err.println("2 Missing a vertex mate for " + edge2);
                        continue;
                    }
                    inserts = Model.findInsertPos(face1, vh, vt, edge2.curve);
                    if (inserts == null) continue;
                    int[] nArray = NmtUtil.mergeGroupIds(edge2.groups, face1.groups);
                    edge2.groups = nArray;
                    Edge newEdge = model1.addEdgeToRegion(edge2.curve, vh, vt, nArray);
                    model1.addEdgeToFace(face1, newEdge, inserts[0], inserts[1]);
                    Model.setMates(m1Edges, m2Edges, newEdge, edge2);
                    continue block5;
                }
                isects = model1.isect(edge2.curve, face1);
                if (isects == null || isects.length <= 0) continue;
                cp1 = edge2.curve.get(0.0);
                cp2 = edge2.curve.get(1.0);
                assert (isects.length == 1);
                for (double isect : isects) {
                    isectLoc = edge2.curve.get(isect);
                    if (Model.compare(isectLoc, cp1) || Model.compare(isectLoc, cp2)) continue;
                    mergedGroupIds = NmtUtil.mergeGroupIds(face1.groups, edge2.groups);
                    model2.debugFindVert(isectLoc, 74655);
                    Vertex nv2 = model2.addVertexToRegion(isectLoc, mergedGroupIds);
                    Edge ne2 = model2.addVertexToEdge(edge2, isect, nv2);
                    model1.debugFindVert(isectLoc, 156815);
                    Vertex nv1 = model1.addVertexToRegion(isectLoc, mergedGroupIds);
                    model1.addVertexToFace(face1, nv1);
                    Model.setMates(m1Verts, m2Verts, nv1, nv2);
                    Model.setMate(m2Edges, ne2, null);
                    edgeStack.push(ne2);
                }
            }
        }
    }

    private static void er(Model model1, Model model2, Map<Vertex, Vertex> m2Verts, Map<Edge, Edge> m2Edges) {
        for (Map.Entry<Edge, Edge> entry : m2Edges.entrySet()) {
            if (entry.getValue() != null) continue;
            Edge edge2 = entry.getKey();
            Vertex vh = Model.getMate(m2Verts, edge2.v1);
            Vertex vt = Model.getMate(m2Verts, edge2.v2);
            if (vh == null || vt == null) {
                System.err.println("3 Missing a vertex mate for " + edge2);
                continue;
            }
            Edge newEdge = model1.addEdgeToRegion(edge2.curve, vh, vt, edge2.groups);
            Model.setMate(m2Edges, edge2, newEdge);
        }
    }

    private static void ff(Model model1, Model model2, Stack<Face> faceStack, Map<Vertex, Vertex> m1Verts, Map<Vertex, Vertex> m2Verts, Map<Edge, Edge> m1Edges, Map<Edge, Edge> m2Edges, Map<Face, Face> m2Faces) {
        for (Map.Entry<Face, Face> entry : m2Faces.entrySet()) {
            if (entry.getValue() != null) continue;
            faceStack.push(entry.getKey());
        }
        block1: while (!faceStack.isEmpty()) {
            Face face2 = faceStack.pop();
            boolean equivFound = false;
            List<Face> nearFaces = model1.findFaces(face2.getBounds());
            if (nearFaces.isEmpty()) continue;
            for (Face face1 : nearFaces) {
                if (!Model.compare(face1, face2, m1Verts, m1Edges)) continue;
                face1.addGroups(face2.groups);
                face2.addGroups(face1.groups);
                Model.setMate(m2Faces, face2, face1);
                equivFound = true;
                break;
            }
            if (equivFound) continue;
            IdentityHashSet<Vertex> f2Verts = new IdentityHashSet<Vertex>();
            for (FaceLoop loop2 : face2.edgeLoops) {
                for (Vertex v2 : Vertices.get(loop2)) {
                    f2Verts.add(v2);
                }
            }
            for (Face face1 : nearFaces) {
                LineSeg3D isectCurve = Model.isect(face1.plane, face2.plane);
                if (isectCurve == null) continue;
                TreeMap<Double, Pair<Vertex, Vertex>> segmentList = new TreeMap<Double, Pair<Vertex, Vertex>>();
                for (int m = 0; m < face1.edgeLoops.size(); ++m) {
                    FaceLoop loop1 = face1.edgeLoops.get(m);
                    for (Vertex v1 : Vertices.get(loop1)) {
                        Vertex v2 = m1Verts.get(v1);
                        if (v2 == null || !f2Verts.contains(v2)) continue;
                        double t = Util3D.tOnLineSeg(isectCurve.p1, isectCurve.p2, v1.loc);
                        segmentList.put(t, new Pair<Vertex, Vertex>(v1, v2));
                    }
                }
                if (segmentList.size() <= 1) continue;
                int[] mergedGroupIds = NmtUtil.mergeGroupIds(face1.groups, face2.groups);
                Iterator segit = segmentList.entrySet().iterator();
                Map.Entry prevEntry = segit.next();
                boolean endTest = false;
                while (segit.hasNext()) {
                    FaceEdgeInsert[] inserts2;
                    FaceEdgeInsert[] inserts1;
                    Map.Entry currEntry = segit.next();
                    Point3d p1 = isectCurve.get((Double)prevEntry.getKey());
                    Point3d p2 = isectCurve.get((Double)currEntry.getKey());
                    Vertex vh1 = (Vertex)((Pair)currEntry.getValue()).v1;
                    Vertex vt1 = (Vertex)((Pair)prevEntry.getValue()).v1;
                    Vertex vh2 = (Vertex)((Pair)currEntry.getValue()).v2;
                    Vertex vt2 = (Vertex)((Pair)prevEntry.getValue()).v2;
                    prevEntry = currEntry;
                    if (p1.distance(p2) < 2.0E-6) continue;
                    LineSeg3D curve1 = new LineSeg3D(vh1.loc, vt1.loc);
                    LineSeg3D curve2 = new LineSeg3D(vh2.loc, vt2.loc);
                    if (model1.findEdge(curve1, vh1, vt1) || model2.findEdge(curve2, vh2, vt2) || (inserts1 = Model.findInsertPos(face1, vh1, vt1, curve1)) == null || (inserts2 = Model.findInsertPos(face2, vh2, vt2, curve2)) == null) continue;
                    Edge ne1 = model1.addEdgeToRegion(curve1, vh1, vt1, mergedGroupIds);
                    Edge ne2 = model2.addEdgeToRegion(curve2, vh2, vt2, mergedGroupIds);
                    Model.setMates(m1Edges, m2Edges, ne1, ne2);
                    Face nf1 = model1.addEdgeToFace(face1, ne1, inserts1[0], inserts1[1]);
                    Face nf2 = model2.addEdgeToFace(face2, ne2, inserts2[0], inserts2[1]);
                    if (nf2 != null) {
                        Model.setMate(m2Faces, nf2, null);
                        faceStack.push(nf2);
                    }
                    if (nf1 == null && nf2 == null) continue;
                    endTest = true;
                    faceStack.push(face2);
                    break;
                }
                if (!endTest) continue;
                continue block1;
            }
        }
    }

    private static void fr(Model model1, Model model2, Map<Vertex, Vertex> m2Verts, Map<Edge, Edge> m2Edges, Map<Face, Face> m2Faces) {
        for (Map.Entry<Face, Face> entry : m2Faces.entrySet()) {
            if (entry.getValue() != null) continue;
            Face face2 = entry.getKey();
            ArrayList<Vertex> singleVerts = new ArrayList<Vertex>();
            ArrayList<EdgeUse> edges = new ArrayList<EdgeUse>();
            for (FaceLoop loop : face2.edgeLoops) {
                if (loop.vert != null) {
                    Vertex v2mate = Model.getMate(m2Verts, loop.vert);
                    if (v2mate == null) {
                        System.err.println("5 Missing a vertex mate for " + loop.vert);
                        continue;
                    }
                    singleVerts.add(v2mate);
                }
                for (EdgeUse eu : loop.edges) {
                    Edge e2mate = Model.getMate(m2Edges, eu.edge);
                    Vertex v1mate = Model.getMate(m2Verts, eu.v1());
                    if (e2mate == null || v1mate == null) {
                        System.err.println("6 Missing a vertex or edge mate for " + eu.edge + " " + eu.v1());
                        continue;
                    }
                    assert (e2mate != null && v1mate != null);
                    boolean pos = e2mate.v1 == v1mate;
                    edges.add(new EdgeUse(e2mate, pos));
                }
            }
            Face newFace = model1.addFaceToRegion(face2.plane, edges, singleVerts, face2.groups);
            Model.setMate(m2Faces, face2, newFace);
        }
    }

    private Vertex findVertex(Point3d p) {
        double closestDistSq = Double.MAX_VALUE;
        Vertex closestVert = null;
        AABox bb = new AABox(p);
        for (Vertex vert : this.findVerts(bb)) {
            double distSq = p.distanceSquared(vert.loc);
            if (!(distSq < closestDistSq)) continue;
            closestDistSq = distSq;
            closestVert = vert;
        }
        return closestVert != null && Math.sqrt(closestDistSq) < 1.0E-6 ? closestVert : null;
    }

    private boolean findEdge(IParametric3D curve, Vertex v1, Vertex v2) {
        if (v1.edges.size() > v2.edges.size()) {
            Vertex temp = v1;
            v1 = v2;
            v2 = temp;
        }
        for (int m = 0; m < v1.edges.size(); ++m) {
            Vertex other;
            Edge e1 = v1.edges.get(m);
            Vertex vertex = other = e1.v1 == v1 ? e1.v2 : e1.v1;
            if (other != v2) continue;
            return true;
        }
        return false;
    }

    private static boolean testPointInLoop(List<IParametric3D> loop, Point3d p, Vector3d dir, boolean[] result) {
        int numIsects = 0;
        double dirTol = 1.0E-6 / dir.length();
        boolean isectAtVert = false;
        double[] st = new double[2];
        for (IParametric3D curve : loop) {
            double lineTol;
            Point3d p2;
            Point3d p1 = curve.get(0.0);
            if (!Inter3D.copLineLineSeg(p, dir, p1, p2 = curve.get(1.0), st, 1.0E-6, lineTol = 1.0E-6 / p1.distance(p2)) || !theUtil.ge0(st[0], dirTol)) continue;
            if (theUtil.eq0(st[0], dirTol)) {
                result[0] = true;
                return true;
            }
            if (theUtil.eq0(st[1], lineTol) || theUtil.eq(st[1], 1.0, lineTol)) {
                isectAtVert = true;
                continue;
            }
            ++numIsects;
        }
        if (isectAtVert) {
            return false;
        }
        result[0] = numIsects % 2 != 0;
        return true;
    }

    private static double randomVecComp(Random rand) {
        return rand.nextDouble() * 2.0 - 1.0;
    }

    private static Vector3d newRandomVec2D(Random rand) {
        return new Vector3d(Model.randomVecComp(rand), Model.randomVecComp(rand), 0.0);
    }

    private static Vector3d newRandomVec3D(Random rand) {
        return new Vector3d(Model.randomVecComp(rand), Model.randomVecComp(rand), Model.randomVecComp(rand));
    }

    private static boolean pointInLoop(List<IParametric3D> loop, Plane3d plane, Point3d projp) {
        Random random = new Random(1L);
        Matrix4d lwXform = Util.getLocalToWorldXform(plane);
        int maxTries = 3;
        for (int m = 0; m < maxTries; ++m) {
            Vector3d testVec = Model.newRandomVec2D(random);
            lwXform.transform(testVec);
            boolean[] pointInLoop = new boolean[1];
            if (!Model.testPointInLoop(loop, projp, testVec, pointInLoop)) continue;
            return pointInLoop[0];
        }
        for (IParametric3D curve : loop) {
            boolean[] pointInLoop;
            Point3d p2 = curve.get(0.5);
            Vector3d testVec = Util3D.vector(projp, p2);
            if (testVec.length() < 2.0E-6 || !Model.testPointInLoop(loop, projp, testVec, pointInLoop = new boolean[1])) continue;
            return pointInLoop[0];
        }
        System.err.printf("No result found for pointInLoop %s%n", projp.toString());
        return false;
    }

    private boolean testPointInEdgeLoop(Face face, Point3d p, Vector3d testVec, AABox loopBounds, boolean[] pointInLoop) {
        double[] rayIsects = Inter3D.rayAABoxIsect(p, testVec, loopBounds.getMin(), loopBounds.getMax(), 1.0E-6);
        if (rayIsects != null) {
            Point3d p2 = Util3D.linePoint(p, testVec, rayIsects[1]);
            List<Edge> potEdges = Model.find(this.d_edgeSearch, new LineSegRTreeTest(p, p2));
            ArrayList<IParametric3D> testCurves = new ArrayList<IParametric3D>(potEdges.size());
            for (int m = 0; m < potEdges.size(); ++m) {
                Edge potEdge = potEdges.get(m);
                if (!potEdge.faces.contains(face) || face.isInternalEdge(potEdge)) continue;
                testCurves.add(potEdge.curve);
            }
            return Model.testPointInLoop(testCurves, p, testVec, pointInLoop);
        }
        pointInLoop[0] = false;
        return true;
    }

    private boolean pointInEdgeLoop(Face face, Plane3d plane, Point3d projp, AABox loopBounds) {
        int m;
        boolean[] pointInLoop = new boolean[1];
        Random random = new Random(1L);
        Matrix4d lwXform = Util.getLocalToWorldXform(plane);
        int maxTries = 3;
        for (m = 0; m < maxTries; ++m) {
            Vector3d testVec = Model.newRandomVec2D(random);
            lwXform.transform(testVec);
            if (!this.testPointInEdgeLoop(face, projp, testVec, loopBounds, pointInLoop)) continue;
            return pointInLoop[0];
        }
        for (m = 0; m < face.edgeLoops.size(); ++m) {
            FaceLoop loop = face.edgeLoops.get(m);
            for (int n = 0; n < loop.edges.size(); ++n) {
                EdgeUse eu = loop.edges.get(n);
                Point3d p2 = eu.edge.curve.get(0.5);
                Vector3d testVec = Util3D.vector(projp, p2);
                if (testVec.length() < 2.0E-6 || !this.testPointInEdgeLoop(face, projp, testVec, loopBounds, pointInLoop)) continue;
                return pointInLoop[0];
            }
        }
        System.err.printf("No result found for pointInLoop %s%n", projp.toString());
        return false;
    }

    public Point3d pointInFace(Face face, Point3d p) {
        boolean result;
        Point3d projp = face.plane.projectOntoPlane(p);
        if (!Model.compare(projp, p) || !face.getBounds().contains(p, 1.0E-6)) {
            return null;
        }
        long tbegin = System.nanoTime();
        int ecount = 0;
        for (FaceLoop loop : face.edgeLoops) {
            ecount += loop.edges.size();
        }
        if (ecount > 30) {
            result = this.pointInEdgeLoop(face, face.plane, projp, face.getBounds());
        } else {
            ArrayList<IParametric3D> curves = new ArrayList<IParametric3D>(ecount);
            for (int m = 0; m < face.edgeLoops.size(); ++m) {
                FaceLoop loop = face.edgeLoops.get(m);
                for (int n = 0; n < loop.edges.size(); ++n) {
                    curves.add(loop.edges.get((int)n).edge.curve);
                }
            }
            result = Model.pointInLoop(curves, face.plane, projp);
        }
        long tend = System.nanoTime();
        t_pointInFace += (double)(tend - tbegin) * 1.0E-9;
        ++t_nPointInFace;
        return result ? projp : null;
    }

    private boolean pointInSolid(Collection<Face> faces, LineSeg3D testCurve) {
        int numIsects = 0;
        for (Face face : faces) {
            double[] isect = this.isect(testCurve, face);
            if (isect == null || isect.length <= 0) continue;
            if (Model.compare(testCurve.get(isect[0]), testCurve.get(0.0))) {
                return true;
            }
            numIsects += isect.length;
        }
        return numIsects % 2 != 0;
    }

    private boolean contains(Point3d rayp, Vector3d raydir) {
        AABox bounds = this.getBoundingBox();
        if (!bounds.contains(rayp, 1.0E-6)) {
            return false;
        }
        double[] rayIsects = Inter3D.rayAABoxIsect(rayp, raydir, bounds.getMin(), bounds.getMax(), 1.0E-6);
        if (rayIsects != null) {
            Point3d p2 = Util3D.linePoint(rayp, raydir, rayIsects[1]);
            List<Face> potFaces = Model.compare(rayp, p2) ? Model.find(this.d_faceSearch, new AABox(rayp)) : Model.find(this.d_faceSearch, new LineSegRTreeTest(rayp, p2));
            double p2t = Math.max(1.0, rayIsects[1] * 2.0);
            return this.pointInSolid(potFaces, new LineSeg3D(rayp, Util3D.linePoint(rayp, raydir, p2t)));
        }
        return false;
    }

    public boolean contains(Point3d p) {
        Random random = new Random(1L);
        Vector3d testVec = Model.newRandomVec3D(random);
        return this.contains(p, testVec);
    }

    private static boolean pointOnLoop(Point3d testPoint, List<IParametric3D> loop) {
        for (IParametric3D curve : loop) {
            double neart;
            Point3d nearpt = curve.get(neart = curve.getClosestT(testPoint));
            if (!Model.compare(nearpt, testPoint)) continue;
            return true;
        }
        return false;
    }

    private boolean pointOnBoundary(Point3d testPt, Face face) {
        int edgeCount = 0;
        for (FaceLoop loop : face.edgeLoops) {
            edgeCount += loop.edges.size();
        }
        if (edgeCount < 10) {
            for (FaceLoop loop : face.edgeLoops) {
                if (!Model.pointOnLoop(testPt, loop.getCurves())) continue;
                return true;
            }
        } else {
            for (Edge edge : this.findEdges(new AABox(testPt))) {
                double neart;
                if (!edge.faces.contains(face) || !Model.compare(edge.curve.get(neart = edge.curve.getClosestT(testPt)), testPt)) continue;
                return true;
            }
        }
        return false;
    }

    public static double[] isect(IParametric3D c1, IParametric3D c2) {
        Point3d pa1 = c1.get(0.0);
        Point3d pb1 = c1.get(1.0);
        Point3d pa2 = c2.get(0.0);
        Point3d pb2 = c2.get(1.0);
        return Inter3D.lineSegLineSegIntersection(pa1, pb1, pa2, pb2, 1.0E-6);
    }

    private static boolean compare(Edge edge1, Edge edge2, Map<Vertex, Vertex> m1Verts) {
        Vertex e1v1mate = m1Verts.get(edge1.v1);
        Vertex e1v2mate = m1Verts.get(edge1.v2);
        return e1v1mate == edge2.v1 && e1v2mate == edge2.v2 || e1v1mate == edge2.v2 && e1v2mate == edge2.v1;
    }

    public double[] isect(IParametric3D curve, Face face) {
        double[] isects = curve.getIsects(face.plane, 1.0E-6);
        if (isects != null && isects.length > 0) {
            ArrayList<Double> validIsects = new ArrayList<Double>(isects.length);
            for (double isect : isects) {
                Point3d isectLoc = curve.get(isect);
                if (this.pointInFace(face, isectLoc) == null) continue;
                validIsects.add(isect);
            }
            return theUtil.toDoubleArray(validIsects);
        }
        return new double[0];
    }

    private static boolean compare(Face face1, Face face2, Map<Vertex, Vertex> v1Mates, Map<Edge, Edge> e1Mates) {
        if (face1.edgeLoops.size() != face2.edgeLoops.size()) {
            return false;
        }
        for (FaceLoop loop1 : face1.edgeLoops) {
            boolean loopFound = false;
            for (FaceLoop loop2 : face2.edgeLoops) {
                if (!Model.compare(loop1, loop2, v1Mates, e1Mates)) continue;
                loopFound = true;
                break;
            }
            if (loopFound) continue;
            return false;
        }
        return true;
    }

    private static boolean compare(FaceLoop loop1, FaceLoop loop2, Map<Vertex, Vertex> v1Mates, Map<Edge, Edge> e1Mates) {
        if (loop1.vert != null) {
            Vertex v1Mate = v1Mates.get(loop1.vert);
            return v1Mate != null && v1Mate == loop2.vert;
        }
        if (loop1.edges.size() != loop2.edges.size()) {
            return false;
        }
        for (EdgeUse eu1 : loop1.edges) {
            Edge e1Mate = e1Mates.get(eu1.edge);
            if (e1Mate == null) {
                return false;
            }
            boolean euFound = false;
            for (EdgeUse eu2 : loop2.edges) {
                if (eu2.edge != e1Mate) continue;
                euFound = true;
                break;
            }
            if (euFound) continue;
            return false;
        }
        return true;
    }

    private static boolean compare(Point3d p1, Point3d p2) {
        double dist = p1.distance(p2);
        return dist < 1.0E-6;
    }

    private static boolean curveOnSurface(IParametric3D curve, Face face) {
        double distTol = 1.0E-6;
        return face.plane.distance(curve.get(0.5)) <= distTol && face.plane.distance(curve.get(0.0)) <= distTol && face.plane.distance(curve.get(1.0)) <= distTol;
    }

    private static LineSeg3D isect(Plane3d plane1, Plane3d plane2) {
        Tuple3d[] isect = Inter3D.planePlaneIsect(plane1, plane2, 1.0E-6);
        if (isect == null) {
            return null;
        }
        return new LineSeg3D((Point3d)isect[0], Util3D.add((Point3d)isect[0], isect[1]));
    }

    public void transform(Matrix4d xform) {
        for (Vertex vert : this.d_mainGroup.verts) {
            vert.loc = Util3D.xform(xform, vert.loc);
            this.updateVertexSearch(vert, 1);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.curve = edge.curve.transform(xform);
            this.updateEdgeSearch(edge, 1);
        }
        for (Face face : this.d_mainGroup.faces) {
            face.calcPlane();
            face.invalidateBounds();
            this.updateFaceSearch(face, 1);
        }
    }

    public void optimize() {
        HashMap<IntArrHash, int[]> ids = new HashMap<IntArrHash, int[]>();
        Model.optimize(this.d_mainGroup.verts, ids);
        Model.optimize(this.d_mainGroup.edges, ids);
        Model.optimize(this.d_mainGroup.faces, ids);
    }

    private static void optimize(Collection<? extends AModelObj> objs, Map<IntArrHash, int[]> map) {
        for (AModelObj aModelObj : objs) {
            IntArrHash hash = new IntArrHash(aModelObj.groups);
            int[] existing = map.get(hash);
            if (existing == null) {
                map.put(hash, aModelObj.groups);
                continue;
            }
            aModelObj.groups = existing;
        }
    }

    public static class Vertices {
        public static Iterable<Vertex> get(final FaceLoop loop) {
            return new Iterable<Vertex>(){

                @Override
                public Iterator<Vertex> iterator() {
                    return new LoopVertexIterator(loop);
                }
            };
        }
    }

    public static class LoopVertexIterator
    implements Iterator<Vertex> {
        private final FaceLoop d_loop;
        private int d_index;

        public LoopVertexIterator(FaceLoop loop) {
            this.d_loop = loop;
            this.d_index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.d_loop.vert != null ? this.d_index == 0 : this.d_index < this.d_loop.edges.size();
        }

        @Override
        public Vertex next() {
            Vertex vert = this.d_loop.vert != null ? this.d_loop.vert : this.d_loop.edges.get(this.d_index).v1();
            ++this.d_index;
            return vert;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IntArrHash {
        public final int[] vals;

        public IntArrHash(int[] vals) {
            this.vals = vals;
        }

        public int hashCode() {
            int hash = 0;
            for (int val : this.vals) {
                hash += val;
            }
            return hash;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof IntArrHash && NmtUtil.equal(((IntArrHash)obj).vals, this.vals);
        }
    }

    private static class FaceEdgeInsert {
        public FaceLoop loop;
        public int edgeIx;

        public FaceEdgeInsert() {
        }

        public FaceEdgeInsert(FaceLoop loop, int edgeIx) {
            this.loop = loop;
            this.edgeIx = edgeIx;
        }
    }

    private static class CrossoverSearcher<T extends AModelObj>
    implements GeomSearcher<T> {
        private static final int CROSSOVER = 30;
        private RTree<T> d_searchTree;
        private AABox d_cachedBounds;
        private Map<T, AABox> d_boxCache = new LinkedIdentityHashMap<T, AABox>();

        private CrossoverSearcher() {
        }

        @Override
        public void add(T obj) {
            if (this.d_boxCache != null) {
                this.d_boxCache.put(obj, ((AModelObj)obj).getBounds());
                if (this.d_boxCache.size() == 30) {
                    this.d_searchTree = new RTree();
                    for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                        this.d_searchTree.insert((ISearchVol)entry.getValue(), entry.getKey());
                    }
                    this.d_boxCache = null;
                }
            } else {
                this.d_searchTree.insert(((AModelObj)obj).getBounds(), obj);
            }
            this.d_cachedBounds = null;
        }

        @Override
        public void remove(T obj) {
            if (this.d_searchTree != null) {
                this.d_searchTree.remove(obj);
                if (this.d_searchTree.count() == 29) {
                    this.d_boxCache = this.d_searchTree.getCachedBounds();
                    this.d_boxCache.remove(obj);
                    this.d_searchTree = null;
                }
            } else {
                this.d_boxCache.remove(obj);
            }
            this.d_cachedBounds = null;
        }

        @Override
        public void update(T obj) {
            if (this.d_searchTree != null) {
                this.d_searchTree.remove(obj);
                this.d_searchTree.insert(((AModelObj)obj).getBounds(), obj);
            } else {
                this.d_boxCache.remove(obj);
                this.d_boxCache.put(obj, ((AModelObj)obj).getBounds());
            }
            this.d_cachedBounds = null;
        }

        @Override
        public void clear() {
            this.d_boxCache = new LinkedIdentityHashMap<T, AABox>();
            this.d_searchTree = null;
            this.d_cachedBounds = null;
        }

        @Override
        public List<T> find(ITest<AABox> test) {
            ArrayList<T> result = new ArrayList<T>();
            if (this.d_searchTree != null) {
                this.d_searchTree.find(test, (IResult<T>)new CollResult(result));
            } else {
                for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                    if (!test.test((AABox)entry.getValue()).positive) continue;
                    result.add(entry.getKey());
                }
            }
            return result;
        }

        @Override
        public GeomSearcher<T> clone(Map<T, T> map) {
            CrossoverSearcher clone;
            try {
                clone = (CrossoverSearcher)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            if (this.d_boxCache != null) {
                clone.d_boxCache = new LinkedIdentityHashMap<T, AABox>(this.d_boxCache.size());
                for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                    clone.d_boxCache.put(map.get(entry.getKey()), entry.getValue());
                }
            } else {
                clone.d_searchTree = this.d_searchTree.clone(map);
            }
            if (this.d_cachedBounds != null) {
                clone.d_cachedBounds = (AABox)this.d_cachedBounds.clone();
            }
            return clone;
        }

        @Override
        public AABox getBounds() {
            if (this.d_searchTree != null) {
                return this.d_searchTree.getBoundingBox();
            }
            if (this.d_cachedBounds == null) {
                this.d_cachedBounds = new AABox();
                for (AABox box : this.d_boxCache.values()) {
                    this.d_cachedBounds.add(box);
                }
            }
            return this.d_cachedBounds;
        }
    }

    private static class ListSearcher<T extends AModelObj>
    implements GeomSearcher<T> {
        private AABox d_cachedBounds;
        private Map<T, AABox> d_boxCache = new LinkedIdentityHashMap<T, AABox>();

        private ListSearcher() {
        }

        @Override
        public void add(T obj) {
            this.d_boxCache.put(obj, ((AModelObj)obj).getBounds());
            this.d_cachedBounds = null;
        }

        @Override
        public void remove(T obj) {
            this.d_boxCache.remove(obj);
            this.d_cachedBounds = null;
        }

        @Override
        public void update(T obj) {
            this.d_boxCache.remove(obj);
            this.d_boxCache.put(obj, ((AModelObj)obj).getBounds());
            this.d_cachedBounds = null;
        }

        @Override
        public void clear() {
            this.d_boxCache = new LinkedIdentityHashMap<T, AABox>();
            this.d_cachedBounds = null;
        }

        @Override
        public List<T> find(ITest<AABox> test) {
            ArrayList<T> result = new ArrayList<T>();
            for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                Containment containment = test.test(entry.getValue());
                if (!containment.positive) continue;
                result.add(entry.getKey());
            }
            return result;
        }

        @Override
        public GeomSearcher<T> clone(Map<T, T> map) {
            ListSearcher clone;
            try {
                clone = (ListSearcher)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            clone.d_boxCache = new LinkedIdentityHashMap<T, AABox>(this.d_boxCache.size());
            for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                clone.d_boxCache.put(map.get(entry.getKey()), entry.getValue());
            }
            if (this.d_cachedBounds != null) {
                clone.d_cachedBounds = (AABox)this.d_cachedBounds.clone();
            }
            return clone;
        }

        @Override
        public AABox getBounds() {
            if (this.d_cachedBounds == null) {
                this.d_cachedBounds = new AABox();
                for (AABox box : this.d_boxCache.values()) {
                    this.d_cachedBounds.add(box);
                }
            }
            return this.d_cachedBounds;
        }
    }

    private static class TreeSearcher<T extends AModelObj>
    implements GeomSearcher<T> {
        private RTree<T> d_searchTree = new RTree();

        private TreeSearcher() {
        }

        @Override
        public void add(T obj) {
            this.d_searchTree.insert(((AModelObj)obj).getBounds(), obj);
        }

        @Override
        public void remove(T obj) {
            this.d_searchTree.remove(obj);
        }

        @Override
        public void update(T obj) {
            this.d_searchTree.remove(obj);
            this.d_searchTree.insert(((AModelObj)obj).getBounds(), obj);
        }

        @Override
        public void clear() {
            this.d_searchTree.clear();
        }

        @Override
        public List<T> find(ITest<AABox> test) {
            ArrayList result = new ArrayList();
            this.d_searchTree.find(test, (IResult<T>)new CollResult(result));
            return result;
        }

        @Override
        public GeomSearcher<T> clone(Map<T, T> map) {
            TreeSearcher clone;
            try {
                clone = (TreeSearcher)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            clone.d_searchTree = this.d_searchTree.clone(map);
            return clone;
        }

        @Override
        public AABox getBounds() {
            return this.d_searchTree.getBoundingBox();
        }
    }

    private static interface GeomSearcher<T extends AModelObj>
    extends Cloneable {
        public void add(T var1);

        public void remove(T var1);

        public void update(T var1);

        public void clear();

        public List<T> find(ITest<AABox> var1);

        public GeomSearcher<T> clone(Map<T, T> var1);

        public AABox getBounds();
    }

    public static class Group
    implements Serializable,
    Cloneable {
        static final long serialVersionUID = 1L;
        public final int id;
        public final Collection<Face> faces;
        public final Collection<Edge> edges;
        public final Collection<Vertex> verts;

        public Group(int id, Class<? extends Collection> collectionType) {
            this.id = id;
            this.faces = Group.newCollection(collectionType);
            this.edges = Group.newCollection(collectionType);
            this.verts = Group.newCollection(collectionType);
        }

        private static <T> Collection<T> newCollection(Class<? extends Collection> type) {
            try {
                return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                return new ArrayList();
            }
        }

        public void add(AModelObj obj) {
            if (obj instanceof Vertex) {
                this.verts.add((Vertex)obj);
            } else if (obj instanceof Edge) {
                this.edges.add((Edge)obj);
            } else if (obj instanceof Face) {
                this.faces.add((Face)obj);
            }
        }

        public void clear() {
            this.faces.clear();
            this.edges.clear();
            this.verts.clear();
        }
    }
}

