/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt;

import java.util.IdentityHashMap;
import java.util.Map;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Edge;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Vertex;

public class CloneMap {
    private final Map<Vertex, Vertex> d_vertMap = new IdentityHashMap<Vertex, Vertex>();
    private final Map<Edge, Edge> d_edgeMap = new IdentityHashMap<Edge, Edge>();
    private final Map<Face, Face> d_faceMap = new IdentityHashMap<Face, Face>();

    private static <T> T get(Map<T, T> map, T key) {
        T result = map.get(key);
        assert (result != null);
        return result;
    }

    public Map<Vertex, Vertex> getVertMap() {
        return this.d_vertMap;
    }

    public Map<Edge, Edge> getEdgeMap() {
        return this.d_edgeMap;
    }

    public Map<Face, Face> getFaceMap() {
        return this.d_faceMap;
    }

    public Vertex get(Vertex vert) {
        return CloneMap.get(this.d_vertMap, vert);
    }

    public Edge get(Edge edge) {
        return CloneMap.get(this.d_edgeMap, edge);
    }

    public Face get(Face face) {
        return CloneMap.get(this.d_faceMap, face);
    }

    public void put(Vertex original, Vertex clone) {
        this.d_vertMap.put(original, clone);
    }

    public void put(Edge original, Edge clone) {
        this.d_edgeMap.put(original, clone);
    }

    public void put(Face original, Face clone) {
        this.d_faceMap.put(original, clone);
    }
}

