/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import javax.vecmath.Point2d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class PolyBuilder {
    private final double d_distTol;
    private final double d_vertWeldDist;
    private final HashMap<Point2d, Vert> d_vertMap;
    private final List<Edge> d_edges = new ArrayList<Edge>();

    public PolyBuilder(double disttol) {
        this(disttol, disttol);
    }

    public PolyBuilder(double disttol, double vertWeldDist) {
        this.d_vertMap = new LinkedHashMap<Point2d, Vert>();
        this.d_distTol = disttol;
        this.d_vertWeldDist = vertWeldDist;
    }

    public boolean addEdge(double p1x, double p1y, double p2x, double p2y) {
        return this.addEdge(new Point2d(p1x, p1y), new Point2d(p2x, p2y));
    }

    public boolean addEdge(Point2d p1, Point2d p2) {
        Vert v2;
        Vert v1 = this.getVert(p1);
        if (v1 == (v2 = this.getVert(p2))) {
            return false;
        }
        Edge edge = new Edge(v1, v2, this.d_distTol);
        for (Edge otherEdge : this.d_edges) {
            List<double[]> isects = this.isect(edge, otherEdge);
            for (double[] isect : isects) {
                Point2d p2a;
                Point2d p1a = this.getVert(edge, isect[0]);
                if (!p1a.equals(p2a = this.getVert(otherEdge, isect[1]))) continue;
                Vert v = this.d_vertMap.get(p1a);
                if (v == null) {
                    v = new Vert(p1a);
                    this.d_vertMap.put(p1a, v);
                }
                if (!edge.divs.containsValue(v)) {
                    isect[0] = Inter2D.nearestTOnLineSeg(v.p, ((Edge)edge).v1.p, ((Edge)edge).v2.p);
                    edge.divs.put(isect[0], v);
                }
                if (otherEdge.divs.containsValue(v)) continue;
                isect[1] = Inter2D.nearestTOnLineSeg(v.p, ((Edge)otherEdge).v1.p, ((Edge)otherEdge).v2.p);
                otherEdge.divs.put(isect[1], v);
            }
        }
        this.d_edges.add(edge);
        return true;
    }

    private Point2d getVert(Edge edge, double t) {
        return Util2D.round(Util2D.linePoint(((Edge)edge).v1.p, ((Edge)edge).v2.p, t), this.d_distTol);
    }

    private Vert getVert(Point2d p) {
        Point2d rp = Util2D.round(p, this.d_vertWeldDist);
        Vert vert = this.d_vertMap.get(rp);
        if (vert == null) {
            vert = new Vert(p);
            this.d_vertMap.put(rp, vert);
        }
        return vert;
    }

    private List<double[]> isect(Edge edge1, Edge edge2) {
        if (edge1.equals(edge2)) {
            ArrayList<double[]> isects = new ArrayList<double[]>(1);
            isects.add(new double[]{0.0, 0.0});
            isects.add(new double[]{1.0, 1.0});
            return isects;
        }
        if (!Inter2D.aabbAABBIntersect(edge1.d_minx, edge1.d_miny, edge1.d_maxx, edge1.d_maxy, edge2.d_minx, edge2.d_miny, edge2.d_maxx, edge2.d_maxy)) {
            return Collections.EMPTY_LIST;
        }
        double[] isect = Inter2D.isectLinesegLineseg(((Edge)edge1).v1.p, ((Edge)edge1).v2.p, ((Edge)edge2).v1.p, ((Edge)edge2).v2.p, this.d_distTol);
        if (isect != null) {
            return Arrays.asList(new double[][]{isect});
        }
        double[][] overlap = Inter2D.lineSeglineSegOverlap(((Edge)edge1).v1.p, ((Edge)edge1).v2.p, ((Edge)edge2).v1.p, ((Edge)edge2).v2.p, this.d_distTol);
        if (overlap != null) {
            ArrayList<double[]> isects = new ArrayList<double[]>(2);
            isects.add(new double[]{overlap[0][0], overlap[1][0]});
            isects.add(new double[]{overlap[0][1], overlap[1][1]});
            return isects;
        }
        return Collections.EMPTY_LIST;
    }

    public Result build() {
        ArrayList<Point2d> verts = new ArrayList<Point2d>(this.d_vertMap.size());
        HashMap<Point2d, Integer> vmap = new HashMap<Point2d, Integer>();
        for (Vert v : this.d_vertMap.values()) {
            if (vmap.containsKey(v.p)) continue;
            vmap.put(v.p, vmap.size());
            verts.add(v.p);
        }
        ArrayList<Integer> iedges = new ArrayList<Integer>(this.d_edges.size() * 2);
        HashSet<IEdge> edges = new HashSet<IEdge>();
        for (Edge e : this.d_edges) {
            Iterator vertit = e.divs.values().iterator();
            int i1 = (Integer)vmap.get(((Vert)vertit.next()).p);
            while (vertit.hasNext()) {
                Vert curr = (Vert)vertit.next();
                int i2 = (Integer)vmap.get(curr.p);
                IEdge ie = new IEdge(i1, i2);
                if (edges.add(ie)) {
                    iedges.add(i1);
                    iedges.add(i2);
                }
                i1 = i2;
            }
        }
        return new Result(verts.toArray(new Point2d[verts.size()]), theUtil.toIntArray(iedges));
    }

    private static class IEdge {
        private final int i1;
        private final int i2;

        public IEdge(int i1, int i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        public int hashCode() {
            return this.i1 + this.i2;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            IEdge e = (IEdge)obj;
            return this.i1 == e.i1 && this.i2 == e.i2 || this.i1 == e.i2 && this.i2 == e.i1;
        }
    }

    public static class Result {
        public final Point2d[] verts;
        public final int[] edges;

        public Result(Point2d[] verts, int[] edges) {
            this.verts = verts;
            this.edges = edges;
        }
    }

    private static class Edge {
        private final Vert v1;
        private final Vert v2;
        private final TreeMap<Double, Vert> divs;
        private double d_minx;
        private double d_miny;
        private double d_maxx;
        private double d_maxy;

        public Edge(Vert v1, Vert v2, double bbtol) {
            this.v1 = v1;
            this.v2 = v2;
            this.divs = new TreeMap();
            this.divs.put(0.0, v1);
            this.divs.put(1.0, v2);
            if (v1.p.x <= v2.p.x) {
                this.d_minx = v1.p.x;
                this.d_maxx = v2.p.x;
            } else {
                this.d_minx = v2.p.x;
                this.d_maxx = v1.p.x;
            }
            if (v1.p.y <= v2.p.y) {
                this.d_miny = v1.p.y;
                this.d_maxy = v2.p.y;
            } else {
                this.d_miny = v2.p.y;
                this.d_maxy = v1.p.y;
            }
            this.d_minx -= bbtol;
            this.d_miny -= bbtol;
            this.d_maxx += bbtol;
            this.d_maxy += bbtol;
        }

        public boolean equals(Edge edge) {
            return this.v1 == edge.v1 && this.v2 == edge.v2 || this.v1 == edge.v2 && this.v2 == edge.v1;
        }
    }

    private static class Vert {
        public final Point2d p;

        public Vert(Point2d p) {
            this.p = p;
        }
    }
}

