/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.evac.DoorList;
import pyrosim.legacy_2012_1.domain.evac.Evac;
import pyrosim.legacy_2012_1.domain.evac.EvacList;
import pyrosim.legacy_2012_1.domain.evac.ExitList;
import pyrosim.legacy_2012_1.domain.evac.Pers;
import pyrosim.legacy_2012_1.domain.evac.PersList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class EvacParser
extends AFDS5Parser {
    public EvacParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id;
        if (!rec.contains("ID")) {
            this.addWarning(rec, Intl.intl("Unable to process EVAC record: ID missing"), Intl.intl("EVAC Record Ignored"));
            return false;
        }
        EvacList mgr = this.getContainer().getEvacList();
        if (mgr.get(id = rec.getString("ID")) != null) {
            int i = 1;
            String idBase = id;
            while (mgr.get(id = String.format("%s[%d]", idBase, i)) != null) {
            }
            this.addWarning(rec, Intl.intl("Invalid EVAC record: Duplicate ID"), String.format(Intl.intl("ID changed from \"%s\"to \"%s\""), idBase, id));
        }
        GridList grids = this.getContainer().getGridManager();
        PersList pers = this.getContainer().getPersList();
        Pers per = rec.contains("PERS_ID") ? (Pers)pers.get(rec.getString("PERS_ID")) : null;
        Evac obj = new Evac(id, per);
        obj.setProp("FYI", rec.get("FYI"));
        if (rec.contains("XB")) {
            FDSArray<UnitDouble> xbRaw = rec.getArray("XB", false);
            obj.setProp("XB", xbRaw.toFlatArray(new UnitDouble[xbRaw.getTotalLength()]));
        }
        if (rec.contains("MESH_ID")) {
            obj.setProp("MESH_ID", grids.get(rec.getString("MESH_ID")));
        }
        obj.setProp("NUMBER_INITIAL_PERSONS", rec.get("NUMBER_INITIAL_PERSONS"));
        if (rec.contains("PERS_ID")) {
            obj.setProp("PERS_ID", pers.get(rec.getString("PERS_ID")));
        }
        obj.setProp("ANGLE", rec.get("ANGLE"));
        obj.setProp("AVATAR_RGB", this.parseColor(rec, "AVATAR_RGB", "AVATAR_COLOR", null, false));
        if (rec.contains("FLOW_FIELD_ID")) {
            obj.setProp("FLOW_FIELD_ID", grids.get(rec.getString("FLOW_FIELD_ID")));
        }
        List knownDoorNames = rec.getList("KNOWN_DOOR_NAMES", false);
        List knownDoorProbs = rec.getList("KNOWN_DOOR_PROBS", false);
        if (knownDoorNames != null && !knownDoorNames.isEmpty()) {
            if (knownDoorNames.size() != knownDoorProbs.size()) {
                this.addWarning(rec, Intl.intl("List length mismatch: KNOWN_DOOR_NAMES, KNOWN_DOOR_PROBS"), Intl.intl("Ignoring tailing entries."));
            }
            ExitList exits = this.getContainer().getExitList();
            DoorList doors = this.getContainer().getDoorList();
            HashMap knownDoors = new HashMap();
            int n = Math.min(knownDoorNames.size(), knownDoorProbs.size());
            for (int i = 0; i < n; ++i) {
                String doorName = (String)knownDoorNames.get(i);
                NamedPyroObject door = null;
                if (door == null) {
                    door = (NamedPyroObject)exits.get(doorName);
                }
                if (door == null) {
                    door = (NamedPyroObject)doors.get(doorName);
                }
                if (door == null) {
                    this.addWarning(rec, String.format(Intl.intl("Invalid EVAC record: Unknown door \"%s\""), doorName), Intl.intl("EVAC Record Ignored"));
                    return false;
                }
                knownDoors.put(door, knownDoorProbs.get(i));
            }
            obj.setProp("KNOWN_DOOR_PROBS", knownDoors);
        }
        mgr.add(obj);
        this.flagObjectAdded(obj);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("EVAC");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }
}

