/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.controls.LatchCtrl;
import pyrosim.legacy_2012_1.domain.controls.NotOp;
import pyrosim.legacy_2012_1.domain.devices.AlarmInfo;
import pyrosim.legacy_2012_1.domain.devices.IDevice;
import pyrosim.legacy_2012_1.domain.devices.TripFlags;
import pyrosim.legacy_2012_1.domain.devices.aspiration.Aspirator;
import pyrosim.legacy_2012_1.domain.devices.aspiration.AspiratorSampler;
import pyrosim.legacy_2012_1.domain.devices.detectors.CableFailDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.IDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLink;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.Timer;
import pyrosim.legacy_2012_1.domain.devices.hvac.HvacDevice;
import pyrosim.legacy_2012_1.domain.devices.measurers.AABoxMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.Clock;
import pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple;
import pyrosim.legacy_2012_1.domain.devices.sprayers.ASprayer;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Nozzle;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Sprinkler;
import pyrosim.legacy_2012_1.domain.geom.AttachedPointLoc;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.hvac.HvacDuct;
import pyrosim.legacy_2012_1.domain.hvac.HvacNode;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.signals.IDoubleOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.common.GeomUtil;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PropParser;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitLineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class DeviceParser
extends AFDS5Parser {
    private final PinConnParser d_pinConns;
    private final PropParser d_propParser;
    private final List<FDSParseRecord> d_aspSamplerRecs = new ArrayList<FDSParseRecord>();

    public DeviceParser(FDS5ParsingInfo parsingInfo, PinConnParser pinConns, PropParser propParser) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
        this.d_propParser = propParser;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("DEVC");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        return this.processDevc(rec);
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        for (FDSParseRecord rec : this.d_aspSamplerRecs) {
            String aspID = (String)rec.get("DEVC_ID");
            if (aspID == null) continue;
            String samplerID = (String)rec.get("ID");
            UnitDouble flowrate = (UnitDouble)rec.get("FLOWRATE", true);
            UnitDouble delay = (UnitDouble)rec.get("DELAY", true);
            AspiratorSampler sampler = (AspiratorSampler)this.getContainer().getDevices().get(samplerID);
            Aspirator asp = (Aspirator)this.getContainer().getDevices().get(aspID);
            if (asp == null) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("Could not find aspirator: %s"), aspID));
            }
            asp.setSamplerLine(new Aspirator.SamplerLine(sampler, flowrate, delay));
        }
    }

    private IQuantity parseQuantity(FDSParseRecord devcRec, FDSParseRecord propRec, String failAction, boolean quantityRequired, boolean throwError) throws FDSRecordFormatException {
        String nodeIdKey;
        String ductIdKey;
        String matlIdKey;
        String specIdKey;
        String partIdKey;
        String quantKey;
        FDSParseRecord quantitySource = devcRec;
        String deviceType = (String)devcRec.get("QUANTITY", false);
        if (deviceType == null) {
            quantitySource = propRec;
            deviceType = (String)propRec.get("QUANTITY", false);
            if (deviceType == null) {
                return null;
            }
        }
        if (quantitySource.getType().equals("DEVC")) {
            quantKey = "QUANTITY";
            partIdKey = "PART_ID";
            specIdKey = "SPEC_ID";
            matlIdKey = "MATL_ID";
            ductIdKey = "DUCT_ID";
            nodeIdKey = "NODE_ID";
        } else {
            quantKey = "QUANTITY";
            partIdKey = "PART_ID";
            specIdKey = "SPEC_ID";
            matlIdKey = null;
            ductIdKey = null;
            nodeIdKey = null;
        }
        return this.parseQuantity(quantitySource, quantKey, partIdKey, specIdKey, matlIdKey, ductIdKey, nodeIdKey, 0, failAction, quantityRequired, throwError);
    }

    protected boolean processDevc(FDSParseRecord devcRec) throws FDSRecordFormatException {
        FDSParseRecord propRec;
        String propID;
        String fdsStat = (String)devcRec.get("STATISTICS", false);
        if (fdsStat != null) {
            return true;
        }
        boolean idFab = false;
        String id = (String)devcRec.get("ID");
        if (id == null || id.trim().equals("")) {
            id = Util.getUniqueName(this.getContainer().getDevices(), Intl.intl("DEVC"));
            idFab = true;
        }
        if ((propID = (String)devcRec.get("PROP_ID")) == null) {
            propRec = PropParser.getDefaultProp();
        } else {
            propRec = this.d_propParser.getProp(propID);
            if (propRec == null) {
                throw new FDSRecordFormatException(devcRec, String.format(Intl.intl("PROP record, %s, could not be found."), propID));
            }
        }
        String deviceType = (String)devcRec.get("QUANTITY", false);
        if (deviceType == null && (deviceType = (String)propRec.get("QUANTITY", false)) == null) {
            this.addWarning(devcRec, Intl.intl("The device type could not be determined from the DEVC or PROP record."), Intl.intl("Adding device to additional records section."));
            return false;
        }
        IDevice device = null;
        if (propRec.contains("PART_ID")) {
            device = this.parseSprayer(devcRec, propRec, id, deviceType);
        } else if (deviceType.equals("SPRINKLER LINK TEMPERATURE")) {
            device = this.parseSprinklerLink(devcRec, propRec, id);
        } else if (deviceType.equals("LINK TEMPERATURE")) {
            device = this.parseHeatDetector(devcRec, propRec, id);
        } else if (deviceType.equals("spot obscuration") || deviceType.equals("CHAMBER OBSCURATION")) {
            device = this.parseSmokeDetector(devcRec, propRec, id);
        } else if (deviceType.equalsIgnoreCase("ASPIRATION")) {
            device = this.parseAspirator(devcRec, propRec, id);
        } else if (deviceType.equals("CABLE TEMPERATURE")) {
            device = this.parseCableMeasurer(devcRec, propRec, id);
        } else if (deviceType.startsWith("MASS FLOW") || deviceType.startsWith("HEAT FLOW") || deviceType.startsWith("VOLUME FLOW")) {
            device = this.parseFlowMeasurer(devcRec, propRec, id, deviceType);
        } else {
            IQuantity msr = this.parseQuantity(devcRec, propRec, Intl.intl("Adding to additional records section."), true, false);
            if (msr == null) {
                return false;
            }
            Quantity quant = msr.get();
            if (msr.equals(Quantity.SPEC_DENSITY.create(ExSpecList.MixFrac.SOOT.spec))) {
                device = this.parseSootDensityDevice(devcRec, propRec, id);
            } else if (quant.equals((Object)Quantity.PATH_OBSCURATION)) {
                device = this.parsePathObscurationMeasurer(devcRec, propRec, id);
            } else if (quant.equals((Object)Quantity.LAYER_HEIGHT)) {
                device = this.parseLayerInfoMeasurer(devcRec, propRec, id, true, false, false);
            } else if (quant.equals((Object)Quantity.UPPER_TEMPERATURE)) {
                device = this.parseLayerInfoMeasurer(devcRec, propRec, id, false, true, false);
            } else if (quant.equals((Object)Quantity.LOWER_TEMPERATURE)) {
                device = this.parseLayerInfoMeasurer(devcRec, propRec, id, false, false, true);
            } else if (quant.equals((Object)Quantity.TIME)) {
                device = this.parseClock(devcRec, id);
            } else if (!GasPointMeasurer.getQuantityFilter().shouldFilter(msr.get())) {
                device = this.parseGasPointMeasurer(devcRec, propRec, id, msr);
            } else if (!SolidPointMeasurer.getQuantityFilter().shouldFilter(msr.get())) {
                device = this.parseSolidPointMeasurer(devcRec, propRec, id, msr);
            } else if (!AABoxMeasurer.getQuantityFilter().shouldFilter(msr.get())) {
                device = this.parseAABoxMeasurer(devcRec, propRec, id, msr);
            } else if (HvacDevice.isValidQuantity(msr)) {
                device = this.parseHvacDevc(deviceType, devcRec, msr, id);
            }
        }
        if (device == null) {
            this.addWarning(devcRec, Intl.intl("Unknown device type encountered."), Intl.intl("Adding device to additional records section."));
            return false;
        }
        if (!idFab && device instanceof ISignalSource) {
            ISignalSource source = (ISignalSource)((Object)device);
            Iterator<? extends IOutPin> iterator = source.getOutputPins().iterator();
            while (iterator.hasNext()) {
                IOutPin pin;
                IOutPin finalPin = pin = iterator.next();
                this.d_pinConns.addOutputName(finalPin, id);
            }
            if (device instanceof Timer) {
                this.d_pinConns.addOutputName(Clock.INSTANCE.getMsrInfo().getPin(), id);
            }
        }
        if (device != Clock.INSTANCE) {
            int exists = this.existsStatus(devcRec, device, IDevice.class);
            if (exists != 0) {
                return this.convertToReturn(exists);
            }
            this.getContainer().getDevices().add(device);
            this.flagObjectAdded(device);
        }
        return true;
    }

    private IOutPin parseLatch(FDSParseRecord rec, IOutPin existing) {
        boolean latch = rec.getBoolean("LATCH", true);
        if (latch) {
            LatchCtrl ctrl = new LatchCtrl();
            if (!ctrl.getInputPin().canConnect(existing)) {
                return existing;
            }
            ctrl.getInputPin().connect(existing);
            return ctrl.getOutputPins().get(0);
        }
        return existing;
    }

    private IOutPin parseInvert(FDSParseRecord rec, IOutPin existing) {
        boolean initState = rec.getBoolean("INITIAL_STATE", true);
        if (initState) {
            NotOp op = new NotOp();
            if (!op.getInputPin().canConnect(existing)) {
                return existing;
            }
            op.getInputPin().connect(existing);
            return op.getOutputPins().get(0);
        }
        return existing;
    }

    private IDevice parseAABoxMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, IQuantity msr) throws FDSRecordFormatException {
        UnitAABox box = DeviceParser.parseAABox(devcRec, "DEVC", "XB", true);
        AABoxMeasurer msrr = new AABoxMeasurer(id, msr, box);
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        return msrr;
    }

    private FlowMeasurer parseFlowMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, String deviceType) throws FDSRecordFormatException {
        String quantity;
        int flowDir;
        String trimmed = deviceType.trim();
        char lastChar = trimmed.charAt(trimmed.length() - 1);
        switch (lastChar) {
            case '-': {
                flowDir = 1;
                quantity = trimmed.substring(0, trimmed.length() - 1).trim();
                break;
            }
            case '+': {
                flowDir = 0;
                quantity = trimmed.substring(0, trimmed.length() - 1).trim();
                break;
            }
            default: {
                flowDir = 2;
                quantity = trimmed;
            }
        }
        Quantity quant = this.getQuantityMap().getQuantity(quantity);
        if (quant == null || FlowMeasurer.getQuantityFilter().shouldFilter(quant)) {
            throw new FDSRecordFormatException(devcRec, Intl.intl("Invalid flow direction specified."));
        }
        AARectangle rect = this.parseAARectangle(devcRec);
        FlowMeasurer msrr = new FlowMeasurer(id, quant.create(), rect, flowDir);
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        return msrr;
    }

    private IDevice parseLayerInfoMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, boolean height, boolean upperTemp, boolean lowerTemp) throws FDSRecordFormatException {
        UnitLineSeg3D beam = DeviceParser.parseLineSeg3D(devcRec, "DEVC", "XB", true);
        LayerMeasurer msrr = new LayerMeasurer(id, height, upperTemp, lowerTemp, beam);
        if (height) {
            msrr.getHeightInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getHeightInfo().getPin()));
        }
        if (upperTemp) {
            msrr.getUpperTempInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getUpperTempInfo().getPin()));
        }
        if (lowerTemp) {
            msrr.getLowerTempInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getLowerTempInfo().getPin()));
        }
        return msrr;
    }

    private PathObscurationMeasurer parsePathObscurationMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        UnitLineSeg3D beam = DeviceParser.parseLineSeg3D(devcRec, "DEVC", "XB", true);
        PathObscurationMeasurer obj = new PathObscurationMeasurer(id, beam);
        obj.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, obj.getQuantity().get()));
        return obj;
    }

    private static AlarmInfo parseAlarm(FDSParseRecord devcRec, IDoubleOutPin pin) {
        return DeviceParser.parseAlarm(devcRec, pin.getUnitType());
    }

    private static AlarmInfo parseAlarm(FDSParseRecord devcRec, Quantity msr) {
        return DeviceParser.parseAlarm(devcRec, msr.unitType);
    }

    private static AlarmInfo parseAlarm(FDSParseRecord devcRec, int unitType) {
        Double val = devcRec.getDouble("SETPOINT", false);
        if (val == null) {
            return null;
        }
        Unit unit = SIUS.unit(unitType);
        UnitDouble setpoint = new UnitDouble(val, unit);
        return new AlarmInfo(setpoint, DeviceParser.parseTripFlags(devcRec));
    }

    private static int parseTripFlags(FDSParseRecord devcRec) {
        int tripFlags = 0;
        if (devcRec.getBoolean("INITIAL_STATE", true).booleanValue()) {
            tripFlags |= 2;
        }
        if (devcRec.getBoolean("LATCH", true).booleanValue()) {
            tripFlags |= 1;
        }
        return tripFlags;
    }

    private CableFailDetector parseCableMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        CableFailDetector.CableInfo ci = new CableFailDetector.CableInfo(propRec.getUnitDouble("CABLE_MASS_PER_LENGTH", true), propRec.getUnitDouble("CABLE_FAILURE_TEMPERATURE", true), propRec.getUnitDouble("CABLE_DIAMETER", true), propRec.getUnitDouble("CABLE_JACKET_THICKNESS", true));
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        CableFailDetector cm = new CableFailDetector(id, loc, ci);
        cm.setTripFlags(DeviceParser.parseTripFlags(devcRec));
        return cm;
    }

    private Aspirator parseAspirator(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        UnitDouble bypassFlowrate = (UnitDouble)devcRec.get("BYPASS_FLOWRATE", true);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        Aspirator asp = new Aspirator(id, bypassFlowrate, loc);
        asp.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, asp.getQuantity().get()));
        return asp;
    }

    private AspiratorSampler parseAspiratorSampler(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        AspiratorSampler sampler = new AspiratorSampler(id, loc);
        sampler.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, sampler.getQuantity().get()));
        this.d_aspSamplerRecs.add(devcRec);
        return sampler;
    }

    private IDevice parseSootDensityDevice(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        if (devcRec.contains("FLOWRATE") || devcRec.contains("DELAY") || devcRec.contains("DEVC_ID")) {
            return this.parseAspiratorSampler(devcRec, propRec, id);
        }
        return this.parseGasPointMeasurer(devcRec, propRec, id, Quantity.SPEC_DENSITY.create(ExSpecList.MixFrac.SOOT.spec));
    }

    private IDevice parseClock(FDSParseRecord devcRec, String id) {
        AlarmInfo ai = DeviceParser.parseAlarm(devcRec, Quantity.TIME);
        if (ai == null) {
            return Clock.INSTANCE;
        }
        Timer timer = new Timer(id, ai.setpoint, TripFlags.initiallyOn(ai.tripFlags));
        return timer;
    }

    private IDevice parseGasPointMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, IQuantity msr) throws FDSRecordFormatException {
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        if (msr.get().equals((Object)Quantity.THERMOCOUPLE)) {
            Thermocouple msrr = new Thermocouple(id, propRec.getUnitDouble("BEAD_DIAMETER", true), propRec.getDouble("BEAD_EMISSIVITY", true), propRec.getUnitDouble("BEAD_DENSITY", true), propRec.getUnitDouble("BEAD_SPECIFIC_HEAT", true), loc);
            msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
            return msrr;
        }
        GasPointMeasurer msrr = new GasPointMeasurer(id, msr, loc);
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        return msrr;
    }

    private IDevice parseSolidPointMeasurer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, IQuantity msr) throws FDSRecordFormatException {
        AttachedPointLoc loc = this.parseAttachedPointLoc(devcRec);
        SolidPointMeasurer msrr = msr.get().equals((Object)Quantity.INSIDE_WALL_TEMPERATURE) ? new InnerTempMeasurer(id, devcRec.getUnitDouble("DEPTH", true), loc) : (msr.get().equals((Object)Quantity.PRESSURE_COEFFICIENT) ? new PressureCoeffMeasurer(id, propRec.getUnitDouble("CHARACTERISTIC_VELOCITY", true), loc) : (msr.get().equals((Object)Quantity.GAUGE_HEAT_FLUX) ? new GaugeHeatFluxMeasurer(id, propRec.getUnitDouble("GAUGE_TEMPERATURE", true), loc) : (!SolidDensityMeasurer.getQuantityFilter().shouldFilter(msr.get()) ? new SolidDensityMeasurer(id, (ObjectQuantity)msr, devcRec.getUnitDouble("DEPTH", true), loc) : new SolidPointMeasurer(id, msr, loc))));
        msrr.getMsrInfo().setAlarmInfo(DeviceParser.parseAlarm(devcRec, msrr.getQuantity().get()));
        return msrr;
    }

    private ASprayer parseSprayer(FDSParseRecord devcRec, FDSParseRecord propRec, String id, String quantity) throws FDSRecordFormatException {
        if (quantity.equals("SPRINKLER LINK TEMPERATURE")) {
            return this.parseSprinkler(devcRec, propRec, id);
        }
        if (quantity.equals("CONTROL")) {
            return this.parseGenericNozzle(devcRec, propRec, id);
        }
        return this.parseMeasuringNozzle(devcRec, propRec, id);
    }

    private Sprinkler parseSprinkler(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprinklerLinkModel linkModel = this.d_propParser.parseSprinklerLinkModel(propRec);
        SprayModel sprayModel = this.d_propParser.parseSprayModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        Sprinkler.TraditionalModel linkMod = new Sprinkler.TraditionalModel(linkModel, devcRec.getBoolean("INITIAL_STATE", true), devcRec.getBoolean("LATCH", true));
        Sprinkler sprinkler = new Sprinkler(id, sprayModel, linkMod, loc);
        return sprinkler;
    }

    private Nozzle parseGenericNozzle(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprayModel sprayModel = this.d_propParser.parseSprayModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        Nozzle nozzle = new Nozzle(id, sprayModel, loc);
        DeviceParser.markSingleInputForRetrieval(devcRec, nozzle, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return nozzle;
    }

    private ASprayer parseMeasuringNozzle(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprayModel sprayModel = this.d_propParser.parseSprayModel(propRec);
        IQuantity msr = this.parseQuantity(devcRec, propRec, "", false, false);
        if (msr == null || Sprinkler.QuantityModel.getQuantityFilter().shouldFilter(msr.get())) {
            return null;
        }
        Double setPoint = (Double)devcRec.get("SETPOINT", true);
        if (setPoint == null) {
            return null;
        }
        UnitDouble setPointU = new UnitDouble(setPoint, SIUS.unit(msr.get().unitType));
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        Sprinkler.QuantityModel linkMod = new Sprinkler.QuantityModel(msr, setPointU, devcRec.getBoolean("INITIAL_STATE", true), devcRec.getBoolean("LATCH", true));
        Sprinkler sprk = new Sprinkler(id, sprayModel, linkMod, loc);
        return sprk;
    }

    private SprinklerLink parseSprinklerLink(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SprinklerLinkModel model = this.d_propParser.parseSprinklerLinkModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        SprinklerLink link = new SprinklerLink(id, model, loc);
        link.setTripFlags(DeviceParser.parseTripFlags(devcRec));
        return link;
    }

    private IDetector parseSmokeDetector(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        SmokeLinkModel model = this.d_propParser.parseSmokeLinkModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        SmokeDetector det = new SmokeDetector(id, model, loc);
        det.setTripFlags(DeviceParser.parseTripFlags(devcRec));
        return det;
    }

    private IDetector parseHeatDetector(FDSParseRecord devcRec, FDSParseRecord propRec, String id) throws FDSRecordFormatException {
        HeatLinkModel model = this.d_propParser.parseHeatLinkModel(propRec);
        FreePointLoc loc = this.parseFreePointLoc(devcRec);
        HeatDetector det = new HeatDetector(id, model, loc);
        det.setTripFlags(DeviceParser.parseTripFlags(devcRec));
        return det;
    }

    private IDevice parseHvacDevc(String quantity, FDSParseRecord devcRec, IQuantity msr, String id) throws FDSRecordFormatException {
        String devcId = devcRec.getString("ID");
        boolean isDuctQuantity = false;
        boolean isNodeQuantity = false;
        for (Class<? extends IPyroObject> type : msr.get().requiredTypes) {
            if (HvacDuct.class.isAssignableFrom(type)) {
                isDuctQuantity = true;
            }
            if (!HvacNode.class.isAssignableFrom(type)) continue;
            isNodeQuantity = true;
        }
        if (isDuctQuantity) {
            return new HvacDevice.DuctDevice(devcId, msr);
        }
        if (isNodeQuantity) {
            return new HvacDevice.NodeDevice(devcId, msr);
        }
        return null;
    }

    private AARectangle parseAARectangle(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitPoint3D[] xb = DeviceParser.parseXB(rec, "DEVC", "XB", true);
        if (xb[0].x() == xb[1].x()) {
            return new AARectangle(0, xb[0].x(), xb[0].y(), xb[0].z(), xb[1].y(), xb[1].z());
        }
        if (xb[0].y() == xb[1].y()) {
            return new AARectangle(1, xb[0].y(), xb[0].x(), xb[0].z(), xb[1].x(), xb[1].z());
        }
        if (xb[0].z() == xb[1].z()) {
            return new AARectangle(2, xb[0].z(), xb[0].x(), xb[0].y(), xb[1].x(), xb[1].y());
        }
        throw new FDSRecordFormatException(rec, Intl.intl("XB must specify a plane."));
    }

    private FreePointLoc parseFreePointLoc(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitPoint3D loc = DeviceParser.parseLoc(rec, "DEVC", "XYZ", true);
        UnitDouble rot = (UnitDouble)rec.get("ROTATION", true);
        FDSArray orientArr = rec.getArray("ORIENTATION", true);
        Vector3d orient = new Vector3d((Double)orientArr.get(0), (Double)orientArr.get(1), (Double)orientArr.get(2));
        return new FreePointLoc(loc, orient, rot);
    }

    private AttachedPointLoc parseAttachedPointLoc(FDSParseRecord rec) throws FDSRecordFormatException {
        UnitPoint3D loc = DeviceParser.parseLoc(rec, "DEVC", "XYZ", true);
        UnitDouble rot = (UnitDouble)rec.get("ROTATION", true);
        Integer ior = (Integer)rec.get("IOR");
        if (ior == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Device must specify orientation using IOR."));
        }
        Vector3d normal = GeomUtil.toWorldVec(ior);
        return new AttachedPointLoc(loc, normal, rot);
    }
}

