/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.particle.Output;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.particle.SizeDistribution;
import pyrosim.legacy_2012_1.domain.particle.WaterPartDesc;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AdjacencyMerger;
import pyrosim.legacy_2012_1.thunderheadeng.util.FileWarning;
import pyrosim.legacy_2012_1.thunderheadeng.util.FileWarningReport;
import pyrosim.legacy_2012_1.thunderheadeng.util.MergedCell;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class SPKReader {
    private static final String MANUFACTURER = "MANUFACTURER";
    private static final String MODEL = "MODEL";
    private static final String RTI = "RTI";
    private static final String C_FACTOR = "C-FACTOR";
    private static final String K_FACTOR = "K-FACTOR";
    private static final String ACTIVATION_TEMPERATURE = "ACTIVATION_TEMPERATURE";
    private static final String OPERATING_PRESSURE = "OPERATING_PRESSURE";
    private static final String OFFSET_DISTANCE = "OFFSET_DISTANCE";
    private static final String VELOCITY = "VELOCITY";
    private static final String FLUX = "FLUX";
    private static final String SIZE_DISTRIBUTION = "SIZE_DISTRIBUTION";
    private SPKResult d_result;

    public SPKResult parse(String filename, double mergeThreshhold) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        return this.parse(new File(filename).getName(), reader, mergeThreshhold);
    }

    public SPKResult parse(String spkName, BufferedReader reader, double mergeThreshhold) throws Exception {
        this.d_result = new SPKResult();
        String modelName = spkName;
        UnitDouble rti = SIUS.newud(165.0, 3);
        UnitDouble cFactor = SIUS.newud(0.0, 60);
        UnitDouble actTemp = SIUS.newud(74.0, 1);
        UnitDouble offsetDist = SIUS.newud(0.05, 0);
        UnitDouble opPress = null;
        UnitDouble kFactor = SIUS.newud(166.0, 58);
        SizeDistribution partSizeDist = new SizeDistribution(new UnitDouble(100.0, SI.MICRO(SI.METER)), new SizeDistribution.RosinRammler());
        ISampleResult vel = null;
        ISampleResult flux = null;
        while (reader.ready()) {
            String type = this.readString(reader);
            if (!reader.ready()) break;
            if (type.equals(MANUFACTURER)) {
                this.readString(reader);
                continue;
            }
            if (type.equals(MODEL)) {
                modelName = this.readString(reader);
                continue;
            }
            if (type.equals(RTI)) {
                rti = this.readUnitDouble(reader, 3);
                continue;
            }
            if (type.equals(C_FACTOR)) {
                cFactor = this.readUnitDouble(reader, 60);
                continue;
            }
            if (type.equals(K_FACTOR)) {
                kFactor = this.readUnitDouble(reader, 58);
                continue;
            }
            if (type.equals(ACTIVATION_TEMPERATURE)) {
                actTemp = this.readUnitDouble(reader, 1);
                continue;
            }
            if (type.equals(OPERATING_PRESSURE)) {
                opPress = this.readUnitDouble(reader, 12);
                continue;
            }
            if (type.equals(OFFSET_DISTANCE)) {
                offsetDist = this.readUnitDouble(reader, 0);
                continue;
            }
            if (type.equals(VELOCITY)) {
                vel = this.readSampleResult(reader, VELOCITY);
                continue;
            }
            if (type.equals(FLUX)) {
                flux = this.readSampleResult(reader, FLUX);
                continue;
            }
            if (!type.equals(SIZE_DISTRIBUTION)) continue;
            partSizeDist = this.readSizeDist(reader);
        }
        if (vel == null) {
            throw this.newException(Intl.intl("No VELOCITY was specified."));
        }
        String sprayName = modelName;
        String linkName = modelName;
        String partName = String.format(Intl.intl("%s_PARTICLE"), modelName);
        this.d_result.d_linkModel = new SprinklerLinkModel(linkName, rti, null, actTemp, cFactor);
        WaterPartDesc defWaterDesc = new WaterPartDesc();
        Output waterOutput = new Output(new UnitDouble(60.0, SI.SECOND), defWaterDesc.d_output.d_samplingFactor);
        Particle particle = new Particle(partName, new WaterPartDesc(defWaterDesc.d_thermalProps, defWaterDesc.d_pyrolysis, partSizeDist, waterOutput, defWaterDesc.d_coloring, defWaterDesc.d_dropsPerSec));
        SprayModel.FlowRate flowRate = opPress != null ? new SprayModel.PressurizedFlowRate(opPress, kFactor, new TimeFunction.TanH(new UnitDouble(0.0, SI.SECOND))) : new SprayModel.ExplicitFlowRate();
        List<SprayModel.Jet> jets = this.toJetList(vel, flux, mergeThreshhold);
        this.d_result.d_sprayModel = new SprayModel(sprayName, particle, offsetDist, flowRate, defWaterDesc.d_dropsPerSec, new UnitDouble(0.01, SI.SECOND), jets);
        return this.d_result;
    }

    private static double average(double[][] vals, int x1, int x2, int y1, int y2) {
        return SPKReader.sum(vals, x1, x2, y1, y2) / (double)((y2 - y1 + 1) * (x2 - x1 + 1));
    }

    private static double sum(double[][] vals, int x1, int x2, int y1, int y2) {
        double tot = 0.0;
        for (int row = y1; row <= y2; ++row) {
            for (int col = x1; col <= x2; ++col) {
                tot += vals[row][col];
            }
        }
        return tot;
    }

    private List<SprayModel.Jet> toJetList(ISampleResult vel, ISampleResult flux, final double mergeThreshhold) throws Exception {
        if (vel instanceof SimpleSampleResult) {
            SimpleSampleResult samp = (SimpleSampleResult)vel;
            SprayModel.Jet jet = new SprayModel.Jet(SIUS.newud(samp.d_val, 8), null, 1.0, samp.d_angle1, samp.d_angle2);
            return Arrays.asList(jet);
        }
        if (!(flux instanceof TableSampleResult)) {
            throw this.newException(Intl.intl("FLUX must also be specified as a table."));
        }
        TableSampleResult velTable = (TableSampleResult)vel;
        TableSampleResult fluxTable = (TableSampleResult)flux;
        int numLat = Math.max(velTable.d_vals.length, fluxTable.d_vals.length);
        int numLong = Math.max(velTable.d_vals[0].length, fluxTable.d_vals[0].length);
        double invLat = numLat == 1 ? 0.0 : 1.0 / (double)numLat;
        double invLong = numLong == 1 ? 0.0 : 1.0 / (double)numLong;
        final double[][] velvals = new double[numLat][numLong];
        final double[][] fluxvals = new double[numLat][numLong];
        ArrIndex[][] ixes = new ArrIndex[numLat][numLong];
        for (int latix = 0; latix < numLat; ++latix) {
            double latt = (double)latix * invLat;
            for (int longix = 0; longix < numLong; ++longix) {
                double longt = (double)longix * invLong;
                velvals[latix][longix] = SPKReader.sampleTable(velTable.d_vals, latt, longt);
                fluxvals[latix][longix] = SPKReader.sampleTable(fluxTable.d_vals, latt, longt);
                ixes[latix][longix] = new ArrIndex(latix, longix);
            }
        }
        Collection<MergedCell<ArrIndex>> cells = AdjacencyMerger.mergeCells(ixes, new AdjacencyMerger.IMergeQuery<ArrIndex>(){

            @Override
            public ArrIndex merge(ArrIndex i1, ArrIndex i2, AdjacencyMerger.Dir dir) {
                if (Math.abs(velvals[i2.row][i2.col] - velvals[i1.row][i1.col]) <= mergeThreshhold && Math.abs(fluxvals[i2.row][i2.col] - fluxvals[i1.row][i1.col]) <= mergeThreshhold) {
                    return i1;
                }
                return null;
            }
        });
        TreeSet<MergedCell<ArrIndex>> sortedCells = new TreeSet<MergedCell<ArrIndex>>(new Comparator<MergedCell<ArrIndex>>(){

            @Override
            public int compare(MergedCell<ArrIndex> o1, MergedCell<ArrIndex> o2) {
                if (((ArrIndex)o1.val).row == ((ArrIndex)o2.val).row) {
                    return ((ArrIndex)o1.val).col - ((ArrIndex)o2.val).col;
                }
                return ((ArrIndex)o1.val).row - ((ArrIndex)o2.val).row;
            }
        });
        sortedCells.addAll(cells);
        cells = sortedCells;
        ArrayList<SprayModel.Jet> jets = new ArrayList<SprayModel.Jet>();
        double totFlux = 0.0;
        for (MergedCell<ArrIndex> cell : cells) {
            double velval = SPKReader.average(velvals, cell.x1, cell.x2, cell.y1, cell.y2);
            double fluxval = SPKReader.sum(fluxvals, cell.x1, cell.x2, cell.y1, cell.y2);
            velvals[((ArrIndex)cell.val).row][((ArrIndex)cell.val).col] = velval;
            fluxvals[((ArrIndex)cell.val).row][((ArrIndex)cell.val).col] = fluxval;
            totFlux += fluxval;
        }
        double invLatAngle = invLat * 180.0;
        double invLongAngle = invLong * 360.0;
        for (MergedCell<ArrIndex> cell : cells) {
            double velval;
            double fluxval = fluxvals[((ArrIndex)cell.val).row][((ArrIndex)cell.val).col];
            double fluxFrac = fluxval / totFlux;
            if (Math.abs(fluxFrac) < 1.0E-16 || Math.abs(velval = velvals[((ArrIndex)cell.val).row][((ArrIndex)cell.val).col]) < 1.0E-16) continue;
            double latAngle1 = (double)cell.y1 * invLatAngle;
            double latAngle2 = (double)cell.y2 * invLatAngle + invLatAngle;
            double longAngle1 = (double)cell.x1 * invLongAngle;
            double longAngle2 = (double)cell.x2 * invLongAngle + invLongAngle;
            jets.add(new SprayModel.Jet(SIUS.newud(velval, 8), null, fluxFrac, new UnitDouble(longAngle1, NonSI.DEGREE_ANGLE), new UnitDouble(longAngle2, NonSI.DEGREE_ANGLE), new UnitDouble(latAngle1, NonSI.DEGREE_ANGLE), new UnitDouble(latAngle2, NonSI.DEGREE_ANGLE)));
        }
        return jets;
    }

    private static double sampleTable(double[][] table, double row, double col) {
        int numRows = table.length;
        int numCols = table[0].length;
        double rowix = (double)numRows * row;
        int rowixlow = (int)Math.floor(rowix);
        int rowixhigh = (rowixlow + 1) % numRows;
        double rowt = rowix - (double)rowixlow;
        double colix = (double)numCols * col;
        int colixlow = (int)Math.floor(colix);
        int colixhigh = (colixlow + 1) % numCols;
        double colt = colix - (double)colixlow;
        double val00 = table[rowixlow][colixlow];
        double val01 = table[rowixlow][colixhigh];
        double val10 = table[rowixhigh][colixlow];
        double val11 = table[rowixhigh][colixhigh];
        double row0val = SPKReader.lerp(val00, val01, colt);
        double row1val = SPKReader.lerp(val10, val11, colt);
        double val = SPKReader.lerp(row0val, row1val, rowt);
        return val;
    }

    private static double lerp(double v1, double v2, double t) {
        return v1 + (v2 - v1) * t;
    }

    private SizeDistribution readSizeDist(BufferedReader reader) throws Exception {
        int type = this.readInt(reader);
        if (type == 1) {
            String[] vals = this.readVals(reader, 2);
            return new SizeDistribution(this.getUnitDouble(vals, 0, SI.MICRO(SI.METER)), new SizeDistribution.RosinRammler(this.getDouble(vals, 1)));
        }
        if (type == 2) {
            this.d_result.addWarning(Intl.intl("The median particle diameter can no longer be a function of position."), Intl.intl("Using a uniform size distribution."));
            return new SizeDistribution();
        }
        throw this.newException(String.format(Intl.intl("Unrecognized size distribution type: %d"), type));
    }

    private ISampleResult readSampleResult(BufferedReader reader, String key) throws Exception {
        int type = this.readInt(reader);
        if (type == 1) {
            String[] vals = this.readVals(reader, 3);
            return new SimpleSampleResult(this.getDouble(vals, 0), this.getUnitDouble(vals, 1, NonSI.DEGREE_ANGLE), this.getUnitDouble(vals, 2, NonSI.DEGREE_ANGLE));
        }
        if (type == 2) {
            String[] vals = this.readVals(reader, 2);
            int numLat = this.getInt(vals, 0);
            int numLong = this.getInt(vals, 1);
            if (numLat <= 0 || numLong <= 0) {
                throw this.newException(Intl.intl("na and nl must be greater than 0."));
            }
            double[][] tableVals = new double[numLat][numLong];
            for (int latix = 0; latix < numLat; ++latix) {
                String[] longstrs = this.readVals(reader, numLong);
                for (int longix = 0; longix < numLong; ++longix) {
                    tableVals[latix][longix] = this.getDouble(longstrs, longix);
                }
            }
            return new TableSampleResult(tableVals);
        }
        throw this.newException(String.format(Intl.intl("Unknown %1$s type: %2$d"), key, type));
    }

    private String readLine(BufferedReader reader) throws Exception {
        if (!reader.ready()) {
            throw this.newException(Intl.intl("Unexpected end of file."));
        }
        String propType = reader.readLine();
        ++this.d_result.d_lineNumber;
        return propType;
    }

    private String readString(BufferedReader reader) throws Exception {
        return this.readLine(reader);
    }

    private UnitDouble readUnitDouble(BufferedReader reader, int unitType) throws Exception {
        Unit u = SIUS.getInstance().getUnit(unitType);
        String strVal = this.readLine(reader);
        try {
            Double dval = Double.valueOf(strVal);
            return new UnitDouble(dval, u);
        }
        catch (NumberFormatException e) {
            throw this.newException(String.format(Intl.intl("Could not read number: %s"), strVal), e.getCause());
        }
    }

    private int readInt(BufferedReader reader) throws Exception {
        String strVal = this.readLine(reader);
        try {
            Integer ival = Integer.valueOf(strVal);
            return ival;
        }
        catch (NumberFormatException e) {
            throw this.newException(String.format(Intl.intl("Could not read integer: %s"), strVal), e.getCause());
        }
    }

    private String[] readVals(BufferedReader reader, int minExpectedCount) throws Exception {
        String line = this.readLine(reader);
        String[] vals = line.split("[ ,]+");
        if (vals == null) {
            vals = new String[]{};
        }
        if (vals.length < minExpectedCount) {
            throw this.newException(String.format(Intl.intl("Expected %d values in list."), minExpectedCount));
        }
        return vals;
    }

    private int getInt(String[] arr, int ix) throws Exception {
        try {
            return Integer.valueOf(arr[ix]);
        }
        catch (NumberFormatException e) {
            throw this.newException(String.format(Intl.intl("Could not read integer: %s"), arr[ix]), e.getCause());
        }
    }

    private UnitDouble getUnitDouble(String[] arr, int ix, Unit unit) throws Exception {
        try {
            return new UnitDouble(Double.valueOf(arr[ix]), unit);
        }
        catch (NumberFormatException e) {
            throw this.newException(String.format(Intl.intl("Could not read number: %s"), arr[ix]), e.getCause());
        }
    }

    private double getDouble(String[] arr, int ix) throws Exception {
        try {
            return Double.valueOf(arr[ix]);
        }
        catch (NumberFormatException e) {
            throw this.newException(String.format(Intl.intl("Could not read number: %s"), arr[ix]), e.getCause());
        }
    }

    private Exception newException(String error) {
        return this.newException(error, null);
    }

    private Exception newException(String error, Throwable cause) {
        return new Exception(error + "  \n" + String.format(Intl.intl("Line Number: %d"), this.d_result.d_lineNumber), cause);
    }

    private static class TableSampleResult
    implements ISampleResult {
        public final double[][] d_vals;

        public TableSampleResult(double[][] vals) {
            this.d_vals = vals;
        }
    }

    private static class SimpleSampleResult
    implements ISampleResult {
        public final double d_val;
        public final UnitDouble d_angle1;
        public final UnitDouble d_angle2;

        public SimpleSampleResult(double val, UnitDouble a1, UnitDouble a2) {
            this.d_val = val;
            this.d_angle1 = a1;
            this.d_angle2 = a2;
        }
    }

    private static interface ISampleResult {
    }

    private static final class ArrIndex {
        public final int row;
        public final int col;

        public ArrIndex(int row, int col) {
            this.row = row;
            this.col = col;
        }
    }

    public static class SPKResult {
        public final FileWarningReport d_warnings = new FileWarningReport();
        public int d_lineNumber = 0;
        public SprayModel d_sprayModel;
        public SprinklerLinkModel d_linkModel;

        public void addWarning(String problem, String actionTaken) {
            this.d_warnings.addWarning(new FileWarning(this.d_lineNumber, problem, actionTaken));
        }
    }
}

