/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.reaction;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.reaction.Byproducts;
import pyrosim.legacy_2012_1.domain.reaction.FireSuppression;
import pyrosim.legacy_2012_1.domain.reaction.Fuel;
import pyrosim.legacy_2012_1.domain.reaction.HeatReleaseRate;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class Reaction
extends NamedPyroObject
implements Serializable {
    static final long serialVersionUID = 1L;
    private String d_fyi;
    private boolean d_active;
    private Fuel d_fuel = new Fuel();
    private FireSuppression d_suppression = new FireSuppression();
    private Byproducts d_byproducts = new Byproducts();
    private HeatReleaseRate d_hrr = HeatReleaseRate.newLES();
    private CustomFDSProps d_customFDSProps = new CustomFDSProps();

    public Reaction(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(in) < 38) {
            assert (this.d_hrr == null);
            HeatReleaseRate flame = HeatReleaseRate.newLES();
            UnitDouble oldHRRPUA = this.d_fuel.d_hrrpuaUpperLimit;
            if (!oldHRRPUA.equals(SIUS.newud(200.0, 22))) {
                flame = new HeatReleaseRate(flame.eddyDissipation, flame.cEdc, oldHRRPUA, flame.hrrpuvUpperLimit);
            }
            this.d_hrr = flame;
        }
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = new CustomFDSProps();
        }
    }

    @Override
    protected void addToDomain(PyroMod domain, IPyroObject parent) {
        super.addToDomain(domain, parent);
        if (domain.getReactions().flatten().isEmpty() || domain.getReactions().flatten().size() == 1 && domain.getReactions().flatten().iterator().next() == this) {
            this.setActive(true);
        }
    }

    public CustomFDSProps getCustomFDSProps() {
        return this.d_customFDSProps;
    }

    public void setCustomFDSProps(CustomFDSProps props) {
        this.d_customFDSProps = props;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Reaction)) {
            return false;
        }
        Reaction r = (Reaction)obj;
        return super.equals(obj) && this.d_fuel.equals(r.d_fuel) && theUtil.equal(this.d_suppression, r.d_suppression) && this.d_byproducts.equals(r.d_byproducts) && this.d_hrr.equals(r.d_hrr) && this.d_customFDSProps.equals(r.d_customFDSProps);
    }

    public void imprint(Reaction reac) {
        this.d_fuel = reac.d_fuel;
        this.d_byproducts = reac.d_byproducts;
        this.d_suppression = reac.d_suppression;
        this.d_hrr = reac.d_hrr;
        this.d_customFDSProps = reac.d_customFDSProps;
        this.changedEvt(new Object[0]);
    }

    public boolean isActive() {
        return this.d_active;
    }

    public void setActive(boolean active) {
        this.d_active = active;
        this.changedEvt(new Object[0]);
    }

    public Fuel getFuel() {
        return this.d_fuel;
    }

    public void setFuel(Fuel fuel) {
        this.d_fuel = fuel;
        this.changedEvt(new Object[0]);
    }

    public Byproducts getByproducts() {
        return this.d_byproducts;
    }

    public void setByproducts(Byproducts byproducts) {
        this.d_byproducts = byproducts;
        this.changedEvt(new Object[0]);
    }

    public FireSuppression getSuppression() {
        return this.d_suppression;
    }

    public void setSuppression(FireSuppression suppression) {
        this.d_suppression = suppression;
        this.changedEvt(new Object[0]);
    }

    public HeatReleaseRate getHRR() {
        return this.d_hrr;
    }

    public void setHRR(HeatReleaseRate flame) {
        this.d_hrr = flame;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean invokesMixFrac() {
        return true;
    }
}

