/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.quantity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.thunderheadeng.util.AcceptAllFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.Util;

public abstract class QuantityReplacer {
    private final PyroMod d_domain;

    public QuantityReplacer(PyroMod domain) {
        this.d_domain = domain;
    }

    protected boolean canReplaceQuant(IQuantity old, IQuantity repl) {
        return true;
    }

    protected abstract Task taskReplaceQuant(IQuantity var1, IQuantity var2);

    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs, IQuantity refedQuantity) {
        this.removeInvalidReplacements(old, objs, Arrays.asList(refedQuantity));
    }

    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs, Collection<? extends IQuantity> refedQuantities) {
        List<Pair<ObjectQuantity, int[]>> quantRefs = QuantityReplacer.getObjectRefs(old, refedQuantities);
        for (Pair<ObjectQuantity, int[]> ref : quantRefs) {
            for (int ix : (int[])ref.v2) {
                Util.removeAllNotOfType(objs, ((ObjectQuantity)ref.v1).get().requiredTypes[ix]);
                IObjectFilter filter = ((ObjectQuantity)ref.v1).get().typeFilters[ix];
                if (filter instanceof AcceptAllFilter) continue;
                Iterator<T> it = objs.iterator();
                while (it.hasNext()) {
                    if (!filter.shouldFilter(it.next())) continue;
                    it.remove();
                }
            }
        }
        Iterator<T> objit = objs.iterator();
        block3: while (objit.hasNext()) {
            T prod = objit.next();
            if (prod == null || !(prod instanceof IPyroObject)) continue;
            Object object = quantRefs.iterator();
            while (object.hasNext()) {
                Pair ref = (Pair)object.next();
                ObjectQuantity newQuant = QuantityReplacer.replaceObjRef((ObjectQuantity)ref.v1, (int[])ref.v2, (IPyroObject)prod);
                if (this.canReplaceQuant((IQuantity)ref.v1, newQuant)) continue;
                objit.remove();
                continue block3;
            }
        }
    }

    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement, IQuantity refedQuantity) {
        return this.taskReplaceDep(old, replacement, Arrays.asList(refedQuantity));
    }

    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement, final Collection<? extends IQuantity> refedQuantities) {
        return new CompositeTask(this.d_domain){

            @Override
            protected void queueBeginRuntimeTasks() {
                List quantRefs = QuantityReplacer.getObjectRefs(old, refedQuantities);
                for (Pair ref : quantRefs) {
                    ObjectQuantity newQuant = replacement == null ? null : QuantityReplacer.replaceObjRef((ObjectQuantity)ref.v1, (int[])ref.v2, replacement);
                    this.addTask(QuantityReplacer.this.taskReplaceQuant((IQuantity)ref.v1, newQuant));
                }
            }
        };
    }

    private static ObjectQuantity replaceObjRef(ObjectQuantity quant, int[] ixes, IPyroObject newObj) {
        IPyroObject[] newArgs = (IPyroObject[])Arrays.copyOf(quant.objects, quant.objects.length);
        for (int ix : ixes) {
            newArgs[ix] = newObj;
        }
        return quant.get().create(newArgs);
    }

    private static List<Pair<ObjectQuantity, int[]>> getObjectRefs(IPyroObject obj, Collection<? extends IQuantity> refedQuants) {
        ArrayList<Pair<ObjectQuantity, int[]>> result = new ArrayList<Pair<ObjectQuantity, int[]>>();
        ArrayList<Integer> ixes = new ArrayList<Integer>();
        for (IQuantity iQuantity : refedQuants) {
            if (!(iQuantity instanceof ObjectQuantity)) continue;
            ObjectQuantity oq = (ObjectQuantity)iQuantity;
            for (int m = 0; m < oq.objects.length; ++m) {
                if (oq.objects[m] != obj) continue;
                ixes.add(m);
            }
            if (ixes.isEmpty()) continue;
            result.add(new Pair<ObjectQuantity, int[]>(oq, theUtil.toIntArray(ixes)));
            ixes.clear();
        }
        return result;
    }
}

