/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.evac;

import java.util.Map;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;

public class KnownExitReplTask
extends AUndoableTask {
    private final IPyroObject d_obj;
    private final Map<String, Object> d_props;
    private final String d_knownDoorProbsKey;
    private final IPyroObject d_old;
    private final IPyroObject d_replacement;
    private Double d_oldVal;
    private Double d_replVal;

    public KnownExitReplTask(IPyroObject obj, Map<String, Object> props, String knownDoorProbsKey, IPyroObject old, IPyroObject repl) {
        this.d_obj = obj;
        this.d_props = props;
        this.d_knownDoorProbsKey = knownDoorProbsKey;
        this.d_old = old;
        this.d_replacement = repl;
    }

    @Override
    public void run() {
        Map knownDoorProbs = (Map)this.d_props.get(this.d_knownDoorProbsKey);
        assert (knownDoorProbs != null);
        this.d_oldVal = (Double)knownDoorProbs.remove(this.d_old);
        if (this.d_replacement != null) {
            this.d_replVal = (Double)knownDoorProbs.get(this.d_replacement);
            Double newVal = this.d_replVal != null ? this.d_replVal + this.d_oldVal : this.d_oldVal;
            knownDoorProbs.put((NamedPyroObject)this.d_replacement, newVal);
        }
        this.d_obj.changedEvt(new Object[0]);
    }

    @Override
    public void undo() {
        Map knownDoorProbs = (Map)this.d_props.get(this.d_knownDoorProbsKey);
        assert (knownDoorProbs != null);
        knownDoorProbs.put((NamedPyroObject)this.d_old, this.d_oldVal);
        if (this.d_replacement != null) {
            if (this.d_replVal == null) {
                knownDoorProbs.remove(this.d_replacement);
            } else {
                knownDoorProbs.put((NamedPyroObject)this.d_replacement, this.d_replVal);
            }
        }
        this.d_obj.changedEvt(new Object[0]);
    }
}

