/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.controls.AControl;
import pyrosim.legacy_2012_1.domain.signals.AOneDoubleInPin;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class CustomCtrl
extends AControl {
    static final long serialVersionUID = 1L;
    private IInPin d_inPin;
    private IOutPin d_outPin;
    private boolean d_initState;
    private SortedSet<UnitDouble> d_tripValues;

    public CustomCtrl() {
        this(false, new ArrayList<UnitDouble>());
    }

    public CustomCtrl(boolean initState, Collection<UnitDouble> tripValues) {
        this(initState, (SortedSet<UnitDouble>)new TreeSet<UnitDouble>(tripValues));
    }

    public CustomCtrl(boolean initState, SortedSet<UnitDouble> tripValues) {
        this.d_initState = initState;
        this.d_tripValues = tripValues;
        this.d_inPin = new AOneDoubleInPin(this){
            static final long serialVersionUID = 7930361730409851012L;

            @Override
            public void updateInputUnit(Unit newUnit) {
                TreeSet<UnitDouble> newTripValues = new TreeSet<UnitDouble>();
                for (UnitDouble oldTrip : CustomCtrl.this.d_tripValues) {
                    newTripValues.add(oldTrip.reinterpret(newUnit));
                }
                CustomCtrl.this.d_tripValues = newTripValues;
                CustomCtrl.this.changedEvt(new Object[0]);
            }

            @Override
            protected void changeInputUnit(Unit unit) {
                TreeSet<UnitDouble> newTripValues = new TreeSet<UnitDouble>();
                for (UnitDouble oldTrip : CustomCtrl.this.d_tripValues) {
                    newTripValues.add(new UnitDouble(oldTrip.getValueNoUnit(), unit));
                }
                CustomCtrl.this.d_tripValues = newTripValues;
                CustomCtrl.this.changedEvt(new Object[0]);
            }
        };
        this.d_outPin = new LogicOutPin(this);
    }

    @Override
    protected String getDefaultName() {
        return Intl.intl("custom");
    }

    @Override
    public boolean isNoop() {
        return this.d_tripValues.isEmpty() || super.isNoop();
    }

    @Override
    public Object clone() {
        CustomCtrl clone = (CustomCtrl)super.clone();
        clone.d_inPin = (IInPin)this.d_inPin.clone(clone);
        clone.d_outPin = (IOutPin)this.d_outPin.clone(clone);
        clone.d_tripValues = new TreeSet<UnitDouble>(this.d_tripValues);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CustomCtrl)) {
            return false;
        }
        CustomCtrl ctrl = (CustomCtrl)obj;
        return super.equals(obj) && this.d_inPin.equals(ctrl.d_inPin) && this.d_initState == ctrl.d_initState && this.d_tripValues.equals(ctrl.d_tripValues);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 53803487 + this.d_inPin.hashCode() + theUtil.hashCode(this.d_initState) + this.d_tripValues.hashCode();
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }

    public boolean getInitialState() {
        return this.d_initState;
    }

    public void setInitialState(boolean initState) {
        this.d_initState = initState;
        this.changedEvt(new Object[0]);
    }

    public SortedSet<UnitDouble> getTripValues() {
        return Collections.unmodifiableSortedSet(this.d_tripValues);
    }

    public void setTripValues(Collection<UnitDouble> tripValues) {
        this.d_tripValues = new TreeSet<UnitDouble>(tripValues);
        this.changedEvt(new Object[0]);
    }
}

