/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import pyrosim.legacy_2006_2.thunderheadeng.util.Keyable;

public class KeyGenerator {
    public static final int NO_KEY = 0;
    private static final int FIRST_KEY_VALUE = 1;
    private static final int MAX_KEY_VALUE = 0xFFFFFF;
    private static final int MAX_STACK_SIZE = 262144;
    private Stack<Integer> d_returnedKeys = new Stack();
    private Map d_objects = Collections.synchronizedMap(new TreeMap());
    private int d_nextKey = 1;

    public Keyable getFirstObjectWithKey(Integer key) {
        Object obj = this.d_objects.get(key);
        if (key == null) {
            return null;
        }
        if (obj instanceof WeakReference) {
            return (Keyable)((WeakReference)obj).get();
        }
        if (obj instanceof LinkedList) {
            return (Keyable)((LinkedList)obj).get(0);
        }
        return null;
    }

    public <T> T getFirstObjectWithKey(Integer key, Class<T> clazz) {
        return clazz.cast(this.getFirstObjectWithKey(key));
    }

    public Collection getAllObjectsWithKey(Integer key) {
        Vector allObjects = new Vector();
        if (key == null) {
            return allObjects;
        }
        Object obj = this.d_objects.get(key);
        if (obj instanceof WeakReference) {
            allObjects.add(((WeakReference)obj).get());
        } else if (obj instanceof LinkedList) {
            for (WeakReference ref : (LinkedList)obj) {
                allObjects.add(ref.get());
            }
        }
        return allObjects;
    }

    public synchronized Integer generateKey() {
        Integer key = null;
        if (this.d_returnedKeys.size() > 0) {
            key = this.d_returnedKeys.pop();
        } else {
            if (this.d_nextKey > 0xFFFFFF) {
                return null;
            }
            key = this.d_nextKey++;
        }
        return key;
    }

    public synchronized boolean returnKey(Integer key) {
        if (key == null) {
            return false;
        }
        Object objsStillRegistered = this.d_objects.get(key);
        if (objsStillRegistered != null) {
            return false;
        }
        this.d_objects.remove(key);
        this.d_returnedKeys.push(key);
        return this.checkStack();
    }

    public synchronized boolean registerObject(Object obj, Integer key) {
        if (key == null) {
            return false;
        }
        WeakReference<Object> objRef = new WeakReference<Object>(obj);
        Object objToPut = objRef;
        Object existingObj = this.d_objects.get(key);
        if (existingObj instanceof WeakReference && ((WeakReference)existingObj).get() != null) {
            LinkedList<Object> newList = new LinkedList<Object>();
            newList.add(existingObj);
            newList.add(objRef);
            objToPut = newList;
        } else if (existingObj instanceof LinkedList) {
            LinkedList list = (LinkedList)existingObj;
            list.add(objRef);
            objToPut = null;
        }
        if (objToPut != null) {
            this.d_objects.put(key, objToPut);
        }
        return true;
    }

    public synchronized boolean unregisterObject(Object obj, Integer key) {
        if (key == null) {
            return false;
        }
        Object existingObj = this.d_objects.get(key);
        if (existingObj instanceof WeakReference) {
            this.d_objects.remove(key);
        } else if (existingObj instanceof LinkedList) {
            LinkedList list = (LinkedList)existingObj;
            for (int m = list.size() - 1; m >= 0; --m) {
                if (((WeakReference)list.get(m)).get() != obj) continue;
                list.remove(m);
            }
            if (list.size() == 1) {
                this.d_objects.put(key, list.get(0));
            } else if (list.size() == 0) {
                this.d_objects.remove(key);
            }
        } else {
            return false;
        }
        return this.checkStack();
    }

    private boolean checkStack() {
        return true;
    }
}

