/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.dependencies;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.UniqueElement;
import pyrosim.legacy_2006_2.domain.dependencies.DependencyTreeNode;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.dependencies.IDependencyManager;
import pyrosim.legacy_2006_2.domain.dependencies.IDependent;
import pyrosim.legacy_2006_2.thunderheadeng.util.ICloneRequired;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public abstract class ADependencyManager
implements IDependencyManager {
    public Set<IDependedOn> getObjectsDependedOn(IDependent dependent) {
        Map<Class, Set<Class>> allPossibleDependedOns = this.getPossibleDependedOnsForDependents();
        HashSet<IDependedOn> children = new HashSet<IDependedOn>();
        Set<Class> possibleDependedOns = allPossibleDependedOns.get(dependent.getClass());
        assert (possibleDependedOns != null);
        for (Class dependedOnType : possibleDependedOns) {
            dependent.getObjectsDependedOn(children, dependedOnType);
        }
        return children;
    }

    @Override
    public Set<? extends IDependent> getDependentsOf(IDependedOn objectPossiblyDependedOn) {
        HashSet<IDependent> dependentObjects = new HashSet<IDependent>();
        Map<Class, Set<Class>> possibleDependenciesMap = this.getPossibleDepedentsForDependedOns();
        Collection possibleDependentTypes = possibleDependenciesMap.get(objectPossiblyDependedOn.getClass());
        assert (possibleDependentTypes != null);
        for (Class possibleDependentType : possibleDependentTypes) {
            Iterator possibleDepIt = this.getDependentObjectsIteratorForType(possibleDependentType);
            while (possibleDepIt.hasNext()) {
                IDependent possibleDependent = (IDependent)possibleDepIt.next();
                if (!possibleDependent.dependsOnObject(objectPossiblyDependedOn)) continue;
                dependentObjects.add(possibleDependent);
            }
        }
        return dependentObjects;
    }

    @Override
    public DependencyTreeNode buildDependencyTree(Set objects, boolean cloneObjects, Map<Object, Object> objToCloneMap) throws CloneNotSupportedException {
        if (!cloneObjects) {
            return this.buildDependencyTree(objects);
        }
        return this.buildClonedDependencyTree(objects, objToCloneMap);
    }

    public DependencyTreeNode buildDependencyTree(Set objects) {
        HashMap<Object, DependencyTreeNode> allNodes = new HashMap<Object, DependencyTreeNode>();
        return this.buildNodeRecursive(null, objects, allNodes);
    }

    private DependencyTreeNode buildNodeRecursive(Object object, Set<?> children, Map<Object, DependencyTreeNode> allNodes) {
        Map<Class, Set<Class>> allPossibleDependedOns = this.getPossibleDependedOnsForDependents();
        HashMap<Object, DependencyTreeNode> childrenNodeMap = new HashMap<Object, DependencyTreeNode>();
        for (Object child : children) {
            DependencyTreeNode node = allNodes.get(child);
            if (node == null) {
                HashSet<IDependedOn> childChildren = new HashSet<IDependedOn>();
                if (child instanceof IDependent) {
                    Set<Class> possibleDependedOns = allPossibleDependedOns.get(child.getClass());
                    assert (possibleDependedOns != null);
                    for (Class dependedOnType : possibleDependedOns) {
                        ((IDependent)child).getObjectsDependedOn(childChildren, dependedOnType);
                    }
                }
                node = this.buildNodeRecursive(child, childChildren, allNodes);
            }
            childrenNodeMap.put(node.getObject(), node);
        }
        DependencyTreeNode node = new DependencyTreeNode(object, childrenNodeMap);
        allNodes.put(object, node);
        return node;
    }

    public DependencyTreeNode buildClonedDependencyTree(Set objects) throws CloneNotSupportedException {
        return this.buildClonedDependencyTree(objects, null);
    }

    public DependencyTreeNode buildClonedDependencyTree(Set<?> objects, Map<Object, Object> objToCloneMap) throws CloneNotSupportedException {
        if (objToCloneMap == null) {
            objToCloneMap = new HashMap<Object, Object>(objects.size());
        }
        HashMap<Object, DependencyTreeNode> allNodes = new HashMap<Object, DependencyTreeNode>();
        HashMap<Object, DependencyTreeNode> objNodeMap = new HashMap<Object, DependencyTreeNode>();
        for (Object o : objects) {
            DependencyTreeNode node = this.buildClonedNodeRecursive(o, allNodes, objToCloneMap);
            objNodeMap.put(node.getObject(), node);
        }
        return new DependencyTreeNode(null, objNodeMap);
    }

    private DependencyTreeNode buildClonedNodeRecursive(Object originalObj, Map<Object, DependencyTreeNode> allNodes, Map<Object, Object> objToCloneMap) throws CloneNotSupportedException {
        Object clonedObj = objToCloneMap.get(originalObj);
        if (clonedObj != null) {
            DependencyTreeNode node = allNodes.get(clonedObj);
            assert (node != null);
            return node;
        }
        try {
            clonedObj = ((ICloneRequired)originalObj).clone();
            objToCloneMap.put(originalObj, clonedObj);
        }
        catch (ClassCastException e) {
            throw new CloneNotSupportedException();
        }
        HashMap<Object, DependencyTreeNode> childrenNodeMap = new HashMap<Object, DependencyTreeNode>();
        if (originalObj instanceof IDependent) {
            IDependent origDependent = (IDependent)originalObj;
            IDependent clonedDependent = (IDependent)clonedObj;
            Set<IDependedOn> children = this.getObjectsDependedOn(origDependent);
            for (IDependedOn child : children) {
                DependencyTreeNode childNode = this.buildClonedNodeRecursive(child, allNodes, objToCloneMap);
                childrenNodeMap.put(childNode.getObject(), childNode);
                Task replaceTask = clonedDependent.taskUpdateAfterDependedOnReplaced(child, (IDependedOn)childNode.getObject());
                if (replaceTask == null) continue;
                replaceTask.run();
            }
        }
        DependencyTreeNode node = new DependencyTreeNode(clonedObj, childrenNodeMap);
        allNodes.put(clonedObj, node);
        return node;
    }

    @Override
    public <T> Collection<Collection<T>> collectObjects(Collection<Collection<T>> objectsDesiredColl) {
        TreeMap<Object, Set<UniqueElement>> uniqueObjectsColl = new TreeMap<Object, Set<UniqueElement>>();
        Hashtable objects = new Hashtable(objectsDesiredColl.size());
        for (Collection<T> objectsDesired : objectsDesiredColl) {
            Iterator<T> it = objectsDesired.iterator();
            if (!it.hasNext()) continue;
            T firstObject = it.next();
            if (!(firstObject instanceof UniqueElement)) {
                Vector<T> existingObjectsOfFDSType = (Vector<T>)objects.get(firstObject.getClass());
                if (existingObjectsOfFDSType == null) {
                    existingObjectsOfFDSType = new Vector<T>();
                    objects.put(firstObject.getClass(), existingObjectsOfFDSType);
                }
                existingObjectsOfFDSType.addAll(objectsDesired);
            } else {
                Object uniqueType = ((UniqueElement)firstObject).getUniqueTypeKey();
                HashSet<UniqueElement> existingUniqueObjects = (HashSet<UniqueElement>)uniqueObjectsColl.get(uniqueType);
                if (existingUniqueObjects == null) {
                    existingUniqueObjects = new HashSet<UniqueElement>();
                    uniqueObjectsColl.put(uniqueType, existingUniqueObjects);
                }
                for (UniqueElement uniqueObject : objectsDesired) {
                    existingUniqueObjects.add(uniqueObject);
                }
            }
            if (!(firstObject instanceof IDependent)) continue;
            this.collectObjectsRecursive(objectsDesired, uniqueObjectsColl, this.getPossibleDependedOnsForDependents());
        }
        for (Set dependedOns : uniqueObjectsColl.values()) {
            if (dependedOns.size() == 0) continue;
            UniqueElement first = (UniqueElement)dependedOns.iterator().next();
            Object uniqueType = first.getUniqueTypeKey();
            Vector serializableColl = new Vector(dependedOns.size());
            serializableColl.addAll(dependedOns);
            objects.put(uniqueType, serializableColl);
        }
        return objects.values();
    }

    private void collectObjectsRecursive(Collection<? extends Object> dependentObjects, Map<Object, Set<UniqueElement>> objectsDependedOnColl, Map<Class, Set<Class>> possibleDependedOnsColl) {
        Class<?> objectType = dependentObjects.iterator().next().getClass();
        Collection possibleDependedOns = possibleDependedOnsColl.get(objectType);
        HashSet<IDependedOn> tempSet = new HashSet<IDependedOn>();
        for (Class possibleDependedOnType : possibleDependedOns) {
            tempSet.clear();
            for (Object object : dependentObjects) {
                ((IDependent)object).getObjectsDependedOn(tempSet, possibleDependedOnType);
            }
            if (tempSet.size() == 0) continue;
            IDependedOn first = (IDependedOn)tempSet.iterator().next();
            Object object = first.getUniqueTypeKey();
            Set<UniqueElement> dependedOns = objectsDependedOnColl.get(object);
            if (dependedOns == null) {
                dependedOns = new HashSet<UniqueElement>();
                objectsDependedOnColl.put(object, dependedOns);
            }
            dependedOns.addAll(tempSet);
            if (!IDependent.class.isAssignableFrom(possibleDependedOnType)) continue;
            this.collectObjectsRecursive(tempSet, objectsDependedOnColl, possibleDependedOnsColl);
        }
    }
}

