/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class RampRecord
implements Serializable,
Cloneable,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    private String d_name;
    private UnitDouble d_t;
    private UnitDouble d_f;
    private int d_tUnit;
    private int d_fUnit;

    public RampRecord(String name, UnitDouble t, UnitDouble f, int tUnit, int fUnit) {
        this.d_name = name;
        this.d_t = t;
        this.d_f = f;
        this.d_tUnit = tUnit;
        this.d_fUnit = fUnit;
    }

    public Object clone() throws CloneNotSupportedException {
        RampRecord rec = (RampRecord)super.clone();
        rec.d_t = (UnitDouble)this.d_t.clone();
        rec.d_f = (UnitDouble)this.d_f.clone();
        return rec;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RampRecord)) {
            return false;
        }
        RampRecord rec = (RampRecord)o;
        return rec.d_name.equals(this.getName()) && rec.d_t.equals(this.d_t) && rec.d_f.equals(this.d_f);
    }

    public String getName() {
        return this.d_name;
    }

    public void setName(String name) {
        this.d_name = name;
    }

    public int getTUnit() {
        return this.d_tUnit;
    }

    public int getFUnit() {
        return this.d_fUnit;
    }

    public UnitDouble getT() {
        return this.d_t;
    }

    public UnitDouble getF() {
        return this.d_f;
    }

    @Override
    public String getFDSType() {
        return "RAMP";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("RAMP");
        rec.setValue("ID", this.getName());
        FdsSISystem si = FdsSISystem.getInstance();
        rec.setValue("T", this.getT().getValue(si.getUnit(this.d_tUnit)));
        rec.setValue("F", this.getF().getValue(si.getUnit(this.d_fUnit)));
        recs.add(rec);
    }
}

