/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Iterator;
import pyrosim.legacy_2006_2.domain.DeepFDSObjectIterator;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectIterator;
import pyrosim.legacy_2006_2.domain.FDSObjectTypeIterator;

public class FDSObjectCollection<T extends FDSObject>
implements Collection<T> {
    private final boolean d_deep;
    private final Collection<? extends FDSObject> d_objs;
    private final Class<T> d_type;
    private int d_size = -1;

    public FDSObjectCollection(Collection<? extends FDSObject> objs, Class<T> type) {
        this(objs, true, type);
    }

    public FDSObjectCollection(Collection<? extends FDSObject> objs, boolean deep, Class<T> type) {
        this.d_deep = deep;
        this.d_objs = objs;
        this.d_type = type;
    }

    @Override
    public int size() {
        if (this.d_size == -1) {
            this.d_size = 0;
            Iterator<T> it = this.iterator();
            while (it.hasNext()) {
                ++this.d_size;
                it.next();
            }
        }
        return this.d_size;
    }

    public int shallowSize() {
        return this.d_objs.size();
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public boolean shallowIsEmpty() {
        return this.d_objs.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return FDSObjectCollection.contains(this.d_objs, o, this.d_deep);
    }

    private static boolean contains(Collection<? extends FDSObject> objs, Object o, boolean deep) {
        for (FDSObject fDSObject : objs) {
            if (fDSObject == o) {
                return true;
            }
            if (!deep || !(fDSObject instanceof FDSComposite)) continue;
            FDSComposite comp = (FDSComposite)fDSObject;
            if (comp.contains((FDSObject)o)) {
                return true;
            }
            if (!FDSObjectCollection.contains(comp.toCollection(), o, deep)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new FDSObjectTypeIterator<T>(this.d_objs, this.d_deep, this.d_type);
    }

    public DeepFDSObjectIterator deepIterator() {
        return new DeepFDSObjectIterator(this.d_objs);
    }

    public FDSObjectIterator shallowIterator() {
        return new FDSObjectIterator(this.d_objs, false);
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        return this.toArray((T2[])arr);
    }

    @Override
    public <T2> T2[] toArray(T2[] a) {
        int index = 0;
        T2[] coll = a;
        for (FDSObject obj : this) {
            coll[index++] = obj;
        }
        return a;
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

