/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class BNDFList
extends APyroDomainManager<String, BNDFRecord>
implements Serializable {
    static final long serialVersionUID = 1L;
    private Hashtable<String, BNDFRecord> d_bndfs = new Hashtable();
    protected boolean d_bOutputEnabled = true;

    public BNDFList() {
    }

    public BNDFList(boolean outputEnabled) {
        this.d_bOutputEnabled = outputEnabled;
    }

    @Override
    public Collection<? extends BNDFRecord> toCollection() {
        return new PyroCollection<String, BNDFRecord>(this);
    }

    public boolean isOutputEnabled() {
        return this.d_bOutputEnabled;
    }

    public void setOutputEnabled(boolean enabled) {
        this.d_bOutputEnabled = enabled;
        this.fireDomainEvent(new PyroDomainEvent(this.toCollection(), BNDFRecord.class, 5));
    }

    @Override
    protected boolean add(BNDFRecord record) {
        if (this.d_bndfs.containsKey(record.getQuantity())) {
            return false;
        }
        super.add(record);
        this.d_bndfs.put(record.getQuantity(), record);
        this.fireDomainEvent(new PyroDomainEvent<BNDFList, BNDFRecord>(this, record, BNDFRecord.class, 3));
        return true;
    }

    @Override
    public BNDFRecord get(String quantity) {
        return this.d_bndfs.get(quantity);
    }

    @Override
    protected boolean remove(BNDFRecord rec) {
        BNDFRecord existingRec = this.get(rec.getQuantity());
        if (existingRec != null) {
            existingRec.destroy();
        }
        super.remove(rec);
        this.fireDomainEvent(new PyroDomainEvent<BNDFList, BNDFRecord>(this, rec, BNDFRecord.class, 4));
        return this.d_bndfs.remove(rec.getQuantity()) != null;
    }

    public BNDFRecord[] toArray() {
        return this.d_bndfs.values().toArray(new BNDFRecord[this.d_bndfs.size()]);
    }

    public BNDFRecord[] toArray(BNDFRecord[] array) {
        return this.d_bndfs.values().toArray(array);
    }

    public static BNDFList fromLegacy(pyrosim.legacy_2006_2.legacy.BNDFList legacyList) {
        BNDFList newList = new BNDFList();
        for (BNDFRecord rec : legacyList.values()) {
            newList.add(rec);
        }
        newList.setOutputEnabled(legacyList.isOutputEnabled());
        return newList;
    }

    @Override
    public boolean contains(String key) {
        return this.d_bndfs.containsKey(key);
    }

    @Override
    public Iterator<BNDFRecord> iterator() {
        return this.d_bndfs.values().iterator();
    }

    @Override
    public int size() {
        return this.d_bndfs.size();
    }

    @Override
    public Class<BNDFRecord> getVClass() {
        return BNDFRecord.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public BNDFRecord get(BNDFRecord pyroObject) {
        return this.d_bndfs.get(pyroObject.getQuantity());
    }

    @Override
    public String describeObject(BNDFRecord pyroObject) {
        return pyroObject.getQuantity();
    }

    @Override
    public Task taskAdd(BNDFRecord pyroObject) {
        return this.taskAddAll((Collection<? extends BNDFRecord>)new VectorFromArray<BNDFRecord>(pyroObject));
    }

    @Override
    public Task taskAddAll(Collection<? extends BNDFRecord> pyroObjects) {
        return new APyroManAddTask<String, BNDFRecord>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(BNDFRecord obj) {
                return BNDFList.this.add(obj);
            }

            @Override
            public boolean remove(BNDFRecord obj) {
                return BNDFList.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskRemove(BNDFRecord pyroObject, BNDFRecord replacement) {
        return this.taskRemoveAll((List<BNDFRecord>)new VectorFromArray<BNDFRecord>(pyroObject), (List<BNDFRecord>)new VectorFromArray<BNDFRecord>(replacement));
    }

    @Override
    public Task taskRemoveAll(List<BNDFRecord> pyroObjects, List<BNDFRecord> replacements) {
        return new APyroManReplaceTask<String, BNDFRecord>((IPyroManager)this, pyroObjects, replacements){

            @Override
            public boolean add(BNDFRecord obj) {
                return BNDFList.this.add(obj);
            }

            @Override
            public boolean remove(BNDFRecord obj) {
                return BNDFList.this.remove(obj);
            }
        };
    }

    @Override
    public boolean canMakeUnique(BNDFRecord pyroObject) {
        return false;
    }

    @Override
    public Task taskMakeUnique(BNDFRecord pyroObject) {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.d_bndfs.isEmpty();
    }
}

