/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.util.Set;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AAlignedFDSObject;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public final class AlignedHole
extends AAlignedFDSObject {
    static final long serialVersionUID = 1L;
    private static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);

    public AlignedHole() {
        this(new UnitPoint3D(0.0, 0.0, 0.0, SI.METER), new UnitPoint3D(0.0, 0.0, 0.0, SI.METER));
    }

    public AlignedHole(UnitPoint3D minPoint, UnitPoint3D maxPoint) {
        this(minPoint, maxPoint, "Hole");
    }

    public AlignedHole(UnitPoint3D minPoint, UnitPoint3D maxPoint, String description) {
        super(minPoint, maxPoint, description, null);
        this.setColor(null);
    }

    public static AlignedHole fromLegacy(pyrosim.legacy_2006_2.legacy.v16.AlignedHole oldBlock) {
        AlignedHole ah = new AlignedHole();
        AAlignedFDSObject.fromLegacy(oldBlock, ah);
        return ah;
    }

    @Override
    protected void rotateFaces(Vector3d rotAxis, UnitDouble angle) {
    }

    @Override
    protected void mirrorFaces(int plane, UnitDouble value) {
    }

    @Override
    public void imprint(Object baseObject) {
        if (!(baseObject instanceof AlignedHole)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(baseObject);
        FDSObject obj = (FDSObject)baseObject;
        this.setColor(obj.getColor());
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AlignedHole)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public void setColor(Color c) {
        if (c != null) {
            super.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 102));
        } else {
            super.setColor(null);
        }
    }

    @Override
    public String getFDSType() {
        return "HOLE";
    }

    @Override
    protected void fillExtraRecords(FDSInputRecord rec) {
    }

    @Override
    protected void fillMaterialRecords(FDSInputRecord rec) {
    }

    @Override
    public void setMaterial(int faceIndex, Material mat) {
    }

    @Override
    public Material getMaterial(int faceIndex) {
        return null;
    }

    @Override
    public void getGeometry(Geometry g) {
        Prism p = new Prism(this.getMinPoint().getValue(Geometry.GEOM_LENGTH_UNIT), this.getMaxPoint().getValue(Geometry.GEOM_LENGTH_UNIT));
        if (this.getColor() != null) {
            p.setColor(this.getColor());
        } else {
            p.setColor(DEF_COLOR);
        }
        g.addPrism(p);
    }

    @Override
    public String getTypeDescription() {
        return "Hole";
    }

    @Override
    public boolean dependsOnObject(IDependedOn depOn) {
        if (depOn instanceof Material) {
            return false;
        }
        return super.dependsOnObject(depOn);
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> dependencies, Class<IDependedOn> type) {
        if (Material.class.isAssignableFrom(type)) {
            return;
        }
        super.getObjectsDependedOn(dependencies, type);
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn dep, Object info) {
        if (dep instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnChanged(dep, info);
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn old, IDependedOn replacement) {
        if (old instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnReplaced(old, replacement);
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn dep, String newID) {
        if (dep instanceof Material) {
            return null;
        }
        return super.taskUpdateBeforeDependedOnRenamed(dep, newID);
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }
}

