/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.pyrosimV5V6;

import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.FDSClusterOptions;
import pyrosim.domain.FDSRun;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IHeatBasedValue;
import pyrosim.domain.INamed;
import pyrosim.domain.ResultsArchive;
import pyrosim.domain.Serialized;
import pyrosim.domain.SimParams;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.appearance.MaterialCache;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.mat.IPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidReaction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.mat.SolidReaction;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.LogicOps.AndOp;
import pyrosim.domain.controls.LogicOps.DblGreaterThanOp;
import pyrosim.domain.controls.MathOps.CountOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.APointDetector;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.hvac.DuctDevice;
import pyrosim.domain.devices.hvac.NodeDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.simctrl.KillDevice;
import pyrosim.domain.devices.simctrl.RestartFileDevc;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.evac.Corr;
import pyrosim.domain.evac.Door;
import pyrosim.domain.evac.DoorList;
import pyrosim.domain.evac.EvhoList;
import pyrosim.domain.evac.Evss;
import pyrosim.domain.evac.EvssList;
import pyrosim.domain.evac.ExitList;
import pyrosim.domain.evac.Pers;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacList;
import pyrosim.domain.output.AMsrStat;
import pyrosim.domain.output.GasMsrStat;
import pyrosim.domain.output.GridBoundarySlice;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.output.StatisticMgr;
import pyrosim.domain.particle.DropletColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.domain.reaction.PredefReac;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.Zone;
import pyrosim.geom.Geometry;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.pyrosimV5V6.ConvertUtil;
import pyrosim.io.pyrosimV5V6.DelayedArrayLoader;
import pyrosim.io.pyrosimV5V6.DelayedLoader;
import pyrosim.io.pyrosimV5V6.DelayedObjectLoader;
import pyrosim.io.pyrosimV5V6.DelayedRef;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.FDSRun;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.IHeatBasedValue;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.ResultsArchive;
import pyrosim.legacy_2012_1.domain.SimParams;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.Variant;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.surf.AirFlow;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Backing;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.FanSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Fuel;
import pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISlip;
import pyrosim.legacy_2012_1.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SpeciesInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfComposition;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfDescStatic;
import pyrosim.legacy_2012_1.domain.boundcond.surf.TempRegulation;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ZonePath;
import pyrosim.legacy_2012_1.domain.controls.ControlMgr;
import pyrosim.legacy_2012_1.domain.controls.DblLessThanOp;
import pyrosim.legacy_2012_1.domain.controls.DeadbandCtrl;
import pyrosim.legacy_2012_1.domain.controls.IntEqualOp;
import pyrosim.legacy_2012_1.domain.controls.IntGreaterThanOp;
import pyrosim.legacy_2012_1.domain.controls.IntLessThanOp;
import pyrosim.legacy_2012_1.domain.controls.IntNotEqualOp;
import pyrosim.legacy_2012_1.domain.controls.LatchCtrl;
import pyrosim.legacy_2012_1.domain.controls.ManualCtrl;
import pyrosim.legacy_2012_1.domain.controls.NotOp;
import pyrosim.legacy_2012_1.domain.controls.OrOp;
import pyrosim.legacy_2012_1.domain.controls.SumOp;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.devices.AlarmInfo;
import pyrosim.legacy_2012_1.domain.devices.DeviceManager;
import pyrosim.legacy_2012_1.domain.devices.aspiration.Aspirator;
import pyrosim.legacy_2012_1.domain.devices.detectors.CableFailDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLink;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.hvac.HvacDevice;
import pyrosim.legacy_2012_1.domain.devices.measurers.AABoxMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.ABeamMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.legacy_2012_1.domain.devices.sprayers.DryPipe;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Nozzle;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModelMgr;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Sprinkler;
import pyrosim.legacy_2012_1.domain.evac.CorrList;
import pyrosim.legacy_2012_1.domain.evac.Entr;
import pyrosim.legacy_2012_1.domain.evac.EntrList;
import pyrosim.legacy_2012_1.domain.evac.Evac;
import pyrosim.legacy_2012_1.domain.evac.EvacList;
import pyrosim.legacy_2012_1.domain.evac.Evho;
import pyrosim.legacy_2012_1.domain.evac.Exit;
import pyrosim.legacy_2012_1.domain.evac.PersList;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.geom.AttachedPointLoc;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.GenericGeomSrc;
import pyrosim.legacy_2012_1.domain.geom.IModelObj;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.domain.geom.PartCloud;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.output.Boundaries;
import pyrosim.legacy_2012_1.domain.output.Isosurface;
import pyrosim.legacy_2012_1.domain.output.IsosurfaceMgr;
import pyrosim.legacy_2012_1.domain.output.Plot3d;
import pyrosim.legacy_2012_1.domain.output.ProfList;
import pyrosim.legacy_2012_1.domain.output.SolidMsrStat;
import pyrosim.legacy_2012_1.domain.output.StatGeom;
import pyrosim.legacy_2012_1.domain.particle.ConstColoring;
import pyrosim.legacy_2012_1.domain.particle.FuelPartDesc;
import pyrosim.legacy_2012_1.domain.particle.FuelPyrolysis;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.IParticleDesc;
import pyrosim.legacy_2012_1.domain.particle.Pyrolysis;
import pyrosim.legacy_2012_1.domain.particle.SizeDistribution;
import pyrosim.legacy_2012_1.domain.particle.ThermalProps;
import pyrosim.legacy_2012_1.domain.particle.TracerPartDesc;
import pyrosim.legacy_2012_1.domain.particle.WaterPartDesc;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.StaticQuantity;
import pyrosim.legacy_2012_1.domain.ramp.IRampInput;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.RampInputs;
import pyrosim.legacy_2012_1.domain.rasterization.RasterizationOptions;
import pyrosim.legacy_2012_1.domain.reaction.Byproducts;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.reaction.Soot;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.domain.texture.ModelImage;
import pyrosim.legacy_2012_1.domain.texture.TextureDB;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.domain.zones.LeakMgr;
import pyrosim.legacy_2012_1.domain.zones.ZoneMgr;
import pyrosim.legacy_2012_1.io.fds.FDSRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.util.Util;
import pyrosim.unitsystem.EnglishUS;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class Convert {
    private WarningReport<Warning> d_warnings;
    private final File d_dbDir;
    private Map<Object, DelayedRef> d_delayLoadMap;
    private Collection<DelayedLoader> d_delayLoaders;
    private Map<ISignalSource, pyrosim.domain.signals.ISignalSource> d_signalSources;
    private Map<pyrosim.legacy_2012_1.domain.signals.ISignalSink, ISignalSink> d_signalSinks;
    private Map<SignalInput, ISignalSource> d_rampSignalInputs;
    private Map<pyrosim.legacy_2012_1.domain.signals.IOutPin, IOutPin> d_outputPins;
    private Map<NamedPyroObject, pyrosim.domain.NamedPyroObject> d_evacMap;
    private Map<Pair<pyrosim.domain.boundcond.mat.ReacByproducts, NamedPyroObject>, Pair<String, Double>> d_matResMap;
    private Map<ExSpec, pyrosim.domain.ExSpec> d_mixFracMap;
    private Map<pyrosim.legacy_2012_1.domain.geom.InitRegion, InitRegion> d_initRegions;
    private final LegacyDictionary_2012_1 d_dictionary;
    private final MaterialCache d_appearanceCache;
    private pyrosim.domain.ExSpecList d_specList;
    private final Set<PartCloud> d_staticPartClouds;

    public Convert(File dbDir, WarningReport warnings) {
        this.d_dbDir = dbDir;
        this.d_warnings = warnings;
        this.d_delayLoadMap = new LinkedHashMap<Object, DelayedRef>();
        this.d_delayLoaders = new ArrayDeque<DelayedLoader>();
        this.d_signalSources = new LinkedHashMap<ISignalSource, pyrosim.domain.signals.ISignalSource>();
        this.d_signalSinks = new LinkedHashMap<pyrosim.legacy_2012_1.domain.signals.ISignalSink, ISignalSink>();
        this.d_rampSignalInputs = new LinkedHashMap<SignalInput, ISignalSource>();
        this.d_evacMap = new HashMap<NamedPyroObject, pyrosim.domain.NamedPyroObject>();
        this.d_matResMap = new LinkedHashMap<Pair<pyrosim.domain.boundcond.mat.ReacByproducts, NamedPyroObject>, Pair<String, Double>>();
        this.d_mixFracMap = new HashMap<ExSpec, pyrosim.domain.ExSpec>();
        this.d_initRegions = new LinkedHashMap<pyrosim.legacy_2012_1.domain.geom.InitRegion, InitRegion>();
        this.d_dictionary = new LegacyDictionary_2012_1();
        this.d_appearanceCache = new MaterialCache(Collections.EMPTY_LIST);
        this.d_staticPartClouds = new LinkedIdentityHashSet<PartCloud>();
        this.d_specList = null;
        this.makeAvailableForDelayLoad(null, null);
    }

    private File getAppearanceDBDir() {
        return new File(this.d_dbDir, "textures");
    }

    private void registerForDelayLoad(Object newObj, Field f, Object legObj) {
        DelayedRef ref = null;
        if (!this.d_delayLoadMap.containsKey(legObj)) {
            ref = new DelayedRef();
            this.d_delayLoadMap.put(legObj, ref);
            this.d_delayLoaders.add(new DelayedObjectLoader(newObj, f, ref));
        } else {
            this.d_delayLoaders.add(new DelayedObjectLoader(newObj, f, this.d_delayLoadMap.get(legObj)));
        }
    }

    private void registerArrayForDelayLoad(Object[] legArray, Object[] newArray, Object container, Method setMethod, int behavior) {
        DelayedRef[] refs = new DelayedRef[legArray.length];
        for (int i = 0; i < legArray.length; ++i) {
            DelayedRef ref = null;
            if (!this.d_delayLoadMap.containsKey(legArray[i])) {
                ref = new DelayedRef();
                this.d_delayLoadMap.put(legArray[i], ref);
            } else {
                ref = this.d_delayLoadMap.get(legArray[i]);
            }
            refs[i] = ref;
        }
        this.d_delayLoaders.add(new DelayedArrayLoader(newArray, refs));
    }

    private void makeAvailableForDelayLoad(Object newObj, Object legObj) {
        if (!this.d_delayLoadMap.containsKey(legObj)) {
            this.d_delayLoadMap.put(legObj, new DelayedRef());
        }
        this.d_delayLoadMap.get(legObj).set(newObj);
    }

    public Serialized fromLegacy(File psmFile, Serialized ser, pyrosim.legacy_2012_1.domain.Serialized old, MaterialDB appearanceDB) {
        this.fromLegacyGridList(old.grids, ser.grids);
        this.fromLegacyZoneMgr(old.zones, ser.zones);
        this.fromLegacyBridgeList(old.zoneLeaks, ser.bridges);
        this.fromLegacyFloorMgr(old.floors, ser.floors);
        this.fromLegacyPartList(old.particles, ser.particles, ser.exSpecs);
        this.fromLegacyMatMgr(old.matmgr, ser.matmgr);
        this.fromLegacySurfMgr(old.surfmgr, ser.surfmgr, true, old.textures, ser.matmgr, appearanceDB);
        this.d_specList = this.fromLegacySpecList(old.exSpecs, ser.exSpecs, ser, true);
        this.addResidues(ser);
        this.fromLegacyReacList(old.reactions, ser.reactions, ser.simParams, ser.exSpecs);
        this.fromLegacyHvacList(old.hvacSystem, ser.hvacSystem);
        this.fromLegacyModelComp(old.obstructions, ser.obstructions);
        this.fromLegacySimParams(old.simParams, ser.simParams, this.d_specList);
        this.warnOnMixFrac(old);
        ser.enableFdsEvac = old.enableFdsEvac;
        this.fromLegacy(old.perss, ser.perss);
        this.fromLegacy(old.exits, ser.exits);
        this.fromLegacy(old.evacs, ser.evacs);
        this.fromLegacy(old.entrs, ser.entrs);
        this.fromLegacy(old.evhos, ser.evhos);
        this.fromLegacy(old.corrs, ser.corrs);
        this.fromLegacy(old.evsss, ser.evsss);
        this.fromLegacy(old.doors, ser.doors);
        this.setEvacProps(old, ser);
        this.fromLegacy(old.controls, ser.controls);
        this.fromLegacyHeatLinkMgr(old.heatLinkModels, ser.heatLinkModels);
        this.fromLegacySmokeLinkMgr(old.smokeLinkModels, ser.smokeLinkModels);
        this.fromLegacySprinklerLinkMgr(old.sprkLinkModels, ser.sprkLinkModels);
        this.fromLegacySprayMgr(old.sprayModels, ser.sprayModels);
        this.fromLegacyDevcMgr(old.devices, ser.devices, ser);
        ser.boundaryOutput = this.fromLegacyBound(old.boundaryOutput, ser.boundaryOutput);
        this.fromLegacyIsoMgr(old.isosurfaces, ser.isosurfaces);
        this.fromLegacyPl3d(old.plot3d, ser.plot3d);
        this.fromLegacySlcfList(old.slices, ser.slices);
        this.fromLegacyProfList(old.profs, ser.profs);
        this.fromLegacyStatMgr(old.msrStats, ser.msrStats);
        this.fromLegacyMatlDB(old.textures, ser.appearances);
        this.fromLegacyRaster(old.rastProps, ser.rastProps);
        ser.unprocessedRecords = old.unprocessedRecords;
        ser.lastFDSRun = this.fromLegacyRunConfig(old.lastFDSRun, ser.lastFDSRun);
        this.fromLegacyClusterConfig(old.clusterOptions, ser.clusterOptions);
        this.fromLegacyResultArch(old.resultsArchive, ser.resultsArchive);
        ser.d_protect = old.d_protect;
        ser.d_protectPassHash = old.d_protectPassHash;
        for (DelayedLoader d : this.d_delayLoaders) {
            d.run();
        }
        PyroSimObjectInputStream.addPeriodicSurface(ser, this.d_warnings);
        ser.initDefaults();
        this.linkAspiratorLines(ser.devices);
        this.loadInitRegionSpecies();
        this.connectPins();
        this.updateEnabled(old);
        PyroSimObjectInputStream.removePre52deprecatedQuants(ser, this.d_warnings);
        PyroSimObjectInputStream.fixPre52ThermocoupleQuants(ser, this.d_warnings);
        PyroSimObjectInputStream.removePre54HRRPUA(ser, this.d_warnings);
        PyroSimObjectInputStream.fixPre54DefaultSurfs(ser, this.d_warnings);
        PyroSimObjectInputStream.updatePre63Surfs(ser, this.d_warnings);
        PyroSimObjectInputStream.updatePre69Adiabatic(ser, this.d_warnings);
        PyroSimObjectInputStream.updatePre65Surfs(ser, this.d_warnings);
        PyroSimObjectInputStream.fixPre68SprayModels(ser, this.d_warnings);
        PyroSimObjectInputStream.fixPre72ClonedPins(ser, this.d_warnings);
        PyroSimObjectInputStream.fixPre73SprayModels(ser, this.d_warnings);
        PyroSimObjectInputStream.fixPre75FireSpreadVents(ser, this.d_warnings);
        PyroSimObjectInputStream.fixPre76SliceDuplicates(ser, this.d_warnings);
        PyroSimObjectInputStream.fixPre82FanCurves(ser, this.d_warnings);
        PyroSimObjectInputStream.fixPre84Evac(ser, this.d_warnings);
        PyroSimObjectInputStream.fds_6_3_update(ser, this.d_warnings);
        PyroSimObjectInputStream.manuallyConvertPre86AtmGradUnits(ser, this.d_warnings);
        PyroSimObjectInputStream.generatePre87Elements(ser, this.d_warnings);
        PyroSimObjectInputStream.warnPre91SingleSprkDryPipe(ser, this.d_warnings);
        PyroSimObjectInputStream.warnPre94OutflowSurfs(ser, this.d_warnings);
        PyroSimObjectInputStream.fixPre95MultipleReacs(ser, this.d_warnings);
        PyroSimObjectInputStream.bakePre99Transforms(ser, this.d_warnings);
        PyroSimObjectInputStream.fixPre131AspiratorUnits(ser, this.d_warnings);
        this.updateStaticPartClouds(ser);
        PyroSimObjectInputStream.fixMissingJets(ser, this.d_warnings);
        PyroSimObjectInputStream.fds_6_3_update(ser, this.d_warnings);
        PyroSimObjectInputStream.fixBadDeviceRefs(ser);
        PyroSimObjectInputStream.regeneratePre147ResultsIds(Optional.ofNullable(psmFile), ser, this.d_warnings);
        return ser;
    }

    private void updateStaticPartClouds(Serialized ser) {
        LinkedIdentityHashSet affectedParts = new LinkedIdentityHashSet();
        for (PartCloud staticPC : this.d_staticPartClouds) {
            affectedParts.add(staticPC.getParticle());
        }
        if (affectedParts.isEmpty()) {
            return;
        }
        PyroMod tempMod = new PyroMod(ser, false, false);
        NameGenerator partNames = tempMod.getNames(Particle.class);
        pyrosim.domain.dependencies.DepSnapshot deps = tempMod.getDependencies(affectedParts);
        for (Particle part : affectedParts) {
            Set<pyrosim.domain.IPyroObject> dependents = deps.findAllDependents(pyrosim.domain.IPyroObject.class, (Object)part);
            if (dependents.isEmpty()) {
                assert (false);
                continue;
            }
            Boolean depsStatic = null;
            for (pyrosim.domain.IPyroObject dep : dependents) {
                boolean depStatic;
                boolean bl = depStatic = dep instanceof PartCloud && this.d_staticPartClouds.contains(dep);
                if (depsStatic == null) {
                    depsStatic = depStatic;
                    continue;
                }
                if (depsStatic == depStatic) continue;
                depsStatic = null;
                break;
            }
            if (depsStatic == null) {
                Particle staticPart = (Particle)part.clone();
                staticPart.setStatic(true);
                String staticPartName = String.format(Intl.intl("%s [static]"), part.getName());
                staticPart.setName(partNames.generateValidName(staticPartName));
                ser.particles.add(staticPart);
                partNames.registerName(staticPartName);
                for (PartCloud pc : theUtil.filter(dependents, PartCloud.class, Filters.accept(this.d_staticPartClouds))) {
                    pc.setParticle(staticPart);
                }
                continue;
            }
            if (!depsStatic.booleanValue()) continue;
            part.setStatic(true);
        }
    }

    private void updateEnabled(pyrosim.legacy_2012_1.domain.Serialized serOld) {
        IObjectFilter<IPyroObject> disabledObjsOnly = new IObjectFilter<IPyroObject>(){

            @Override
            public boolean shouldFilter(IPyroObject o) {
                return o.isEnabled();
            }
        };
        Collection<IPyroObject> allDisabledObjs = pyrosim.legacy_2012_1.domain.Hierarchy.flatten(pyrosim.legacy_2012_1.PyroMod.getMembers(serOld, true), IPyroObject.class, disabledObjsOnly);
        for (IPyroObject obj : allDisabledObjs) {
            assert (!obj.isEnabled());
            if (obj.isEnabled()) continue;
            if (this.d_delayLoadMap.containsKey(obj)) {
                APyroObject objNew = (APyroObject)this.d_delayLoadMap.get(obj).get();
                objNew.setEnabled(false);
                continue;
            }
            String helpfulName = obj instanceof NamedPyroObject ? ((NamedPyroObject)obj).getName() : "" + obj.hashCode();
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unable to maintain disabled status on %s: %s"), obj.getClass().getSimpleName(), helpfulName), Intl.intl("Updated value must be disabled manually.")));
        }
    }

    private void addResidues(Serialized ser) {
        for (Map.Entry<Pair<pyrosim.domain.boundcond.mat.ReacByproducts, NamedPyroObject>, Pair<String, Double>> entr : this.d_matResMap.entrySet()) {
            pyrosim.domain.ExSpec spec;
            pyrosim.domain.boundcond.mat.ReacByproducts bp = (pyrosim.domain.boundcond.mat.ReacByproducts)entr.getKey().v1;
            String resName = (String)entr.getValue().v1;
            double comp = (Double)entr.getValue().v2;
            if (entr.getKey().v2 instanceof pyrosim.legacy_2012_1.domain.boundcond.mat.Material) {
                Material mat = (Material)ser.matmgr.get(resName);
                if (mat == null) continue;
                bp.addResidue(mat, comp);
                continue;
            }
            if (!(entr.getKey().v2 instanceof ExSpec)) continue;
            if (ExSpecList.isPredefinedSpecies(resName) && ser.exSpecs.get("WATER VAPOR") == null) {
                pyrosim.domain.ExSpec waterSpec = new pyrosim.domain.ExSpec(pyrosim.domain.ExSpecList.getPredefinedSpecies("WATER VAPOR"));
                this.d_specList.add(waterSpec);
            }
            if ((spec = ser.exSpecs.get(resName)) == null) continue;
            bp.addResidue(spec, comp);
        }
    }

    private void linkAspiratorLines(pyrosim.domain.devices.DeviceManager devMan) {
        for (IDevice dev : devMan.flatten()) {
            if (!(dev instanceof Aspirator)) continue;
            Aspirator asp = (Aspirator)dev;
            ArrayList<Aspirator.SamplerLine> samplerLines = new ArrayList<Aspirator.SamplerLine>();
            samplerLines.addAll(asp.getSamplerLines());
            asp.setSamplerLines(samplerLines);
        }
    }

    private void loadInitRegionSpecies() {
        for (Map.Entry<pyrosim.legacy_2012_1.domain.geom.InitRegion, InitRegion> entr : this.d_initRegions.entrySet()) {
            if (entr.getKey().getExtraSpecies().size() == 0) continue;
            LinkedHashMap<pyrosim.domain.ExSpec, UnitDouble> newCompMap = new LinkedHashMap<pyrosim.domain.ExSpec, UnitDouble>();
            for (Map.Entry<ExSpec, pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble> legEntr : entr.getKey().getExtraSpecies().entrySet()) {
                pyrosim.domain.ExSpec newSpec = (pyrosim.domain.ExSpec)this.d_delayLoadMap.get(legEntr.getKey()).get();
                newCompMap.put(newSpec, ConvertUtil.c(legEntr.getValue()));
            }
            entr.getValue().setExtraSpecies(newCompMap, InitRegion.SpecFractionType.MASS_FRACTION);
        }
    }

    private pyrosim.domain.quantity.IQuantity quantRefsObject(pyrosim.domain.quantity.IQuantity quant, Object obj) {
        if (quant instanceof pyrosim.domain.quantity.ObjectQuantity) {
            pyrosim.domain.quantity.ObjectQuantity objQuant = (pyrosim.domain.quantity.ObjectQuantity)quant;
            for (Object pyroObj : objQuant.objects) {
                if (pyroObj != obj) continue;
                return objQuant;
            }
        }
        return null;
    }

    private Object fromLegacyEvacProp(Object legVal) {
        if (legVal == null) {
            return null;
        }
        if (legVal instanceof NamedPyroObject) {
            if (legVal instanceof pyrosim.legacy_2012_1.domain.Grid) {
                return this.d_delayLoadMap.get(legVal).get();
            }
            return this.d_evacMap.get(legVal);
        }
        if (legVal instanceof ILegacy_2012_1) {
            return this.d_dictionary.get((ILegacy_2012_1)legVal);
        }
        if (legVal instanceof pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble[]) {
            return ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble[])legVal);
        }
        if (legVal instanceof Map) {
            Map legMap = (Map)legVal;
            LinkedIdentityHashMap<Object, Object> newMap = new LinkedIdentityHashMap<Object, Object>(legMap.size());
            for (Map.Entry entry : legMap.entrySet()) {
                newMap.put(this.fromLegacyEvacProp(entry.getKey()), this.fromLegacyEvacProp(entry.getValue()));
            }
            return newMap;
        }
        return legVal;
    }

    private void setEvacProps(pyrosim.legacy_2012_1.domain.Serialized old, Serialized ser) {
        for (pyrosim.legacy_2012_1.domain.evac.Pers legPers : old.perss.flatten()) {
            Pers newPers = (Pers)this.d_evacMap.get(legPers);
            for (Map.Entry<String, Object> legEntr : legPers.getProps().entrySet()) {
                newPers.setProp(legEntr.getKey(), this.fromLegacyEvacProp(legEntr.getValue()));
            }
        }
        for (Exit legExit : old.exits.flatten()) {
            pyrosim.domain.evac.Exit newExit = (pyrosim.domain.evac.Exit)this.d_evacMap.get(legExit);
            for (Map.Entry<String, Object> legEntr : legExit.getProps().entrySet()) {
                newExit.setProp(legEntr.getKey(), this.fromLegacyEvacProp(legEntr.getValue()));
            }
        }
        for (Evac legEvac : old.evacs.flatten()) {
            pyrosim.domain.evac.Evac newEvac = (pyrosim.domain.evac.Evac)this.d_evacMap.get(legEvac);
            for (Map.Entry<String, Object> legEntr : legEvac.getProps().entrySet()) {
                newEvac.setProp(legEntr.getKey(), this.fromLegacyEvacProp(legEntr.getValue()));
            }
        }
        for (Entr legEntr : old.entrs.flatten()) {
            pyrosim.domain.evac.Entr newEntr = (pyrosim.domain.evac.Entr)this.d_evacMap.get(legEntr);
            for (Map.Entry<String, Object> legEntry : legEntr.getProps().entrySet()) {
                newEntr.setProp(legEntry.getKey(), this.fromLegacyEvacProp(legEntry.getValue()));
            }
        }
        for (Evho legEvho : old.evhos.flatten()) {
            pyrosim.domain.evac.Evho newEvho = (pyrosim.domain.evac.Evho)this.d_evacMap.get(legEvho);
            for (Map.Entry<String, Object> legEntr : legEvho.getProps().entrySet()) {
                newEvho.setProp(legEntr.getKey(), this.fromLegacyEvacProp(legEntr.getValue()));
            }
        }
        for (pyrosim.legacy_2012_1.domain.evac.Corr legCorrs : old.corrs.flatten()) {
            Corr newCorrs = (Corr)this.d_evacMap.get(legCorrs);
            for (Map.Entry<String, Object> legEntr : legCorrs.getProps().entrySet()) {
                newCorrs.setProp(legEntr.getKey(), this.fromLegacyEvacProp(legEntr.getValue()));
            }
        }
        for (pyrosim.legacy_2012_1.domain.evac.Evss legEvss : old.evsss.flatten()) {
            Evss newEvss = (Evss)this.d_evacMap.get(legEvss);
            for (Map.Entry<String, Object> legEntr : legEvss.getProps().entrySet()) {
                newEvss.setProp(legEntr.getKey(), this.fromLegacyEvacProp(legEntr.getValue()));
            }
        }
        for (pyrosim.legacy_2012_1.domain.evac.Door legDoor : old.doors.flatten()) {
            Door newDoor = (Door)this.d_evacMap.get(legDoor);
            for (Map.Entry<String, Object> legEntr : legDoor.getProps().entrySet()) {
                newDoor.setProp(legEntr.getKey(), this.fromLegacyEvacProp(legEntr.getValue()));
            }
        }
    }

    private void addToConnectionsMap(Object newObj, Object oldObj) {
        if (oldObj instanceof pyrosim.legacy_2012_1.domain.devices.measurers.Clock) {
            newObj = Clock.INSTANCE;
        }
        if (oldObj instanceof ISignalSource && !this.d_signalSources.containsKey(oldObj)) {
            this.d_signalSources.put((ISignalSource)oldObj, (pyrosim.domain.signals.ISignalSource)newObj);
        }
        if (oldObj instanceof pyrosim.legacy_2012_1.domain.signals.ISignalSink) {
            Set<ISignalSource> legSources = ((pyrosim.legacy_2012_1.domain.signals.ISignalSink)oldObj).getInputPin().getConnectedSources();
            if (legSources.isEmpty()) {
                return;
            }
            for (ISignalSource legSource : legSources) {
                INamed newSource = null;
                if (legSource instanceof pyrosim.legacy_2012_1.domain.controls.IControl && !(legSource instanceof pyrosim.legacy_2012_1.domain.controls.ControlBridge)) {
                    if (this.d_delayLoadMap.containsKey(legSource)) continue;
                    newSource = this.fromLegacyIControl((pyrosim.legacy_2012_1.domain.controls.IControl)legSource);
                } else if (legSource instanceof pyrosim.legacy_2012_1.domain.devices.measurers.Clock) {
                    newSource = this.fromLegacyDevc((pyrosim.legacy_2012_1.domain.devices.IDevice)((Object)legSource), null);
                } else if (legSource instanceof pyrosim.legacy_2012_1.domain.devices.detectors.Timer && !this.d_delayLoadMap.containsKey(legSource)) {
                    newSource = this.fromLegacyDevc((pyrosim.legacy_2012_1.domain.devices.detectors.Timer)legSource, null);
                }
                if (newSource == null) continue;
                this.addToConnectionsMap(newSource, legSource);
            }
            if (!this.d_signalSinks.containsKey(oldObj)) {
                this.d_signalSinks.put((pyrosim.legacy_2012_1.domain.signals.ISignalSink)oldObj, (ISignalSink)newObj);
            }
        }
    }

    private void connectPins() {
        for (Map.Entry<pyrosim.legacy_2012_1.domain.signals.ISignalSink, ISignalSink> entry : this.d_signalSinks.entrySet()) {
            block3: for (ISignalSource legSource : entry.getKey().getInputPin().getConnectedSources()) {
                pyrosim.domain.signals.ISignalSource newSource = this.d_signalSources.get(legSource);
                ISignalSink newSink = entry.getValue();
                if (newSource == null) continue;
                for (IOutPin iOutPin : newSource.getOutputPins()) {
                    if (!newSink.getInputPin().isCompatible(iOutPin)) continue;
                    newSink.getInputPin().connect(iOutPin);
                    continue block3;
                }
            }
        }
        for (Map.Entry<Serializable, Cloneable> entry : this.d_rampSignalInputs.entrySet()) {
            pyrosim.domain.signals.ISignalSource newSrc = this.d_signalSources.get(entry.getValue());
            Iterator<? extends IOutPin> iterator = newSrc.getOutputPins().iterator();
            if (!iterator.hasNext()) continue;
            IOutPin out = iterator.next();
            try {
                pyrosim.util.Util.assignFinalField(entry.getKey(), "input", out);
            }
            catch (Exception e) {
                assert (false);
            }
        }
    }

    private IControl fromLegacyIControl(pyrosim.legacy_2012_1.domain.controls.IControl legacy) {
        AControl newControl = null;
        if (legacy instanceof pyrosim.legacy_2012_1.domain.controls.DblGreaterThanOp) {
            newControl = new DblGreaterThanOp(ConvertUtil.c(((pyrosim.legacy_2012_1.domain.controls.DblGreaterThanOp)legacy).getN()));
        } else if (legacy instanceof DblLessThanOp) {
            newControl = new pyrosim.domain.controls.LogicOps.DblLessThanOp(ConvertUtil.c(((DblLessThanOp)legacy).getN()));
        } else if (legacy instanceof IntLessThanOp) {
            newControl = new pyrosim.domain.controls.LogicOps.IntLessThanOp(((IntLessThanOp)legacy).getN());
        } else if (legacy instanceof IntGreaterThanOp) {
            newControl = new pyrosim.domain.controls.LogicOps.IntGreaterThanOp(((IntGreaterThanOp)legacy).getN());
        } else if (legacy instanceof IntEqualOp) {
            newControl = new pyrosim.domain.controls.LogicOps.IntEqualOp(((IntEqualOp)legacy).getN());
        } else if (legacy instanceof IntNotEqualOp) {
            newControl = new pyrosim.domain.controls.LogicOps.IntNotEqualOp(((IntNotEqualOp)legacy).getN());
        } else if (legacy instanceof pyrosim.legacy_2012_1.domain.controls.AndOp) {
            newControl = new AndOp();
        } else if (legacy instanceof OrOp) {
            newControl = new pyrosim.domain.controls.LogicOps.OrOp();
        } else if (legacy instanceof NotOp) {
            newControl = new pyrosim.domain.controls.LogicOps.NotOp();
        } else if (legacy instanceof SumOp) {
            newControl = new CountOp();
        } else if (legacy instanceof pyrosim.legacy_2012_1.domain.controls.CustomCtrl) {
            newControl = new CustomCtrl(legacy.isEnabled(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.controls.CustomCtrl)legacy).getTripValues()));
        } else if (legacy instanceof DeadbandCtrl) {
            DeadbandCtrl legCtrl = (DeadbandCtrl)legacy;
            newControl = new pyrosim.domain.controls.DeadbandCtrl(legCtrl.getTripDirection(), ConvertUtil.c(legCtrl.getLowerBound()), ConvertUtil.c(legCtrl.getUpperBound()));
        } else if (legacy instanceof LatchCtrl) {
            newControl = new AndOp();
        } else if (legacy instanceof ManualCtrl) {
            ManualCtrl legCtrl = (ManualCtrl)legacy;
            newControl = new pyrosim.domain.controls.ManualCtrl(legCtrl.getFDSText(), legCtrl.getName());
        } else if (legacy instanceof pyrosim.legacy_2012_1.domain.controls.TimeDelayCtrl) {
            newControl = new TimeDelayCtrl(ConvertUtil.c(((pyrosim.legacy_2012_1.domain.controls.TimeDelayCtrl)legacy).getTimeDelay()));
        }
        return newControl;
    }

    private pyrosim.domain.SimParams fromLegacySimParams(SimParams legacy, pyrosim.domain.SimParams newParams, pyrosim.domain.ExSpecList specs) {
        newParams.setJobTitle(legacy.getJobTitle());
        this.fromLegacySPTime(legacy.getTime(), newParams.getTime());
        this.fromLegacySPCalc(legacy.getCalculations(), newParams.getCalculations());
        this.fromLegacySPEnv(legacy.getEnvironment(), newParams.getEnvironment());
        this.fromLegacySPWind(legacy.getEnvironment(), newParams.getWind());
        this.fromLegacySPRad(legacy.getRadiTransport(), newParams.getRadiTransport());
        this.fromLegacySPFile(legacy.getFileOutput(), newParams.getFileOutput());
        this.fromLegacySPPart(legacy.getParticles(), newParams.getParticles());
        this.fromLegacySPMisc(legacy.getMisc(), newParams.getMisc(), specs);
        newParams.setCustomFDSProps("TIME", this.fromLegacyCustomFDS(legacy.getCustomFDSProps("TIME")));
        newParams.setCustomFDSProps("DUMP", this.fromLegacyCustomFDS(legacy.getCustomFDSProps("DUMP")));
        newParams.setCustomFDSProps("RADI", this.fromLegacyCustomFDS(legacy.getCustomFDSProps("RADI")));
        newParams.setCustomFDSProps("MISC", this.fromLegacyCustomFDS(legacy.getCustomFDSProps("MISC")));
        return newParams;
    }

    private void fromLegacySPTime(SimParams.Time legacy, SimParams.Time newTime) {
        newTime.setInitTimeStep(ConvertUtil.c(legacy.getInitTimeStep()));
        newTime.setWallIncrement(legacy.getWallIncrement());
        newTime.setStartTime(ConvertUtil.c(legacy.getStartTime()));
        newTime.setStopTime(ConvertUtil.c(legacy.getStopTime()));
        newTime.setTimeStepLocks(legacy.lockTimeSteps(), legacy.restrictTimeSteps());
        Map<String, Object> props = legacy.getEvacProps();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            newTime.setEvacProp(entry.getKey(), this.fromLegacyEvacProp(entry.getValue()));
        }
    }

    private void fromLegacySPCalc(SimParams.Calculations legacy, SimParams.Calculations newCalcs) {
        if (legacy.getUseMLTurbulentModel()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("FDS no longer supports the H_EDDY parameter in the MISC namelist (Moinuddin and Li Turbulent Model)."), Intl.intl("Moinuddin and Li Turbulent Model dropped from MISC record.")));
        }
        if (legacy.calcDNS()) {
            newCalcs.setSimMode(SimParams.Calculations.SimulationMode.DNS);
            newCalcs.setBaroclinicState(SimParams.Calculations.BaroclinicState.AUTO);
        } else {
            newCalcs.setSimMode(SimParams.Calculations.SimulationMode.VLES);
            if (legacy.isCorrectBaroclinicTorque()) {
                newCalcs.setBaroclinicState(SimParams.Calculations.BaroclinicState.AUTO);
            } else {
                newCalcs.setBaroclinicState(SimParams.Calculations.BaroclinicState.FALSE);
            }
        }
        newCalcs.setCflRange(legacy.getCflRange()[0], legacy.getCflRange()[1]);
        newCalcs.setVnRange(legacy.getVnRange()[0], legacy.getVnRange()[1]);
        newCalcs.setCsmag(legacy.getCsmag());
        newCalcs.setPrandtlNum(legacy.getPrandtlNum());
        newCalcs.setSchmidtNum(legacy.getSchmidtNum());
        SimParams.Calculations defCalcs = new SimParams.Calculations();
        if (legacy.getCForced() != defCalcs.getCForced()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("Forced convection coefficient now set individually for surfaces."), String.format(Intl.intl("%s=%.3f dropped from MISC record."), "C_FORCED", legacy.getCForced())));
        }
        if (legacy.getCHorizontal() != defCalcs.getCHorizontal()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("Horizontal convection coefficient now set individually for surfaces."), String.format(Intl.intl("%s=%.3f dropped from MISC record."), "C_HORIZONTAL", legacy.getCHorizontal())));
        }
        if (legacy.getCVertical() != defCalcs.getCVertical()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("Vertical convection coefficient now set individually for surfaces."), String.format(Intl.intl("%s=%.3f dropped from MISC record."), "C_VERTICAL", legacy.getCVertical())));
        }
    }

    private void fromLegacySPEnv(SimParams.Environment legacy, SimParams.Environment newEnv) {
        newEnv.setRelHumidity(new UnitDouble(legacy.getRelHumidity(), NonSI.PERCENT));
        newEnv.setAmbTemp(ConvertUtil.c(legacy.getAmbTemp()));
        newEnv.setAmbPressure(ConvertUtil.c(legacy.getAmbPressure()));
        newEnv.setGravityAccel(this.fromLegacyVariant(legacy.getGravityX(), newEnv.getGravityX()), this.fromLegacyVariant(legacy.getGravityY(), newEnv.getGravityY()), this.fromLegacyVariant(legacy.getGravityZ(), newEnv.getGravityZ()));
    }

    private Variant fromLegacyVariant(pyrosim.legacy_2012_1.domain.Variant legacy, Variant newVar) {
        if (legacy instanceof Variant.UnitDoubleVar) {
            newVar = Variant.constant(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)legacy.val));
        } else if (legacy instanceof Variant.DefaultVar) {
            newVar = Variant.DEFAULT;
        } else if (legacy instanceof Variant.RampVar) {
            Variant.RampVar rampVar = (Variant.RampVar)legacy;
            newVar = Variant.ramp(this.fromLegacyRamp((Ramp)rampVar.val));
        }
        return newVar;
    }

    private void fromLegacySPRad(SimParams.RadiationTransport legacy, SimParams.RadiationTransport newRad) {
        newRad.setRadiationOn(legacy.isRadiationOn());
        newRad.setAngleIncrement(legacy.getAngleIncrement());
        if (legacy.isIncludeExtraFuelBands()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports CH4_BANDS parameter in the MISC namelist."), Intl.intl("Use Additional Fuel Bands dropped from MISC record.")));
        }
        UnitDouble absorptionCoeff = ConvertUtil.c(this.d_warnings, Intl.intl("Radiation Absorption Coefficient"), 13, legacy.getConstAbsorptionCoef());
        newRad.setConstAbsorptionCoef(absorptionCoeff);
        newRad.setNumPolarAngles(legacy.getNumPolarAngles());
        newRad.setNumSolidAngles(legacy.getNumSolidAngles());
        newRad.setRadCalcPathLen(ConvertUtil.c(legacy.getRadCalcPathLen()));
        newRad.setRadiativeLossFraction(legacy.getRadiativeLossFraction());
        newRad.setAssumedRadSourceTemp(ConvertUtil.c(legacy.getAssumedRadSourceTemp()));
        newRad.setTimeStepInc(legacy.getTimeStepInc());
        newRad.setNonGrayGasAssumption(legacy.isNonGrayGasAssumption());
    }

    private void fromLegacySPFile(SimParams.FileOutput legacy, SimParams.FileOutput newOut) {
        newOut.setLimitCSVColumns(legacy.isLimitCSVColumns());
        newOut.setDtBoundaryFile(ConvertUtil.c(legacy.getDtBoundaryFile()));
        newOut.setDtDeviceFiles(ConvertUtil.c(legacy.getDtDeviceFiles()));
        newOut.setDtHeatReleaseRateFiles(ConvertUtil.c(legacy.getDtHeatReleaseRateFiles()));
        newOut.setDtIsofFiles(ConvertUtil.c(legacy.getDtIsofFiles()));
        newOut.setDtParticleFiles(ConvertUtil.c(legacy.getDtParticleFiles()));
        newOut.setDtRestartFile(ConvertUtil.c(legacy.getDtRestartFile()));
        newOut.setDtSliceFiles(ConvertUtil.c(legacy.getDtSliceFiles()));
        newOut.setDtMassFiles(ConvertUtil.c(legacy.getDtMassFiles()));
        newOut.setDtPlot3dFile(ConvertUtil.c(legacy.getDtPlot3dFile()));
        newOut.setDtProfileDumpInterval(ConvertUtil.c(legacy.getDtProfileDumpInterval()));
        newOut.setNumOutputFrames(legacy.getNumOutputFrames());
        newOut.setVisualize3dSmoke(legacy.isVisualize3dSmoke());
        newOut.setWriteSpeciesMassFile(legacy.isWriteSpeciesMassFile());
    }

    private void fromLegacySPPart(SimParams.Particles legacy, SimParams.Particles newPart) {
        newPart.setPourousFloor(legacy.isPourousFloor());
        newPart.setAllowUndersideDroplets(legacy.getAllowUndersideDroplets());
        newPart.setMaxParticlesPerMesh(legacy.getMaxParticlesPerMesh());
    }

    private void setBGSpec(pyrosim.domain.ExSpecList exSpecList, String specName) {
        pyrosim.domain.ExSpec bgSpec = exSpecList.get(specName);
        if (bgSpec == null) {
            if (pyrosim.domain.ExSpecList.isPredefinedSpecies(specName)) {
                if (specName.equals(ExSpecList.Predefined.AIR.getName())) {
                    return;
                }
                exSpecList.add(new pyrosim.domain.ExSpec(pyrosim.domain.ExSpecList.getPredefinedSpecies(specName)));
                bgSpec = exSpecList.get(specName);
            } else {
                return;
            }
        }
        pyrosim.domain.CustomFDSProps bgProps = bgSpec.getCustomFDSProps();
        HashMap<String, String> newProp = new HashMap<String, String>();
        FDSRecordSpec specSpec = FDS6Const.getRecordSpecs().get("SPEC");
        FDSRenderProps renderProps = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
        this.addPropIfNotDefault(newProp, renderProps, specSpec, "BACKGROUND", true);
        bgSpec.setCustomFDSProps(pyrosim.domain.CustomFDSProps.union(bgProps, pyrosim.domain.CustomFDSProps.get(newProp)));
        this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports the BACKGROUND parameter in the SPEC namelist."), String.format(Intl.intl("%s moved to %s Advanced Parameters."), "BACKGROUND", specName)));
    }

    private void fromLegacySPWind(SimParams.Environment legacyEnv, SimParams.Wind newWind) {
        SimParams.Environment defEnv = new SimParams.Environment();
        newWind.set(SimParams.Wind.GROUND_LEVEL, ConvertUtil.c(legacyEnv.getGroundLevel()));
        if (!defEnv.getAmbVel().equals(legacyEnv.getAmbVel())) {
            UnitPoint3D legVel = ConvertUtil.c(legacyEnv.getAmbVel());
            newWind.set(SimParams.Wind.INITSPEEDOPT, SimParams.Wind.InitSpeedOptions.UV);
            newWind.set(SimParams.Wind.U0, legVel.xu());
            newWind.set(SimParams.Wind.V0, legVel.yu());
            newWind.set(SimParams.Wind.W0, legVel.zu());
        }
        if (legacyEnv.getAtmLapseRate() != null) {
            newWind.set(SimParams.Wind.LAPSE_RATE, ConvertUtil.c(legacyEnv.getAtmLapseRate()));
        }
    }

    private void fromLegacySPMisc(SimParams.Misc legacy, SimParams.Misc newMisc, pyrosim.domain.ExSpecList exSpecList) {
        String bgSpecName = legacy.getBackgroundSpecies();
        this.setBGSpec(exSpecList, bgSpecName);
        try {
            this.registerForDelayLoad(newMisc, SimParams.Misc.class.getDeclaredField("d_surfDefault"), legacy.getSurfDefault());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        newMisc.setTextureOrigin(ConvertUtil.c(legacy.getTextureOrigin()));
        if (legacy.predictCOProd()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("CO Production now handled by finite element reactions."), Intl.intl("CO Production dropped from MISC record.")));
        }
        for (Map.Entry<String, Object> entry : legacy.getEvacProps().entrySet()) {
            if (entry.getValue() instanceof pyrosim.legacy_2012_1.domain.boundcond.surf.Surface) {
                String key = entry.getKey();
                pyrosim.legacy_2012_1.domain.boundcond.surf.Surface oldSurf = (pyrosim.legacy_2012_1.domain.boundcond.surf.Surface)entry.getValue();
                DelayedRef ref = this.d_delayLoadMap.get(oldSurf);
                if (ref == null) {
                    this.d_warnings.addWarning(new Warning(Intl.intl("SURF: Problem converting field EVAC_DEFAULT."), Intl.intl("Surface INERT set as default.")));
                    continue;
                }
                Surface newSurf = (Surface)ref.get();
                newMisc.setEvacProp(key, newSurf);
                continue;
            }
            newMisc.setEvacProp(entry.getKey(), entry.getValue());
        }
    }

    private ModelComposite fromLegacyModelComp(pyrosim.legacy_2012_1.domain.geom.ModelComposite legacy, ModelComposite newComp) {
        newComp.setName(legacy.getName());
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.geom.ModelComposite oldSubComp = (pyrosim.legacy_2012_1.domain.geom.ModelComposite)legObj;
                ModelComposite newSubComp = new ModelComposite(oldSubComp.getName());
                newComp.add(this.fromLegacyModelComp(oldSubComp, newSubComp));
                continue;
            }
            IModelObj legGeom = (IModelObj)legObj;
            pyrosim.domain.geom.IModelObj convertedComp = this.fromLegacyModelObj(legGeom);
            assert (convertedComp != null);
            if (convertedComp != null) {
                newComp.add(convertedComp);
                continue;
            }
            this.addUnableToLoadWarn(legGeom.getName(), Intl.intl("geometry object"));
        }
        return newComp;
    }

    private pyrosim.domain.geom.IModelObj fromLegacyModelObj(IModelObj legacy) {
        pyrosim.domain.NamedPyroObject newObj = null;
        if (legacy instanceof GenericGeomSrc) {
            GenericGeomSrc geom = (GenericGeomSrc)legacy;
            newObj = new pyrosim.domain.geom.GenericGeomSrc(geom.getName(), this.fromLegacyNode(geom.getGeom(), geom.getTexCoordGen()), this.fromLegacyProp(geom.getDisplayProps()));
        } else if (legacy instanceof pyrosim.legacy_2012_1.domain.geom.Hole) {
            pyrosim.legacy_2012_1.domain.geom.Hole hole = (pyrosim.legacy_2012_1.domain.geom.Hole)legacy;
            newObj = new Hole(hole.getName(), this.fromLegacyNode(hole.getGeom()));
            this.setFDSObjectProps(hole, (pyrosim.domain.geom.FDSObject)((Object)newObj));
        } else if (legacy instanceof Obstruction) {
            Obstruction obst = (Obstruction)legacy;
            ArrayList<Surface> newSurfs = new ArrayList<Surface>();
            for (pyrosim.legacy_2012_1.domain.boundcond.surf.Surface oldSurf : obst.getSurfaces()) {
                newSurfs.add((Surface)this.d_delayLoadMap.get(oldSurf).get());
            }
            Surface[] newSurfArray = newSurfs.toArray(new Surface[newSurfs.size()]);
            pyrosim.domain.geom.Obstruction newObst = new pyrosim.domain.geom.Obstruction(obst.getName(), this.fromLegacyNode(obst.getGeom()), newSurfArray);
            newObst.setBulkDensity(ConvertUtil.c(obst.getBulkDensity()));
            newObst.setOptions(253, false);
            if ((obst.getSetOptions() & 2) != 0) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Smooth surfaces."), String.format(Intl.intl("Smooth option removed from obstruction, %s."), obst.getName())));
            }
            newObst.setOptions(obst.getSetOptions() & 0xFFFFFFFD, true);
            newObj = newObst;
            this.setFDSObjectProps(obst, (pyrosim.domain.geom.FDSObject)((Object)newObj));
        } else if (legacy instanceof pyrosim.legacy_2012_1.domain.geom.InitRegion) {
            pyrosim.legacy_2012_1.domain.geom.InitRegion init = (pyrosim.legacy_2012_1.domain.geom.InitRegion)legacy;
            newObj = new InitRegion(init.getName(), (AABoxGeom)this.fromLegacyNode(init.getGeom()).flatten().getLocalGeom());
            ((InitRegion)newObj).setDensity(ConvertUtil.c(init.getDensity()));
            ((InitRegion)newObj).setTemperature(ConvertUtil.c(init.getTemperature()));
            this.d_initRegions.put(init, (InitRegion)newObj);
            this.setFDSObjectProps(init, (pyrosim.domain.geom.FDSObject)((Object)newObj));
        } else if (legacy instanceof pyrosim.legacy_2012_1.domain.geom.PartCloud) {
            pyrosim.legacy_2012_1.domain.geom.PartCloud cloud = (pyrosim.legacy_2012_1.domain.geom.PartCloud)legacy;
            PartCloud newPC = new PartCloud(cloud.getName(), null, (AABoxGeom)this.fromLegacyNode(cloud.getGeom()).flatten().getLocalGeom());
            newObj = newPC;
            newPC.setInitDrops(this.fromLegacyPCDropCount(cloud.getInitDrops()));
            newPC.setInsertion(this.fromLegacyPCInsert(cloud.getInsertion()));
            if (cloud.isStatic()) {
                this.d_staticPartClouds.add(newPC);
            }
            try {
                this.registerForDelayLoad(newObj, PartCloud.class.getDeclaredField("d_particle"), cloud.getParticle());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            this.setFDSObjectProps(cloud, (pyrosim.domain.geom.FDSObject)((Object)newObj));
        } else if (legacy instanceof pyrosim.legacy_2012_1.domain.geom.Vent) {
            pyrosim.legacy_2012_1.domain.geom.Vent vent = (pyrosim.legacy_2012_1.domain.geom.Vent)legacy;
            Vent.VentGeom vg = vent.getGeom();
            AARectangle geom = new AARectangle(vg.d_plane, vg.d_planeVal, vg.d_minx, vg.d_miny, vg.d_maxx, vg.d_maxy, false);
            UnitPoint3D centerPoint = null;
            UnitDouble spreadRate = null;
            if (vent.getFireSpread() != null) {
                centerPoint = vent.getFireSpread().d_source.fromLegacy(this.d_dictionary);
                spreadRate = vent.getFireSpread().d_spreadRate.fromLegacy(this.d_dictionary);
            }
            newObj = new Vent(vent.getName(), null, geom, spreadRate, centerPoint);
            try {
                this.registerForDelayLoad(newObj, Vent.class.getDeclaredField("d_surf"), vent.getSurface());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            if (vent.getOpenProps() != null) {
                if (!vent.getOpenProps().species.isEmpty()) {
                    this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Open Vent Species Mixture Fractions."), String.format(Intl.intl("%s dropped from Vent %s."), "MASS_FRACTION", vent.getName())));
                }
                ((Vent)newObj).setOpenProps(new Vent.OpenProps(ConvertUtil.c(vent.getOpenProps().temp), this.fromLegacyTBV(vent.getOpenProps().pressure)));
            }
            this.setFDSObjectProps(vent, (pyrosim.domain.geom.FDSObject)((Object)newObj));
        }
        if (legacy instanceof AFDSObject) {
            this.addToConnectionsMap(newObj, legacy);
        }
        if (newObj != null) {
            newObj.setVisible(legacy.isVisible());
            newObj.setEnabled(legacy.isEnabled());
            this.makeAvailableForDelayLoad(newObj, legacy);
        }
        return newObj;
    }

    private PartCloud.IDropletCount fromLegacyPCDropCount(PartCloud.IDropletCount count) {
        if (count instanceof PartCloud.ConstDropletCount) {
            PartCloud.ConstDropletCount cdc = (PartCloud.ConstDropletCount)count;
            return new PartCloud.ConstDropletCount(cdc.d_dropCount);
        }
        assert (count instanceof PartCloud.DropDensityCount);
        PartCloud.DropDensityCount ddc = (PartCloud.DropDensityCount)count;
        return new PartCloud.DropDensityCount(ConvertUtil.c(ddc.d_density));
    }

    private PartCloud.IInsertion fromLegacyPCInsert(PartCloud.IInsertion insertion) {
        if (insertion instanceof PartCloud.InsertOnce) {
            PartCloud.InsertOnce ionce = (PartCloud.InsertOnce)insertion;
            return new PartCloud.InsertOnce(ConvertUtil.c(ionce.massPerVolume));
        }
        assert (insertion instanceof PartCloud.InsertPeriodically);
        PartCloud.InsertPeriodically iper = (PartCloud.InsertPeriodically)insertion;
        return new PartCloud.InsertPeriodically(ConvertUtil.c(iper.dt), ConvertUtil.c(iper.massPerTime));
    }

    private void setFDSObjectProps(FDSObject legacy, pyrosim.domain.geom.FDSObject newObj) {
        newObj.setColors(legacy.getColors());
        newObj.setEvac(EvacProps.get(legacy.getEvac().evacuation, (Grid)this.d_delayLoadMap.get(legacy.getEvac().mesh).get()));
    }

    private pyrosim.domain.GridList fromLegacyGridList(GridList legacy, pyrosim.domain.GridList newGridList) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                GridList oldSubComp = (GridList)legObj;
                pyrosim.domain.GridList newSubComp = new pyrosim.domain.GridList(oldSubComp.getName());
                newGridList.add(this.fromLegacyGridList(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.Grid legGrid = (pyrosim.legacy_2012_1.domain.Grid)legObj;
            Grid convertedGrid = this.fromLegacyGrid(legGrid);
            assert (convertedGrid != null);
            if (convertedGrid != null) {
                newGridList.add(convertedGrid);
                continue;
            }
            this.addUnableToLoadWarn(legGrid.getName(), Intl.intl("mesh"));
        }
        return newGridList;
    }

    public Grid fromLegacyGrid(pyrosim.legacy_2012_1.domain.Grid legacy) {
        if (legacy == null) {
            return null;
        }
        Grid newGrid = new Grid(legacy.getName(), ConvertUtil.c(legacy.getMinPoint()), ConvertUtil.c(legacy.getMaxPoint()), ConvertUtil.c(legacy.getXDivisions()), ConvertUtil.c(legacy.getYDivisions()), ConvertUtil.c(legacy.getZDivisions()));
        newGrid.setFYI(legacy.getFYI());
        if (legacy.getColor() != null) {
            newGrid.setColor(new Color(legacy.getColor().getRed(), legacy.getColor().getGreen(), legacy.getColor().getBlue(), 255));
            if (legacy.getColor().getAlpha() < 255) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports transparency for MESHES."), String.format(Intl.intl("Parameter Alpha dropped from MESH %s"), legacy.getName())));
            }
        }
        newGrid.setSyncTimeStep(legacy.syncTimeStep());
        newGrid.setVisible(true);
        newGrid.setEvacuation(legacy.getEvacuation());
        newGrid.setEvacHumans(legacy.getEvacHumans());
        newGrid.setEvacZOffset(ConvertUtil.c(legacy.getEvacZOffset()));
        this.makeAvailableForDelayLoad(newGrid, legacy);
        return newGrid;
    }

    private pyrosim.domain.zones.ZoneMgr fromLegacyZoneMgr(ZoneMgr legacy, pyrosim.domain.zones.ZoneMgr newMgr) {
        this.makeAvailableForDelayLoad(newMgr.getOuter(), legacy.getOuter());
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                ZoneMgr oldSubComp = (ZoneMgr)legObj;
                pyrosim.domain.zones.ZoneMgr newSubComp = new pyrosim.domain.zones.ZoneMgr(oldSubComp.getName());
                newMgr.add(this.fromLegacyZoneMgr(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.zones.Zone oldZone = (pyrosim.legacy_2012_1.domain.zones.Zone)legObj;
            if (oldZone.isOuter()) continue;
            Zone convertedZone = this.fromLegacyZone(oldZone);
            assert (convertedZone != null);
            if (convertedZone != null) {
                newMgr.add(convertedZone);
                continue;
            }
            this.addUnableToLoadWarn(oldZone.getName(), Intl.intl("zone"));
        }
        return newMgr;
    }

    private Zone fromLegacyZone(pyrosim.legacy_2012_1.domain.zones.Zone legacy) {
        if (legacy == null) {
            return null;
        }
        if (this.d_delayLoadMap.containsKey(legacy)) {
            return (Zone)this.d_delayLoadMap.get(legacy).get();
        }
        UnitAABox zoneBounds = ConvertUtil.c(legacy.getBox());
        Point3d min = zoneBounds.getMin(Geometry.LU);
        Point3d max = zoneBounds.getMax(Geometry.LU);
        Point newGeom = new Point(new Point3d((min.x + max.x) / 2.0, (min.y + max.y) / 2.0, (min.z + max.z) / 2.0));
        Zone newZone = new Zone(legacy.getName(), newGeom);
        newZone.setVisible(legacy.isVisible());
        newZone.setColor(legacy.getColor());
        this.makeAvailableForDelayLoad(newZone, legacy);
        return newZone;
    }

    private BridgeList fromLegacyBridgeList(LeakMgr legacy, BridgeList newMgr) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof LeakMgr) {
                LeakMgr oldSubComp = (LeakMgr)legObj;
                BridgeList newSubComp = new BridgeList(oldSubComp.getName());
                newMgr.add(this.fromLegacyBridgeList(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.zones.Leak legLeak = (pyrosim.legacy_2012_1.domain.zones.Leak)legObj;
            Leak convertedLeak = this.fromLegacyLeak(legLeak);
            assert (convertedLeak != null);
            newMgr.add(convertedLeak);
        }
        assert (legacy.flatten().size() == newMgr.flatten().size());
        return newMgr;
    }

    private Leak fromLegacyLeak(pyrosim.legacy_2012_1.domain.zones.Leak legacy) {
        Leak newLeak = new Leak(null, null, ConvertUtil.c(legacy.area));
        try {
            this.registerForDelayLoad(newLeak, Leak.class.getDeclaredField("zone1"), legacy.zone1);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        try {
            this.registerForDelayLoad(newLeak, Leak.class.getDeclaredField("zone2"), legacy.zone2);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        this.addToConnectionsMap(newLeak, legacy);
        return newLeak;
    }

    private FloorManager fromLegacyFloorMgr(pyrosim.legacy_2012_1.domain.FloorManager legacy, FloorManager newMgr) {
        newMgr.clear();
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.FloorManager oldSubComp = (pyrosim.legacy_2012_1.domain.FloorManager)legObj;
                FloorManager newSubComp = new FloorManager(oldSubComp.getName());
                newMgr.add(this.fromLegacyFloorMgr(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.Floor legFloor = (pyrosim.legacy_2012_1.domain.Floor)legObj;
            Floor convertedFloor = this.fromLegacyFloor(legFloor);
            assert (convertedFloor != null);
            if (convertedFloor != null) {
                newMgr.add(convertedFloor);
                continue;
            }
            this.addUnableToLoadWarn(legFloor.getName(), Intl.intl("floor"));
        }
        return newMgr;
    }

    private Floor fromLegacyFloor(pyrosim.legacy_2012_1.domain.Floor legacy) {
        Floor newFloor = new Floor(legacy.getName(), ConvertUtil.c(legacy.getElevation()), ConvertUtil.c(legacy.getSlabThickness()), ConvertUtil.c(legacy.getWallHeight()), this.fromLegacyImg(legacy.getBgImage()), Floor.DEFAULT_COLOR);
        return newFloor;
    }

    private pyrosim.domain.ModelImage fromLegacyImg(ModelImage legacy) {
        return legacy != null ? new pyrosim.domain.ModelImage(this.fromLegacyImage(legacy.getImage()), ConvertUtil.c(legacy.getLWTransform()), legacy.getOpacity()) : null;
    }

    private ParticleList fromLegacyPartList(pyrosim.legacy_2012_1.domain.particle.ParticleList legacy, ParticleList newList, pyrosim.domain.ExSpecList specList) {
        pyrosim.legacy_2012_1.domain.particle.ParticleList legDefList = new pyrosim.legacy_2012_1.domain.particle.ParticleList();
        legDefList.addDefaults();
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.particle.ParticleList oldSubComp = (pyrosim.legacy_2012_1.domain.particle.ParticleList)legObj;
                ParticleList newSubComp = new ParticleList(oldSubComp.getName());
                newList.add(this.fromLegacyPartList(oldSubComp, newSubComp, specList));
                continue;
            }
            pyrosim.legacy_2012_1.domain.particle.Particle legPart = (pyrosim.legacy_2012_1.domain.particle.Particle)legObj;
            Particle newPart = this.fromLegacyParticle(legPart, newList, specList);
            assert (newPart != null);
            if (newPart != null) {
                newList.add(newPart);
                continue;
            }
            this.addUnableToLoadWarn(legPart.getName(), Intl.intl("particle"));
        }
        return newList;
    }

    private Particle fromLegacyParticle(pyrosim.legacy_2012_1.domain.particle.Particle legacy, ParticleList partList, pyrosim.domain.ExSpecList specList) {
        Output output = new Output(ConvertUtil.c(legacy.getDescription().getOutput().d_age), legacy.getDescription().getOutput().d_samplingFactor);
        IColoring coloring = this.createColoringFromLegacyPartDesc(legacy.getDescription());
        Particle newPart = new Particle(legacy.getName(), Particle.Type.LIQUID, output, coloring);
        this.setTypeFromLegacyPartDesc(legacy.getDescription(), newPart);
        pyrosim.domain.ExSpec partSpec = this.createSpeciesFromLegacyPartDesc(legacy, legacy.getDescription());
        if (partSpec != null) {
            specList.add(partSpec);
            newPart.setSpecies(partSpec);
        }
        pyrosim.domain.CustomFDSProps newCustomProps = pyrosim.domain.CustomFDSProps.get(this.convertDataFromLegacyPartDesc(legacy.getDescription(), newPart));
        newPart.setCustomFDSProps(pyrosim.domain.CustomFDSProps.union(this.fromLegacyCustomFDS(legacy.getCustomFDSProps()), newCustomProps));
        newPart.setFYI(legacy.getFYI());
        String partName = newPart.getName();
        Particle nameStealer = (Particle)partList.get(partName);
        if (nameStealer != null) {
            nameStealer.setName(partName + "_1");
        }
        this.makeAvailableForDelayLoad(newPart, legacy);
        return newPart;
    }

    private void setSizeDistFromLegacyPartSize(SizeDistribution sizeDist, Particle newPart) {
        newPart.setDiameter(ConvertUtil.c(sizeDist.d_medianDiameter));
        if (sizeDist.d_type instanceof SizeDistribution.RosinRammler) {
            SizeDistribution.RosinRammler rosin = (SizeDistribution.RosinRammler)sizeDist.d_type;
            newPart.setGammaD(rosin.d_gammaD);
            newPart.setMinDiameter(ConvertUtil.c(rosin.d_minDiameter));
            newPart.setMaxDiameter(ConvertUtil.c(rosin.d_maxDiameter));
            if (rosin.d_sigma != null) {
                newPart.setSigmaD(rosin.d_sigma);
            }
            newPart.setDistribution(Particle.Distribution.ROSIN);
        } else {
            newPart.setDistribution(Particle.Distribution.CONST);
        }
    }

    private void setTypeFromLegacyPartDesc(IParticleDesc desc, Particle newPart) {
        if (desc instanceof FuelPartDesc) {
            newPart.setType(Particle.Type.LIQUID);
            this.setSizeDistFromLegacyPartSize(((FuelPartDesc)desc).d_sizeDist, newPart);
        } else if (desc instanceof TracerPartDesc) {
            newPart.setType(Particle.Type.TRACER);
        } else if (desc instanceof WaterPartDesc) {
            newPart.setType(Particle.Type.LIQUID);
            this.setSizeDistFromLegacyPartSize(((WaterPartDesc)desc).d_sizeDist, newPart);
        } else if (desc instanceof GenericPartDesc) {
            newPart.setType(Particle.Type.LIQUID);
            this.setSizeDistFromLegacyPartSize(((GenericPartDesc)desc).d_sizeDist, newPart);
        } else {
            throw new RuntimeException("Unknown particle description class: " + desc.getClass().getName());
        }
    }

    private Map<String, String> convertDataFromLegacyPartDesc(IParticleDesc desc, Particle newPart) {
        FDSRenderProps renderProps;
        HashMap<String, String> advancedParams = new HashMap<String, String>();
        FDSRecordSpec partSpec = FDS6Const.getRecordSpecs().get("PART");
        FDSRenderProps fDSRenderProps = renderProps = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
        if (desc instanceof TracerPartDesc) {
            return advancedParams;
        }
        GenericPartDesc genericDesc = (GenericPartDesc)desc;
        if (genericDesc.d_thermalProps.d_initTemp != null) {
            this.addPropIfNotDefault(advancedParams, renderProps, partSpec, "INITIAL_TEMPERATURE", ConvertUtil.c(genericDesc.d_thermalProps.d_initTemp));
        }
        if (genericDesc instanceof FuelPartDesc) {
            FuelPartDesc fuelDesc = (FuelPartDesc)desc;
            UnitDouble hoc = ConvertUtil.c(((FuelPyrolysis)fuelDesc.d_pyrolysis).d_heatOfCombustion);
            this.addPropIfNotDefault(advancedParams, renderProps, partSpec, "HEAT_OF_COMBUSTION", hoc);
        }
        return advancedParams;
    }

    private void convertDataFromLegacySizeDist(pyrosim.legacy_2012_1.domain.particle.Particle legPart, Particle newPart) {
        IParticleDesc desc = legPart.getDescription();
        SizeDistribution sizeDistro = null;
        if (desc instanceof FuelPartDesc) {
            FuelPartDesc fuelDesc = (FuelPartDesc)desc;
            sizeDistro = fuelDesc.d_sizeDist;
        } else if (desc instanceof WaterPartDesc) {
            WaterPartDesc waterDesc = (WaterPartDesc)desc;
            sizeDistro = waterDesc.d_sizeDist;
        } else if (desc instanceof GenericPartDesc) {
            GenericPartDesc genericDesc = (GenericPartDesc)desc;
            sizeDistro = genericDesc.d_sizeDist;
        }
        if (sizeDistro == null) {
            return;
        }
        newPart.setDiameter(ConvertUtil.c(sizeDistro.d_medianDiameter));
        if (sizeDistro.d_type instanceof SizeDistribution.Constant) {
            newPart.setDistribution(Particle.Distribution.CONST);
            return;
        }
        SizeDistribution.RosinRammler rosRam = (SizeDistribution.RosinRammler)sizeDistro.d_type;
        newPart.setMaxDiameter(ConvertUtil.c(rosRam.d_maxDiameter));
        newPart.setMinDiameter(ConvertUtil.c(rosRam.d_minDiameter));
        newPart.setGammaD(rosRam.d_gammaD);
        newPart.setSigmaD(rosRam.d_sigma);
        newPart.setDistribution(Particle.Distribution.ROSIN);
    }

    private pyrosim.domain.ExSpec createSpeciesFromLegacyPartDesc(pyrosim.legacy_2012_1.domain.particle.Particle legacyPart, IParticleDesc desc) {
        if (desc instanceof FuelPartDesc) {
            FuelPartDesc fuel = (FuelPartDesc)desc;
            pyrosim.domain.ExSpec specData = new pyrosim.domain.ExSpec(legacyPart.getName() + "_SPEC", 1);
            this.setSpeciesParamsFromLegacyParticle(legacyPart, specData, fuel.d_thermalProps, fuel.d_pyrolysis, fuel.d_sizeDist);
            return specData;
        }
        if (desc instanceof TracerPartDesc) {
            return null;
        }
        if (desc instanceof WaterPartDesc) {
            WaterPartDesc water = (WaterPartDesc)desc;
            pyrosim.domain.ExSpec specData = new pyrosim.domain.ExSpec(legacyPart.getName() + "_SPEC", 1);
            this.setSpeciesParamsFromLegacyParticle(legacyPart, specData, water.d_thermalProps, water.d_pyrolysis, water.d_sizeDist);
            return specData;
        }
        if (desc instanceof GenericPartDesc) {
            GenericPartDesc generic = (GenericPartDesc)desc;
            pyrosim.domain.ExSpec specData = new pyrosim.domain.ExSpec(legacyPart.getName() + "_SPEC", 1);
            this.setSpeciesParamsFromLegacyParticle(legacyPart, specData, generic.d_thermalProps, generic.d_pyrolysis, generic.d_sizeDist);
            return specData;
        }
        throw new RuntimeException("Unknown particle description class: " + desc.getClass().getName());
    }

    private void setSpeciesParamsFromLegacyParticle(pyrosim.legacy_2012_1.domain.particle.Particle parent, pyrosim.domain.ExSpec destSpecies, ThermalProps thermalProps, Pyrolysis pyrolysis, SizeDistribution sizeDist) {
        ExSpec.PrimitiveParams params = destSpecies.getPrimParams();
        params.setMeltingTemp(ConvertUtil.c(pyrolysis.d_meltingTemp));
        if (pyrolysis.evaporates()) {
            params.setVapTemp(ConvertUtil.c(pyrolysis.d_vapTemp));
            params.setHoVaporization(ConvertUtil.c(pyrolysis.d_heatOfVap));
            if (pyrolysis.getVaporizationSpecies() != null) {
                this.d_warnings.addWarning(new Warning(Intl.intl("No FDS6 equivalent exists for Particle Vaporization Species."), String.format(Intl.intl("Vaporization Species dropped from Particle %s."), parent.getName())));
            }
        }
        params.setDensityLiquid(ConvertUtil.c(thermalProps.d_density));
        params.setSpecHeatLiquid(Variant.constant(ConvertUtil.c(thermalProps.d_specificHeat)));
        params.setMeanDiameter(ConvertUtil.c(sizeDist.d_medianDiameter));
    }

    private IColoring createColoringFromLegacyPartDesc(IParticleDesc desc) {
        if (desc instanceof FuelPartDesc) {
            FuelPartDesc fuel = (FuelPartDesc)desc;
            if (fuel.d_coloring == null) {
                return new pyrosim.domain.particle.ConstColoring(Color.YELLOW);
            }
            return this.fromLegacyIColor(fuel.d_coloring);
        }
        if (desc instanceof TracerPartDesc) {
            TracerPartDesc tracer = (TracerPartDesc)desc;
            return new pyrosim.domain.particle.ConstColoring(tracer.d_color);
        }
        if (desc instanceof WaterPartDesc) {
            WaterPartDesc water = (WaterPartDesc)desc;
            if (water.d_coloring == null) {
                return new pyrosim.domain.particle.ConstColoring(Color.BLUE);
            }
            return this.fromLegacyIColor(water.d_coloring);
        }
        if (desc instanceof GenericPartDesc) {
            GenericPartDesc generic = (GenericPartDesc)desc;
            if (generic.d_coloring == null) {
                return new pyrosim.domain.particle.ConstColoring(Color.YELLOW);
            }
            return this.fromLegacyIColor(generic.d_coloring);
        }
        throw new RuntimeException("Unknown particle description class: " + desc.getClass().getName());
    }

    private void addPropIfNotDefault(Map<String, String> props, FDSRenderProps renderProps, FDSRecordSpec spec, String paramName, Object value) {
        if (!spec.isDefault(paramName, value)) {
            Pair<String, String> fdsStrings = spec.renderField(renderProps, paramName, value);
            props.put((String)fdsStrings.v1, (String)fdsStrings.v2);
        }
    }

    private pyrosim.domain.CustomFDSProps fromLegacyCustomFDS(CustomFDSProps legacy) {
        return pyrosim.domain.CustomFDSProps.get(legacy.getProps());
    }

    private IColoring fromLegacyIColor(pyrosim.legacy_2012_1.domain.particle.IColoring legacy) {
        if (legacy == null) {
            return new pyrosim.domain.particle.ConstColoring(Color.YELLOW);
        }
        if (legacy instanceof ConstColoring) {
            return new pyrosim.domain.particle.ConstColoring(((ConstColoring)legacy).d_color);
        }
        return new DropletColoring(((pyrosim.legacy_2012_1.domain.particle.DropletColoring)legacy).d_properties);
    }

    private MaterialManager fromLegacyMatMgr(pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager legacy, MaterialManager newMgr) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager oldSubComp = (pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager)legObj;
                MaterialManager newSubComp = new MaterialManager(oldSubComp.getName());
                newMgr.add(this.fromLegacyMatMgr(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.boundcond.mat.Material legMat = (pyrosim.legacy_2012_1.domain.boundcond.mat.Material)legObj;
            Material convertedMaterial = this.fromLegacyMatl(legMat);
            assert (convertedMaterial != null);
            if (convertedMaterial != null) {
                newMgr.add(convertedMaterial);
                continue;
            }
            this.addUnableToLoadWarn(legMat.getName(), Intl.intl("material"));
        }
        return newMgr;
    }

    private Material fromLegacyMatl(pyrosim.legacy_2012_1.domain.boundcond.mat.Material legacy) {
        Material newMat = new Material(legacy.getName(), this.fromLegacyPyrolysis(legacy.getPyrolysis()), this.fromLegacyMatlThermal(legacy.getThermalProps()));
        newMat.setFYI(legacy.getFYI());
        this.makeAvailableForDelayLoad(newMat, legacy);
        pyrosim.domain.CustomFDSProps props = this.fromLegacyCustomFDS(legacy.getCustomFDSProps());
        if (legacy.getPyrolysis() instanceof pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis) {
            UnitDouble vapFlux = ConvertUtil.c(((pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis)legacy.getPyrolysis()).d_iniVaporFlux);
            HashMap<String, String> newPropsMap = new HashMap<String, String>();
            newPropsMap.put("INITIAL_VAPOR_FLUX", Double.toString(vapFlux.getValue(SIUS.unit(73))));
            props = pyrosim.domain.CustomFDSProps.union(props, pyrosim.domain.CustomFDSProps.get(newPropsMap));
            this.d_warnings.addWarning(new Warning("The variable Initial Vapor Flux is no longer supported.", String.format(Intl.intl("INITIAL_VAPOR_FLUX for material %s moved to Advanced Parameters."), legacy.getName())));
        }
        newMat.setCustomFDSProps(props);
        return newMat;
    }

    private IPyrolysis fromLegacyPyrolysis(pyrosim.legacy_2012_1.domain.boundcond.mat.IPyrolysis legacy) {
        if (legacy instanceof pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis) {
            pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis pyro = (pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis)legacy;
            LiquidReaction reac = pyro.d_reaction;
            return new LiquidPyrolysis(ConvertUtil.c(pyro.d_heatOfCombust), new pyrosim.domain.boundcond.mat.LiquidReaction(new LiquidReaction.Rate(ConvertUtil.c(reac.d_rate.d_boilingTemp)), this.fromLegacyMatlReac(reac.d_byproducts)));
        }
        SolidPyrolysis pyro = (SolidPyrolysis)legacy;
        ArrayList<SolidReaction> newReacs = new ArrayList<SolidReaction>();
        for (pyrosim.legacy_2012_1.domain.boundcond.mat.Reaction reaction : pyro.getReactions()) {
            SolidReaction.Rate.ISpecification spec;
            pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction reac = (pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction)reaction;
            if (reac.d_rate.d_spec instanceof SolidReaction.Rate.AESpec) {
                spec = (SolidReaction.Rate.AESpec)reac.d_rate.d_spec;
                newReacs.add(new SolidReaction(new SolidReaction.Rate(reac.d_rate.d_massFracExponent, reac.d_rate.d_tempExponent, ConvertUtil.c(reac.d_rate.d_thresholdTemp), new SolidReaction.Rate.AESpec(ConvertUtil.c(spec.d_a), ConvertUtil.c(spec.d_e))), this.fromLegacyMatlReac(reac.d_byproducts)));
                continue;
            }
            spec = (SolidReaction.Rate.RefSpec)reac.d_rate.d_spec;
            newReacs.add(new SolidReaction(new SolidReaction.Rate(reac.d_rate.d_massFracExponent, reac.d_rate.d_tempExponent, ConvertUtil.c(reac.d_rate.d_thresholdTemp), new SolidReaction.Rate.RefSpec(ConvertUtil.c(((SolidReaction.Rate.RefSpec)spec).d_refTemp), ConvertUtil.c(((SolidReaction.Rate.RefSpec)spec).d_pyrolysisRange), ConvertUtil.c(((SolidReaction.Rate.RefSpec)spec).d_heatingRate))), this.fromLegacyMatlReac(reac.d_byproducts)));
        }
        return new pyrosim.domain.boundcond.mat.SolidPyrolysis(ConvertUtil.c(pyro.d_heatOfCombustion), newReacs);
    }

    private pyrosim.domain.boundcond.mat.ReacByproducts fromLegacyMatlReac(ReacByproducts legacy) {
        if (legacy == null) {
            return null;
        }
        pyrosim.domain.boundcond.mat.ReacByproducts bp = new pyrosim.domain.boundcond.mat.ReacByproducts();
        if (legacy.d_nuWater > 0.0) {
            this.d_matResMap.put(new Pair<pyrosim.domain.boundcond.mat.ReacByproducts, ExSpec>(bp, ExSpecList.getPredefinedSpecies("WATER VAPOR")), new Pair<String, Double>("WATER VAPOR", legacy.d_nuWater));
        }
        if (legacy.d_nuResidue > 0.0) {
            this.d_matResMap.put(new Pair<pyrosim.domain.boundcond.mat.ReacByproducts, pyrosim.legacy_2012_1.domain.boundcond.mat.Material>(bp, legacy.getResidue()), new Pair<String, Double>(legacy.getResidue().getName(), legacy.d_nuResidue));
        }
        if (legacy.d_nuFuel > 0.0) {
            this.d_warnings.addWarning(new Warning(Intl.intl("MATL: NU_FUEL now requires a paired SPEC_ID. "), Intl.intl("Value removed")));
        }
        if (legacy.d_heat != null) {
            bp.d_heat = ConvertUtil.c(legacy.d_heat);
        }
        return bp;
    }

    private pyrosim.domain.boundcond.mat.ThermalProps fromLegacyMatlThermal(pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps legacy) {
        return new pyrosim.domain.boundcond.mat.ThermalProps(this.fromLegacyHBV(legacy.d_conductivity), ConvertUtil.c(legacy.d_density), this.fromLegacyHBV(legacy.d_specificHeat), legacy.d_emissivity, ConvertUtil.c(legacy.d_absorptionCoeff));
    }

    private IHeatBasedValue fromLegacyHBV(pyrosim.legacy_2012_1.domain.IHeatBasedValue legacy) {
        if (legacy instanceof IHeatBasedValue.Constant) {
            return new IHeatBasedValue.Constant(ConvertUtil.c(((IHeatBasedValue.Constant)legacy).value));
        }
        if (legacy instanceof IHeatBasedValue.Custom) {
            return new IHeatBasedValue.Custom(this.fromLegacyRamp(((IHeatBasedValue.Custom)legacy).value));
        }
        return null;
    }

    private pyrosim.domain.ramp.Ramp fromLegacyRamp(Ramp legacy) {
        pyrosim.domain.ramp.IRampInput defInput = this.fromLegacyRampInput(legacy.getDefaultInput());
        pyrosim.domain.ramp.IRampInput input = this.fromLegacyRampInput(legacy.getInput());
        ArrayList<Ramp.Entry> newEntries = new ArrayList<Ramp.Entry>();
        for (Ramp.Entry entry : legacy.getRecords()) {
            newEntries.add(new Ramp.Entry(ConvertUtil.c(entry.t), ConvertUtil.c(entry.f)));
        }
        return new pyrosim.domain.ramp.Ramp(newEntries, defInput, input, legacy.getFUnitType());
    }

    private pyrosim.domain.ramp.IRampInput fromLegacyRampInput(IRampInput legacy) {
        if (legacy instanceof RampInputs.HeatInput) {
            return RampInputs.HEAT;
        }
        if (legacy instanceof RampInputs.PressureInput) {
            return RampInputs.PRESSURE;
        }
        if (legacy instanceof RampInputs.TimeInput) {
            return RampInputs.TIME;
        }
        if (legacy instanceof RampInputs.XPositionInput) {
            return RampInputs.XPOS;
        }
        if (legacy instanceof pyrosim.legacy_2012_1.domain.ramp.SignalInput) {
            return this.fromLegacySignalInput((pyrosim.legacy_2012_1.domain.ramp.SignalInput)legacy);
        }
        return null;
    }

    private SignalInput fromLegacySignalInput(pyrosim.legacy_2012_1.domain.ramp.SignalInput legacy) {
        SignalInput newInp = new SignalInput(null);
        ISignalSource src = legacy.input.getAttachedSource();
        if (src instanceof pyrosim.legacy_2012_1.domain.devices.measurers.Clock) {
            Iterator<? extends IOutPin> iterator = Clock.INSTANCE.getOutputPins().iterator();
            if (iterator.hasNext()) {
                IOutPin pin = iterator.next();
                newInp = new SignalInput((IDoubleOutPin)pin);
            }
        } else {
            this.d_rampSignalInputs.put(newInp, src);
        }
        return newInp;
    }

    private SurfaceManager fromLegacySurfMgr(pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager legacy, SurfaceManager newMgr, boolean isRoot, TextureDB legTexDB, MaterialManager matMan, MaterialDB appearanceDB) {
        Surface periodicSurf = (Surface)newMgr.get(PredefSurf.PERIODIC.toString());
        if (periodicSurf != null) {
            newMgr.remove(periodicSurf);
        }
        if (isRoot) {
            this.makeAvailableForDelayLoad(newMgr.get(PredefSurf.INERT), legacy.get(PredefSurf.INERT.name()));
            this.makeAvailableForDelayLoad(newMgr.get(PredefSurf.OPEN), legacy.get(PredefSurf.OPEN.name()));
            this.makeAvailableForDelayLoad(newMgr.get(PredefSurf.MIRROR), legacy.get(PredefSurf.MIRROR.name()));
            this.makeAvailableForDelayLoad(newMgr.get(PredefSurf.HVAC), legacy.get(PredefSurf.HVAC.name()));
            if (newMgr.get("ADIABATIC") != null && legacy.get("ADIABATIC") != null) {
                this.makeAvailableForDelayLoad(newMgr.get("ADIABATIC"), legacy.get("ADIABATIC"));
            }
        }
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager oldSubComp = (pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager)legObj;
                SurfaceManager newSubComp = new SurfaceManager(oldSubComp.getName());
                newMgr.add(this.fromLegacySurfMgr(oldSubComp, newSubComp, false, legTexDB, matMan, appearanceDB));
                continue;
            }
            pyrosim.legacy_2012_1.domain.boundcond.surf.Surface legSurf = (pyrosim.legacy_2012_1.domain.boundcond.surf.Surface)legObj;
            if (legSurf.getName().equals("ADIABATIC")) {
                Surface adiabatic = (Surface)newMgr.get(Intl.intl("ADIABATIC"));
                if (adiabatic == null) {
                    adiabatic = (Surface)newMgr.get("ADIABATIC");
                }
                adiabatic.setAppearance(this.toMaterial(appearanceDB, legTexDB, legSurf));
                adiabatic.setSurfDesc(this.fromLegacySurfDesc(legSurf.getSurfDesc(), legSurf, matMan));
                adiabatic.setCustomFDSProps(this.fromLegacyCustomFDS(legSurf.getCustomFDSProps()));
                continue;
            }
            if (legSurf.isPredefined()) continue;
            Surface convertedSurface = this.fromLegacySurface(appearanceDB, legTexDB, legSurf, matMan);
            assert (convertedSurface != null);
            if (convertedSurface != null) {
                newMgr.add(convertedSurface);
                continue;
            }
            this.addUnableToLoadWarn(legSurf.getName(), Intl.intl("surface"));
        }
        return newMgr;
    }

    private Surface fromLegacySurface(MaterialDB appearanceDB, TextureDB legTexDB, pyrosim.legacy_2012_1.domain.boundcond.surf.Surface legSurf, MaterialManager matMan) {
        Surface surf = new Surface(legSurf.getName(), legSurf.getColor(), this.toMaterial(appearanceDB, legTexDB, legSurf), this.fromLegacySurfDesc(legSurf.getSurfDesc(), legSurf, matMan));
        surf.setFYI(legSurf.getFYI());
        surf.setCustomFDSProps(this.fromLegacyCustomFDS(legSurf.getCustomFDSProps()));
        this.makeAvailableForDelayLoad(surf, legSurf);
        return surf;
    }

    private pyrosim.domain.appearance.Material toMaterial(MaterialDB appearanceDB, TextureDB legTexDB, pyrosim.legacy_2012_1.domain.boundcond.surf.Surface legSurf) {
        Color diffColor = legSurf.getColor().getAlpha() == 255 ? Color.WHITE : new Color(255, 255, 255, legSurf.getColor().getAlpha());
        TextureInfo legTexInfo = legSurf.getTextureInfo();
        if (legTexInfo == null) {
            return null;
        }
        pyrosim.legacy_2012_1.domain.texture.Texture legTex = legTexDB.getTexture(legTexInfo.getTexID());
        if (legTex == null) {
            for (pyrosim.domain.appearance.Material mat : appearanceDB.flatten()) {
                Texture tex;
                if (!mat.getName().equals(legTexInfo.getTexID()) || (tex = mat.getAttributes().getTexture(MatChannel.DIFFUSE)) == null) continue;
                return this.toMaterial(diffColor, tex.image, legTexInfo);
            }
            String msg = String.format(Intl.intl("Could not find texture for SURF, %1$s: %2$s"), legSurf.getName(), legTexInfo.getTexID());
            String action = Intl.intl("Removed texture from SURF.");
            this.d_warnings.addWarning(new Warning(msg, action));
            return null;
        }
        return this.toMaterial(diffColor, legTex, legTexInfo);
    }

    private ISurfDesc fromLegacySurfDesc(pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc legacy, pyrosim.legacy_2012_1.domain.boundcond.surf.Surface owner, MaterialManager matMan) {
        if (legacy instanceof BlowerSurfDesc) {
            BlowerSurfDesc desc = (BlowerSurfDesc)legacy;
            return new pyrosim.domain.boundcond.surf.BlowerSurfDesc(this.fromLegacyTempReg(desc.d_tempReg), this.fromLegacySurfAirflow(desc.d_airFlow, owner), this.fromLegacySurfPartInj(desc.d_partInj), IGeometry.DEFAULT);
        }
        if (legacy instanceof pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc) {
            pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc desc = (pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc)legacy;
            BurnerSurfDesc bsd = new BurnerSurfDesc(this.fromLegacySurfHeatRelease(desc.d_heatRelease), this.fromLegacySurfPartInj(desc.d_partInj), this.fromLegacyTempReg(desc.d_temperature), IGeometry.DEFAULT);
            return bsd;
        }
        if (legacy instanceof pyrosim.legacy_2012_1.domain.boundcond.surf.ConstantTempSurfDesc) {
            pyrosim.legacy_2012_1.domain.boundcond.surf.ConstantTempSurfDesc desc = (pyrosim.legacy_2012_1.domain.boundcond.surf.ConstantTempSurfDesc)legacy;
            return new ConstantTempSurfDesc(this.fromLegacyTempReg(desc.d_tempReg), this.fromLegacySurfPartInj(desc.d_partInj), IGeometry.DEFAULT);
        }
        if (legacy instanceof FanSurfDesc) {
            FanSurfDesc desc = (FanSurfDesc)legacy;
            this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports surfaces of type Fan."), String.format(Intl.intl("Surface %s converted to type Exhaust."), owner.getName())));
            return new pyrosim.domain.boundcond.surf.InFlowSurfDesc(this.fromLegacySurfAirflow(desc.d_airFlow, owner), pyrosim.domain.boundcond.surf.TempRegulation.newDefault());
        }
        if (legacy instanceof InFlowSurfDesc) {
            InFlowSurfDesc desc = (InFlowSurfDesc)legacy;
            return new pyrosim.domain.boundcond.surf.InFlowSurfDesc(this.fromLegacySurfAirflow(desc.d_airFlow, owner), pyrosim.domain.boundcond.surf.TempRegulation.newDefault());
        }
        if (legacy instanceof LayeredSurfDesc) {
            LayeredSurfDesc desc = (LayeredSurfDesc)legacy;
            if (desc.d_surfDensity != null) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Surface Density for Layered Surfaces."), String.format(Intl.intl("Surface Density dropped from Surface %s."), owner.getName())));
            }
            IGeometry geom = null;
            if (desc.d_geom.equals((Object)LayeredSurfDesc.Geometry.FLAT)) {
                geom = new IGeometry.Cartesian(new UnitDouble(0.0, SI.METER), new UnitDouble(0.0, SI.METER), null);
            } else if (desc.d_geom.equals((Object)LayeredSurfDesc.Geometry.SPHERICAL)) {
                geom = new IGeometry.Spherical(new UnitDouble(0.0, SI.METER), null);
            } else if (desc.d_geom.equals((Object)LayeredSurfDesc.Geometry.CYLINDRICAL)) {
                geom = new IGeometry.Cylindrical(new UnitDouble(0.0, SI.METER), null, Variant.constant(new UnitDouble(0.0, SI.METER)));
            }
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unknown geometry data for legacy surface, %s."), owner.getName()), String.format(Intl.intl("Generic geometry dimensions added to surface, %s."), owner.getName())));
            return new pyrosim.domain.boundcond.surf.LayeredSurfDesc(geom, this.fromLegacySurfSlip(desc.d_slip), this.fromLegacySurfReac(desc.d_iReac), this.fromLegacySurfComp(desc.d_surfComp, matMan), this.fromLegacySurfSpecInjList(desc.d_specInj), this.fromLegacySurfPartInj(desc.d_partInj), desc.d_burnAway, this.fromLegacySurfZonePath(desc.d_leakPath), pyrosim.domain.boundcond.surf.TempRegulation.newDefault());
        }
        if (legacy instanceof LeakSurfDesc) {
            LeakSurfDesc desc = (LeakSurfDesc)legacy;
            if (desc.d_porous) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports the Surface parameter, Porous"), String.format(Intl.intl("Porous dropped from Surface %s."), owner.getName())));
            }
            return new pyrosim.domain.boundcond.surf.LeakSurfDesc(this.fromLegacySurfZonePath(desc.d_leak));
        }
        if (legacy instanceof SurfDescStatic.Adiabatic) {
            return new SurfDescStatic.Adiabatic(this.fromLegacySurfSlip(((SurfDescStatic.Adiabatic)legacy).slip));
        }
        if (legacy instanceof SurfDescStatic.Hvac) {
            return new SurfDescStatic.Hvac();
        }
        if (legacy instanceof SurfDescStatic.Inert) {
            return new SurfDescStatic.Inert();
        }
        if (legacy instanceof SurfDescStatic.Mirror) {
            return new SurfDescStatic.Mirror();
        }
        if (legacy instanceof SurfDescStatic.Open) {
            return new SurfDescStatic.Open();
        }
        return null;
    }

    private Fuel.IReaction fromLegacySurfReac(Fuel.IReaction legacy) {
        if (legacy instanceof Fuel.MaterialReac) {
            return new Fuel.MaterialReac();
        }
        if (legacy instanceof Fuel.ManualReac) {
            Fuel.ManualReac reac = (Fuel.ManualReac)legacy;
            return new Fuel.ManualReac(this.fromLegacySurfHeatRelease(reac.d_heatRelease), ConvertUtil.c(reac.d_heatOfVap), this.fromLegacySurfIgnition(reac.d_ignition));
        }
        return null;
    }

    private Fuel.ManualReac.IIgnition fromLegacySurfIgnition(Fuel.ManualReac.IIgnition legacy) {
        if (legacy instanceof Fuel.ManualReac.ImmediateIgnite) {
            return new Fuel.ManualReac.ImmediateIgnite();
        }
        if (legacy instanceof Fuel.ManualReac.TemperatureIgnite) {
            return new Fuel.ManualReac.TemperatureIgnite(ConvertUtil.c(((Fuel.ManualReac.TemperatureIgnite)legacy).d_temperature));
        }
        return null;
    }

    private pyrosim.domain.boundcond.surf.TempRegulation fromLegacyTempReg(TempRegulation legacy) {
        if (legacy.isNetHeatFluxTR()) {
            return pyrosim.domain.boundcond.surf.TempRegulation.newNetHeatFluxTR(ConvertUtil.c(legacy.d_netHeatFlux), pyrosim.domain.TimeFunction.newDefault(), 0.9, null, false);
        }
        return pyrosim.domain.boundcond.surf.TempRegulation.newFixedHeatFluxTR(ConvertUtil.c(legacy.d_temperature), this.fromLegacyTimeFunc(legacy.d_rampup), ConvertUtil.c(legacy.d_heatFlux), pyrosim.domain.TimeFunction.newDefault(), legacy.d_emissivity, null, false);
    }

    private pyrosim.domain.TimeFunction fromLegacyTimeFunc(TimeFunction legacy) {
        if (legacy instanceof TimeFunction.TanH) {
            return new TimeFunction.TanH(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)((TimeFunction.TanH)legacy).val));
        }
        if (legacy instanceof TimeFunction.TSquared) {
            return new TimeFunction.TSquared(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)((TimeFunction.TSquared)legacy).val));
        }
        if (legacy instanceof TimeFunction.Custom) {
            return new TimeFunction.Custom(this.fromLegacyRamp((Ramp)((TimeFunction.Custom)legacy).val));
        }
        return null;
    }

    private AirFlow fromLegacySurfAirflow(pyrosim.legacy_2012_1.domain.boundcond.surf.AirFlow legacy, pyrosim.legacy_2012_1.domain.boundcond.surf.Surface owner) {
        if (legacy.d_duct != null) {
            this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Surface Air Ducts."), String.format(Intl.intl("Air Duct dropped from Surface %s."), owner.getName())));
        }
        return new AirFlow(this.fromLegacySurfAirflowRate(legacy.d_rate), this.fromLegacySurfAirflowProf(legacy.d_profile));
    }

    private pyrosim.domain.boundcond.surf.ZonePath fromLegacySurfZonePath(ZonePath legacy) {
        return legacy == null ? null : new pyrosim.domain.boundcond.surf.ZonePath(this.fromLegacyZone(legacy.getZones()[0]), this.fromLegacyZone(legacy.getZones()[1]));
    }

    private AirFlow.Rate fromLegacySurfAirflowRate(AirFlow.Rate legacy) {
        AirFlow.ValRate oldRate;
        AirFlow.Rate newRate = null;
        if (legacy instanceof AirFlow.NormalVel) {
            oldRate = (AirFlow.NormalVel)legacy;
            newRate = new AirFlow.NormalVel(ConvertUtil.c(oldRate.val), ConvertUtil.c(oldRate.tanVelU), ConvertUtil.c(oldRate.tanVelV), this.fromLegacyTimeFunc(oldRate.func), this.fromLegacySurfSpecInjList(oldRate.specInj));
        }
        if (legacy instanceof AirFlow.VolumeFlux) {
            oldRate = (AirFlow.VolumeFlux)legacy;
            newRate = new AirFlow.VolumeFlux(ConvertUtil.c(((AirFlow.VolumeFlux)oldRate).val), ConvertUtil.c(((AirFlow.VolumeFlux)oldRate).tanVelU), ConvertUtil.c(((AirFlow.VolumeFlux)oldRate).tanVelV), this.fromLegacyTimeFunc(((AirFlow.VolumeFlux)oldRate).func), this.fromLegacySurfSpecInjList(((AirFlow.VolumeFlux)oldRate).specInj));
        }
        if (legacy instanceof AirFlow.TotalMassFlux) {
            oldRate = (AirFlow.TotalMassFlux)legacy;
            newRate = new AirFlow.TotalMassFlux(ConvertUtil.c(((AirFlow.TotalMassFlux)oldRate).val), ConvertUtil.c(((AirFlow.TotalMassFlux)oldRate).tanVelU), ConvertUtil.c(((AirFlow.TotalMassFlux)oldRate).tanVelV), this.fromLegacyTimeFunc(((AirFlow.TotalMassFlux)oldRate).func), this.fromLegacySurfSpecInjList(((AirFlow.TotalMassFlux)oldRate).specInj));
        }
        if (legacy instanceof AirFlow.ExSpecMassFlux) {
            newRate = new AirFlow.ExSpecMassFlux(ConvertUtil.c(legacy.tanVelU), ConvertUtil.c(legacy.tanVelV), this.fromLegacyTimeFunc(legacy.func), this.fromLegacySurfSpecInjList(legacy.specInj));
        }
        return newRate;
    }

    private SpecInjList fromLegacySurfSpecInjList(pyrosim.legacy_2012_1.domain.boundcond.surf.SpecInjList legacy) {
        if (legacy == null) {
            return null;
        }
        ArrayList<pyrosim.domain.boundcond.surf.SpeciesInjection> newList = new ArrayList<pyrosim.domain.boundcond.surf.SpeciesInjection>();
        for (SpeciesInjection spInj : legacy.getInjections()) {
            newList.add(this.fromLegacySurfSpecInj(spInj));
        }
        return new SpecInjList(legacy.injType, newList);
    }

    private pyrosim.domain.boundcond.surf.SpeciesInjection fromLegacySurfSpecInj(SpeciesInjection legacy) {
        Comparable newVal;
        if (legacy.val instanceof pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble) {
            newVal = ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)legacy.val);
        } else {
            assert (legacy.val instanceof Double);
            newVal = (Double)legacy.val;
        }
        pyrosim.domain.boundcond.surf.SpeciesInjection newInject = new pyrosim.domain.boundcond.surf.SpeciesInjection(null, newVal, this.fromLegacyTimeFunc(legacy.func));
        try {
            this.registerForDelayLoad(newInject, pyrosim.domain.boundcond.surf.SpeciesInjection.class.getDeclaredField("species"), legacy.species);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return newInject;
    }

    private AirFlow.IProfile fromLegacySurfAirflowProf(AirFlow.IProfile legacy) {
        if (legacy instanceof AirFlow.AtmosphericProf) {
            return new AirFlow.AtmosphericProf(((AirFlow.AtmosphericProf)legacy).d_exponent, ConvertUtil.c(((AirFlow.AtmosphericProf)legacy).d_origin));
        }
        if (legacy instanceof AirFlow.ParabolicProf) {
            return new AirFlow.ParabolicProf();
        }
        if (legacy instanceof AirFlow.TopHatProf) {
            return new AirFlow.TopHatProf();
        }
        return null;
    }

    private ParticleInjection fromLegacySurfPartInj(pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection legacy) {
        if (legacy == null) {
            return null;
        }
        ParticleInjection newInject = new ParticleInjection(null, legacy.d_numPartsPerCell, this.fromLegacyTBV(legacy.getMassFlux()), ConvertUtil.c(legacy.d_dtInsert));
        try {
            this.registerForDelayLoad(newInject, ParticleInjection.class.getDeclaredField("d_particle"), legacy.getParticle());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return newInject;
    }

    private HeatRelease fromLegacySurfHeatRelease(pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease legacy) {
        HeatRelease.Type type = legacy.d_type;
        UnitDouble legExtingCoeff = ConvertUtil.c(legacy.d_extingCoeff);
        Unit legExtingCoeffUnit = legExtingCoeff.getUnit();
        if (legExtingCoeffUnit == SI.SECOND.pow(-1) || legExtingCoeffUnit == SI.METER.pow(2).multiply(SI.SECOND).divide(SI.KILOGRAM)) {
            legExtingCoeff = new UnitDouble(legExtingCoeff.getRawValue(), SIUS.unit(21));
        } else if (legExtingCoeffUnit == NonSI.FOOT.pow(2).multiply(SI.SECOND).divide(NonSI.POUND)) {
            legExtingCoeff = new UnitDouble(legExtingCoeff.getRawValue(), EnglishUS.unit(21));
        }
        if (type instanceof HeatRelease.HRRType) {
            return new HeatRelease(new HeatRelease.HRRType(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)type.val), this.fromLegacyTimeFunc(type.func)), legExtingCoeff);
        }
        if (type instanceof HeatRelease.MLRType) {
            return new HeatRelease(new HeatRelease.MLRType(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)type.val), this.fromLegacyTimeFunc(type.func)), legExtingCoeff);
        }
        return null;
    }

    private pyrosim.domain.boundcond.surf.ISlip fromLegacySurfSlip(ISlip legacy) {
        if (legacy instanceof ISlip.FreeSlip) {
            return pyrosim.domain.boundcond.surf.ISlip.FREE_SLIP;
        }
        if (legacy instanceof ISlip.NoSlip) {
            return pyrosim.domain.boundcond.surf.ISlip.NO_SLIP;
        }
        if (legacy instanceof ISlip.RoughSlip) {
            return new ISlip.RoughSlip(ConvertUtil.c(((ISlip.RoughSlip)legacy).roughness));
        }
        return new ISlip.RoughSlip(new UnitDouble(0.0, SI.METER));
    }

    private SurfComposition fromLegacySurfComp(pyrosim.legacy_2012_1.domain.boundcond.surf.SurfComposition legacy, MaterialManager matMan) {
        ArrayList<SurfComposition.SurfLayer> newLayers = new ArrayList<SurfComposition.SurfLayer>();
        for (SurfComposition.SurfLayer layer : legacy.d_layers) {
            newLayers.add(this.fromLegacySurfLayer(layer, matMan));
        }
        return new SurfComposition(SurfComposition.TEMP_RAMP_INTERNAL.getDefault(), this.fromLegacySurfBacking(legacy.d_backing), legacy.d_layerDivide, newLayers);
    }

    private Backing fromLegacySurfBacking(pyrosim.legacy_2012_1.domain.boundcond.surf.Backing legacy) {
        if (legacy instanceof Backing.Exposed) {
            return Backing.EXPOSED;
        }
        if (legacy instanceof Backing.Insulated) {
            return Backing.INSULATED;
        }
        if (legacy instanceof Backing.AirGap) {
            return new Backing.AirGap(ConvertUtil.c(((Backing.AirGap)legacy).d_airTemp), pyrosim.domain.TimeFunction.newDefault());
        }
        return null;
    }

    private SurfComposition.SurfLayer fromLegacySurfLayer(SurfComposition.SurfLayer legacy, MaterialManager matMan) {
        ArrayList<SurfComposition.SurfLayer.SurfComponent> newList = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
        for (SurfComposition.SurfLayer.SurfComponent comp : legacy.getComponents()) {
            DelayedRef dref = this.d_delayLoadMap.get(comp.d_material);
            if (dref == null) {
                NameGenerator ng = new NameGenerator(Intl.intl("Materials"));
                for (Material m : matMan.flatten()) {
                    ng.registerName(m.getName());
                }
                String newMatName = ng.generateValidName(comp.d_material.getName());
                Material newMat = this.fromLegacyMatl(comp.d_material);
                newMat.setName(newMatName);
                matMan.add(newMat);
                newList.add(new SurfComposition.SurfLayer.SurfComponent(comp.d_massFraction, newMat));
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("The material %s could not be found."), comp.d_material.getName()), String.format(Intl.intl("Generated a new material called %s."), newMatName)));
                continue;
            }
            newList.add(new SurfComposition.SurfLayer.SurfComponent(comp.d_massFraction, (Material)this.d_delayLoadMap.get(comp.d_material).get()));
        }
        return new SurfComposition.SurfLayer(ConvertUtil.c(legacy.d_thickness), newList);
    }

    private TimeBasedValue<UnitDouble> fromLegacyTBV(pyrosim.legacy_2012_1.domain.TimeBasedValue<pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble> legacy) {
        return legacy == null ? null : new TimeBasedValue<UnitDouble>(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)legacy.val), this.fromLegacyTimeFunc(legacy.func));
    }

    private ReactionList fromLegacyReacList(pyrosim.legacy_2012_1.domain.reaction.ReactionList legacy, ReactionList newList, pyrosim.domain.SimParams misc, pyrosim.domain.ExSpecList specList) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.reaction.ReactionList oldSubComp = (pyrosim.legacy_2012_1.domain.reaction.ReactionList)legObj;
                ReactionList newSubComp = new ReactionList(oldSubComp.getName());
                newList.add(this.fromLegacyReacList(oldSubComp, newSubComp, misc, specList));
                continue;
            }
            Reaction legReac = (Reaction)legObj;
            pyrosim.domain.reaction.Reaction convertedReac = this.fromLegacyReaction(legReac, misc, specList);
            assert (convertedReac != null);
            if (convertedReac != null) {
                boolean isActive = convertedReac.isActive();
                newList.add(convertedReac);
                convertedReac.setActive(isActive);
                continue;
            }
            this.addUnableToLoadWarn(legReac.getName(), Intl.intl("reaction"));
        }
        if (newList.isEmpty()) {
            pyrosim.domain.reaction.Reaction propane = new pyrosim.domain.reaction.Reaction(PredefReac.PROPANE.name() + "_REAC", true, Reaction.ReacType.SIMPLE);
            propane.setFYI(Intl.intl("SFPE Handbook"));
            pyrosim.domain.ExSpec propaneSpec = specList.get("PROPANE");
            if (propaneSpec == null) {
                propaneSpec = new pyrosim.domain.ExSpec(pyrosim.domain.ExSpecList.getPredefinedSpecies("PROPANE"));
                propaneSpec.setType(1);
                specList.add(propaneSpec);
            }
            propane.setFuel(propaneSpec);
            propane.setSootYield(0.024);
            propane.setCOYield(0.005);
            newList.add(propane);
            propane.setActive(true);
        }
        return newList;
    }

    private pyrosim.domain.reaction.Reaction fromLegacyReaction(Reaction legacy, pyrosim.domain.SimParams misc, pyrosim.domain.ExSpecList specList) {
        pyrosim.domain.reaction.Reaction newReac = new pyrosim.domain.reaction.Reaction(legacy.getName(), Reaction.ReacType.SIMPLE);
        newReac.setFYI(legacy.getFYI());
        newReac.setActive(legacy.isActive());
        NameGenerator ng = new NameGenerator(Intl.intl("Species"));
        for (pyrosim.domain.ExSpec spec : specList.flatten()) {
            ng.registerName(spec.getName());
        }
        newReac.setFuel(pyrosim.domain.ExSpecList.getDefaultFuel(specList, ng, true));
        Soot legacySoot = legacy.getByproducts().d_soot;
        if (newReac.isActive()) {
            misc.getEnvironment().setAmbMFO2(SIUS.newud(legacy.getFuel().d_ambMassFracO2, 18));
            if (legacySoot == null) {
                misc.getEnvironment().setMaxVisibility(new UnitDouble(30.0, SI.METER));
                misc.getEnvironment().setVisibilityFactor(3.0);
            } else {
                misc.getEnvironment().setMaxVisibility(ConvertUtil.c(legacySoot.d_maxVisibility));
                misc.getEnvironment().setVisibilityFactor(legacySoot.d_visFactor);
            }
        }
        newReac.setFuelComp(legacy.getFuel().d_hydrogen, legacy.getFuel().d_carbon, legacy.getFuel().d_oxygen, legacy.getFuel().d_nitrogen);
        if (legacy.getSuppression() != null) {
            newReac.setCritFlameTemp(ConvertUtil.c(legacy.getSuppression().d_criticalFlameTemp));
            newReac.setSuppression(legacy.getSuppression().d_limitingOxygenIndex > 0.0);
        }
        newReac.setHrrpuaSheet(ConvertUtil.c(legacy.getHRR().hrrpuaUpperLimit));
        newReac.setHrrpuvAvg(ConvertUtil.c(legacy.getHRR().hrrpuvUpperLimit));
        Byproducts.Energy legEnergy = legacy.getByproducts().d_energy;
        newReac.setIdeal(legacy.getByproducts().d_energy.d_ideal);
        if (legEnergy instanceof Byproducts.FuelEnergy) {
            newReac.setHeatOfCombustion(ConvertUtil.c(((Byproducts.FuelEnergy)legEnergy).d_heatOfCombustion));
            newReac.setEnergyType(Reaction.EnergyRelease.HEAT_OF_COMBUSTION);
        } else {
            newReac.setEpumo2(ConvertUtil.c(((Byproducts.OxygenEnergy)legEnergy).d_epumo2));
            newReac.setEnergyType(Reaction.EnergyRelease.EPUMO2);
        }
        newReac.setCOYield(legacy.getByproducts().d_coYield);
        newReac.setSootYield(legacy.getByproducts().d_sootYield);
        newReac.setHCNYield(0.0);
        if (legacySoot == null) {
            newReac.setSootHFraction(0.1);
        } else {
            newReac.setSootHFraction(legacySoot.d_hydrogenFrac);
        }
        newReac.setCustomFDSProps(this.fromLegacyCustomFDS(legacy.getCustomFDSProps()));
        return newReac;
    }

    private void addMixFracDelayLoad(int mixFracIx, pyrosim.domain.ExSpec newReference) {
        ExSpec mixFracSpec = ExSpecList.MIXFRAC_EXSPECS[mixFracIx];
        this.d_mixFracMap.put(mixFracSpec, newReference);
        this.makeAvailableForDelayLoad(newReference, mixFracSpec);
    }

    private void addMixFracDelayLoad(int mixFracIx, String predefName) {
        pyrosim.domain.ExSpec predefCopy = new pyrosim.domain.ExSpec(pyrosim.domain.ExSpecList.getPredefinedSpecies(predefName));
        this.addMixFracDelayLoad(mixFracIx, predefCopy);
    }

    private pyrosim.domain.ExSpecList fromLegacySpecList(ExSpecList legacy, pyrosim.domain.ExSpecList newList, Serialized ser, boolean isRoot) {
        if (isRoot) {
            PyroMod tempMod = new PyroMod(ser, false, false);
            NameGenerator specNames = tempMod.getNames(pyrosim.domain.ExSpec.class);
            this.addMixFracDelayLoad(0, pyrosim.domain.ExSpecList.getDefaultFuel(newList, specNames, true));
            this.addMixFracDelayLoad(1, "OXYGEN");
            this.addMixFracDelayLoad(2, "NITROGEN");
            this.addMixFracDelayLoad(3, "WATER VAPOR");
            this.addMixFracDelayLoad(4, "CARBON DIOXIDE");
            this.addMixFracDelayLoad(5, "CARBON MONOXIDE");
            this.addMixFracDelayLoad(6, "HYDROGEN");
            this.addMixFracDelayLoad(7, "SOOT");
            for (ExSpec oldSpec : ExSpecList.PREDEFINED.values()) {
                String name = oldSpec.getName();
                pyrosim.domain.ExSpec newPredefSpec = pyrosim.domain.ExSpecList.getPredefinedSpecies(name);
                if (name.equals("HYDROGEN FLOURIDE")) {
                    newPredefSpec = pyrosim.domain.ExSpecList.getPredefinedSpecies("HYDROGEN FLUORIDE");
                }
                newPredefSpec.setType(0);
                this.makeAvailableForDelayLoad(newPredefSpec, oldSpec);
            }
        }
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                ExSpecList oldSubComp = (ExSpecList)legObj;
                pyrosim.domain.ExSpecList newSubComp = new pyrosim.domain.ExSpecList(oldSubComp.getName());
                newList.add(this.fromLegacySpecList(oldSubComp, newSubComp, ser, false));
                continue;
            }
            ExSpec oldSpec = (ExSpec)legObj;
            pyrosim.domain.ExSpec convertedReac = this.fromLegacySpecies(oldSpec);
            assert (convertedReac != null);
            if (convertedReac != null) {
                newList.add(convertedReac);
                continue;
            }
            this.addUnableToLoadWarn(oldSpec.getName(), "species");
        }
        return newList;
    }

    private pyrosim.domain.ExSpec fromLegacySpecies(ExSpec legacy) {
        if (legacy == null) {
            return null;
        }
        pyrosim.domain.ExSpec newSpec = null;
        HashMap<String, String> customFDSProps = new HashMap<String, String>();
        if (ExSpecList.isPredefinedSpecies(legacy.getName())) {
            newSpec = new pyrosim.domain.ExSpec(pyrosim.domain.ExSpecList.getPredefinedSpecies(legacy.getName()));
            newSpec.setType(0);
        } else {
            newSpec = new pyrosim.domain.ExSpec(legacy.getName(), 1);
            newSpec.setMolecularWeight(ConvertUtil.c(legacy.getMolWt()));
            if (legacy.getDNSType() == 1) {
                newSpec.getPrimParams().setSigmaLJ(legacy.getSigma().getValueNoUnit(), true);
                newSpec.getPrimParams().setEpsilonKLJ(legacy.getEpsilonK().getValueNoUnit(), true);
            } else if (legacy.getDNSType() == 2) {
                newSpec.getPrimParams().setDiffusivity(Variant.constant(ConvertUtil.c(legacy.getDiffusivity())));
                newSpec.getPrimParams().setViscosity(Variant.constant(ConvertUtil.c(legacy.getViscosity())));
                this.d_warnings.addWarning(new Warning(Intl.intl("Meaning of FDS5 parameter CONDUCTIVITY has changed."), String.format(Intl.intl("Conductivity dropped from species %s"), newSpec.getName())));
            }
        }
        newSpec.setFYI(legacy.getFYI());
        newSpec.setMassFrac0(legacy.getMassFrac0());
        if (legacy.getAbsorb() && !pyrosim.domain.ExSpecList.isPredefinedSpecies(legacy.getName())) {
            this.d_warnings.addWarning(new Warning(Intl.intl("FDS5 parameter ABSORBING removed."), String.format(Intl.intl("Default RADCAL_ID, METHANE, added to species %s"), newSpec.getName())));
            newSpec.getPrimParams().setRadCalSurrogate("METHANE");
        }
        FDSRecordSpec specSpec = FDS6Const.getRecordSpecs().get("SPEC");
        if (legacy.getMassExtinctionCoeff() != null && !specSpec.isDefault("MASS_EXTINCTION_COEFFICIENT", legacy.getMassExtinctionCoeff())) {
            customFDSProps.put("MASS_EXTINCTION_COEFFICIENT", Double.toString(legacy.getMassExtinctionCoeff().getValueNoUnit()));
            this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Mass Extinction Coefficient."), String.format(Intl.intl("%s moved to %s Advanced Parameters."), "MASS_EXTINCTION_COEFFICIENT", newSpec.getName())));
        }
        newSpec.setCustomFDSProps(pyrosim.domain.CustomFDSProps.get(customFDSProps));
        this.makeAvailableForDelayLoad(newSpec, legacy);
        return newSpec;
    }

    private HvacList fromLegacyHvacList(pyrosim.legacy_2012_1.domain.hvac.HvacList legacy, HvacList newList) {
        if (!legacy.flatten().isEmpty()) {
            String warning = Intl.intl("HVAC objects from PyroSim 2012 are not supported.");
            String action = Intl.intl("Skipping all PyroSim 2012 HVAC objects.");
            this.d_warnings.addWarning(new Warning(warning, action));
        }
        return newList;
    }

    private pyrosim.domain.evac.PersList fromLegacy(PersList legacy, pyrosim.domain.evac.PersList newList) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                PersList oldSubComp = (PersList)legObj;
                pyrosim.domain.evac.PersList newSubComp = new pyrosim.domain.evac.PersList(oldSubComp.getName());
                newList.add(this.fromLegacy(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.evac.Pers legPers = (pyrosim.legacy_2012_1.domain.evac.Pers)legObj;
            Pers newPers = new Pers(legPers.getName());
            assert (newPers != null);
            newList.add(newPers);
            this.d_evacMap.put(legPers, newPers);
        }
        return newList;
    }

    private ExitList fromLegacy(pyrosim.legacy_2012_1.domain.evac.ExitList legacy, ExitList newList) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.evac.ExitList oldSubComp = (pyrosim.legacy_2012_1.domain.evac.ExitList)legObj;
                ExitList newSubComp = new ExitList(oldSubComp.getName());
                newList.add(this.fromLegacy(oldSubComp, newSubComp));
                continue;
            }
            Exit legExit = (Exit)legObj;
            pyrosim.domain.evac.Exit newExit = new pyrosim.domain.evac.Exit(legExit.getName());
            assert (newExit != null);
            newList.add(newExit);
            this.d_evacMap.put(legExit, newExit);
        }
        return newList;
    }

    private pyrosim.domain.evac.EvacList fromLegacy(EvacList legacy, pyrosim.domain.evac.EvacList newList) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                EvacList oldSubComp = (EvacList)legObj;
                pyrosim.domain.evac.EvacList newSubComp = new pyrosim.domain.evac.EvacList(oldSubComp.getName());
                newList.add(this.fromLegacy(oldSubComp, newSubComp));
                continue;
            }
            Evac legEvac = (Evac)legObj;
            pyrosim.domain.evac.Evac newEvac = new pyrosim.domain.evac.Evac(legEvac.getName(), null);
            assert (newEvac != null);
            newList.add(newEvac);
            this.d_evacMap.put(legEvac, newEvac);
        }
        return newList;
    }

    private pyrosim.domain.evac.EntrList fromLegacy(EntrList legacy, pyrosim.domain.evac.EntrList newList) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                EntrList oldSubComp = (EntrList)legObj;
                pyrosim.domain.evac.EntrList newSubComp = new pyrosim.domain.evac.EntrList(oldSubComp.getName());
                newList.add(this.fromLegacy(oldSubComp, newSubComp));
                continue;
            }
            Entr legEntr = (Entr)legObj;
            pyrosim.domain.evac.Entr newEntr = new pyrosim.domain.evac.Entr(legEntr.getName());
            assert (newEntr != null);
            newList.add(newEntr);
            this.d_evacMap.put(legEntr, newEntr);
        }
        return newList;
    }

    private EvhoList fromLegacy(pyrosim.legacy_2012_1.domain.evac.EvhoList legacy, EvhoList newList) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.evac.EvhoList oldSubComp = (pyrosim.legacy_2012_1.domain.evac.EvhoList)legObj;
                EvhoList newSubComp = new EvhoList(oldSubComp.getName());
                newList.add(this.fromLegacy(oldSubComp, newSubComp));
                continue;
            }
            Evho legEvho = (Evho)legObj;
            pyrosim.domain.evac.Evho newEvho = new pyrosim.domain.evac.Evho(legEvho.getName());
            assert (newEvho != null);
            newList.add(newEvho);
            this.d_evacMap.put(legEvho, newEvho);
        }
        return newList;
    }

    private pyrosim.domain.evac.CorrList fromLegacy(CorrList legacy, pyrosim.domain.evac.CorrList newList) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                CorrList oldSubComp = (CorrList)legObj;
                pyrosim.domain.evac.CorrList newSubComp = new pyrosim.domain.evac.CorrList(oldSubComp.getName());
                newList.add(this.fromLegacy(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.evac.Corr legCorr = (pyrosim.legacy_2012_1.domain.evac.Corr)legObj;
            Corr newCorr = new Corr(legCorr.getName());
            assert (newCorr != null);
            newList.add(newCorr);
            this.d_evacMap.put(legCorr, newCorr);
        }
        return newList;
    }

    private EvssList fromLegacy(pyrosim.legacy_2012_1.domain.evac.EvssList legacy, EvssList newList) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.evac.EvssList oldSubComp = (pyrosim.legacy_2012_1.domain.evac.EvssList)legObj;
                EvssList newSubComp = new EvssList(oldSubComp.getName());
                newList.add(this.fromLegacy(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.evac.Evss legEvss = (pyrosim.legacy_2012_1.domain.evac.Evss)legObj;
            Evss newEvss = new Evss(legEvss.getName());
            assert (newEvss != null);
            newList.add(newEvss);
            this.d_evacMap.put(legEvss, newEvss);
        }
        return newList;
    }

    private DoorList fromLegacy(pyrosim.legacy_2012_1.domain.evac.DoorList legacy, DoorList newList) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.evac.DoorList oldSubComp = (pyrosim.legacy_2012_1.domain.evac.DoorList)legObj;
                DoorList newSubComp = new DoorList(oldSubComp.getName());
                newList.add(this.fromLegacy(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.evac.Door legDoor = (pyrosim.legacy_2012_1.domain.evac.Door)legObj;
            Door newDoor = new Door(legDoor.getName());
            assert (newDoor != null);
            newList.add(newDoor);
            this.d_evacMap.put(legDoor, newDoor);
        }
        return newList;
    }

    private pyrosim.domain.controls.ControlMgr fromLegacy(ControlMgr legacy, pyrosim.domain.controls.ControlMgr newMgr) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                ControlMgr oldSubComp = (ControlMgr)legObj;
                pyrosim.domain.controls.ControlMgr newSubComp = new pyrosim.domain.controls.ControlMgr(oldSubComp.getName());
                newMgr.add(this.fromLegacy(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.controls.ControlBridge legCtrl = (pyrosim.legacy_2012_1.domain.controls.ControlBridge)legObj;
            ControlBridge convertedControl = this.fromLegacyControl(legCtrl);
            assert (convertedControl != null);
            if (convertedControl != null) {
                newMgr.add(convertedControl);
                continue;
            }
            this.addUnableToLoadWarn(legCtrl.getName(), Intl.intl("control"));
        }
        return newMgr;
    }

    private ControlBridge fromLegacyControl(pyrosim.legacy_2012_1.domain.controls.ControlBridge legacy) {
        ControlBridge bridge = new ControlBridge(legacy.getName());
        this.addToConnectionsMap(bridge, legacy);
        return bridge;
    }

    private HeatLinkModelMgr fromLegacyHeatLinkMgr(pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModelMgr legacy, HeatLinkModelMgr newMgr) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModelMgr oldSubComp = (pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModelMgr)legObj;
                HeatLinkModelMgr newSubComp = new HeatLinkModelMgr(oldSubComp.getName());
                newMgr.add(this.fromLegacyHeatLinkMgr(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel model = (pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel)legObj;
            HeatLinkModel newModel = new HeatLinkModel(model.getName(), ConvertUtil.c(model.getRti()), ConvertUtil.c(model.getInitialTemp()), ConvertUtil.c(model.getActivationTemp()));
            assert (newModel != null);
            this.makeAvailableForDelayLoad(newModel, model);
            newMgr.add(newModel);
        }
        return newMgr;
    }

    private SmokeLinkModelMgr fromLegacySmokeLinkMgr(pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModelMgr legacy, SmokeLinkModelMgr newMgr) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModelMgr oldSubComp = (pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModelMgr)legObj;
                SmokeLinkModelMgr newSubComp = new SmokeLinkModelMgr(oldSubComp.getName());
                newMgr.add(this.fromLegacySmokeLinkMgr(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel legModel = (pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel)legObj;
            SmokeLinkModel convertedModel = this.fromLegacySmokeLink(legModel);
            assert (convertedModel != null);
            if (convertedModel != null) {
                newMgr.add(convertedModel);
                continue;
            }
            this.addUnableToLoadWarn(legModel.getName(), Intl.intl("smoke link model"));
        }
        return newMgr;
    }

    private SmokeLinkModel fromLegacySmokeLink(pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel legacy) {
        SmokeLinkModel model = new SmokeLinkModel(legacy.getName(), ConvertUtil.c(legacy.getActivationObscuration()), null, this.fromLegacySmokeLinkSpec(legacy.getSpec()));
        try {
            this.registerForDelayLoad(model, SmokeLinkModel.class.getDeclaredField("d_smokeSpecies"), legacy.getSmokeSpecies());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        model.setFYI(legacy.getFYI());
        this.makeAvailableForDelayLoad(model, legacy);
        return model;
    }

    private SmokeLinkModel.ISpec fromLegacySmokeLinkSpec(SmokeLinkModel.ISpec legacy) {
        if (legacy instanceof SmokeLinkModel.Cleary) {
            SmokeLinkModel.Cleary spec = (SmokeLinkModel.Cleary)legacy;
            return new SmokeLinkModel.Cleary(spec.d_cAlpha, spec.d_cBeta, spec.d_eAlpha, spec.d_eBeta);
        }
        if (legacy instanceof SmokeLinkModel.Heskestad) {
            return new SmokeLinkModel.Heskestad(ConvertUtil.c(((SmokeLinkModel.Heskestad)legacy).d_length));
        }
        return null;
    }

    private pyrosim.domain.devices.detectors.SprinklerLinkModelMgr fromLegacySprinklerLinkMgr(SprinklerLinkModelMgr legacy, pyrosim.domain.devices.detectors.SprinklerLinkModelMgr newMgr) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                SprinklerLinkModelMgr oldSubComp = (SprinklerLinkModelMgr)legObj;
                pyrosim.domain.devices.detectors.SprinklerLinkModelMgr newSubComp = new pyrosim.domain.devices.detectors.SprinklerLinkModelMgr(oldSubComp.getName());
                newMgr.add(this.fromLegacySprinklerLinkMgr(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel model = (pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel)legObj;
            if (model.getName() == "Water Spray") {
                for (SprinklerLinkModel defModel : newMgr.flatten()) {
                    if (!defModel.getName().equals("Water Spray")) continue;
                    newMgr.remove(defModel);
                    break;
                }
            }
            SprinklerLinkModel newModel = new SprinklerLinkModel(model.getName(), ConvertUtil.c(model.getRti()), ConvertUtil.c(model.getInitialTemp()), ConvertUtil.c(model.getActivationTemp()), ConvertUtil.c(model.getCFactor()));
            newModel.setFYI(model.getFYI());
            assert (newModel != null);
            this.makeAvailableForDelayLoad(newModel, model);
            newMgr.add(newModel);
        }
        return newMgr;
    }

    private pyrosim.domain.devices.sprayers.SprayModelMgr fromLegacySprayMgr(SprayModelMgr legacy, pyrosim.domain.devices.sprayers.SprayModelMgr newMgr) {
        for (pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel model : legacy.flatten()) {
            ArrayList<SprayModel.Jet> newJets = new ArrayList<SprayModel.Jet>();
            for (SprayModel.Jet jet : model.getJets()) {
                newJets.add(new SprayModel.Jet(ConvertUtil.c(jet.d_velocity), ConvertUtil.c(jet.d_orificeDiam), jet.d_flowFrac, ConvertUtil.c(jet.d_long1), ConvertUtil.c(jet.d_long2), ConvertUtil.c(jet.d_lat1), ConvertUtil.c(jet.d_lat2)));
            }
            pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel defModel = new pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel(null, null);
            if (defModel.getDtInsert() == model.getDtInsert()) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Insertion Interval for Spray Models."), String.format(Intl.intl("Insertion Interval removed from Spray Model, %s."), model.getName())));
            }
            SprayModel newModel = new SprayModel(model.getName(), null, ConvertUtil.c(model.getSprayOffset()), this.fromLegacySprayFlow(model, model.getFlowRate()), model.getDropsPerSecond(), newJets);
            try {
                this.registerForDelayLoad(newModel, SprayModel.class.getDeclaredField("d_particle"), model.getParticle());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            newModel.setFYI(model.getFYI());
            this.makeAvailableForDelayLoad(newModel, model);
            newMgr.add(newModel);
        }
        return newMgr;
    }

    private SprayModel.FlowRate fromLegacySprayFlow(pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel legSprayModel, SprayModel.FlowRate legacy) {
        if (legacy instanceof SprayModel.ExplicitFlowRate) {
            SprayModel.ExplicitFlowRate rate = (SprayModel.ExplicitFlowRate)legacy;
            return new SprayModel.ExplicitFlowRate(ConvertUtil.c(rate.d_rate), this.fromLegacyTimeFunc(rate.d_ramp));
        }
        if (legacy instanceof SprayModel.PressurizedFlowRate) {
            SprayModel.PressurizedFlowRate rate = (SprayModel.PressurizedFlowRate)legacy;
            return new SprayModel.PressurizedFlowRate(ConvertUtil.c(rate.d_opPressure), ConvertUtil.c(rate.d_kFactor), this.fromLegacyTimeFunc(rate.d_ramp));
        }
        if (legacy instanceof SprayModel.VaryingFlowRate) {
            SprayModel.VaryingFlowRate rate = (SprayModel.VaryingFlowRate)legacy;
            pyrosim.domain.ramp.IRampInput defInput = rate.d_pressureRamp.getDefaultInput().equals(SprayModel.VaryingFlowRate.DEF_RAMP_INPUT) ? SprayModel.VaryingFlowRate.DEF_RAMP_INPUT : this.fromLegacyRampInput(rate.d_pressureRamp.getDefaultInput());
            pyrosim.domain.ramp.IRampInput input = rate.d_pressureRamp.getInput().equals(SprayModel.VaryingFlowRate.DEF_RAMP_INPUT) ? SprayModel.VaryingFlowRate.DEF_RAMP_INPUT : this.fromLegacyRampInput(rate.d_pressureRamp.getDefaultInput());
            boolean convertedUnit = false;
            ArrayList<Ramp.Entry> newEntries = new ArrayList<Ramp.Entry>();
            for (Ramp.Entry entry : rate.d_pressureRamp.getRecords()) {
                UnitDouble f;
                if (entry.f.getUnit().equals(SI.PASCAL)) {
                    f = new UnitDouble(entry.f.getValueNoUnit(), NonSI.ATMOSPHERE);
                    convertedUnit = true;
                } else if (entry.f.getUnit().equals(NonSI.BAR)) {
                    double fval = entry.f.getValue(SI.PASCAL);
                    f = new UnitDouble(fval, NonSI.ATMOSPHERE);
                    convertedUnit = true;
                } else {
                    f = ConvertUtil.c(entry.f);
                }
                newEntries.add(new Ramp.Entry(ConvertUtil.c(entry.t), f));
            }
            if (convertedUnit) {
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Spray Model, %s, contained incorrectly stored Pipe Pressure Ramp units."), legSprayModel.getName()), String.format(Intl.intl("Attempted to auto-correct. Verify values for %s are correct."), legSprayModel.getName())));
            }
            return new SprayModel.VaryingFlowRate(new pyrosim.domain.ramp.Ramp(newEntries, defInput, input, 12), ConvertUtil.c(rate.d_opPressure), ConvertUtil.c(rate.d_kFactor), ConvertUtil.c(rate.d_rate), this.fromLegacyTimeFunc(rate.d_ramp));
        }
        return null;
    }

    private pyrosim.domain.devices.DeviceManager fromLegacyDevcMgr(DeviceManager legacy, pyrosim.domain.devices.DeviceManager newMgr, Serialized ser) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                DeviceManager oldSubComp = (DeviceManager)legObj;
                pyrosim.domain.devices.DeviceManager newSubComp = new pyrosim.domain.devices.DeviceManager(oldSubComp.getName());
                newMgr.add(this.fromLegacyDevcMgr(oldSubComp, newSubComp, ser));
                continue;
            }
            pyrosim.legacy_2012_1.domain.devices.IDevice legDevc = (pyrosim.legacy_2012_1.domain.devices.IDevice)legObj;
            IDevice newDev = this.fromLegacyDevc(legDevc, ser);
            if (newDev != null) {
                newMgr.add(newDev);
                continue;
            }
            this.addUnableToLoadWarn(legDevc.getName(), Intl.intl("device"));
        }
        return newMgr;
    }

    private IDevice fromLegacyDevc(pyrosim.legacy_2012_1.domain.devices.IDevice legacy, Serialized ser) {
        AlarmInfo oldAlarm;
        ADevice newDevice = null;
        if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.aspiration.Aspirator) {
            pyrosim.legacy_2012_1.domain.devices.aspiration.Aspirator aspirator = (pyrosim.legacy_2012_1.domain.devices.aspiration.Aspirator)legacy;
            newDevice = new Aspirator(aspirator.getName(), ConvertUtil.c(aspirator.getBypassFlowrate()), this.fromLegacyFreePoint(aspirator.getLocation()));
            for (Aspirator.SamplerLine legLine : aspirator.getSamplerLines()) {
                ((Aspirator)newDevice).setSamplerLine(this.fromLegacySampler(legLine));
            }
        } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.aspiration.AspiratorSampler) {
            newDevice = new AspiratorSampler(legacy.getName(), this.fromLegacyFreePoint(((pyrosim.legacy_2012_1.domain.devices.aspiration.AspiratorSampler)legacy).getLocation()));
        } else {
            pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc meas;
            pyrosim.legacy_2012_1.domain.devices.detectors.APointDetector detector;
            if (legacy instanceof CableFailDetector) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Cable Failure Detectors."), String.format(Intl.intl("Device %s removed. See FDS6 User's Guide section 15.3.8."), legacy.getName())));
                return null;
            }
            if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector) {
                detector = (pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector)legacy;
                newDevice = new HeatDetector(detector.getName(), null, this.fromLegacyFreePoint(detector.getLocation()));
                try {
                    this.registerForDelayLoad(newDevice, HeatDetector.class.getDeclaredField("d_link"), ((pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector)detector).getModel());
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            if (legacy instanceof SmokeDetector) {
                detector = (SmokeDetector)legacy;
                newDevice = new pyrosim.domain.devices.detectors.SmokeDetector(detector.getName(), null, this.fromLegacyFreePoint(detector.getLocation()));
                try {
                    this.registerForDelayLoad(newDevice, pyrosim.domain.devices.detectors.SmokeDetector.class.getDeclaredField("d_model"), ((SmokeDetector)detector).getModel());
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            if (legacy instanceof SprinklerLink) {
                detector = (SprinklerLink)legacy;
                newDevice = new pyrosim.domain.devices.detectors.SprinklerLink(detector.getName(), null, this.fromLegacyFreePoint(detector.getLocation()));
                try {
                    this.registerForDelayLoad(newDevice, pyrosim.domain.devices.detectors.SprinklerLink.class.getDeclaredField("d_linkDesc"), ((SprinklerLink)detector).getModel());
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.detectors.Timer) {
                pyrosim.legacy_2012_1.domain.devices.detectors.Timer timer = (pyrosim.legacy_2012_1.domain.devices.detectors.Timer)legacy;
                newDevice = new Timer(timer.getName(), ConvertUtil.c(timer.getAlarmInfo().setpoint), TripFlags.initiallyOn(timer.getAlarmInfo().tripFlags));
            } else if (legacy instanceof HvacDevice) {
                pyrosim.domain.quantity.IQuantity q;
                HvacDevice dev = (HvacDevice)legacy;
                if (legacy instanceof HvacDevice.DuctDevice) {
                    pyrosim.domain.quantity.IQuantity q2 = this.fromLegacyIQuant(dev.getQuantity());
                    if (q2 != null) {
                        newDevice = new DuctDevice(dev.getName(), q2);
                    }
                } else if (legacy instanceof HvacDevice.NodeDevice && (q = this.fromLegacyIQuant(dev.getQuantity())) != null) {
                    newDevice = new NodeDevice(dev.getName(), q);
                }
            } else if (legacy instanceof AABoxMeasurer) {
                meas = (AABoxMeasurer)legacy;
                pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(meas.getQuantity());
                if (q != null) {
                    newDevice = new pyrosim.domain.devices.measurers.AABoxMeasurer(meas.getName(), q, ConvertUtil.c(((AABoxMeasurer)meas).getBox()));
                }
            } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer) {
                meas = (pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer)legacy;
                pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(meas.getQuantity());
                if (q != null) {
                    newDevice = new FlowMeasurer(meas.getName(), q, (AARectangle)this.fromLegacyNode(((pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer)meas).getRect()).flatten().getLocalGeom(), ((pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer)meas).getFlowDir());
                }
            } else if (legacy instanceof GaugeHeatFluxMeasurer) {
                meas = (GaugeHeatFluxMeasurer)legacy;
                newDevice = new pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer(meas.getName(), ConvertUtil.c(((GaugeHeatFluxMeasurer)meas).getGaugeTemperature()), this.fromLegacyAttachPoint(((pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)meas).getAttachedLocation()));
            } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.measurers.InnerTempMeasurer) {
                meas = (pyrosim.legacy_2012_1.domain.devices.measurers.InnerTempMeasurer)legacy;
                newDevice = new InnerTempMeasurer(meas.getName(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.measurers.InnerTempMeasurer)meas).getDepth()), this.fromLegacyAttachPoint(((pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)meas).getAttachedLocation()));
            } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer) {
                pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer measurer = (pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer)legacy;
                newDevice = new LayerMeasurer(measurer.getName(), measurer.getHeightInfo().isEnabled(), measurer.getUpperTempInfo().isEnabled(), measurer.getLowerTempInfo().isEnabled(), ConvertUtil.c(measurer.getBeam()));
                for (int i = 0; i < measurer.getNumMeasurements(); ++i) {
                    AlarmInfo legInfo = measurer.getMsrInfo(i).getAlarmInfo();
                    if (legInfo == null) continue;
                    ((LayerMeasurer)newDevice).getMsrInfo(i).setAlarmInfo(this.fromLegacyAlarm(legInfo));
                }
            } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.measurers.PathObscurationMeasurer) {
                meas = (pyrosim.legacy_2012_1.domain.devices.measurers.PathObscurationMeasurer)legacy;
                newDevice = new PathObscurationMeasurer(meas.getName(), ConvertUtil.c(((ABeamMeasurer)meas).getBeam()));
            } else if (legacy instanceof PressureCoeffMeasurer) {
                meas = (PressureCoeffMeasurer)legacy;
                newDevice = new pyrosim.domain.devices.measurers.PressureCoeffMeasurer(meas.getName(), ConvertUtil.c(((PressureCoeffMeasurer)meas).getCharacteristicVel()), this.fromLegacyAttachPoint(((pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)meas).getAttachedLocation()));
            } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.measurers.SolidDensityMeasurer) {
                meas = (pyrosim.legacy_2012_1.domain.devices.measurers.SolidDensityMeasurer)legacy;
                pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(meas.getQuantity());
                if (q != null) {
                    newDevice = new SolidDensityMeasurer(meas.getName(), (pyrosim.domain.quantity.ObjectQuantity)q, this.fromLegacyAttachPoint(((pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)meas).getAttachedLocation()));
                }
            } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer) {
                meas = (pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)legacy;
                pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(meas.getQuantity());
                if (q != null) {
                    newDevice = new SolidPointMeasurer(meas.getName(), q, this.fromLegacyAttachPoint(((pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)meas).getAttachedLocation()));
                }
            } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple) {
                meas = (pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple)legacy;
                newDevice = new Thermocouple(meas.getName(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple)meas).getBeadDiameter()), ((pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple)meas).getEmissivity(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple)meas).getBeadDensity()), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple)meas).getBeadSpecHeat()), this.fromLegacyFreePoint(((pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer)meas).getLocation()));
            } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.measurers.Clock) {
                newDevice = Clock.INSTANCE;
            } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer) {
                meas = (pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer)legacy;
                pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(meas.getQuantity());
                if (q != null) {
                    newDevice = new GasPointMeasurer(meas.getName(), q, this.fromLegacyFreePoint(((pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer)meas).getLocation()));
                } else {
                    this.d_warnings.addWarning(new Warning(Intl.intl("FDS5 Extra Species, Other, cannot be converted."), String.format(Intl.intl("Gas-phase Device %s removed from model."), meas.getName())));
                }
            } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.simctrl.KillDevice) {
                newDevice = new KillDevice(legacy.getName());
            } else if (legacy instanceof pyrosim.legacy_2012_1.domain.devices.simctrl.RestartFileDevc) {
                newDevice = new RestartFileDevc(legacy.getName());
            } else if (legacy instanceof DryPipe) {
                DryPipe pipe = (DryPipe)legacy;
                newDevice = new pyrosim.domain.devices.sprayers.DryPipe(pipe.getName(), ConvertUtil.c(pipe.getDelay()));
            } else {
                if (legacy instanceof Nozzle) {
                    Nozzle nozzle = (Nozzle)legacy;
                    newDevice = new pyrosim.domain.devices.sprayers.Nozzle(nozzle.getName(), null, this.fromLegacyFreePoint(nozzle.getLocation()));
                    try {
                        this.registerForDelayLoad(newDevice, pyrosim.domain.devices.sprayers.Nozzle.class.getSuperclass().getDeclaredField("d_sprayDescription"), nozzle.getSprayModel());
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
                if (legacy instanceof Sprinkler) {
                    Sprinkler legSprinkler = (Sprinkler)legacy;
                    Sprinkler.LinkModel newLinkModel = this.fromLegacySprinklerLink(legSprinkler.getLinkModel());
                    if (newLinkModel == null) {
                        this.d_warnings.addWarning(new Warning(Intl.intl("FDS5 Extra Species, Other, cannot be converted."), String.format(Intl.intl("Sprinkler %s activation set to the default Sprinkler Link Model."), legSprinkler.getName())));
                        SprinklerLinkModel defLink = ser.sprkLinkModels.find("Default", SprinklerLinkModel.class, true);
                        if (defLink == null) {
                            defLink = new SprinklerLinkModel(Intl.intl("Legacy Default"));
                            ser.sprkLinkModels.add(defLink);
                        }
                        newLinkModel = new Sprinkler.TraditionalModel(defLink, false, true);
                    }
                    newDevice = new pyrosim.domain.devices.sprayers.Sprinkler(legSprinkler.getName(), null, newLinkModel, this.fromLegacyFreePoint(legSprinkler.getLocation()));
                    try {
                        this.registerForDelayLoad(newDevice, pyrosim.domain.devices.sprayers.Sprinkler.class.getDeclaredField("d_dryPipe"), legSprinkler.getDryPipe());
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                    try {
                        this.registerForDelayLoad(newDevice, pyrosim.domain.devices.sprayers.Sprinkler.class.getSuperclass().getDeclaredField("d_sprayDescription"), legSprinkler.getSprayModel());
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
            }
        }
        if (newDevice instanceof AMeasuringDevc && (oldAlarm = ((pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc)legacy).getMsrInfo().getAlarmInfo()) != null) {
            ((AMeasuringDevc)newDevice).getMsrInfo().setAlarmInfo(this.fromLegacyAlarm(oldAlarm));
        }
        if (newDevice instanceof APointDetector) {
            ((APointDetector)newDevice).setTripFlags(((pyrosim.legacy_2012_1.domain.devices.detectors.APointDetector)legacy).getTripFlags());
        }
        this.addToConnectionsMap(newDevice, legacy);
        this.makeAvailableForDelayLoad(newDevice, legacy);
        return newDevice;
    }

    private Aspirator.SamplerLine fromLegacySampler(Aspirator.SamplerLine legacy) {
        Aspirator.SamplerLine newLine = new Aspirator.SamplerLine(new AspiratorSampler(null, null), ConvertUtil.c(legacy.d_flowrate), ConvertUtil.c(legacy.d_delay));
        try {
            this.registerForDelayLoad(newLine, Aspirator.SamplerLine.class.getDeclaredField("d_sampler"), legacy.d_sampler);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return newLine;
    }

    private pyrosim.domain.devices.AlarmInfo fromLegacyAlarm(AlarmInfo legacy) {
        return new pyrosim.domain.devices.AlarmInfo(ConvertUtil.c(legacy.setpoint), legacy.tripFlags);
    }

    private Sprinkler.LinkModel fromLegacySprinklerLink(Sprinkler.LinkModel legacy) {
        if (legacy instanceof Sprinkler.TraditionalModel) {
            Sprinkler.TraditionalModel legacyModel = (Sprinkler.TraditionalModel)legacy;
            Sprinkler.TraditionalModel newModel = new Sprinkler.TraditionalModel(null, legacyModel.d_initState, legacyModel.d_latch);
            try {
                this.registerForDelayLoad(newModel, Sprinkler.TraditionalModel.class.getDeclaredField("d_link"), legacyModel.d_link);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            return newModel;
        }
        if (legacy instanceof Sprinkler.QuantityModel) {
            Sprinkler.QuantityModel legacyModel = (Sprinkler.QuantityModel)legacy;
            pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(legacyModel.d_quantity);
            if (q != null) {
                Sprinkler.QuantityModel newModel = new Sprinkler.QuantityModel(this.fromLegacyIQuant(legacyModel.d_quantity), ConvertUtil.c(legacyModel.d_setPoint), legacyModel.d_initState, legacyModel.d_latch);
                return newModel;
            }
        }
        return null;
    }

    private pyrosim.domain.geom.AttachedPointLoc fromLegacyAttachPoint(AttachedPointLoc legacy) {
        return legacy.fromLegacy(this.d_dictionary);
    }

    private FreePointLoc fromLegacyFreePoint(pyrosim.legacy_2012_1.domain.geom.FreePointLoc legacy) {
        return legacy.fromLegacy(this.d_dictionary);
    }

    private pyrosim.domain.output.Boundaries fromLegacyBound(Boundaries legacy, pyrosim.domain.output.Boundaries newBounds) {
        ArrayList<pyrosim.domain.quantity.IQuantity> newQuantities = new ArrayList<pyrosim.domain.quantity.IQuantity>();
        for (IQuantity oldQuantity : legacy.getQuantities()) {
            pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(oldQuantity);
            if (q == null) continue;
            newQuantities.add(this.fromLegacyIQuant(oldQuantity));
        }
        pyrosim.domain.quantity.IQuantity[] newQuantArray = newQuantities.toArray(new pyrosim.domain.quantity.IQuantity[newQuantities.size()]);
        newBounds = new pyrosim.domain.output.Boundaries(newQuantArray);
        newBounds.setGaugeTemperature(ConvertUtil.c(legacy.getGaugeTemperature()));
        newBounds.setPressCoeffCharVel(ConvertUtil.c(legacy.getPressCoeffCharVel()));
        newBounds.setVelocitySign(this.fromLegacyVeloSign(legacy.getVelocitySign()));
        this.makeAvailableForDelayLoad(newBounds, legacy);
        return newBounds;
    }

    private pyrosim.domain.output.IsosurfaceMgr fromLegacyIsoMgr(IsosurfaceMgr legacy, pyrosim.domain.output.IsosurfaceMgr newMgr) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                IsosurfaceMgr oldSubComp = (IsosurfaceMgr)legObj;
                pyrosim.domain.output.IsosurfaceMgr newSubComp = new pyrosim.domain.output.IsosurfaceMgr(oldSubComp.getName());
                newMgr.add(this.fromLegacyIsoMgr(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.domain.output.Isosurface iso = this.fromLegacyIsosurf((Isosurface)legObj);
            assert (iso != null);
            if (iso == null) continue;
            newMgr.add(this.fromLegacyIsosurf((Isosurface)legObj));
        }
        return newMgr;
    }

    private pyrosim.domain.output.Isosurface fromLegacyIsosurf(Isosurface legacy) {
        pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(legacy.getQuantity());
        if (q == null) {
            return null;
        }
        pyrosim.domain.output.Isosurface surf = new pyrosim.domain.output.Isosurface(this.fromLegacyIQuant(legacy.getQuantity()), ConvertUtil.c(legacy.getContours()));
        surf.setVelocitySign(this.fromLegacyVeloSign(legacy.getVelocitySign()));
        return surf;
    }

    private void addPredefSpecToDomain(pyrosim.domain.ExSpec spec) {
        if (!this.d_specList.contains(spec)) {
            this.d_specList.add(spec);
        }
    }

    private pyrosim.domain.quantity.IQuantity fromLegacyIQuant(IQuantity legacy) {
        if (legacy instanceof StaticQuantity) {
            Quantity type = legacy.get();
            pyrosim.domain.quantity.Quantity newType = this.fromLegacyQuant(type);
            ArrayList<pyrosim.domain.IPyroObject> newObjs = new ArrayList<pyrosim.domain.IPyroObject>();
            if (legacy instanceof ObjectQuantity) {
                ObjectQuantity legQuant = (ObjectQuantity)legacy;
                for (Object old : legQuant.objects) {
                    ExSpec legSpec;
                    DelayedRef dRef;
                    if (old instanceof ExSpec && old.isMixFracOnly()) {
                        if (old.equals(ExSpecList.MixFrac.OTHER.spec)) continue;
                        this.addPredefSpecToDomain((pyrosim.domain.ExSpec)this.d_delayLoadMap.get(old).get());
                    }
                    if ((dRef = this.d_delayLoadMap.get(old)) != null) {
                        newObjs.add((pyrosim.domain.IPyroObject)this.d_delayLoadMap.get(old).get());
                        continue;
                    }
                    if (!(old instanceof ExSpec) || !(legSpec = (ExSpec)old).isPredefined() || this.d_specList.get(legSpec.getName()) == null) continue;
                    newObjs.add(this.d_specList.get(legSpec.getName()));
                }
                if (!newObjs.isEmpty()) {
                    return newType.create(newObjs);
                }
            }
            if (newType != null && newType.requiredTypes.length == 0) {
                return newType.create();
            }
        }
        return null;
    }

    private pyrosim.domain.quantity.Quantity fromLegacyQuant(Quantity legacy) {
        if (legacy.equals((Object)Quantity.ABSORPTION_COEFFICIENT)) {
            return pyrosim.domain.quantity.Quantity.ABSORPTION_COEFFICIENT;
        }
        if (legacy.equals((Object)Quantity.ASPIRATION)) {
            return pyrosim.domain.quantity.Quantity.ASPIRATION;
        }
        if (legacy.equals((Object)Quantity.AVERAGE_SPECIFIC_HEAT)) {
            return pyrosim.domain.quantity.Quantity.AVERAGE_SPECIFIC_HEAT;
        }
        if (legacy.equals((Object)Quantity.CABLE_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.CABLE_TEMPERATURE;
        }
        if (legacy.equals((Object)Quantity.CONDUCTIVITY)) {
            return pyrosim.domain.quantity.Quantity.CONDUCTIVITY;
        }
        if (legacy.equals((Object)Quantity.DENSITY)) {
            return pyrosim.domain.quantity.Quantity.DENSITY;
        }
        if (legacy.equals((Object)Quantity.DIVERGENCE)) {
            return pyrosim.domain.quantity.Quantity.DIVERGENCE;
        }
        if (legacy.equals((Object)Quantity.ENTHALPY)) {
            return pyrosim.domain.quantity.Quantity.ENTHALPY;
        }
        if (legacy.equals((Object)Quantity.EXTINCTION_COEFFICIENT)) {
            return pyrosim.domain.quantity.Quantity.EXTINCTION_COEFFICIENT;
        }
        if (legacy.equals((Object)Quantity.FED)) {
            return pyrosim.domain.quantity.Quantity.FED;
        }
        if (legacy.equals((Object)Quantity.H)) {
            return pyrosim.domain.quantity.Quantity.H;
        }
        if (legacy.equals((Object)Quantity.HRRPUV)) {
            return pyrosim.domain.quantity.Quantity.HRRPUV;
        }
        if (legacy.equals((Object)Quantity.MIXTURE_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.MIXTURE_FRACTION;
        }
        if (legacy.equals((Object)Quantity.OPTICAL_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.OPTICAL_DENSITY;
        }
        if (legacy.equals((Object)Quantity.PRESSURE)) {
            return pyrosim.domain.quantity.Quantity.PRESSURE;
        }
        if (legacy.equals((Object)Quantity.RADIATIVE_HEAT_FLUX_GAS)) {
            return pyrosim.domain.quantity.Quantity.RADIATIVE_HEAT_FLUX_GAS;
        }
        if (legacy.equals((Object)Quantity.RELATIVE_HUMIDITY)) {
            return pyrosim.domain.quantity.Quantity.RELATIVE_HUMIDITY;
        }
        if (legacy.equals((Object)Quantity.SPECIFIC_ENTHALPY)) {
            return pyrosim.domain.quantity.Quantity.SPECIFIC_ENTHALPY;
        }
        if (legacy.equals((Object)Quantity.SPECIFIC_HEAT)) {
            return pyrosim.domain.quantity.Quantity.SPECIFIC_HEAT;
        }
        if (legacy.equals((Object)Quantity.TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.TEMPERATURE;
        }
        if (legacy.equals((Object)Quantity.THERMOCOUPLE)) {
            return pyrosim.domain.quantity.Quantity.THERMOCOUPLE;
        }
        if (legacy.equals((Object)Quantity.U_VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.U_VELOCITY;
        }
        if (legacy.equals((Object)Quantity.V_VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.V_VELOCITY;
        }
        if (legacy.equals((Object)Quantity.W_VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.W_VELOCITY;
        }
        if (legacy.equals((Object)Quantity.VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.VELOCITY;
        }
        if (legacy.equals((Object)Quantity.VISCOSITY)) {
            return pyrosim.domain.quantity.Quantity.VISCOSITY;
        }
        if (legacy.equals((Object)Quantity.VISIBILITY)) {
            return pyrosim.domain.quantity.Quantity.VISIBILITY;
        }
        if (legacy.equals((Object)Quantity.ADIABATIC_SURFACE_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.ADIABATIC_SURFACE_TEMPERATURE;
        }
        if (legacy.equals((Object)Quantity.BACK_WALL_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.BACK_WALL_TEMPERATURE;
        }
        if (legacy.equals((Object)Quantity.BURNING_RATE)) {
            return pyrosim.domain.quantity.Quantity.BURNING_RATE;
        }
        if (legacy.equals((Object)Quantity.CONVECTIVE_FLUX)) {
            return pyrosim.domain.quantity.Quantity.CONVECTIVE_FLUX;
        }
        if (legacy.equals((Object)Quantity.GAS_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.GAS_TEMPERATURE;
        }
        if (legacy.equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
            return pyrosim.domain.quantity.Quantity.GAUGE_HEAT_FLUX;
        }
        if (legacy.equals((Object)Quantity.HEAT_FLUX)) {
            return pyrosim.domain.quantity.Quantity.HEAT_FLUX;
        }
        if (legacy.equals((Object)Quantity.HEAT_TRANSFER_COEFFICIENT)) {
            return pyrosim.domain.quantity.Quantity.HEAT_TRANSFER_COEFFICIENT;
        }
        if (legacy.equals((Object)Quantity.INCIDENT_HEAT_FLUX)) {
            return pyrosim.domain.quantity.Quantity.INCIDENT_HEAT_FLUX;
        }
        if (legacy.equals((Object)Quantity.INSIDE_WALL_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.INSIDE_WALL_TEMPERATURE;
        }
        if (legacy.equals((Object)Quantity.MASS_LOSS)) {
            this.d_warnings.addWarning(new Warning(Intl.intl("The quantity MASS_LOSS no longer exists."), Intl.intl("Quantity removed from record.")));
            return null;
        }
        if (legacy.equals((Object)Quantity.NORMAL_VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.NORMAL_VELOCITY;
        }
        if (legacy.equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
            return pyrosim.domain.quantity.Quantity.PRESSURE_COEFFICIENT;
        }
        if (legacy.equals((Object)Quantity.RADIATIVE_FLUX)) {
            return pyrosim.domain.quantity.Quantity.RADIATIVE_FLUX;
        }
        if (legacy.equals((Object)Quantity.RADIOMETER)) {
            return pyrosim.domain.quantity.Quantity.RADIOMETER;
        }
        if (legacy.equals((Object)Quantity.SURFACE_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.SURFACE_DENSITY;
        }
        if (legacy.equals((Object)Quantity.WALL_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.WALL_TEMPERATURE;
        }
        if (legacy.equals((Object)Quantity.WALL_THICKNESS)) {
            return pyrosim.domain.quantity.Quantity.WALL_THICKNESS;
        }
        if (legacy.equals((Object)Quantity.HEAT_FLOW)) {
            return pyrosim.domain.quantity.Quantity.HEAT_FLOW;
        }
        if (legacy.equals((Object)Quantity.HRR)) {
            return pyrosim.domain.quantity.Quantity.HRR;
        }
        if (legacy.equals((Object)Quantity.MASS_FLOW)) {
            return pyrosim.domain.quantity.Quantity.MASS_FLOW;
        }
        if (legacy.equals((Object)Quantity.VOLUME_FLOW)) {
            return pyrosim.domain.quantity.Quantity.VOLUME_FLOW;
        }
        if (legacy.equals((Object)Quantity.LAYER_HEIGHT)) {
            return pyrosim.domain.quantity.Quantity.LAYER_HEIGHT;
        }
        if (legacy.equals((Object)Quantity.LOWER_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.LOWER_TEMPERATURE;
        }
        if (legacy.equals((Object)Quantity.PATH_OBSCURATION)) {
            return pyrosim.domain.quantity.Quantity.PATH_OBSCURATION;
        }
        if (legacy.equals((Object)Quantity.UPPER_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.UPPER_TEMPERATURE;
        }
        if (legacy.equals((Object)Quantity.ACTUATED_SPRINKLERS)) {
            return pyrosim.domain.quantity.Quantity.ACTUATED_SPRINKLERS;
        }
        if (legacy.equals((Object)Quantity.CPU_TIME)) {
            return pyrosim.domain.quantity.Quantity.CPU_TIME;
        }
        if (legacy.equals((Object)Quantity.ITERATION)) {
            return pyrosim.domain.quantity.Quantity.ITERATION;
        }
        if (legacy.equals((Object)Quantity.OPEN_NOZZLES)) {
            return pyrosim.domain.quantity.Quantity.OPEN_NOZZLES;
        }
        if (legacy.equals((Object)Quantity.PRESSURE_ZONE)) {
            return pyrosim.domain.quantity.Quantity.PRESSURE_ZONE;
        }
        if (legacy.equals((Object)Quantity.TIME)) {
            return pyrosim.domain.quantity.Quantity.TIME;
        }
        if (legacy.equals((Object)Quantity.TIME_STEP)) {
            return pyrosim.domain.quantity.Quantity.TIME_STEP;
        }
        if (legacy.equals((Object)Quantity.TURBULENCE_RESOLUTION)) {
            return pyrosim.domain.quantity.Quantity.TURBULENCE_RESOLUTION;
        }
        if (legacy.equals((Object)Quantity.WALL_CLOCK_TIME)) {
            return pyrosim.domain.quantity.Quantity.WALL_CLOCK_TIME;
        }
        if (legacy.equals((Object)Quantity.SPEC_MASS_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.SPEC_MASS_FRACTION;
        }
        if (legacy.equals((Object)Quantity.SPEC_VOLUME_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.SPEC_VOLUME_FRACTION;
        }
        if (legacy.equals((Object)Quantity.SPEC_MASS_FLUX_X)) {
            return pyrosim.domain.quantity.Quantity.SPEC_MASS_FLUX_X;
        }
        if (legacy.equals((Object)Quantity.SPEC_MASS_FLUX_Y)) {
            return pyrosim.domain.quantity.Quantity.SPEC_MASS_FLUX_Y;
        }
        if (legacy.equals((Object)Quantity.SPEC_MASS_FLUX_Z)) {
            return pyrosim.domain.quantity.Quantity.SPEC_MASS_FLUX_Z;
        }
        if (legacy.equals((Object)Quantity.SPEC_MASS_FLUX)) {
            return pyrosim.domain.quantity.Quantity.SPEC_MASS_FLUX;
        }
        if (legacy.equals((Object)Quantity.SPEC_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.SPEC_DENSITY;
        }
        if (legacy.equals((Object)Quantity.SPEC_VISIBILITY)) {
            return pyrosim.domain.quantity.Quantity.SPEC_VISIBILITY;
        }
        if (legacy.equals((Object)Quantity.SPEC_OPTICAL_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.SPEC_OPTICAL_DENSITY;
        }
        if (legacy.equals((Object)Quantity.MATL_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.MATL_DENSITY;
        }
        if (legacy.equals((Object)Quantity.MATL_SOLID_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.MATL_SOLID_DENSITY;
        }
        if (legacy.equals((Object)Quantity.PART_ACMPUA)) {
            return pyrosim.domain.quantity.Quantity.PART_ACMPUA;
        }
        if (legacy.equals((Object)Quantity.PART_CPUA)) {
            return pyrosim.domain.quantity.Quantity.PART_CPUA;
        }
        if (legacy.equals((Object)Quantity.PART_MASS_FLUX_X)) {
            return pyrosim.domain.quantity.Quantity.PART_MASS_FLUX_X;
        }
        if (legacy.equals((Object)Quantity.PART_MASS_FLUX_Y)) {
            return pyrosim.domain.quantity.Quantity.PART_MASS_FLUX_Y;
        }
        if (legacy.equals((Object)Quantity.PART_MASS_FLUX_Z)) {
            return pyrosim.domain.quantity.Quantity.PART_MASS_FLUX_Z;
        }
        if (legacy.equals((Object)Quantity.PART_MPUA)) {
            return pyrosim.domain.quantity.Quantity.PART_MPUA;
        }
        if (legacy.equals((Object)Quantity.PART_MPUV)) {
            return pyrosim.domain.quantity.Quantity.PART_MPUV;
        }
        if (legacy.equals((Object)Quantity.HVAC_AIRCOIL_HEAT_EXCHANGE)) {
            return pyrosim.domain.quantity.Quantity.HVAC_AIRCOIL_HEAT_EXCHANGE;
        }
        if (legacy.equals((Object)Quantity.HVAC_DUCT_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_DENSITY;
        }
        if (legacy.equals((Object)Quantity.HVAC_DUCT_MASS_FLOW)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_MASS_FLOW;
        }
        if (legacy.equals((Object)Quantity.HVAC_DUCT_MASS_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_MASS_FRACTION;
        }
        if (legacy.equals((Object)Quantity.HVAC_DUCT_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_TEMPERATURE;
        }
        if (legacy.equals((Object)Quantity.HVAC_DUCT_VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_VELOCITY;
        }
        if (legacy.equals((Object)Quantity.HVAC_DUCT_VOLUME_FLOW)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_VOLUME_FLOW;
        }
        if (legacy.equals((Object)Quantity.HVAC_DUCT_VOLUME_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_VOLUME_FRACTION;
        }
        if (legacy.equals((Object)Quantity.HVAC_FILTER_LOADING)) {
            return pyrosim.domain.quantity.Quantity.HVAC_FILTER_LOADING;
        }
        if (legacy.equals((Object)Quantity.HVAC_FILTER_LOSS)) {
            return pyrosim.domain.quantity.Quantity.HVAC_FILTER_LOSS;
        }
        if (legacy.equals((Object)Quantity.HVAC_NODE_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_DENSITY;
        }
        if (legacy.equals((Object)Quantity.HVAC_NODE_MASS_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_MASS_FRACTION;
        }
        if (legacy.equals((Object)Quantity.HVAC_NODE_PRESSURE)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_PRESSURE;
        }
        if (legacy.equals((Object)Quantity.HVAC_NODE_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_TEMPERATURE;
        }
        if (legacy.equals((Object)Quantity.HVAC_NODE_VOLUME_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_VOLUME_FRACTION;
        }
        if (legacy.equals((Object)Quantity.HVAC_NODE_PRESSURE_DIFFERENCE)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_PRESSURE_DIFFERENCE;
        }
        return null;
    }

    private VelocitySign fromLegacyVeloSign(pyrosim.legacy_2012_1.domain.quantity.VelocitySign legacy) {
        if (legacy == pyrosim.legacy_2012_1.domain.quantity.VelocitySign.ALWAYS_POSITIVE) {
            return VelocitySign.ALWAYS_POSITIVE;
        }
        if (legacy == pyrosim.legacy_2012_1.domain.quantity.VelocitySign.MATCH_U) {
            return VelocitySign.MATCH_U;
        }
        if (legacy == pyrosim.legacy_2012_1.domain.quantity.VelocitySign.MATCH_V) {
            return VelocitySign.MATCH_V;
        }
        if (legacy == pyrosim.legacy_2012_1.domain.quantity.VelocitySign.MATCH_W) {
            return VelocitySign.MATCH_W;
        }
        return null;
    }

    private pyrosim.domain.output.Plot3d fromLegacyPl3d(Plot3d legacy, pyrosim.domain.output.Plot3d newPlot3d) {
        ArrayList<pyrosim.domain.quantity.IQuantity> newQuantities = new ArrayList<pyrosim.domain.quantity.IQuantity>();
        for (IQuantity quant : legacy.getQuantities()) {
            pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(quant);
            if (q == null) continue;
            newQuantities.add(q);
        }
        newPlot3d.setQuantities(newQuantities);
        newPlot3d.setVelocitySign(this.fromLegacyVeloSign(legacy.getVelocitySign()));
        return newPlot3d;
    }

    /*
     * Enabled aggressive block sorting
     */
    private SliceList fromLegacySlcfList(pyrosim.legacy_2012_1.domain.output.SliceList legacy, SliceList newList) {
        Iterator<IPyroObject> iterator = legacy.getMembers().iterator();
        while (true) {
            Slice newSlice;
            block15: {
                pyrosim.domain.quantity.IQuantity q;
                pyrosim.legacy_2012_1.domain.output.Slice oldSlice;
                if (!iterator.hasNext()) {
                    return newList;
                }
                IPyroObject legObj = iterator.next();
                if (legObj instanceof Composite) {
                    pyrosim.legacy_2012_1.domain.output.SliceList oldSubComp = (pyrosim.legacy_2012_1.domain.output.SliceList)legObj;
                    SliceList newSubComp = new SliceList(oldSubComp.getName());
                    newList.add(this.fromLegacySlcfList(oldSubComp, newSubComp));
                    continue;
                }
                newSlice = null;
                if (legObj instanceof pyrosim.legacy_2012_1.domain.output.PlanarSlice) {
                    oldSlice = (pyrosim.legacy_2012_1.domain.output.PlanarSlice)legObj;
                    q = this.fromLegacyIQuant(oldSlice.getQuantity());
                    if (q != null) {
                        newSlice = new PlanarSlice(((pyrosim.legacy_2012_1.domain.output.PlanarSlice)oldSlice).getPlane(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.output.PlanarSlice)oldSlice).getLocation()), q, oldSlice.includeFlowVector(), false, q.getDescription());
                        break block15;
                    } else {
                        int axis = ((pyrosim.legacy_2012_1.domain.output.PlanarSlice)oldSlice).getPlane();
                        String planeName = null;
                        switch (axis) {
                            case 0: {
                                planeName = String.format(Intl.intl("X = %s"), ((pyrosim.legacy_2012_1.domain.output.PlanarSlice)oldSlice).getLocation().toString());
                                break;
                            }
                            case 1: {
                                planeName = String.format(Intl.intl("X = %s"), ((pyrosim.legacy_2012_1.domain.output.PlanarSlice)oldSlice).getLocation().toString());
                                break;
                            }
                            case 2: {
                                planeName = String.format(Intl.intl("X = %s"), ((pyrosim.legacy_2012_1.domain.output.PlanarSlice)oldSlice).getLocation().toString());
                                break;
                            }
                        }
                        this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unable to convert quantity %s"), oldSlice.getQuantity().getDescription()), String.format(Intl.intl("Slice %s at %s dropped."), oldSlice.getQuantity().getDescription(), planeName)));
                        continue;
                    }
                }
                if (legObj instanceof pyrosim.legacy_2012_1.domain.output.GridBoundarySlice) {
                    oldSlice = (pyrosim.legacy_2012_1.domain.output.GridBoundarySlice)legObj;
                    q = this.fromLegacyIQuant(oldSlice.getQuantity());
                    if (q != null) {
                        newSlice = new GridBoundarySlice(this.fromLegacyGrid(((pyrosim.legacy_2012_1.domain.output.GridBoundarySlice)oldSlice).getGrid()), ((pyrosim.legacy_2012_1.domain.output.GridBoundarySlice)oldSlice).getGridFace(), q, oldSlice.includeFlowVector(), false);
                    }
                } else {
                    oldSlice = (pyrosim.legacy_2012_1.domain.output.Slice)legObj;
                    q = this.fromLegacyIQuant(oldSlice.getQuantity());
                    if (q != null) {
                        newSlice = new Slice(q, oldSlice.includeFlowVector(), false, "Slice");
                    }
                }
            }
            if (newSlice == null) continue;
            newList.add(newSlice);
        }
    }

    private pyrosim.domain.output.ProfList fromLegacyProfList(ProfList legacy, pyrosim.domain.output.ProfList newList) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                ProfList oldSubComp = (ProfList)legObj;
                pyrosim.domain.output.ProfList newSubComp = new pyrosim.domain.output.ProfList(oldSubComp.getName());
                newList.add(this.fromLegacyProfList(oldSubComp, newSubComp));
                continue;
            }
            ProfRec convertedprof = this.fromLegacyProf((pyrosim.legacy_2012_1.domain.output.ProfRec)legObj);
            assert (convertedprof != null);
            newList.add(convertedprof);
        }
        return newList;
    }

    private ProfRec fromLegacyProf(pyrosim.legacy_2012_1.domain.output.ProfRec legacy) {
        pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(legacy.getQuantity());
        if (q != null) {
            return new ProfRec(legacy.getName(), legacy.getIOR(), this.fromLegacyIQuant(legacy.getQuantity()), ConvertUtil.c(legacy.getPoint()));
        }
        return null;
    }

    private StatisticMgr fromLegacyStatMgr(pyrosim.legacy_2012_1.domain.output.StatisticMgr legacy, StatisticMgr newMgr) {
        for (IPyroObject legObj : legacy.getMembers()) {
            if (legObj instanceof Composite) {
                pyrosim.legacy_2012_1.domain.output.StatisticMgr oldSubComp = (pyrosim.legacy_2012_1.domain.output.StatisticMgr)legObj;
                StatisticMgr newSubComp = new StatisticMgr(oldSubComp.getName());
                newMgr.add(this.fromLegacyStatMgr(oldSubComp, newSubComp));
                continue;
            }
            pyrosim.legacy_2012_1.domain.output.IMeasurementStat legStat = (pyrosim.legacy_2012_1.domain.output.IMeasurementStat)legObj;
            IMeasurementStat convertedStat = this.fromLegacyStat(legStat);
            assert (convertedStat != null);
            if (convertedStat != null) {
                newMgr.add(convertedStat);
                continue;
            }
            this.addUnableToLoadWarn(legStat.getName(), Intl.intl("statistic"));
        }
        return newMgr;
    }

    private IMeasurementStat fromLegacyStat(pyrosim.legacy_2012_1.domain.output.IMeasurementStat legacy) {
        AMsrStat newStat = null;
        if (legacy instanceof pyrosim.legacy_2012_1.domain.output.GasMsrStat) {
            pyrosim.legacy_2012_1.domain.output.GasMsrStat stat = (pyrosim.legacy_2012_1.domain.output.GasMsrStat)legacy;
            pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(stat.getQuantity());
            List<Long> stats = stat.getStats().stream().map(Long::valueOf).collect(Collectors.toList());
            if (q != null) {
                newStat = new GasMsrStat(stat.getName(), q, this.fromLegacyNode(stat.getGeom()).flatten().getLocalGeom(), stats);
            }
        } else if (legacy instanceof SolidMsrStat) {
            SolidMsrStat stat = (SolidMsrStat)legacy;
            ArrayList<Surface> newSurfs = new ArrayList<Surface>();
            for (pyrosim.legacy_2012_1.domain.boundcond.surf.Surface surf : stat.getSurfaces()) {
                newSurfs.add((Surface)this.d_delayLoadMap.get(surf).get());
            }
            pyrosim.domain.quantity.IQuantity q = this.fromLegacyIQuant(stat.getQuantity());
            List<Long> stats = stat.getStats().stream().map(Long::valueOf).collect(Collectors.toList());
            if (q != null) {
                newStat = new pyrosim.domain.output.SolidMsrStat(stat.getName(), q, this.fromLegacyNode(stat.getGeom()).flatten().getLocalGeom(), newSurfs, stats);
            }
        }
        return newStat;
    }

    private IGeomNode fromLegacyNode(IGeom lgeom, ITexCoordGenerator luv) {
        IGeomNode geom = this.fromLegacyNode(lgeom);
        IElemSource<Point2d> uv = this.fromLegacyElem(luv);
        return geom.applyUVElements("uvset", (i, oe) -> uv.getPrimSource((int)i)).prune();
    }

    private IGeomNode fromLegacyNode(IGeom legacy) {
        if (legacy instanceof StatGeom.GridGeom) {
            StatGeom.GridGeom legStatGeom = (StatGeom.GridGeom)legacy;
            StatGeom.GridGeom newGeom = new StatGeom.GridGeom(null);
            try {
                this.registerForDelayLoad(newGeom, StatGeom.GridGeom.class.getDeclaredField("grid"), legStatGeom.grid);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            return GeomNodeUtil.newNode(newGeom);
        }
        Object result = this.d_dictionary.get(legacy);
        if (result instanceof thunderheadeng.geometry.objs.IGeom) {
            return GeomNodeUtil.newNode((thunderheadeng.geometry.objs.IGeom)result);
        }
        if (result instanceof IGeomNode) {
            return (IGeomNode)result;
        }
        return null;
    }

    private thunderheadeng.scene3d.geom.IPropsSrc fromLegacyProp(IPropsSrc leg) {
        return (thunderheadeng.scene3d.geom.IPropsSrc)this.d_dictionary.get(leg);
    }

    private IElemSource<Point2d> fromLegacyElem(ITexCoordGenerator leg) {
        return (IElemSource)this.d_dictionary.get(leg);
    }

    private Image fromLegacyImage(pyrosim.legacy_2012_1.thunderheadeng.image.Image leg) {
        return (Image)this.d_dictionary.get(leg);
    }

    private pyrosim.domain.rasterization.RasterizationOptions fromLegacyRaster(RasterizationOptions legacy, pyrosim.domain.rasterization.RasterizationOptions newOpts) {
        newOpts = new pyrosim.domain.rasterization.RasterizationOptions(true, legacy.largeBlocks, legacy.mergeIdentical, legacy.separateDisconnected, legacy.ignoreMergeNames, legacy.forceThicken, legacy.geomGroups, legacy.rasterizeAligned);
        return newOpts;
    }

    private MaterialDB fromLegacyMatlDB(TextureDB legacy, MaterialDB newDB) {
        for (pyrosim.domain.appearance.Material mat : this.d_appearanceCache.getAddedMaterials()) {
            newDB.add(mat);
        }
        return newDB;
    }

    private pyrosim.domain.appearance.Material toMaterial(Color diffColor, pyrosim.legacy_2012_1.domain.texture.Texture tex, TextureInfo legInfo) {
        Image img = this.fromLegacyImage(tex.getImage());
        return this.toMaterial(diffColor, img, legInfo);
    }

    private pyrosim.domain.appearance.Material toMaterial(Color diffColor, IImage img, TextureInfo legInfo) {
        Texture diffTex = Texture.repeated(img, "uvset");
        MatAttrs attrs = new MatAttrs(IMatAttrs.DIFFUSE_TEXTURE, diffTex);
        attrs = attrs.applyColorToDiffuseAndOpacity(diffColor);
        pyrosim.domain.appearance.Material result = new pyrosim.domain.appearance.Material(legInfo.getTexID(), attrs, ConvertUtil.c(legInfo.getWidth()), ConvertUtil.c(legInfo.getHeight()));
        return this.d_appearanceCache.add(result);
    }

    private pyrosim.domain.FDSRun fromLegacyRunConfig(FDSRun legacy, pyrosim.domain.FDSRun newRun) {
        if (legacy.mode == FDSRun.Mode.SINGLE) {
            newRun = new pyrosim.domain.FDSRun(FDSRun.Mode.SINGLE, legacy.fdsFilepath);
        } else if (legacy.mode == FDSRun.Mode.PARALLEL) {
            newRun = new pyrosim.domain.FDSRun(FDSRun.Mode.PARALLEL, legacy.fdsFilepath);
        } else if (legacy.mode == FDSRun.Mode.CLUSTER) {
            newRun = new pyrosim.domain.FDSRun(FDSRun.Mode.CLUSTER, legacy.fdsFilepath);
        }
        return newRun;
    }

    private FDSClusterOptions fromLegacyClusterConfig(pyrosim.legacy_2012_1.domain.FDSClusterOptions legacy, FDSClusterOptions newOptions) {
        if (legacy == null) {
            return null;
        }
        newOptions = new FDSClusterOptions(legacy.lastFDSLocation, legacy.hosts);
        return newOptions;
    }

    private ResultsArchive fromLegacyResultArch(pyrosim.legacy_2012_1.domain.ResultsArchive legacy, ResultsArchive newArchive) {
        for (ResultsArchive.Record rec : legacy.getAllRecords()) {
            ResultsArchive.IMethod method = null;
            if (rec.method instanceof ResultsArchive.Directory) {
                method = ResultsArchive.DIRECTORY;
            } else if (rec.method instanceof ResultsArchive.Uncompressed) {
                method = ResultsArchive.UNCOMPRESSED;
            } else if (rec.method instanceof ResultsArchive.Compressed) {
                method = ResultsArchive.COMPRESSED;
            }
            newArchive.addArchive(new ResultsArchive.Record(rec.name, method, rec.dateCreated));
        }
        return newArchive;
    }

    private void addUnableToLoadWarn(String objName, String objType) {
        this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unable to load %s %s."), objType, objName), String.format(Intl.intl("%s removed from the model."), objName)));
    }

    private void warnOnMixFrac(pyrosim.legacy_2012_1.domain.Serialized ser) {
        if (!ser.simParams.getMisc().getForceMixFracFlag()) {
            return;
        }
        ArrayList<IPyroObject> objs = new ArrayList<IPyroObject>();
        objs.add(ser.simParams);
        objs.addAll(ser.obstructions.flatten());
        objs.addAll(ser.grids.flatten());
        objs.addAll(Util.sort(ser.zones));
        objs.addAll(Util.sort(ser.exSpecs));
        Reaction activeReac = ser.reactions.getActiveReaction();
        if (activeReac != null) {
            objs.add(activeReac);
        }
        objs.addAll(ser.devices.flatten());
        objs.add(ser.boundaryOutput);
        objs.add(ser.plot3d);
        objs.addAll(ser.isosurfaces.flatten());
        objs.addAll(ser.profs.flatten());
        objs.addAll(ser.slices.flatten());
        objs.addAll(ser.msrStats.flatten());
        objs.addAll(ser.hvacSystem.flatten());
        DepSnapshot deps = FDSRenderer.collectDependedOns(objs);
        objs.addAll(deps.getAllDependedOn());
        boolean mixFracNeeded = false;
        boolean mixFracInvoked = false;
        for (IPyroObject obj : objs) {
            if (obj.invokesMixFrac()) {
                mixFracInvoked = true;
            }
            if (obj.isMixFracOnly()) {
                mixFracNeeded = true;
            }
            if (!mixFracInvoked || !mixFracNeeded) continue;
            break;
        }
        if (mixFracNeeded && !mixFracInvoked) {
            this.d_warnings.addWarning(new Warning(Intl.intl("Writing a generic burner surface to force a reaction is no longer required in PyroSim."), Intl.intl("The Force Mixture Fraction Model flag has been removed.")));
        }
    }

    private void sortManagers(Serialized ser) {
        ArrayList<pyrosim.domain.Composite> allGroups = new ArrayList<pyrosim.domain.Composite>(Hierarchy.flatten(PyroMod.getMembers(ser, true), pyrosim.domain.Composite.class));
        for (pyrosim.domain.Composite group : allGroups) {
            Class type = group.getType();
            if (type.isAssignableFrom(pyrosim.domain.geom.FDSObject.class) || type.isAssignableFrom(Grid.class) || !INamed.class.isAssignableFrom(type)) continue;
            List<pyrosim.domain.IPyroObject> members = pyrosim.util.Util.sort(group.getMembers());
            group.reorder(members);
        }
    }
}

