/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.Set;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.evac.Exit;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class ExitRenderer
extends AFDS6Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Exit.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Grid flowFieldId;
        Grid ventFfield;
        Exit e = (Exit)o;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("EXIT");
        rec.setValue("ID", e.getName());
        rec.setValue("FYI", e.getProp("FYI"), false);
        UnitDouble[] xb = (UnitDouble[])e.getProp("XB");
        UnitAABox xbBox = new UnitAABox(new UnitPoint3D(xb[0], xb[2], xb[4]), new UnitPoint3D(xb[1], xb[3], xb[5]));
        ExitRenderer.renderXB(rec, "XB", xbBox.getMin(), xbBox.getMax());
        Boolean countOnly = (Boolean)e.getProp("COUNT_ONLY");
        rec.setValue("COUNT_ONLY", countOnly, false);
        Color c = (Color)e.getProp("RGB");
        ExitRenderer.renderColor(rec, true, c, "RGB", "COLOR", null);
        UnitDouble[] xyz = (UnitDouble[])e.getProp("XYZ");
        if (xyz != null) {
            UnitPoint3D xyzPt = new UnitPoint3D(xyz[0], xyz[1], xyz[2]);
            AFDS6Renderer.renderLoc(rec, "XYZ", xyzPt);
        }
        Integer ior = (Integer)e.getProp("IOR");
        rec.setValue("IOR", ior, false);
        Grid meshId = (Grid)e.getProp("MESH_ID");
        if (meshId != null) {
            rec.setValue("MESH_ID", meshId.getName());
        }
        if ((ventFfield = (Grid)e.getProp("VENT_FFIELD")) != null) {
            rec.setValue("VENT_FFIELD", ventFfield.getName());
        }
        if ((flowFieldId = (Grid)e.getProp("FLOW_FIELD_ID")) != null) {
            rec.setValue("FLOW_FIELD_ID", flowFieldId.getName());
        }
        UnitDouble timeOpen = (UnitDouble)e.getProp("TIME_OPEN");
        rec.setValue("TIME_OPEN", timeOpen);
        UnitDouble timeClose = (UnitDouble)e.getProp("TIME_CLOSE");
        rec.setValue("TIME_CLOSE", timeClose);
        props.render(rec, o);
        return true;
    }
}

