/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import pyrosim.Intl;
import pyrosim.domain.SimParams;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IPropertySet;

public class SimParamsParser
extends AFDS6Parser {
    private int d_obstDefaults = 16;
    private static String s_prefSmokeNamelist = "SM3D";

    public SimParamsParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    public int getObstDefaults() {
        return this.d_obstDefaults;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("HEAD");
        types.add("MISC");
        types.add("TIME");
        types.add("DUMP");
        types.add("RADI");
        types.add("PRES");
        types.add("WIND");
        types.add("COMB");
        types.add("CLIP");
        types.add("SM3D");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        if (type.equals("MISC")) {
            unsupportedFields.put("ASSUMED_GAS_TEMPERATURE", "UNSUPPORTED");
            unsupportedFields.put("NOISE", "UNSUPPORTED");
            unsupportedFields.put("SOLID_PHASE_ONLY", "UNSUPPORTED");
            unsupportedFields.put("ALLOW_SURFACE_PARTICLES", "UNSUPPORTED");
            unsupportedFields.put("ASSUMED_GAS_TEMPERATURE_RAMP", "UNSUPPORTED");
            unsupportedFields.put("CNF_CUTOFF", "UNSUPPORTED");
            unsupportedFields.put("CONSTANT_SPECIFIC_HEAT_RATIO", "UNSUPPORTED");
            unsupportedFields.put("CFL_VELOCITY_NORM", "UNSUPPORTED");
            unsupportedFields.put("CHECK_HT", "UNSUPPORTED");
            unsupportedFields.put("CHECK_VN", "UNSUPPORTED");
            unsupportedFields.put("CLIP_MASS_FRACTION", "UNSUPPORTED");
            unsupportedFields.put("C_DEARDORFF", "UNSUPPORTED");
            unsupportedFields.put("C_VREMAN", "UNSUPPORTED");
            unsupportedFields.put("DRIFT_FLUX", "UNSUPPORTED");
            unsupportedFields.put("DT_MEAN_FORCING", "UNSUPPORTED");
            unsupportedFields.put("FLUX_LIMITER", "UNSUPPORTED");
            unsupportedFields.put("FORCE_VECTOR", "UNSUPPORTED");
            unsupportedFields.put("GAMMA", "UNSUPPORTED");
            unsupportedFields.put("GRAVITATIONAL_DEPOSITION", "UNSUPPORTED");
            unsupportedFields.put("GRAVITATIONAL_SETTLING", "UNSUPPORTED");
            unsupportedFields.put("LES_FILTER_WIDTH", "UNSUPPORTED");
            unsupportedFields.put("MAX_LEAK_PATHS", "UNSUPPORTED");
            unsupportedFields.put("MEAN_FORCING", "UNSUPPORTED");
            unsupportedFields.put("MPI_TIMEOUT", "UNSUPPORTED");
            unsupportedFields.put("NOISE_VELOCITY", "UNSUPPORTED");
            unsupportedFields.put("OVERWRITE", "UNSUPPORTED");
            unsupportedFields.put("PARTICLE_CFL", "UNSUPPORTED");
            unsupportedFields.put("PARTICLE_CFL_MAX", "UNSUPPORTED");
            unsupportedFields.put("PROJECTION", "UNSUPPORTED");
            unsupportedFields.put("RICHARDSON_ERROR_TOLERANCE", "UNSUPPORTED");
            unsupportedFields.put("RUN_AVG_FAC", "UNSUPPORTED");
            unsupportedFields.put("SECOND_ORDER_INTERPOLATED_BOUNDARY", "UNSUPPORTED");
            unsupportedFields.put("SHARED_FILE_SYSTEM", "UNSUPPORTED");
            unsupportedFields.put("SMOKE_ALBEDO", "UNSUPPORTED");
            unsupportedFields.put("STRATIFICATION", "UNSUPPORTED");
            unsupportedFields.put("THERMOPHORETIC_DEPOSITION", "UNSUPPORTED");
            unsupportedFields.put("NO_EVACUATION", "UNSUPPORTED");
            unsupportedFields.put("MAX_CHEMISTRY_ITERATIONS", "UNSUPPORTED");
            unsupportedFields.put("TURBULENCE_MODEL", "UNSUPPORTED");
            unsupportedFields.put("TURBULENT_DEPOSITION", "UNSUPPORTED");
            unsupportedFields.put("DT_HVAC", "FDS Version 6.7");
            unsupportedFields.put("EVACUATION_DRILL", "UNSUPPORTED");
            unsupportedFields.put("EVACUATION_MC_MODE", "UNSUPPORTED");
            unsupportedFields.put("EVAC_PRESSURE_ITERATIONS", "UNSUPPORTED");
            unsupportedFields.put("EVAC_SURF_DEFAULT", "UNSUPPORTED");
            unsupportedFields.put("EVAC_TIME_ITERATIONS", "UNSUPPORTED");
        } else if (type.equals("DUMP")) {
            unsupportedFields.put("FLUSH_FILE_BUFFERS", "UNSUPPORTED");
            unsupportedFields.put("CLIP_RESTART_FILES", "UNSUPPORTED");
            unsupportedFields.put("CTRL_COLUMN_LIMIT", "UNSUPPORTED");
            unsupportedFields.put("DEBUG", "UNSUPPORTED");
            unsupportedFields.put("DEVC_COLUMN_LIMIT", "UNSUPPORTED");
            unsupportedFields.put("DT_CTRL", "UNSUPPORTED");
            unsupportedFields.put("DT_DEVC_LINE", "UNSUPPORTED");
            unsupportedFields.put("DT_FLUSH", "UNSUPPORTED");
            unsupportedFields.put("EB_PART_FILE", "UNSUPPORTED");
            unsupportedFields.put("SIG_FIGS", "UNSUPPORTED");
            unsupportedFields.put("SIG_FIGS_EXP", "UNSUPPORTED");
            unsupportedFields.put("STATUS_FILES", "UNSUPPORTED");
            unsupportedFields.put("TIMING", "UNSUPPORTED");
            unsupportedFields.put("UVW_TIMER", "UNSUPPORTED");
            unsupportedFields.put("VELOCITY_ERROR_FILE", "UNSUPPORTED");
        } else if (type.equals("TIME")) {
            unsupportedFields.put("SHRINK_FACTOR", "UNSUPPORTED");
            unsupportedFields.put("SYNCHRONIZE", "FDS Version 6.3");
        } else if (type.equals("RADI")) {
            unsupportedFields.put("BAND_LIMITS", "UNSUPPORTED");
            unsupportedFields.put("MIE_MAXIMUM_DIAMETER", "UNSUPPORTED");
            unsupportedFields.put("MIE_MINIMUM_DIAMETER", "UNSUPPORTED");
            unsupportedFields.put("MIE_NDG", "UNSUPPORTED");
            unsupportedFields.put("RADIATIVE_FRACTION", "FDS Version 6.3");
        } else if (!type.equals("PRES")) {
            if (type.equals("WIND")) {
                unsupportedFields.put("INITIALIZATION_ONLY", "UNSUPPORTED");
                unsupportedFields.put("STRATIFICATION", "UNSUPPORTED");
                unsupportedFields.put("SPONGE_CELLS", "UNSUPPORTED");
                unsupportedFields.put("DT_MEAN_FORCING", "UNSUPPORTED");
            } else if (type.equals("CLIP")) {
                unsupportedFields.put("MAXIMUM_DENSITY", "UNSUPPORTED");
                unsupportedFields.put("MINIMUM_DENSITY", "UNSUPPORTED");
                unsupportedFields.put("MAXIMUM_TEMPERATURE", "UNSUPPORTED");
                unsupportedFields.put("MINIMUM_TEMPERATURE", "UNSUPPORTED");
            } else if (type.equals("COMB")) {
                unsupportedFields.put("AIT_EXCLUSION_ZONE", "UNSUPPORTED");
                unsupportedFields.put("AUTO_IGNITION_TEMPERATURE", "UNSUPPORTED");
                unsupportedFields.put("CHECK_REALIZABILITY", "UNSUPPORTED");
                unsupportedFields.put("EXTINCTION_MODEL", "UNSUPPORTED");
                unsupportedFields.put("FIXED_MIX_TIME", "UNSUPPORTED");
                unsupportedFields.put("FREE_BURN_TEMPERATURE", "UNSUPPORTED");
                unsupportedFields.put("FUEL_C_TO_CO_FRACTION", "UNSUPPORTED");
                unsupportedFields.put("FUEL_H_TO_H2_FRACTION", "UNSUPPORTED");
                unsupportedFields.put("MAX_CHEMISTRY_SUBSTEPS", "UNSUPPORTED");
                unsupportedFields.put("N_FIXED_CHEMISTRY_SUBSTEPS", "UNSUPPORTED");
                unsupportedFields.put("N_SIMPLE_CHEMISTRY_REACTIONS", "UNSUPPORTED");
                unsupportedFields.put("ODE_SOLVER", "UNSUPPORTED");
                unsupportedFields.put("RADIATIVE_FRACTION", "UNSUPPORTED");
                unsupportedFields.put("RICHARDSON_ERROR_TOLERANCE", "UNSUPPORTED");
                unsupportedFields.put("TAU_CHEM", "UNSUPPORTED");
                unsupportedFields.put("TAU_FLAME", "UNSUPPORTED");
            }
        }
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        if (rec.getType().equals("HEAD")) {
            return this.processHead(rec);
        }
        if (rec.getType().equals("MISC")) {
            return this.processMisc(rec);
        }
        if (rec.getType().equals("TIME")) {
            return this.processTime(rec);
        }
        if (rec.getType().equals("DUMP")) {
            return this.processDump(rec);
        }
        if (rec.getType().equals("SM3D")) {
            return this.processSM3D(rec);
        }
        if (rec.getType().equals("RADI")) {
            return this.processRadi(rec);
        }
        if (rec.getType().equals("WIND")) {
            return this.processWind(rec);
        }
        if (rec.getType().equals("COMB")) {
            return this.processComb(rec);
        }
        if (rec.getType().equals("CLIP")) {
            return this.processClip(rec);
        }
        if (rec.getType().equals("PRES")) {
            return this.processPres(rec);
        }
        return true;
    }

    private boolean processHead(FDSParseRecord rec) throws FDSRecordFormatException {
        SimParams params = this.getContainer().getSimParams();
        String title = rec.getString("TITLE");
        if (title != null) {
            params.setJobTitle(title);
        }
        this.flagObjectAdded(params);
        return true;
    }

    private boolean processTime(FDSParseRecord rec) throws FDSRecordFormatException {
        this.parseCustomFDSProps(this.getContainer().getSimParams(), rec);
        SimParams.Time time = this.getContainer().getSimParams().getTime();
        time.setTimeStepLocks(rec.getBoolean("LOCK_TIME_STEP", true), rec.getBoolean("RESTRICT_TIME_STEP", true));
        time.setInitTimeStep(rec.getUnitDouble("DT", true));
        time.setStartTime(rec.getUnitDouble("T_BEGIN", true));
        time.setStopTime(rec.getUnitDouble("T_END", true));
        time.setWallIncrement(rec.getInteger("WALL_INCREMENT", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private boolean processClip(FDSParseRecord rec) throws FDSRecordFormatException {
        this.parseCustomFDSProps(this.getContainer().getSimParams(), rec);
        return true;
    }

    private boolean processMisc(FDSParseRecord rec) throws FDSRecordFormatException {
        FDSArray<UnitDouble> texList;
        this.parseCustomFDSProps(this.getContainer().getSimParams(), rec);
        SimParams.Calculations calc = this.getContainer().getSimParams().getCalculations();
        SimParams.Calculations.SimulationMode mode = null;
        if (!rec.contains("SIMULATION_MODE") && rec.contains("DNS")) {
            if (rec.getBoolean("DNS").booleanValue()) {
                mode = SimParams.Calculations.SimulationMode.DNS;
            }
        } else if (mode == null) {
            String simModeStr = rec.getString("SIMULATION_MODE", true);
            for (SimParams.Calculations.SimulationMode sm : SimParams.Calculations.SimulationMode.values()) {
                if (!simModeStr.equals(sm.simpleName)) continue;
                mode = sm;
                break;
            }
            if (mode == null) {
                this.addWarning(rec, String.format(Intl.intl("Unknown value %s entered for field %s."), simModeStr, "SIMULATION_MODE"), String.format(Intl.intl("Default value, %s, will be used instead."), "VLES"));
                mode = SimParams.Calculations.SimulationMode.VLES;
            }
        }
        calc.setSimMode(mode);
        Boolean baroclinic = rec.getBoolean("BAROCLINIC", false);
        SimParams.Calculations.BaroclinicState baroState = SimParams.Calculations.BaroclinicState.AUTO;
        if (baroclinic != null) {
            baroState = baroclinic != false ? SimParams.Calculations.BaroclinicState.TRUE : SimParams.Calculations.BaroclinicState.FALSE;
        }
        calc.setBaroclinicState(baroState);
        calc.setCflRange(rec.getDouble("CFL_MIN", true), rec.getDouble("CFL_MAX", true));
        calc.setCsmag(rec.getDouble("C_SMAGORINSKY", true));
        calc.setPrandtlNum(rec.getDouble("PR", true));
        calc.setSchmidtNum(rec.getDouble("SC", true));
        calc.setVnRange(rec.getDouble("VN_MIN", true), rec.getDouble("VN_MAX", true));
        SimParams.Environment env = this.getContainer().getSimParams().getEnvironment();
        this.readGravity(env, rec);
        env.setRelHumidity(rec.getUnitDouble("HUMIDITY", true));
        env.setAmbPressure(rec.getUnitDouble("P_INF", true));
        env.setAmbTemp(rec.getUnitDouble("TMPA", true));
        env.setAmbMFO2(rec.getUnitDouble("Y_O2_INFTY", true));
        env.setAmbMFCO2(rec.getUnitDouble("Y_CO2_INFTY", true));
        env.setMaxVisibility(rec.getUnitDouble("MAXIMUM_VISIBILITY", true));
        env.setVisibilityFactor(rec.getDouble("VISIBILITY_FACTOR", true));
        SimParams.Wind wind = this.getContainer().getSimParams().getWind();
        UnitDouble groundLevel = rec.getUnitDouble("GROUND_LEVEL", false);
        if (groundLevel != null) {
            wind.set(SimParams.Wind.GROUND_LEVEL, groundLevel);
        }
        SimParams.Particles par = this.getContainer().getSimParams().getParticles();
        par.setPourousFloor(rec.getBoolean("POROUS_FLOOR", true));
        par.setAllowUndersideDroplets(rec.getBoolean("ALLOW_UNDERSIDE_PARTICLES", true));
        SimParams.Misc misc = this.getContainer().getSimParams().getMisc();
        String evacSurfKey = rec.getString("EVAC_SURF_DEFAULT", true);
        if (evacSurfKey != null) {
            Surface evacSurf = this.findObject(Surface.class, evacSurfKey);
            if (evacSurf == null) {
                throw new FDSRecordFormatException(rec, "The specified default surface, \"" + evacSurfKey + ",\" does not exist.");
            }
            misc.setEvacProp("EVAC_SURF_DEFAULT", evacSurf);
        }
        if ((texList = rec.getArray("TEXTURE_ORIGIN", true)) != null) {
            misc.setTextureOrigin(new UnitPoint3D(texList.toFlatArray(new UnitDouble[3])));
        }
        boolean bndfDef = rec.getBoolean("BNDF_DEFAULT", true);
        boolean thickenDef = rec.getBoolean("THICKEN_OBSTRUCTIONS", true);
        this.d_obstDefaults = bndfDef ? (this.d_obstDefaults |= 0x10) : (this.d_obstDefaults &= 0xFFFFFFEF);
        this.d_obstDefaults = thickenDef ? (this.d_obstDefaults |= 1) : (this.d_obstDefaults &= 0xFFFFFFFE);
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private boolean processComb(FDSParseRecord rec) throws FDSRecordFormatException {
        SimParams.Calculations calc = this.getContainer().getSimParams().getCalculations();
        calc.setInitUnmixedFraction(rec.getDouble("INITIAL_UNMIXED_FRACTION", true));
        SimParams.Misc misc = this.getContainer().getSimParams().getMisc();
        Boolean suppression = rec.getBoolean("SUPPRESSION", false);
        if (suppression == null) {
            misc.setSuppression(SimParams.Misc.SUPPRESSION.AUTO);
        } else {
            misc.setSuppression(suppression != false ? SimParams.Misc.SUPPRESSION.TRUE : SimParams.Misc.SUPPRESSION.FALSE);
        }
        this.parseCustomFDSProps(this.getContainer().getSimParams(), rec);
        return true;
    }

    private void readGravity(SimParams.Environment env, FDSParseRecord rec) {
        Variant[] gravity = this.parseVectorVariant(rec, "GVEC", "RAMP_GX", "RAMP_GY", "RAMP_GZ", 6, false, false);
        env.setGravityAccel(gravity[0], gravity[1], gravity[2]);
    }

    private Ramp readRamp(String rampKey, int unitType, FDSParseRecord rec) {
        IRampInput rampInput;
        String rampId = rec.getString(rampKey);
        FDS6ParsingInfo.RampInfo rampInfo = this.getParsingInfo().getRampInfo(rampId);
        Ramp r = null;
        if (rampInfo != null && (rampInput = SimParamsParser.getRampInput(rampInfo)) != null) {
            r = this.getParsingInfo().getRamp(rampId, rampInput, unitType, false);
        }
        if (r == null) {
            String warn = String.format(Intl.intl("Unable to read RAMP record \"%s\"."), rampId);
            this.addWarning(rec, warn, Intl.intl("Ramp Ignored"));
        }
        return r;
    }

    private static IRampInput getRampInput(FDS6ParsingInfo.RampInfo rampInfo) {
        if (rampInfo.rec.contains("T")) {
            return RampInputs.TIME;
        }
        if (rampInfo.rec.contains("X")) {
            return RampInputs.XPOS;
        }
        if (rampInfo.rec.contains("Z")) {
            return RampInputs.ZPOS;
        }
        return null;
    }

    private boolean processRadi(FDSParseRecord rec) throws FDSRecordFormatException {
        this.parseCustomFDSProps(this.getContainer().getSimParams(), rec);
        SimParams.RadiationTransport radi = this.getContainer().getSimParams().getRadiTransport();
        radi.setRadiationOn(rec.getBoolean("RADIATION", true));
        radi.setAngleIncrement(rec.getInteger("ANGLE_INCREMENT", true));
        radi.setConstAbsorptionCoef(rec.getUnitDouble("KAPPA0", true));
        radi.setNumPolarAngles(rec.getInteger("NMIEANG", true));
        radi.setNumSolidAngles(rec.getInteger("NUMBER_RADIATION_ANGLES", true));
        radi.setRadCalcPathLen(rec.getUnitDouble("PATH_LENGTH", true));
        radi.setAssumedRadSourceTemp(rec.getUnitDouble("RADTMP", true));
        radi.setTimeStepInc(rec.getInteger("TIME_STEP_INCREMENT", true));
        radi.setNonGrayGasAssumption(rec.getBoolean("WIDE_BAND_MODEL", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private boolean processWind(FDSParseRecord rec) throws FDSRecordFormatException {
        this.parseCustomFDSProps(this.getContainer().getSimParams(), rec);
        SimParams.Wind wind = this.getContainer().getSimParams().getWind();
        this.parseWindProfile(rec, wind);
        this.parseWindSpeed(rec, wind);
        this.parseWindForce(rec, wind);
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private boolean processPres(FDSParseRecord rec) throws FDSRecordFormatException {
        this.parseCustomFDSProps(this.getContainer().getSimParams(), rec);
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private void parseWindForce(FDSParseRecord rec, SimParams.Wind wind) {
        Variant[] force = this.parseVectorVariant(rec, "FORCE_VECTOR", "RAMP_FVX_T", "RAMP_FVY_T", "RAMP_FVZ_T", 92, true, true);
        wind.set(SimParams.Wind.FORCEX, force[0]);
        wind.set(SimParams.Wind.FORCEY, force[1]);
        wind.set(SimParams.Wind.FORCEZ, force[2]);
    }

    private Variant[] parseVectorVariant(FDSParseRecord rec, String constKey, String rampKeyX, String rampKeyY, String rampKeyZ, int unitType, boolean fracRampSupported, boolean defVarSupported) {
        FDSArray<UnitDouble> constVal = rec.getArray(constKey, false);
        FDSArray defConstVal = rec.getArray(constKey, true);
        UnitDouble[] constArr = constVal.toFlatArray(new UnitDouble[3]);
        Variant[] result = new Variant[3];
        BiConsumer<String, Integer> setForceRamp = (k, m) -> {
            Variant var;
            variantArray[m.intValue()] = var = this.parseVecComponent(rec, constArr[m], (UnitDouble)defConstVal.get((int)m), (String)k, unitType, fracRampSupported, defVarSupported);
        };
        setForceRamp.accept(rampKeyX, 0);
        setForceRamp.accept(rampKeyY, 1);
        setForceRamp.accept(rampKeyZ, 2);
        return result;
    }

    private Variant parseVecComponent(FDSParseRecord rec, UnitDouble constComp, UnitDouble defConstComp, String rampKey, int unitType, boolean fracRampSupported, boolean defVarSupported) {
        Ramp r;
        if (rec.contains(rampKey) && (r = this.readRamp(rampKey, fracRampSupported ? 28 : unitType, rec)) != null) {
            if (constComp == null) {
                constComp = defConstComp;
            }
            if (fracRampSupported) {
                return Variant.fracRamp(constComp, r);
            }
            r = r.scaleF(constComp.getValue(SIUS.unit(unitType)));
            return Variant.ramp(r);
        }
        if (constComp != null) {
            return Variant.constant(constComp);
        }
        if (!defVarSupported) {
            return Variant.constant(defConstComp);
        }
        return Variant.def();
    }

    private void parseWindProfile(FDSParseRecord rec, SimParams.Wind wind) {
        wind.set(SimParams.Wind.ZREF, rec.getUnitDouble("Z_REF", true));
        wind.set(SimParams.Wind.USTAR, rec.getUnitDouble("U_STAR", true));
        wind.set(SimParams.Wind.THETASTAR, rec.getUnitDouble("THETA_STAR", true));
        wind.set(SimParams.Wind.Z0, rec.getUnitDouble("Z_0", true));
        wind.set(SimParams.Wind.L, rec.getUnitDouble("L", true));
        wind.set(SimParams.Wind.LAPSE_RATE, rec.getUnitDouble("LAPSE_RATE", true));
        wind.set(SimParams.Wind.TMP0Z_RAMP, this.readRampOrDefault(rec, "RAMP_TMP0_Z", 28));
        UnitDouble groundLevel = rec.getUnitDouble("GROUND_LEVEL", false);
        if (groundLevel != null) {
            wind.set(SimParams.Wind.GROUND_LEVEL, groundLevel);
        }
    }

    private void parseWindSpeed(FDSParseRecord rec, SimParams.Wind wind) {
        SimParams.Wind.InitSpeedOptions initSpeedOpt = !rec.contains("U0") && !rec.contains("V0") || rec.getUnitDouble("SPEED", true).gt(SIUS.newud(0.0, 8), 0.0) || rec.contains("U_STAR") && rec.getUnitDouble("U_STAR").gt(SIUS.newud(0.0, 8), 0.0) ? SimParams.Wind.InitSpeedOptions.SPEED : SimParams.Wind.InitSpeedOptions.UV;
        wind.set(SimParams.Wind.INITSPEEDOPT, initSpeedOpt);
        wind.set(SimParams.Wind.SPEED, rec.getUnitDouble("SPEED", true));
        BiFunction<String, String, String> chooseKey = (oldKey, newKey) -> {
            if (rec.contains((String)newKey) && rec.contains((String)oldKey)) {
                this.addWarning(rec, String.format(Intl.intl("%1$s has been renamed to %2$s."), oldKey, newKey), String.format(Intl.intl("Ignoring %s"), oldKey));
                return newKey;
            }
            return !rec.contains((String)newKey) && rec.contains((String)oldKey) ? oldKey : newKey;
        };
        String speedRampKey = chooseKey.apply("RAMP_SPEED", "RAMP_SPEED_T");
        wind.set(SimParams.Wind.SPEED_RAMP_T, this.readRampOrDefault(rec, speedRampKey, 8));
        wind.set(SimParams.Wind.DIRECTION, rec.getUnitDouble("DIRECTION", true));
        String speedDirKey = chooseKey.apply("RAMP_DIRECTION", "RAMP_DIRECTION_T");
        wind.set(SimParams.Wind.DIRECTION_RAMP_T, this.readRampOrDefault(rec, speedDirKey, 29));
        this.parseVectorWindComponent(wind, rec, SimParams.Wind.U0, "U0", SimParams.Wind.U0T, "RAMP_U0_T", SimParams.Wind.U0Z, "RAMP_U0_Z");
        this.parseVectorWindComponent(wind, rec, SimParams.Wind.V0, "V0", SimParams.Wind.V0T, "RAMP_V0_T", SimParams.Wind.V0Z, "RAMP_V0_Z");
        this.parseVectorWindComponent(wind, rec, SimParams.Wind.W0, "W0", SimParams.Wind.W0T, "RAMP_W0_T", SimParams.Wind.W0Z, "RAMP_W0_Z");
    }

    private void parseVectorWindComponent(SimParams.Wind wind, FDSParseRecord rec, IPropertySet.Prop<UnitDouble> constProp, String constKey, IPropertySet.Prop<Variant> rampTProp, String rampTKey, IPropertySet.Prop<Variant> rampZProp, String rampZKey) {
        wind.set(constProp, rec.getUnitDouble(constKey, true));
        wind.set(rampTProp, this.readRampOrDefault(rec, rampTKey, 28));
        wind.set(rampZProp, this.readRampOrDefault(rec, rampZKey, 28));
    }

    private Variant readRampOrDefault(FDSParseRecord rec, String key, int unit) {
        Ramp r;
        if (rec.contains(key) && (r = this.readRamp(key, unit, rec)) != null) {
            return Variant.ramp(r);
        }
        return Variant.def();
    }

    private boolean processSM3D(FDSParseRecord rec) throws FDSRecordFormatException {
        this.tryParseCustomSmoke(rec, "QUANTITY", "SPEC_ID");
        return true;
    }

    private boolean processDump(FDSParseRecord rec) throws FDSRecordFormatException {
        this.parseCustomFDSProps(this.getContainer().getSimParams(), rec);
        SimParams.FileOutput fout = this.getContainer().getSimParams().getFileOutput();
        fout.setSuppressDiagnostics(rec.getBoolean("SUPPRESS_DIAGNOSTICS", true));
        fout.setLimitCSVColumns(rec.getBoolean("COLUMN_DUMP_LIMIT", true));
        fout.setHrrGasOnly(rec.getBoolean("HRR_GAS_ONLY", true));
        fout.setDtBoundaryFile(rec.getUnitDouble("DT_BNDF", true));
        fout.setDtDeviceFiles(rec.getUnitDouble("DT_DEVC", true));
        fout.setDtHeatReleaseRateFiles(rec.getUnitDouble("DT_HRR", true));
        fout.setDtIsofFiles(rec.getUnitDouble("DT_ISOF", true));
        fout.setDtMassFiles(rec.getUnitDouble("DT_MASS", true));
        fout.setDtParticleFiles(rec.getUnitDouble("DT_PART", true));
        fout.setDtPlot3dFile(rec.getUnitDouble("DT_PL3D", true));
        fout.setDtProfileDumpInterval(rec.getUnitDouble("DT_PROF", true));
        fout.setDtRestartFile(rec.getUnitDouble("DT_RESTART", true));
        fout.setDtSliceFiles(rec.getUnitDouble("DT_SLCF", true));
        fout.setNumOutputFrames(rec.getInteger("NFRAMES", true));
        fout.setVisualize3dSmoke(rec.getBoolean("SMOKE3D", true));
        fout.setWriteSpeciesMassFile(rec.getBoolean("MASS_FILE", true));
        fout.setDtSlice3dFiles(rec.getUnitDouble("DT_SL3D", true));
        this.tryParseCustomSmoke(rec, "SMOKE3D_QUANTITY", "SMOKE3D_SPEC_ID");
        SimParams.Particles par = this.getContainer().getSimParams().getParticles();
        par.setMaxParticlesPerMesh(rec.getInteger("MAXIMUM_PARTICLES", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private void tryParseCustomSmoke(FDSParseRecord rec, String quantKey, String specKey) throws FDSRecordFormatException {
        if (!rec.contains(quantKey) && !rec.contains(specKey)) {
            return;
        }
        SimParams.FileOutput fout = this.getContainer().getSimParams().getFileOutput();
        boolean alreadyDefined = fout.getSmokeQuantity() != null;
        boolean isPrefNamelist = s_prefSmokeNamelist.equals(rec.getSpec().rectype);
        if (alreadyDefined && !isPrefNamelist) {
            this.addWarning(rec, Intl.intl("Smoke3D definition found in multiple locations."), Intl.intl("Ignoring redundant Smoke3D definition."));
        } else if (alreadyDefined && isPrefNamelist) {
            boolean validSmoke;
            IQuantity smokeQuant = this.parseQuantity(rec, quantKey, null, specKey, null, null, null, 0L, Intl.intl("Ignoring custom smoke."), false, false, false);
            boolean bl = validSmoke = smokeQuant != null && SimParams.FileOutput.isValidSmokeQuantity(smokeQuant.get());
            if (!validSmoke) {
                this.addWarning(rec, Intl.intl("Smoke3D definition found in multiple locations."), Intl.intl("Ignoring invalid Smoke3D."));
            } else {
                fout.setSmokeQuantity(smokeQuant);
                this.addWarning(rec, Intl.intl("Smoke3D definition found in multiple locations."), String.format(Intl.intl("Using Smoke3D definition found in preferred namelist, %s."), s_prefSmokeNamelist));
            }
        } else {
            IQuantity smokeQuant = this.parseQuantity(rec, quantKey, null, specKey, null, null, null, 0L, Intl.intl("Ignoring custom smoke."), true, false, true);
            if (smokeQuant != null) {
                boolean validSmoke;
                boolean bl = validSmoke = smokeQuant != null && SimParams.FileOutput.isValidSmokeQuantity(smokeQuant.get());
                if (validSmoke) {
                    fout.setSmokeQuantity(smokeQuant);
                } else {
                    this.addWarning(rec, Intl.intl("Unsupported Smoke3D Quantity found."), Intl.intl("Ignoring custom Smoke3D."));
                }
            }
        }
    }
}

