/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.units.UnitDouble;

public class ReactionParser
extends AFDS6Parser {
    private Map<FDSParseRecord, Reaction> d_reactions = new HashMap<FDSParseRecord, Reaction>();

    public ReactionParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("REAC");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("AIT_EXCLUSION_ZONE", "UNSUPPORTED");
        unsupportedFields.put("EQUATION", "UNSUPPORTED");
        unsupportedFields.put("FUEL_RADCAL_ID", "UNSUPPORTED");
        unsupportedFields.put("HRRPUA_SHEET", "FDS Version 6.3");
        unsupportedFields.put("HRRPUV_AVERAGE", "FDS Version 6.3");
        unsupportedFields.put("A", "UNSUPPORTED");
        unsupportedFields.put("E", "UNSUPPORTED");
        unsupportedFields.put("N_S", "UNSUPPORTED");
        unsupportedFields.put("SPEC_ID_N_S", "UNSUPPORTED");
        unsupportedFields.put("N_T", "UNSUPPORTED");
        unsupportedFields.put("CHECK_ATOM_BALANCE", "UNSUPPORTED");
        unsupportedFields.put("REAC_ATOM_ERROR", "UNSUPPORTED");
        unsupportedFields.put("REAC_MASS_ERROR", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        int exists;
        String id = this.parseName(rec, "ID", Reaction.class);
        Reaction reac = new Reaction(id, false, Reaction.ReacType.SIMPLE);
        reac.setFYI(rec.getString("FYI", false));
        this.parseCustomFDSProps(reac, rec);
        this.parseFuel(rec, reac);
        this.parseSuppression(rec, reac);
        this.parseByProducts(rec, reac);
        if (rec.contains("SPEC_ID_NU") && rec.contains("NU")) {
            reac.setReacType(Reaction.ReacType.COMPLEX);
            ExSpecList specList = this.getContainer().getExSpecList();
            List specNames = rec.getList("SPEC_ID_NU", false);
            List fracs = rec.getList("NU", false);
            List specs = ((Stream)specNames.stream().sequential()).map(name -> ReactionParser.getKnownSpec(specList, name)).collect(Collectors.toList());
            int nullIx = 0;
            while (nullIx != -1) {
                nullIx = specs.indexOf(null);
                if (nullIx == -1) continue;
                specs.remove(nullIx);
                fracs.remove(nullIx);
                String badSpec = (String)specNames.remove(nullIx);
                this.addWarning(rec, String.format(Intl.intl("Unable to parse dependent species %s."), badSpec), String.format(Intl.intl("Unparsed species, %s, will be dropped from the reaction chemistry."), badSpec));
            }
            int mapSize = Math.min(specNames.size(), fracs.size());
            if (specNames.size() != fracs.size()) {
                int numDropped = Math.abs(specNames.size() - fracs.size());
                this.addWarning(rec, String.format(Intl.intl("An inconsistent number of values for %s and %s detected."), "NU", "SPEC_ID_NU"), String.format(Intl.intl("%d mismatched values will be ignored."), numDropped));
            }
            Map<ExSpec, Double> chemMap = IntStream.range(0, mapSize).boxed().collect(Collectors.toMap(specs::get, fracs::get));
            reac.setComplexStoichiometry(chemMap);
            ReactionParser.collectAdvancedFields(rec, reac);
        }
        if ((exists = this.existsStatus(rec, reac, Reaction.class)) != 0) {
            return this.convertToReturn(exists);
        }
        ReactionList reacs = this.getContainer().getReactions();
        reacs.add(reac);
        this.flagObjectAdded(reac);
        reacs.setActiveReaction(reac);
        this.d_reactions.put(rec, reac);
        return true;
    }

    private void parseFuel(FDSParseRecord rec, Reaction reac) {
        reac.setFuel(this.getFuelSpec(rec));
        double H = 0.0;
        double C = 0.0;
        double O = 0.0;
        double N = 0.0;
        if (rec.contains("FORMULA")) {
            HashMap<Character, Integer> pairMap = new HashMap<Character, Integer>();
            String origStr = rec.getString("FORMULA");
            char[] original = origStr.toCharArray();
            int i = 0;
            while (i < original.length) {
                if (Character.isLetter(original[i])) {
                    int numIxBegin;
                    char letter = original[i];
                    int numIxEnd = numIxBegin = i + 1;
                    int numIxIter = numIxBegin;
                    while (numIxIter < origStr.length() && Character.isDigit(original[numIxIter])) {
                        numIxEnd = ++numIxIter;
                    }
                    int digits = Integer.parseInt(origStr.substring(numIxBegin, numIxEnd));
                    pairMap.put(Character.valueOf(letter), digits);
                    i = numIxIter;
                    continue;
                }
                ++i;
            }
            for (Map.Entry pair : pairMap.entrySet()) {
                if (((Character)pair.getKey()).charValue() == 'H' || ((Character)pair.getKey()).charValue() == 'h') {
                    H = ((Integer)pair.getValue()).intValue();
                    continue;
                }
                if (((Character)pair.getKey()).charValue() == 'C' || ((Character)pair.getKey()).charValue() == 'c') {
                    C = ((Integer)pair.getValue()).intValue();
                    continue;
                }
                if (((Character)pair.getKey()).charValue() == 'O' || ((Character)pair.getKey()).charValue() == 'o') {
                    O = ((Integer)pair.getValue()).intValue();
                    continue;
                }
                if (((Character)pair.getKey()).charValue() != 'N' && ((Character)pair.getKey()).charValue() != 'n') continue;
                N = ((Integer)pair.getValue()).intValue();
            }
        } else {
            H = rec.getDouble("H", true);
            C = rec.getDouble("C", true);
            O = rec.getDouble("O", true);
            N = rec.getDouble("N", true);
        }
        if (!ExSpecList.isPredefinedSpecies(reac.getFuel().getName())) {
            reac.setFuelComp(H, C, O, N);
        } else {
            HashMap<String, String> newProps = new HashMap<String, String>();
            if (H > 0.0) {
                newProps.put("H", Double.toString(H));
            }
            if (C > 0.0) {
                newProps.put("C", Double.toString(C));
            }
            if (O > 0.0) {
                newProps.put("O", Double.toString(O));
            }
            if (N > 0.0) {
                newProps.put("N", Double.toString(N));
            }
            reac.setCustomFDSProps(CustomFDSProps.union(CustomFDSProps.get(newProps), reac.getCustomFDSProps()));
        }
    }

    private void parseSuppression(FDSParseRecord rec, Reaction reac) {
        if (rec.contains("CRITICAL_FLAME_TEMPERATURE") || rec.contains("AUTO_IGNITION_TEMPERATURE")) {
            reac.setSuppression(true);
        }
        reac.setCritFlameTemp(rec.getUnitDouble("CRITICAL_FLAME_TEMPERATURE", true));
        reac.setAutoIgnitionTemp(rec.getUnitDouble("AUTO_IGNITION_TEMPERATURE", true));
    }

    private void parseByProducts(FDSParseRecord rec, Reaction reac) {
        reac.setCOYield(rec.getDouble("CO_YIELD", true));
        reac.setSootYield(rec.getDouble("SOOT_YIELD", true));
        reac.setHCNYield(rec.getDouble("HCN_YIELD", true));
        UnitDouble hoc = rec.getUnitDouble("HEAT_OF_COMBUSTION", true);
        UnitDouble epumo2 = rec.getUnitDouble("EPUMO2", true);
        reac.setEpumo2(epumo2);
        if (hoc == null) {
            reac.setHeatOfCombustion(null);
            reac.setEnergyType(Reaction.EnergyRelease.EPUMO2);
        } else {
            reac.setHeatOfCombustion(hoc);
            reac.setEnergyType(Reaction.EnergyRelease.HEAT_OF_COMBUSTION);
        }
        reac.setSootHFraction(rec.getDouble("SOOT_H_FRACTION", true));
        reac.setIdeal(rec.getBoolean("IDEAL", true));
        reac.setRadiativeFraction(rec.getUnitDouble("RADIATIVE_FRACTION", true));
    }

    private ExSpec getFuelSpec(FDSParseRecord rec) {
        ExSpecList specs = this.getContainer().getExSpecList();
        String fuelName = rec.getString("FUEL", true);
        if (fuelName == null) {
            return ExSpecList.getDefaultFuel(true);
        }
        ExSpec fuelSpec = specs.get(fuelName);
        if (fuelSpec != null) {
            return fuelSpec;
        }
        boolean isPredef = ExSpecList.isPredefinedSpecies(fuelName);
        if (isPredef) {
            ExSpec predefSpec = new ExSpec(ExSpecList.getPredefinedSpecies(fuelName));
            predefSpec.setType(1);
            specs.add(predefSpec);
            return predefSpec;
        }
        specs.setReacDefaultAlias(fuelName);
        return ExSpecList.getDefaultFuel(this.getContainer().getExSpecList(), this.getContainer().getNames(ExSpec.class), true);
    }

    private static ExSpec getKnownSpec(ExSpecList specs, String name) {
        ExSpec fuelSpec = specs.get(name);
        if (fuelSpec != null) {
            return fuelSpec;
        }
        boolean isPredef = ExSpecList.isPredefinedSpecies(name);
        if (isPredef) {
            ExSpec predefSpec = new ExSpec(ExSpecList.getPredefinedSpecies(name));
            predefSpec.setType(1);
            specs.add(predefSpec);
            return predefSpec;
        }
        return null;
    }

    private void addImplicitSpecs() {
        ExSpecList specs = this.getContainer().getExSpecList();
        specs.addImplicitSpecs();
    }

    private static void collectAdvancedFields(FDSParseRecord rec, Reaction reac) {
        List keysOfInterest = Stream.of("CRITICAL_FLAME_TEMPERATURE", "AUTO_IGNITION_TEMPERATURE", "EPUMO2", "RADIATIVE_FRACTION").collect(Collectors.toList());
        HashMap<String, String> newProps = new HashMap<String, String>();
        for (String key : keysOfInterest) {
            Object value = rec.get(key, false);
            String result = "";
            if (value == null) continue;
            if (value instanceof String) {
                result = "'" + value + "'";
            } else if (value instanceof Integer) {
                result = Integer.toString((Integer)value);
            } else if (value instanceof Double) {
                result = Double.toString((Double)value);
            } else if (value instanceof UnitDouble) {
                Unit u = ((FDSRecordSpec.UnitDoubleFld)rec.getSpec().fields.get((Object)key)).unit;
                double dblVal = ((UnitDouble)value).get(u);
                result = Double.toString(dblVal);
            }
            newProps.put(key, result);
        }
        reac.setCustomFDSProps(CustomFDSProps.union(CustomFDSProps.get(newProps), reac.getCustomFDSProps()));
    }
}

