/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class IsofParser
extends AFDS6Parser {
    public IsofParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("ISOF");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("REDUCE_TRIANGLES", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        IQuantity measurement = this.parseQuantity(rec, "QUANTITY", null, "SPEC_ID", null, null, null, 32L, Intl.intl("ISOF ignored"), true, false, true);
        if (measurement == null) {
            return false;
        }
        Unit unit = SIUS.unit(measurement.get().unitType);
        List<UnitDouble> values = rec.getUnitDoubleList("VALUE", unit, false);
        if (values == null) {
            this.addWarning(rec, Intl.intl("No values specified for ISOF record."), Intl.intl("ISOF record ignored"));
            return false;
        }
        Isosurface isof = this.getContainer().getIsofList().getIso(measurement);
        if (isof == null) {
            isof = new Isosurface(measurement, values);
            this.getContainer().getIsofList().add(isof);
        } else {
            values.addAll(isof.getContours());
            isof.setContours(values);
        }
        if (measurement.get().equals((Object)Quantity.VELOCITY)) {
            int veloIndex = rec.getInteger("VELO_INDEX", true);
            VelocitySign vs = this.parseVelocitySign(rec, veloIndex);
            isof.setVelocitySign(vs);
        }
        this.flagObjectAdded(isof);
        return true;
    }
}

