/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.util.Pair;

public class QuantityMap {
    public static final String CONTROL = "CONTROL";
    public static final String LINK_TEMPERATURE = "LINK TEMPERATURE";
    public static final String SPOT_OBSCURATION = "spot obscuration";
    public static final String CHAMBER_OBSCURATION = "CHAMBER OBSCURATION";
    public static final String SPRINKLER_LINK_TEMPERATURE = "SPRINKLER LINK TEMPERATURE";
    public static final String ASPIRATION = "ASPIRATION";
    public static final String HEAT_FLOW = "HEAT FLOW";
    public static final String MASS_FLOW = "MASS FLOW";
    public static final String VOLUME_FLOW = "VOLUME FLOW";
    public static final String CABLE_TEMPERATURE = "CABLE TEMPERATURE";
    public static final String FDS_TIME = "TIME";
    private final Map<Quantity, String> d_pyroToFDSMap = new HashMap<Quantity, String>();
    private final Map<String, IQuantity> d_fdsToPyroPredefMap = new HashMap<String, IQuantity>();
    private final Map<String, Quantity> d_fdsToPyroObjMap = new HashMap<String, Quantity>();
    private final List<Pair<String, Quantity>> d_fdsToPyroLegPostfixMap = new ArrayList<Pair<String, Quantity>>();
    private final Map<String, IQuantity> d_fdsToPyroPredefFlowMap = new HashMap<String, IQuantity>();
    private final Map<String, Quantity> d_fdsToPyroObjFlowMap = new HashMap<String, Quantity>();
    private final Map<Quantity, Map<Byte, Quantity>> d_legacyFlowMap = new HashMap<Quantity, Map<Byte, Quantity>>();

    public QuantityMap() {
        this.mapPredef(Quantity.ABSORPTION_COEFFICIENT, "ABSORPTION COEFFICIENT", "ABSORPTION_COEFFICIENT");
        this.mapPredef(Quantity.ADIABATIC_SURFACE_TEMPERATURE_GAS, "ADIABATIC SURFACE TEMPERATURE GAS");
        this.mapPredef(Quantity.AVERAGE_SPECIFIC_HEAT, "AVERAGE SPECIFIC HEAT");
        this.mapPredef(Quantity.BACKGROUND_PRESSURE, "BACKGROUND PRESSURE");
        this.mapPredef(Quantity.CONDUCTIVITY, "CONDUCTIVITY");
        this.mapPredef(Quantity.DENSITY, "DENSITY");
        this.mapPredef(Quantity.DIVERGENCE, "DIVERGENCE");
        this.mapPredef(Quantity.ENTHALPY, "ENTHALPY");
        this.mapPredef(Quantity.SENSIBLE_ENTHALPY, "SENSIBLE ENTHALPY");
        this.mapPredef(Quantity.EXTINCTION_COEFFICIENT, "EXTINCTION COEFFICIENT", "extinction coefficient");
        this.mapPredef(Quantity.FED, "FED");
        this.mapPredef(Quantity.FIC, "FIC");
        this.mapPredef(Quantity.H, "H");
        this.mapPredef(Quantity.HRRPUA, "HRRPUA");
        this.mapPredef(Quantity.HRRPUV, "HRRPUV");
        this.mapPredef(Quantity.MIXTURE_FRACTION, "MIXTURE FRACTION", "MIXTURE_FRACTION");
        this.mapPredef(Quantity.OPTICAL_DENSITY, "OPTICAL DENSITY");
        this.mapPredef(Quantity.PRESSURE, "PRESSURE");
        this.mapPredef(Quantity.RADIATIVE_HEAT_FLUX_GAS, "RADIATIVE HEAT FLUX GAS");
        this.mapPredef(Quantity.GAUGE_HEAT_FLUX_GAS, "GAUGE HEAT FLUX GAS");
        this.mapPredef(Quantity.RELATIVE_HUMIDITY, "RELATIVE HUMIDITY");
        this.mapPredef(Quantity.SPECIFIC_ENTHALPY, "SPECIFIC ENTHALPY");
        this.mapPredef(Quantity.SPECIFIC_SENSIBLE_ENTHALPY, "SPECIFIC SENSIBLE ENTHALPY");
        this.mapPredef(Quantity.SPECIFIC_HEAT, "SPECIFIC HEAT");
        this.mapPredef(Quantity.TEMPERATURE, "TEMPERATURE");
        this.mapPredef(Quantity.THERMOCOUPLE, "THERMOCOUPLE");
        this.mapPredef(Quantity.U_VELOCITY, "U-VELOCITY");
        this.mapPredef(Quantity.V_VELOCITY, "V-VELOCITY");
        this.mapPredef(Quantity.W_VELOCITY, "W-VELOCITY");
        this.mapPredef(Quantity.VELOCITY, "VELOCITY");
        this.mapPredef(Quantity.VISCOSITY, "VISCOSITY");
        this.mapPredef(Quantity.VISIBILITY, "VISIBILITY", "visibility");
        this.mapPredef(Quantity.ADIABATIC_SURFACE_TEMPERATURE, "ADIABATIC SURFACE TEMPERATURE", "ADIABATIC_SURFACE_TEMPERATURE");
        this.mapPredef(Quantity.BACK_WALL_TEMPERATURE, "BACK WALL TEMPERATURE", "BACK_WALL_TEMPERATURE");
        this.mapPredef(Quantity.BURNING_RATE, "BURNING RATE", "BURNING_RATE");
        this.mapPredef(Quantity.CONVECTIVE_FLUX, "CONVECTIVE HEAT FLUX", "CONVECTIVE_FLUX");
        this.mapPredef(Quantity.FRICTION_VELOCITY, "FRICTION VELOCITY");
        this.mapPredef(Quantity.GAS_TEMPERATURE, "GAS TEMPERATURE");
        this.mapPredef(Quantity.GAUGE_HEAT_FLUX, "GAUGE HEAT FLUX", "GAUGE_HEAT_FLUX");
        this.mapPredef(Quantity.HEAT_FLUX, "NET HEAT FLUX", "HEAT_FLUX");
        this.mapPredef(Quantity.HEAT_TRANSFER_COEFFICIENT, "HEAT TRANSFER COEFFICIENT", "HEAT_TRANSFER_COEFFICIENT");
        this.mapPredef(Quantity.INCIDENT_HEAT_FLUX, "INCIDENT HEAT FLUX", "INCIDENT_HEAT_FLUX");
        this.mapPredef(Quantity.INSIDE_WALL_TEMPERATURE, "INSIDE WALL TEMPERATURE", "INSIDE_WALL_TEMPERATURE");
        this.mapPredef(Quantity.NORMAL_VELOCITY, "NORMAL VELOCITY", "NORMAL_VELOCITY");
        this.mapPredef(Quantity.PRESSURE_COEFFICIENT, "PRESSURE COEFFICIENT", "PRESSURE_COEFFICIENT");
        this.mapPredef(Quantity.RADIATIVE_FLUX, "RADIATIVE HEAT FLUX", "RADIATIVE_FLUX");
        this.mapPredef(Quantity.RADIOMETER, "RADIOMETER");
        this.mapPredef(Quantity.SOLID_CONDUCTIVITY, "SOLID CONDUCTIVITY");
        this.mapPredef(Quantity.SOLID_SPECIFIC_HEAT, "SOLID SPECIFIC HEAT");
        this.mapPredef(Quantity.SURFACE_DENSITY, "SURFACE DENSITY");
        this.mapPredef(Quantity.WALL_TEMPERATURE, "WALL TEMPERATURE", "WALL_TEMPERATURE");
        this.mapPredef(Quantity.WALL_THICKNESS, "WALL THICKNESS", "WALL_THICKNESS");
        this.mapPredef(Quantity.HEAT_FLOW, HEAT_FLOW);
        this.mapPredef(Quantity.HEAT_FLOW_WALL, "HEAT FLOW WALL");
        this.mapPredef(Quantity.HRR, "HRR");
        this.mapPredef(Quantity.MASS_FLOW, MASS_FLOW);
        this.mapPredef(Quantity.MASS_FLOW_WALL, "MASS FLOW WALL");
        this.mapPredef(Quantity.VOLUME_FLOW, VOLUME_FLOW);
        this.mapPredef(Quantity.VOLUME_FLOW_WALL, "VOLUME FLOW WALL");
        this.mapFlowPredef(Quantity.VOLUME_FLOW_X, "U-VELOCITY");
        this.mapFlowPredef(Quantity.VOLUME_FLOW_Y, "V-VELOCITY");
        this.mapFlowPredef(Quantity.VOLUME_FLOW_Z, "W-VELOCITY");
        this.mapFlowPredef(Quantity.VOLUME_FLOW_BOUNDARY, "NORMAL VELOCITY");
        this.mapFlowPredef(Quantity.ENTHALPY_FLOW_X, "ENTHALPY FLUX X");
        this.mapFlowPredef(Quantity.ENTHALPY_FLOW_Y, "ENTHALPY FLUX Y");
        this.mapFlowPredef(Quantity.ENTHALPY_FLOW_Z, "ENTHALPY FLUX Z");
        this.mapFlowPredef(Quantity.ENTHALPY_FLOW_WALL, "ENTHALPY FLUX WALL");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW, "MASS FLUX");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_WALL, "MASS FLUX WALL");
        this.mapFlowPredef(Quantity.NOSPEC_TOTAL_MASS_FLOW_WALL, "TOTAL MASS FLUX WALL");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_X, "MASS FLUX X");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Y, "MASS FLUX Y");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Z, "MASS FLUX Z");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_X_TOTAL, "TOTAL MASS FLUX X");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Y_TOTAL, "TOTAL MASS FLUX Y");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Z_TOTAL, "TOTAL MASS FLUX Z");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_X_ADVECTIVE, "ADVECTIVE MASS FLUX X");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Y_ADVECTIVE, "ADVECTIVE MASS FLUX Y");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Z_ADVECTIVE, "ADVECTIVE MASS FLUX Z");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_X_DIFFUSIVE, "DIFFUSIVE MASS FLUX X");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Y_DIFFUSIVE, "DIFFUSIVE MASS FLUX Y");
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Z_DIFFUSIVE, "DIFFUSIVE MASS FLUX Z");
        this.mapPredef(Quantity.LAYER_HEIGHT, "LAYER HEIGHT");
        this.mapPredef(Quantity.LOWER_TEMPERATURE, "LOWER TEMPERATURE");
        this.mapPredef(Quantity.PATH_OBSCURATION, "PATH OBSCURATION", "path obscuration");
        this.mapPredef(Quantity.TRANSMISSION, "TRANSMISSION");
        this.mapPredef(Quantity.UPPER_TEMPERATURE, "UPPER TEMPERATURE");
        this.mapPredef(Quantity.CHAMBER_OBSCURATION, CHAMBER_OBSCURATION);
        this.mapPredef(Quantity.LINK_TEMPERATURE, LINK_TEMPERATURE);
        this.mapPredef(Quantity.SPRINKLER_LINK_TEMPERATURE, SPRINKLER_LINK_TEMPERATURE);
        this.mapPredef(Quantity.ACTUATED_SPRINKLERS, "ACTUATED SPRINKLERS");
        this.mapPredef(Quantity.CPU_TIME, "CPU TIME");
        this.mapPredef(Quantity.CPU_TIME_PER_STEP, "CPU TIME PER STEP");
        this.mapPredef(Quantity.DEPOSITION_VELOCITY, "DEPOSITION VELOCITY");
        this.mapPredef(Quantity.ITERATION, "ITERATION");
        this.mapPredef(Quantity.NUMBER_OF_PARTICLES, "NUMBER OF PARTICLES");
        this.mapPredef(Quantity.OPEN_NOZZLES, "OPEN NOZZLES");
        this.mapPredef(Quantity.PRESSURE_ZONE, "PRESSURE ZONE");
        this.mapPredef(Quantity.TIME, FDS_TIME);
        this.mapPredef(Quantity.TIME_STEP, "TIME STEP");
        this.mapPredef(Quantity.TURBULENCE_RESOLUTION, "TURBULENCE RESOLUTION");
        this.mapPredef(Quantity.WALL_CLOCK_TIME, "WALL CLOCK TIME");
        this.mapPredef(Quantity.WALL_CLOCK_TIME_ITERATIONS, "WALL CLOCK TIME ITERATIONS");
        this.mapPredef(Quantity.CELL_U, "CELL U");
        this.mapPredef(Quantity.CELL_V, "CELL V");
        this.mapPredef(Quantity.CELL_W, "CELL W");
        this.mapPredef(Quantity.YPLUS, "VISCOUS WALL UNITS");
        this.mapPredef(Quantity.PDPA, "PDPA");
        this.mapPredef(Quantity.INTEGRATED_INTENSITY, "INTEGRATED INTENSITY");
        this.mapPredef(Quantity.HRRPUL, "HRRPUL");
        this.mapPredef(Quantity.EXTINCTION, "EXTINCTION");
        this.mapPredef(Quantity.NORMALIZED_HEATING_RATE, "NORMALIZED HEATING RATE");
        this.mapPredef(Quantity.NORMALIZED_HEAT_RELEASE_RATE, "NORMALIZED HEAT RELEASE RATE");
        this.mapPredef(Quantity.RADIATION_LOSS, "RADIATION LOSS");
        this.mapPredef(Quantity.CHEMISTRY_ITER, "CHEMICAL SUBITERATIONS", "CHEMISTRY SUBITERATIONS");
        this.mapObj(Quantity.PART_ACMPUA, "AMPUA");
        this.mapObj(Quantity.PART_CPUA, "CPUA");
        this.mapObj(Quantity.PART_MASS_FLUX_X, "PARTICLE FLUX X");
        this.mapObj(Quantity.PART_MASS_FLUX_Y, "PARTICLE FLUX Y");
        this.mapObj(Quantity.PART_MASS_FLUX_Z, "PARTICLE FLUX Z");
        this.mapObj(Quantity.PART_MPUA, "MPUA");
        this.mapObj(Quantity.PART_MPUV, "MPUV");
        this.mapObj(Quantity.SPEC_AMPUA, "AMPUA_Z");
        this.mapObj(Quantity.SPEC_CPUA, "CPUA_Z");
        this.mapObj(Quantity.SPEC_MASS_FLUX, "MASS FLUX");
        this.mapObj(Quantity.SPEC_MASS_FLUX_X, "MASS FLUX X");
        this.mapObj(Quantity.SPEC_MASS_FLUX_Y, "MASS FLUX Y");
        this.mapObj(Quantity.SPEC_MASS_FLUX_Z, "MASS FLUX Z");
        this.mapObj(Quantity.SPEC_MPUA, "MPUA_Z");
        this.mapObj(Quantity.SPEC_MPUV, "MPUV_Z");
        this.mapObj(Quantity.SPEC_MASS_FRACTION, "MASS FRACTION");
        this.mapObj(Quantity.SPEC_VOLUME_FRACTION, "VOLUME FRACTION");
        this.mapObj(Quantity.SPEC_DENSITY, "DENSITY");
        this.mapObj(Quantity.SPEC_VISIBILITY, "VISIBILITY");
        this.mapObj(Quantity.SPEC_OPTICAL_DENSITY, "OPTICAL DENSITY");
        this.mapObj(Quantity.AERO_VOLUME_FRACTION, "AEROSOL VOLUME FRACTION");
        this.mapObj(Quantity.SPEC_SURFACE_DEPOSITION, "SURFACE DEPOSITION");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW, "MASS FLUX");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_WALL, "MASS FLUX WALL");
        this.mapFlowObj(Quantity.SPEC_TOTAL_MASS_FLOW_WALL, "TOTAL MASS FLUX WALL");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_X, "MASS FLUX X");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Y, "MASS FLUX Y");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Z, "MASS FLUX Z");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_X_TOTAL, "TOTAL MASS FLUX X");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Y_TOTAL, "TOTAL MASS FLUX Y");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Z_TOTAL, "TOTAL MASS FLUX Z");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_X_ADVECTIVE, "ADVECTIVE MASS FLUX X");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Y_ADVECTIVE, "ADVECTIVE MASS FLUX Y");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Z_ADVECTIVE, "ADVECTIVE MASS FLUX Z");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_X_DIFFUSIVE, "DIFFUSIVE MASS FLUX X");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Y_DIFFUSIVE, "DIFFUSIVE MASS FLUX Y");
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Z_DIFFUSIVE, "DIFFUSIVE MASS FLUX Z");
        this.mapObj(Quantity.MATL_SOLID_DENSITY, "SOLID DENSITY");
        this.mapObj(Quantity.HVAC_AIRCOIL_HEAT_EXCHANGE, "AIRCOIL HEAT EXCHANGE");
        this.mapObj(Quantity.HVAC_DUCT_DENSITY, "DUCT DENSITY");
        this.mapObj(Quantity.HVAC_DUCT_MASS_FLOW, "DUCT MASS FLOW");
        this.mapObj(Quantity.HVAC_DUCT_MASS_FRACTION, "DUCT MASS FRACTION");
        this.mapObj(Quantity.HVAC_DUCT_TEMPERATURE, "DUCT TEMPERATURE");
        this.mapObj(Quantity.HVAC_DUCT_VELOCITY, "DUCT VELOCITY");
        this.mapObj(Quantity.HVAC_DUCT_VOLUME_FLOW, "DUCT VOLUME FLOW");
        this.mapObj(Quantity.HVAC_DUCT_VOLUME_FRACTION, "DUCT VOLUME FRACTION");
        this.mapObj(Quantity.HVAC_DUCT_ENERGY_FLOW, "DUCT ENERGY FLOW");
        this.mapObj(Quantity.HVAC_FILTER_LOADING, "FILTER LOADING");
        this.mapObj(Quantity.HVAC_FILTER_LOSS, "FILTER LOSS");
        this.mapObj(Quantity.HVAC_NODE_DENSITY, "NODE DENSITY");
        this.mapObj(Quantity.HVAC_NODE_MASS_FRACTION, "NODE MASS FRACTION");
        this.mapObj(Quantity.HVAC_NODE_PRESSURE, "NODE PRESSURE");
        this.mapObj(Quantity.HVAC_NODE_TEMPERATURE, "NODE TEMPERATURE");
        this.mapObj(Quantity.HVAC_NODE_VOLUME_FRACTION, "NODE VOLUME FRACTION");
        this.mapObj(Quantity.HVAC_NODE_PRESSURE_DIFFERENCE, "NODE PRESSURE DIFFERENCE");
        this.mapObj(Quantity.HVAC_NODE_ENTHALPY, "NODE ENTHALPY");
        this.constructLegacyFlowMap();
    }

    private void constructLegacyFlowMap() {
        HashMap<Byte, Quantity> volGas = new HashMap<Byte, Quantity>();
        volGas.put((byte)0, Quantity.VOLUME_FLOW_X);
        volGas.put((byte)1, Quantity.VOLUME_FLOW_Y);
        volGas.put((byte)2, Quantity.VOLUME_FLOW_Z);
        HashMap<Byte, Quantity> volSolid = new HashMap<Byte, Quantity>();
        volSolid.put((byte)0, Quantity.VOLUME_FLOW_BOUNDARY);
        volSolid.put((byte)1, Quantity.VOLUME_FLOW_BOUNDARY);
        volSolid.put((byte)2, Quantity.VOLUME_FLOW_BOUNDARY);
        HashMap<Byte, Quantity> massGas = new HashMap<Byte, Quantity>();
        massGas.put((byte)0, Quantity.NOSPEC_MASS_FLOW_X);
        massGas.put((byte)1, Quantity.NOSPEC_MASS_FLOW_Y);
        massGas.put((byte)2, Quantity.NOSPEC_MASS_FLOW_Z);
        HashMap<Byte, Quantity> massSolid = new HashMap<Byte, Quantity>();
        massSolid.put((byte)0, Quantity.NOSPEC_MASS_FLOW);
        massSolid.put((byte)1, Quantity.NOSPEC_MASS_FLOW);
        massSolid.put((byte)2, Quantity.NOSPEC_MASS_FLOW);
        HashMap<Byte, Quantity> heatGas = new HashMap<Byte, Quantity>();
        heatGas.put((byte)0, Quantity.ENTHALPY_FLOW_X);
        heatGas.put((byte)1, Quantity.ENTHALPY_FLOW_Y);
        heatGas.put((byte)2, Quantity.ENTHALPY_FLOW_Z);
        HashMap<Byte, Quantity> heatSolid = new HashMap<Byte, Quantity>();
        heatSolid.put((byte)0, Quantity.ENTHALPY_FLOW_WALL);
        heatSolid.put((byte)1, Quantity.ENTHALPY_FLOW_WALL);
        heatSolid.put((byte)2, Quantity.ENTHALPY_FLOW_WALL);
        this.d_legacyFlowMap.put(Quantity.VOLUME_FLOW, volGas);
        this.d_legacyFlowMap.put(Quantity.VOLUME_FLOW_WALL, volSolid);
        this.d_legacyFlowMap.put(Quantity.MASS_FLOW, massGas);
        this.d_legacyFlowMap.put(Quantity.MASS_FLOW_WALL, massSolid);
        this.d_legacyFlowMap.put(Quantity.HEAT_FLOW, heatGas);
        this.d_legacyFlowMap.put(Quantity.HEAT_FLOW_WALL, heatSolid);
    }

    private void mapObj(Quantity quantity, String fdsName) {
        this.mapObj(quantity, fdsName, null);
    }

    private void mapObj(Quantity quantity, String fdsName, String optLegPostfix) {
        this.d_fdsToPyroObjMap.put(fdsName, quantity);
        this.d_pyroToFDSMap.put(quantity, fdsName);
        if (optLegPostfix != null) {
            this.d_fdsToPyroLegPostfixMap.add(new Pair<String, Quantity>(optLegPostfix, quantity));
        }
    }

    private void mapFlowObj(Quantity quantity, String fdsName) {
        this.d_fdsToPyroObjFlowMap.put(fdsName, quantity);
        this.d_pyroToFDSMap.put(quantity, fdsName);
    }

    private void mapPredef(Quantity quantity, String ... fdsNames) {
        assert (quantity.getNumArgs() == 0);
        this.mapPredef(quantity.create(), fdsNames);
    }

    private void mapPredef(IQuantity quantity, String ... fdsNames) {
        for (String fdsName : fdsNames) {
            this.d_fdsToPyroPredefMap.put(fdsName, quantity);
        }
        if (quantity.get().getNumArgs() == 0) {
            this.d_pyroToFDSMap.put(quantity.get(), fdsNames[0]);
        }
    }

    private void mapFlowPredef(Quantity quantity, String ... fdsNames) {
        assert (quantity.getNumArgs() == 0);
        this.mapFlowPredef(quantity.create(), fdsNames);
    }

    private void mapFlowPredef(IQuantity quantity, String ... fdsNames) {
        for (String fdsName : fdsNames) {
            this.d_fdsToPyroPredefFlowMap.put(fdsName, quantity);
        }
        if (quantity.get().getNumArgs() == 0) {
            this.d_pyroToFDSMap.put(quantity.get(), fdsNames[0]);
        }
    }

    public IQuantity parseFlowQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantKey, String partIdKey, String specIdKey, String matIdKey, String ductIdKey, String nodeIdKey, boolean quantityRequired) throws FDSRecordFormatException {
        String quantName = rec.getString(quantKey);
        if (quantName == null) {
            if (quantityRequired) {
                throw new FDSRecordFormatException(rec, Intl.intl("Quantity missing."));
            }
            return null;
        }
        Object partId = partIdKey == null ? null : rec.get(partIdKey);
        Object specId = specIdKey == null ? null : rec.get(specIdKey);
        Object matId = matIdKey == null ? null : rec.get(matIdKey);
        Object ductId = ductIdKey == null ? null : rec.get(ductIdKey);
        Object nodeId = nodeIdKey == null ? null : rec.get(nodeIdKey);
        return this.parseFlowQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId);
    }

    public IQuantity parseQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantKey, String partIdKey, String specIdKey, String matIdKey, String ductIdKey, String nodeIdKey, boolean quantityRequired) throws FDSRecordFormatException {
        String quantName = rec.getString(quantKey);
        if (quantName == null) {
            if (quantityRequired) {
                throw new FDSRecordFormatException(rec, Intl.intl("Quantity missing."));
            }
            return null;
        }
        Object partId = partIdKey == null ? null : rec.get(partIdKey);
        Object specId = specIdKey == null ? null : rec.get(specIdKey);
        Object matId = matIdKey == null ? null : rec.get(matIdKey);
        Object ductId = ductIdKey == null ? null : rec.get(ductIdKey);
        Object nodeId = nodeIdKey == null ? null : rec.get(nodeIdKey);
        return this.parseQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId);
    }

    public IQuantity parseFlowQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantName, Object partId, Object specId, Object matId, Object ductId, Object nodeId) throws FDSRecordFormatException {
        return this.parseMappedQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId, key -> this.d_fdsToPyroObjFlowMap.get(key), key -> this.d_fdsToPyroPredefFlowMap.get(key));
    }

    public IQuantity parseMappedQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantName, Object partId, Object specId, Object matId, Object ductId, Object nodeId, Function<String, Quantity> objGetter, Function<String, IQuantity> staticGetter) throws FDSRecordFormatException {
        IQuantity quantity = QuantityMap.tryParseObjQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId, objGetter, staticGetter);
        if (quantity != null) {
            return quantity;
        }
        return staticGetter.apply(quantName);
    }

    public IQuantity parseQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantName, Object partId, Object specId, Object matId, Object ductId, Object nodeId) throws FDSRecordFormatException {
        IQuantity quantity = this.parseMappedQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId, key -> this.d_fdsToPyroObjMap.get(key), key -> this.d_fdsToPyroPredefMap.get(key));
        if (quantity != null) {
            return quantity;
        }
        for (Pair<String, Quantity> pair : this.d_fdsToPyroLegPostfixMap) {
            int ix = quantName.indexOf((String)pair.v1);
            if (ix <= 0) continue;
            String objName = quantName.substring(0, ix);
            assert (((Quantity)((Object)pair.v2)).requiredTypes.length == 1);
            try {
                IPyroObject obj = QuantityMap.findObject(parseInfo, rec, ((Quantity)((Object)pair.v2)).requiredTypes[0], ((Quantity)((Object)pair.v2)).typeFilters[0], objName, quantName);
                return ((Quantity)((Object)pair.v2)).create(obj);
            }
            catch (FDSRecordFormatException fDSRecordFormatException) {
            }
        }
        ExSpec spec = parseInfo.findObject(ExSpec.class, quantName);
        if (spec != null) {
            return Quantity.SPEC_MASS_FRACTION.create(spec);
        }
        Material mat = parseInfo.findObject(Material.class, quantName);
        if (mat != null) {
            return Quantity.MATL_DENSITY.create(mat);
        }
        throw new FDSRecordFormatException(rec, String.format(Intl.intl("Unknown quantity: %s"), quantName));
    }

    private static IQuantity tryParseObjQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantName, Object partId, Object specId, Object matId, Object ductId, Object nodeId, Function<String, Quantity> objGetter, Function<String, IQuantity> staticGetter) throws FDSRecordFormatException {
        Quantity objQuantity = objGetter.apply(quantName);
        if (objQuantity != null) {
            int count;
            IQuantity staticQuantity = staticGetter.apply(quantName);
            boolean argumentsOptional = staticQuantity != null;
            ArrayList<String> missingTypes = new ArrayList<String>();
            ArrayList<IPyroObject> objects = new ArrayList<IPyroObject>(objQuantity.getNumArgs());
            for (int m = 0; m < objQuantity.getNumArgs(); m += count) {
                Class<? extends IPyroObject> type = objQuantity.requiredTypes[m];
                count = 1;
                for (int n = m + 1; n < objQuantity.getNumArgs() && objQuantity.requiredTypes[n].equals(type); ++n) {
                    ++count;
                }
                Object ids = QuantityMap.getObjVal(type, partId, specId, matId, ductId, nodeId);
                for (int n = 0; n < count; ++n) {
                    if (ids == null) {
                        String typeDesc = TVEntryPoints.ep(type).getCategoryName();
                        missingTypes.add(typeDesc);
                        objects.add(null);
                        continue;
                    }
                    String id = ids instanceof String ? (String)ids : (String)((List)ids).get(n);
                    try {
                        IPyroObject obj = QuantityMap.findObject(parseInfo, rec, type, objQuantity.typeFilters[m + n], id, quantName);
                        objects.add(obj);
                        continue;
                    }
                    catch (FDSRecordFormatException e) {
                        if (!argumentsOptional) {
                            throw e;
                        }
                        String typeDesc = TVEntryPoints.ep(type).getCategoryName();
                        missingTypes.add(typeDesc);
                    }
                }
            }
            if (argumentsOptional && missingTypes.size() == objQuantity.requiredTypes.length) {
                return staticQuantity;
            }
            if (!missingTypes.isEmpty()) {
                String typeDesc = (String)missingTypes.get(0);
                String msg = String.format(Intl.intl("Use of quantity, %1$s, requires a %2$s to be specified."), quantName, typeDesc);
                throw new FDSRecordFormatException(rec, msg);
            }
            assert (objects.size() == objQuantity.requiredTypes.length);
            return objQuantity.create(objects.toArray(new IPyroObject[objects.size()]));
        }
        return null;
    }

    private static IPyroObject findObject(FDSParsingInfo parseInfo, FDSParseRecord rec, Class type, Predicate filter, String id, String quantName) throws FDSRecordFormatException {
        String typeDesc = TVEntryPoints.ep(type).getCategoryName();
        Object obj = parseInfo.findObject(type, id);
        if (obj == null) {
            String msg = String.format(Intl.intl("Could not find %1$s, %2$s, needed for quantity, %3$s."), typeDesc, id, quantName);
            throw new FDSRecordFormatException(rec, msg);
        }
        if (!filter.test(obj)) {
            String msg = String.format(Intl.intl("Invalid %1$s for quantity, %2$s: %3$s"), typeDesc, quantName, filter.toString());
            throw new FDSRecordFormatException(rec, msg);
        }
        return obj;
    }

    public void renderQuantity(FDSRenderRecord rec, String quantKey, String partIdKey, String specIdKey, String matIdKey, String ductIdKey, String nodeIdKey, IQuantity msr) {
        if (msr.get() == Quantity.MATL_DENSITY) {
            rec.setValue(quantKey, Util.getName(((ObjectQuantity)msr).objects[0]));
            return;
        }
        String quantity = this.d_pyroToFDSMap.get((Object)msr.get());
        assert (quantity != null);
        rec.setValue(quantKey, quantity);
        if (msr instanceof ObjectQuantity) {
            int count;
            ObjectQuantity om = (ObjectQuantity)msr;
            Quantity q = msr.get();
            for (int m = 0; m < q.getNumArgs(); m += count) {
                Class<? extends IPyroObject> type = q.requiredTypes[m];
                count = 1;
                for (int n = m + 1; n < q.getNumArgs() && q.requiredTypes[n].equals(type); ++n) {
                    ++count;
                }
                ArrayList<String> ids = new ArrayList<String>(count);
                for (int n = 0; n < count; ++n) {
                    Object obj = om.objects[m + n];
                    ids.add(((INamed)obj).getName());
                }
                String objIdKey = QuantityMap.getObjVal(type, partIdKey, specIdKey, matIdKey, ductIdKey, nodeIdKey);
                if (objIdKey == null || ids.size() <= 0) continue;
                FDSRecordSpec.Field fld = rec.getSpec().fields.get(objIdKey);
                ArrayList<String> objVal = fld instanceof FDSRecordSpec.ListFld ? ids : ids.get(0);
                rec.setValue(objIdKey, objVal);
            }
        }
    }

    public Quantity getQuantity(String quantityName) {
        IQuantity predef = this.d_fdsToPyroPredefMap.get(quantityName);
        if (predef != null) {
            return predef.get();
        }
        return this.d_fdsToPyroObjMap.get(quantityName);
    }

    public String getFDSName(Quantity msr) {
        return this.d_pyroToFDSMap.get((Object)msr);
    }

    private static <T> T getObjVal(Class type, T part, T spec, T mat, T duct, T node) {
        if (ExSpec.class.isAssignableFrom(type)) {
            return spec;
        }
        if (Particle.class.isAssignableFrom(type)) {
            return part;
        }
        if (Material.class.isAssignableFrom(type)) {
            return mat;
        }
        if (HvacNode.class.isAssignableFrom(type)) {
            return node;
        }
        if (HvacDuct.class.isAssignableFrom(type)) {
            return duct;
        }
        return null;
    }

    public static boolean isLegacyFlowQuantity(String quant) {
        return quant.startsWith(MASS_FLOW) || quant.startsWith(HEAT_FLOW) || quant.startsWith(VOLUME_FLOW);
    }

    public boolean isFlowMeasureQuantity(String quant) {
        return this.d_fdsToPyroObjFlowMap.containsKey(quant) || this.d_fdsToPyroPredefFlowMap.containsKey(quant);
    }

    public Quantity convertLegacyFlowQuantity(Quantity legQ, byte plane) {
        return this.d_legacyFlowMap.get((Object)legQ).get(plane);
    }
}

