/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.extloader;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import pyroloader.IPyroDataStore;
import pyroloader.IPyroGeom;
import pyroloader.IPyroGeomNode;
import pyroloader.IPyroGeomSrc;
import pyroloader.IPyroPrimProps;
import pyroloader.IPyroSurface;
import pyroloader.PyroLoadOptions;
import pyroloader.PyroPoint3d;
import pyroloader.PyroTexture;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.io.ImportFDSFile;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.io.extloader.GeomNodeWrapper;
import pyrosim.io.extloader.GeomSrcWrapper;
import pyrosim.io.extloader.GeomWrapper;
import pyrosim.io.extloader.PrimPropWrapper;
import pyrosim.io.extloader.SurfWrapper;
import pyrosim.mv.displays.ClippingManager;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.image.IImage;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class DataStore
implements IPyroDataStore {
    public static final double[] IDENTITY_XFORM = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    private final PyroMod d_model = new PyroMod(true);
    private final Map<IGeomNode, IPyroGeom> d_nodeToGeomMap = new IdentityHashMap<IGeomNode, IPyroGeom>();
    private final Map<IGeom, IPyroGeom> d_geomMap;
    private final Map<IGeomNode, IPyroGeomNode> d_nodeMap = new IdentityHashMap<IGeomNode, IPyroGeomNode>();
    private final Map<Surface, IPyroSurface> d_surfMap;
    private final Map<Point3d, PyroPoint3d> d_pMap;
    private final Map<IPrimProps, IPyroPrimProps> d_propsMap;
    private final Map<IPyroPrimProps, IPrimProps> d_revPropsMap;
    private final Map<IImage, byte[]> d_imgDataMap;
    private final Map<String, IMatAttrs.MatProp<?>> d_propMap;
    private PyroLoadOptions d_loadOptions;
    private GridMergeUtil.MergeResult d_mergedGridsCache;

    public DataStore() {
        this.d_geomMap = new IdentityHashMap<IGeom, IPyroGeom>();
        this.d_surfMap = new IdentityHashMap<Surface, IPyroSurface>();
        this.d_propsMap = new IdentityHashMap<IPrimProps, IPyroPrimProps>();
        this.d_revPropsMap = new IdentityHashMap<IPyroPrimProps, IPrimProps>();
        this.d_imgDataMap = new IdentityHashMap<IImage, byte[]>();
        this.d_propMap = new HashMap();
        for (IMatAttrs.MatProp<?> prop : IMatAttrs.ALL) {
            this.d_propMap.put(prop.strKey, prop);
        }
        this.d_pMap = new HashMap<Point3d, PyroPoint3d>();
    }

    public String getPyroSimRevision() {
        return "2022.3.1208";
    }

    private void initApp() {
        new PyroSim(this.d_loadOptions.getAppName(), this.d_loadOptions.getInstallDir(), this.d_loadOptions.getActiveFrame());
    }

    protected IMatAttrs.MatProp<?> getMatProp(String key) {
        return this.d_propMap.get(key);
    }

    public void readPyroSim(String filename, PyroLoadOptions options) throws Exception {
        this.readPyroSim(null, filename, options);
    }

    private static void printWarnings(WarningReport<Warning> warnings) {
        if (!warnings.isEmpty()) {
            System.out.println("Import warnings:");
            String report = warnings.prepareReport();
            if (report.length() < 262144) {
                System.out.println(report);
            } else {
                System.out.println("Warning report too long to print.");
            }
        }
    }

    public void readPyroSim(Component parent, String filename, PyroLoadOptions options) throws Exception {
        this.d_model.updateGeomSearchesEnabled(options.cutHoles());
        this.d_loadOptions = options;
        this.initApp();
        int version = Integer.MAX_VALUE;
        File pyroFile = new File(filename);
        try (PyroSimObjectInputStream ois = new PyroSimObjectInputStream(new BufferedInputStream(new FileInputStream(pyroFile)), false, Optional.of(pyroFile));){
            if (ois.isNewer()) {
                String msg = String.format(Intl.intl("This file was created with %s, which is newer\nthan this importer supports."), "PyroSim " + ois.getRevision());
                throw new IOException(msg);
            }
            if (ois.canOpenVersion()) {
                this.d_model.openModel(ois, true);
                DataStore.printWarnings(ois.getWarnings());
                return;
            }
            version = ois.getVersion();
        }
        String[] infoDescriptions = new String[]{Intl.intl("Record"), Intl.intl("Action")};
        WarningReport<Warning> warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), infoDescriptions, 0);
        if (version >= 20) {
            try (pyrosim.legacy_2012_1.io.PyroSimObjectInputStream leg_2012_OIS = new pyrosim.legacy_2012_1.io.PyroSimObjectInputStream(new BufferedInputStream(new FileInputStream(filename)), Collections.emptySet());){
                pyrosim.legacy_2012_1.PyroMod data = new pyrosim.legacy_2012_1.PyroMod();
                data.openModel(leg_2012_OIS, true);
                this.d_model.fromLegacy(pyroFile, null, data, warnings);
                DataStore.printWarnings(warnings);
            }
            return;
        }
        try (pyrosim.legacy_2006_2.PyroSimObjectInputStream leg_2006_OIS = new pyrosim.legacy_2006_2.PyroSimObjectInputStream(new BufferedInputStream(new FileInputStream(filename)));){
            pyrosim.legacy_2006_2.PyroMod data = new pyrosim.legacy_2006_2.PyroMod();
            data.openModel(leg_2006_OIS, true);
            this.d_model.fromLegacy(pyroFile, null, data, warnings);
            DataStore.printWarnings(warnings);
        }
    }

    public void readFDS(String filename, PyroLoadOptions options) throws Exception {
        this.readFDS(null, filename, options);
    }

    public void readFDS(Component parent, String filename, PyroLoadOptions options) throws Exception {
        this.d_model.updateGeomSearchesEnabled(options.cutHoles());
        this.d_loadOptions = options;
        this.initApp();
        if (!ImportFDSFile.readFDSFile(parent, null, filename, this.d_model, false)) {
            throw new CancellationException();
        }
    }

    public PyroMod getModel() {
        return this.d_model;
    }

    public IPyroDisplayProps getDisplayProps() {
        return new IPyroDisplayProps(){

            @Override
            public Predicate<IHole> getHoleFilter(IObstruction obst) {
                return Filters.always(DataStore.this.d_loadOptions.cutHoles());
            }

            @Override
            public double getCurveError() {
                return 0.1;
            }

            @Override
            public double getFaceError() {
                return 0.1;
            }

            @Override
            public FDSRasterization getRasterizer() {
                return null;
            }

            @Override
            public ClippingManager getClippingManager() {
                return null;
            }

            @Override
            public GridMergeUtil.MergeResult getMergedMeshes() {
                if (DataStore.this.d_mergedGridsCache == null) {
                    DataStore.this.d_mergedGridsCache = GridMergeUtil.mergeGrids(DataStore.this.d_model.getGridManager().flatten(g -> DataStore.this.include((IPyroObject)g)), Collections.emptyList());
                }
                return DataStore.this.d_mergedGridsCache;
            }

            @Override
            public boolean getVentOrientVisible() {
                return false;
            }

            @Override
            public boolean isWireframe(Object o) {
                return false;
            }
        };
    }

    public Collection<IPyroSurface> getSurfaces() {
        ArrayList<IPyroSurface> surfaces = new ArrayList<IPyroSurface>();
        for (Surface surf : this.d_model.getSurfaceMgr().flatten()) {
            surfaces.add(this.getSurface(surf));
        }
        return surfaces;
    }

    public IPyroSurface getSurface(Surface surf) {
        IPyroSurface psurf = this.d_surfMap.get(surf);
        if (psurf == null) {
            psurf = new SurfWrapper(this, surf);
            this.d_surfMap.put(surf, psurf);
        }
        return psurf;
    }

    public IPyroGeom getNodeAsGeom(IGeomNode node) {
        IPyroGeom pgeom = this.d_nodeToGeomMap.get(node);
        if (pgeom == null) {
            pgeom = new GeomWrapper(this, node);
            this.d_nodeToGeomMap.put(node, pgeom);
        }
        return pgeom;
    }

    public IPyroGeomNode getNode(IGeomNode node) {
        return this.d_nodeMap.computeIfAbsent(node, n -> new GeomNodeWrapper(this, (IGeomNode)n));
    }

    public IPyroPrimProps getProps(IPrimProps props) {
        IPyroPrimProps result = this.d_propsMap.get(props);
        if (result == null) {
            result = new PrimPropWrapper(this, props);
            this.d_propsMap.put(props, result);
            this.d_revPropsMap.put(result, props);
        }
        return result;
    }

    public IPrimProps getNativeProps(IPyroPrimProps p) {
        return this.d_revPropsMap.get(p);
    }

    public IPyroGeom getGeom(IGeom geom) {
        return this.d_geomMap.computeIfAbsent(geom, g -> new GeomWrapper(this, GeomNodeUtil.newNode(geom)));
    }

    private static PyroTexture.Mode convert(Texture.Mode mode) {
        switch (mode) {
            case BLEND: {
                return PyroTexture.Mode.BLEND;
            }
            case DECAL: {
                return PyroTexture.Mode.DECAL;
            }
            case MODULATE: {
                return PyroTexture.Mode.MODULATE;
            }
            case REPLACE: {
                return PyroTexture.Mode.REPLACE;
            }
        }
        assert (false);
        return PyroTexture.Mode.MODULATE;
    }

    private static PyroTexture.Wrap convert(Texture.Wrap wrap) {
        switch (wrap) {
            case CLAMP: {
                return PyroTexture.Wrap.CLAMP;
            }
            case CLAMP_TO_EDGE: {
                return PyroTexture.Wrap.CLAMP_TO_EDGE;
            }
            case REPEAT: {
                return PyroTexture.Wrap.REPEAT;
            }
            case MIRRORED_REPEAT: {
                return PyroTexture.Wrap.MIRRORED_REPEAT;
            }
        }
        assert (false);
        return PyroTexture.Wrap.REPEAT;
    }

    public PyroTexture getTexture(Texture t) {
        byte[] data = this.getImageData(t.image);
        return new PyroTexture(t.image.getFilename(), t.uvSet, DataStore.convert(t.mode), DataStore.convert(t.wrapS), DataStore.convert(t.wrapT), t.borderColor, data);
    }

    private byte[] getImageData(IImage i) {
        return this.d_imgDataMap.computeIfAbsent(i, img -> {
            byte[] data = null;
            if (img.isCached()) {
                IStreamSrc src = img.getSource();
                try {
                    ByteBuffer buffer = (ByteBuffer)IOUtil.loadData((IStreamSrc)src, (int)1, (boolean)false, (ByteOrder)ByteOrder.nativeOrder()).v1;
                    if (buffer.hasArray()) {
                        data = buffer.array();
                    } else {
                        data = new byte[buffer.capacity()];
                        buffer.get(data);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return data;
        });
    }

    public PyroPoint3d getPoint(Point3d p) {
        PyroPoint3d pp = this.d_pMap.get(p);
        if (pp == null) {
            pp = new PyroPoint3d(p.x, p.y, p.z);
            this.d_pMap.put(p, pp);
        }
        return pp;
    }

    public PyroPoint3d[] getPoints(Point3d ... points) {
        PyroPoint3d[] ppoints = new PyroPoint3d[points.length];
        for (int m = 0; m < points.length; ++m) {
            ppoints[m] = this.getPoint(points[m]);
        }
        return ppoints;
    }

    public PyroLoadOptions getLoadOptions() {
        return this.d_loadOptions;
    }

    private int count(Class<? extends IModelObj> type) {
        return ((APyroObject)this.d_model.getObstructions()).flatten(type).size();
    }

    public void printSummary(PrintStream out) {
        out.println("Num Grids: " + this.d_model.getGridManager().flatten().size());
        out.println("Num Generic: " + this.count(GenericGeomSrc.class));
        out.println("Num Vents: " + this.count(Vent.class));
        out.println("Num Obstructions: " + this.count(IObstruction.class));
        out.println("Num Holes: " + this.count(IHole.class));
    }

    public boolean include(IPyroObject obj) {
        return obj.isEnabled() || this.d_loadOptions.includeDisabled();
    }

    public Collection<IPyroGeomSrc> getGeomObjs() {
        ArrayList<IPyroGeomSrc> objs = new ArrayList<IPyroGeomSrc>(this.d_model.getGridManager().flatten().size() + this.d_model.getObstructions().getMembers().size());
        for (Grid grid : this.d_model.getGridManager().flatten()) {
            if (!this.include(grid)) continue;
            objs.add(new GeomSrcWrapper(this, grid));
        }
        for (IPyroObject obj : this.d_model.getObstructions().getMembers()) {
            if (!this.include(obj)) continue;
            objs.add(new GeomSrcWrapper(this, obj));
        }
        return objs;
    }
}

