/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.PyroTaskManager;
import pyrosim.gui.PyroGuiUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiExceptionError;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.Task;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class ImportFDSFile
implements Task,
PyroTaskManager.BypassWriteProtection {
    private final PyroSim d_pySim;
    private final PyroMod d_pyMod;
    private final String d_fn;
    private boolean d_success;

    public ImportFDSFile(PyroSim pySim, PyroMod pyMod, String fn) {
        this.d_pySim = pySim;
        this.d_pyMod = pyMod;
        this.d_fn = fn;
        this.d_success = false;
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
        assert (this.canUndo());
    }

    @Override
    public int getEst() {
        return 1;
    }

    public boolean getSuccess() {
        return this.d_success;
    }

    @Override
    public void run() {
        this.d_pyMod.pauseUpdates(false);
        this.d_success = this.readFDSFile(this.d_fn);
        if (this.d_success) {
            this.d_pySim.getFDSMRUMenu().usedFile(this.d_fn);
            this.d_pySim.setFilename(this.d_fn, true);
            this.d_pyMod.resumeUpdates();
            this.d_pyMod.getEvents().changed(this.d_pyMod, PyroMod.EVT_FILENAME_CHANGED, PyroMod.EVT_MODEL_CHANGED);
        } else {
            this.d_pyMod.resumeUpdates();
        }
    }

    private boolean readFDSFile(String filename) {
        try {
            return ImportFDSFile.readFDSFile(PyroSim.getApp().getActiveFrame(), new File(Application.getApp().getInstallDir(), "fds"), filename, this.d_pyMod, true);
        }
        catch (Exception e) {
            Application.getApp().error(new guiExceptionError(e));
            e.printStackTrace();
            return false;
        }
    }

    public static boolean readFDSFile(Component parent, File dbDir, String filename, PyroMod dest, boolean showWarnings) throws IOException {
        int ver;
        Window parentWindow = parent != null ? PyroGuiUtil.getWindow(parent) : null;
        String fds4 = "FDS4";
        String fds5 = "FDS5";
        String fds6 = "FDS6";
        String defSel = FilenameManager.getExtension(filename).equalsIgnoreCase("data") ? "FDS4" : "FDS6";
        Object[] opts = new String[]{"FDS4", "FDS5", "FDS6"};
        String sel = (String)JOptionPane.showInputDialog(parentWindow, Intl.intl("Select the FDS version used to create the input file."), Intl.intl("FDS Version Selection Dialog"), -1, null, opts, defSel);
        if (sel == null) {
            return false;
        }
        switch (sel) {
            case "FDS4": {
                ver = 4;
                break;
            }
            case "FDS5": {
                ver = 5;
                break;
            }
            case "FDS6": {
                ver = 6;
                break;
            }
            default: {
                assert (false) : "Invalid state";
                return false;
            }
        }
        try {
            String[] infoDescriptions = new String[]{Intl.intl("Record"), Intl.intl("Action")};
            WarningReport<Warning> warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), infoDescriptions, 0);
            boolean readSuccessful = false;
            if (ver == 6 && !readSuccessful) {
                readSuccessful = dest.readFDS6File(filename, false);
            }
            if (ver == 5 && !readSuccessful) {
                readSuccessful = ImportFDSFile.readFDS5File(dbDir, filename, warnings, dest);
            }
            if (ver == 4 && !readSuccessful) {
                readSuccessful = ImportFDSFile.readFDS4File(dbDir, filename, warnings, dest);
            }
            if (readSuccessful) {
                if (showWarnings) {
                    if (!warnings.isEmpty()) {
                        String title = Intl.intl("File Conversion Warnings");
                        String msg = Intl.intl("Please review the following items in your updated model to verify proper conversion.");
                        WarningDlg<Warning> warnDlg = parentWindow instanceof JDialog ? new WarningDlg<Warning>((Window)((JDialog)parentWindow), title, msg, warnings) : (parentWindow instanceof JFrame ? new WarningDlg<Warning>((Window)((JFrame)parentWindow), title, msg, warnings) : new WarningDlg<Warning>((Window)null, title, msg, warnings));
                        warnDlg.doModal();
                    } else {
                        System.out.println("Warnings:\n" + warnings.prepareReport());
                    }
                }
                return true;
            }
            throw new IOException(Intl.intl("Unable to determine FDS file type."));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    private static boolean readFDS4File(File dbDir, String filename, WarningReport warnings, PyroMod dest) throws Exception {
        pyrosim.legacy_2006_2.PyroMod oldMod = new pyrosim.legacy_2006_2.PyroMod();
        return oldMod.readFDS4File(filename) && dest.fromLegacy(new File(filename), dbDir, oldMod, (WarningReport<Warning>)warnings);
    }

    private static boolean readFDS5File(File dbDir, String filename, WarningReport warnings, PyroMod dest) throws Exception {
        pyrosim.legacy_2012_1.PyroMod oldMod = new pyrosim.legacy_2012_1.PyroMod();
        return oldMod.readFDS5File(filename, false) && dest.fromLegacy(new File(filename), dbDir, oldMod, (WarningReport<Warning>)warnings);
    }
}

