/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import javax.swing.JDialog;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.output.GasMsrStat;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.SolidMsrStat;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.gui.NewTypeDlg;
import pyrosim.gui.comboboxes.QuantityComboBox;

public class NewStatDlg
extends NewTypeDlg<IMeasurementStat, IQuantity> {
    private static final long serialVersionUID = -461338032515125141L;

    public NewStatDlg(JDialog owner, PyroMod model) {
        super(owner, Intl.intl("New Statistic"), model.getMsrStatMgr(), Intl.intl("Quantity:"), NewStatDlg.getQuantityCB());
    }

    private static QuantityComboBox getQuantityCB() {
        return new QuantityComboBox(new QuantityUtil.TypeFilter(1L, new QuantityType[]{QuantityType.GAS, QuantityType.SOLID}){

            @Override
            public boolean test(Quantity o) {
                return super.test(o) && QuantityUtil.canOutputAny(o, -65536L);
            }
        });
    }

    public IMeasurementStat createStat() {
        String name = this.getSelectedName();
        IQuantity msr = (IQuantity)this.getSelectedType();
        if (msr.get().quantityType == QuantityType.GAS) {
            return new GasMsrStat(name, msr);
        }
        return new SolidMsrStat(name, msr);
    }

    @Override
    protected void validateName(PyroMod domain, IQuantity type, String name) throws Exception {
        if (domain.getNames(IMeasurementStat.class).isRegistered(name)) {
            throw new NewTypeDlg.NameInUseException();
        }
    }

    @Override
    protected String getNameSuggestion(PyroMod domain, IQuantity type) {
        String name = type.getDescription();
        return domain.getNames(IMeasurementStat.class).generateValidName(name);
    }
}

