/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.vecmath.Point3d;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroTaskManager;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.ReorderObjectsTask;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.NewDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.grid.GridPanel;
import pyrosim.gui.grid.Validator;
import pyrosim.util.GeomUtil;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.TaskManager;

public class GridManagerDlg
extends ManagerDlg<Grid, GridList> {
    private static final long serialVersionUID = 3083871787606522107L;
    private final Action[] d_actions;
    private final IEditor<Grid> d_editor = new GridEditor();
    private GridList d_mgr = null;

    public GridManagerDlg(JFrame owner) {
        super(owner, Intl.intl("Edit Meshes"), true);
        this.d_actions = new Action[]{new NewAction(), new RenameAction<Grid, GridList>(this, Intl.intl("mesh")), new ManagerDlg.DeleteAction(this)};
        this.updateActions();
    }

    public void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[1].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
        this.d_actions[2].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
    }

    @Override
    protected Collection<? extends Grid> getModelColl(GridList manager) {
        return manager.flatten();
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.updateActions();
    }

    @Override
    public void update(Observable o, Object evt) {
        super.update(o, evt);
    }

    public void init(GridList mgr, Grid init) {
        this.d_mgr = mgr;
        ((RenameAction)this.d_actions[1]).init(mgr);
        super.init(this.d_mgr, this.d_editor, this.d_actions, init);
        this.updateActions();
    }

    public class GridEditor
    implements IEditor<Grid>,
    ChangeListener {
        private final JTabbedPane d_tabs;
        private final guiPanel d_editorPanel;
        private final guiTextField d_fyi;
        private final JSpinner d_spinner;
        private final guiCheckBox d_colorCB;
        private final ColorButton d_colorBtn;
        private final GridPanel d_panel = new GridPanel(0, 1);
        private final guiLabel d_alignQ;
        private final CustomFDSPanel d_advancedPanel = new CustomFDSPanel(6);

        public GridEditor() {
            this.d_tabs = new JTabbedPane();
            this.d_tabs.addTab(Intl.intl("Properties"), this.d_panel);
            this.d_tabs.addTab(Intl.intl("Advanced"), this.d_advancedPanel);
            this.d_editorPanel = new guiPanel(new MigLayout("insets 0, gapx 12, gapy 6"));
            this.d_fyi = new guiTextField();
            this.d_spinner = new JSpinner();
            this.d_spinner.addChangeListener(this);
            this.d_spinner.setPreferredSize(new JButton("M").getPreferredSize());
            guiLabel spinLab = new guiLabel(Intl.intl("Order / Priority") + ":");
            this.d_colorCB = new guiCheckBox(Intl.intl("Specify Color:"));
            this.d_colorBtn = new ColorButton(1);
            this.d_colorBtn.addObserver(this.d_editorPanel.getComm());
            guiLabel labAlignQ = new guiLabel(Intl.intl("Mesh Alignment Test:"));
            this.d_alignQ = new guiLabel();
            this.d_alignQ.setFont(this.d_alignQ.getFont().deriveFont(1));
            guiLabel fyiLbl = new guiLabel(Intl.intl("Description:"));
            this.d_editorPanel.add(fyiLbl);
            this.d_editorPanel.add((Component)this.d_fyi, "span 2, growx, wrap");
            this.d_editorPanel.add(spinLab);
            this.d_editorPanel.add((Component)this.d_spinner, "growx");
            this.d_editorPanel.add(Box.createGlue(), "growx 100, wrap");
            this.d_editorPanel.add(this.d_colorCB);
            this.d_editorPanel.add((Component)this.d_colorBtn, "grow");
            this.d_editorPanel.add(Box.createGlue(), "growx 100, wrap");
            this.d_editorPanel.add(labAlignQ);
            this.d_editorPanel.add((Component)this.d_alignQ, "wrap 8");
            this.d_editorPanel.add((Component)this.d_tabs, "span");
            LinkStatus.link((AbstractButton)this.d_colorCB, this.d_colorBtn);
            this.init(null);
        }

        @Override
        public void init(Grid grid) {
            this.d_editorPanel.setEnabled(grid != null);
            this.d_panel.setValues(grid);
            this.d_fyi.setText("");
            if (grid != null) {
                this.d_fyi.setText(grid.getFYI());
                this.updateSpinner(grid);
                Color color = grid.getColor();
                this.d_colorCB.setSelected(color != null);
                if (color != null) {
                    this.d_colorBtn.setColor(color);
                }
                this.updateAlignmentQuality(grid);
                this.d_advancedPanel.load(Collections.singleton(grid));
            }
            this.d_editorPanel.setModified(false);
        }

        @Override
        public Grid preview(Grid grid) {
            if (!GridManagerDlg.this.validateData(false, false)) {
                return null;
            }
            this.saveGrid(grid);
            return grid;
        }

        private void updateAlignmentQuality(Grid g) {
            if (!g.isEnabled()) {
                this.d_alignQ.setForeground(new Color(100, 100, 100));
                this.d_alignQ.setText(Intl.intl("Mesh Disabled, Test Skipped"));
                this.d_alignQ.setToolTipText("");
                return;
            }
            ArrayList gs = new ArrayList(GridManagerDlg.this.d_mgr.flatten());
            Validator.Alignment iResult = Validator.getValidity(gs, g);
            if (iResult.isValid()) {
                this.d_alignQ.setForeground(new Color(0, 124, 36));
                this.d_alignQ.setText(Intl.intl("Passed"));
                this.d_alignQ.setToolTipText("");
            } else {
                String append;
                int m;
                String longOverlapStr;
                String shrtOverlapStr;
                ArrayList<Grid> unaligned = new ArrayList<Grid>(iResult.unalignedTouch);
                unaligned.addAll(iResult.unalignedOverlap);
                String shrtMsg = Intl.intl("Failed: ");
                String longMsg = "";
                int maxNumToPrint = 2;
                if (!iResult.alignedOverlap.isEmpty()) {
                    shrtOverlapStr = "";
                    longOverlapStr = "";
                    for (m = 0; m < iResult.alignedOverlap.size(); ++m) {
                        append = "";
                        if (m != 0) {
                            append = append + ",";
                        }
                        append = append + iResult.alignedOverlap.get(m).getName();
                        longOverlapStr = longOverlapStr + append;
                        if (m < maxNumToPrint) {
                            shrtOverlapStr = shrtOverlapStr + append;
                            continue;
                        }
                        if (m != maxNumToPrint) continue;
                        shrtOverlapStr = shrtOverlapStr + ",...";
                    }
                    shrtMsg = shrtMsg + String.format(Intl.intl("Overlaps with %s"), shrtOverlapStr);
                    longMsg = longMsg + String.format(Intl.intl("Overlaps with %s"), longOverlapStr);
                }
                if (!unaligned.isEmpty()) {
                    shrtOverlapStr = "";
                    longOverlapStr = "";
                    for (m = 0; m < unaligned.size(); ++m) {
                        append = "";
                        if (m != 0) {
                            append = append + ",";
                        }
                        append = append + ((Grid)unaligned.get(m)).getName();
                        longOverlapStr = longOverlapStr + append;
                        if (m < maxNumToPrint) {
                            shrtOverlapStr = shrtOverlapStr + append;
                            continue;
                        }
                        if (m != maxNumToPrint) continue;
                        shrtOverlapStr = shrtOverlapStr + ",...";
                    }
                    if (!iResult.alignedOverlap.isEmpty()) {
                        shrtMsg = shrtMsg + "    ";
                        longMsg = longMsg + "    ";
                    }
                    shrtMsg = shrtMsg + String.format(Intl.intl("Unaligned with %s"), shrtOverlapStr);
                    longMsg = longMsg + String.format(Intl.intl("Unaligned with %s"), longOverlapStr);
                }
                this.d_alignQ.setForeground(new Color(217, 128, 13));
                this.d_alignQ.setText(shrtMsg);
                this.d_alignQ.setToolTipText(longMsg);
            }
        }

        private void updateSpinner(Grid g) {
            int order = Util.indexOf(GridManagerDlg.this.d_mgr.flatten(), g) + 1;
            int min = Math.max(1, order - 1);
            int max = Math.min(GridManagerDlg.this.d_mgr.flatten().size(), order + 1);
            this.d_spinner.setModel(new SpinnerNumberModel(order, min, max, -1));
        }

        @Override
        public boolean isModified() {
            return this.d_editorPanel.isModified();
        }

        public void saveGrid(Grid dest) {
            Grid grid = this.d_panel.getGrid();
            grid.setName(dest.getName());
            grid.setFYI(this.d_fyi.getText());
            Color color = this.d_colorCB.isSelected() ? this.d_colorBtn.getColor() : null;
            grid.setColor(color);
            grid.setCustomFDSProps(dest.getCustomFDSProps());
            this.d_advancedPanel.save(Collections.singleton(grid));
            dest.taskImprint(grid).run();
        }

        @Override
        public Grid commit(Grid dataObj) {
            assert (dataObj != null);
            Grid dest = dataObj;
            Grid tmp = (Grid)dest.clone();
            this.saveGrid(tmp);
            PyroMod domain = (PyroMod)GridManagerDlg.this.d_mgr.getDomain();
            domain.getTaskManager().exec(dest.taskImprint(tmp), Intl.intl("Apply Mesh Changes"));
            this.d_editorPanel.setModified(false);
            this.updateAlignmentQuality(dest);
            return dest;
        }

        @Override
        public guiPanel getEditorPanel() {
            return this.d_editorPanel;
        }

        @Override
        public void addObserver(Observer o) {
            this.d_editorPanel.addObserver(o);
        }

        @Override
        public void removeObserver(Observer o) {
            this.d_editorPanel.removeObserver(o);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int newIx = (Integer)this.d_spinner.getValue() - 1;
            Grid g = (Grid)GridManagerDlg.this.getList().getItem(GridManagerDlg.this.getList().getSelectedIx());
            PyroMod domain = (PyroMod)GridManagerDlg.this.d_mgr.getDomain();
            PyroTaskManager tMan = domain.getTaskManager();
            APyroObject before = null;
            int ix = 0;
            Iterator it = GridManagerDlg.this.d_mgr.flatten().iterator();
            while (it.hasNext() && ix < newIx) {
                Grid next = (Grid)it.next();
                if (next == g) continue;
                before = next;
                ++ix;
            }
            Composite parent = before == null ? GridManagerDlg.this.d_mgr : (Composite)before.getParent();
            int index = before == null ? 0 : parent.indexOf(before) + 1;
            ReorderObjectsTask t = new ReorderObjectsTask((IPyroObject)parent, index, g);
            ((TaskManager)tMan).exec(t, Intl.intl("Reorder Meshes"));
            GridManagerDlg.this.d_edix = newIx;
            GridManagerDlg.this.getList().updateModelView(GridManagerDlg.this.d_mgr);
            this.updateSpinner(g);
            this.updateAlignmentQuality(g);
        }

        public GridPanel getGridPanel() {
            return this.d_panel;
        }
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -8901054711690594357L;

        public NewAction() {
            super(Intl.intl("New..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GridManagerDlg.this.preSave()) {
                return;
            }
            PyroMod domain = (PyroMod)GridManagerDlg.this.d_mgr.getDomain();
            boolean resolution = false;
            double defCellSz = 0.2;
            while (!resolution) {
                resolution = true;
                NewDlg<Grid> dlg = new NewDlg<Grid>(GridManagerDlg.this.d_mgr, Grid.class, Intl.intl("mesh"));
                try {
                    AABox box;
                    if (dlg.doModal() != 1) continue;
                    Grid grid = null;
                    if (GridManagerDlg.this.d_mgr.flatten().isEmpty() && (box = GeomUtil.getBounds(domain.getAllGeom())).isValid()) {
                        double dx = box.getWidth();
                        double dy = box.getDepth();
                        double dz = box.getHeight();
                        double tol = 0.01;
                        if (dx > tol && dy > tol && dz > tol) {
                            AABox rounded = new AABox(new Point3d(Math.floor(box.getMinX()), Math.floor(box.getMinY()), Math.floor(box.getMinZ())), new Point3d(Math.ceil(box.getMaxX()), Math.ceil(box.getMaxY()), Math.ceil(box.getMaxZ())));
                            int nx = Math.max((int)Math.round(rounded.getWidth() / defCellSz), 1);
                            int ny = Math.max((int)Math.round(rounded.getDepth() / defCellSz), 1);
                            int nz = Math.max((int)Math.round(rounded.getHeight() / defCellSz), 1);
                            grid = new Grid(dlg.getName(), new UnitPoint3D(rounded.getMin(), (Unit)SI.METER), new UnitPoint3D(rounded.getMax(), (Unit)SI.METER), nx, ny, nz);
                        }
                    }
                    if (grid == null) {
                        grid = new Grid(dlg.getName(), new UnitPoint3D(new Point3d(0.0, 0.0, 0.0), (Unit)SI.METER), new UnitPoint3D(new Point3d(10.0, 10.0, 3.0), (Unit)SI.METER), 50, 50, 15);
                    }
                    try {
                        PyroTaskManager tMan = domain.getTaskManager();
                        ((TaskManager)tMan).exec(new AddTask((IPyroObject)GridManagerDlg.this.d_mgr, (IPyroObject[])new Grid[]{grid}), Intl.intl("New Mesh"));
                        GridManagerDlg.this.getList().updateModelView(GridManagerDlg.this.d_mgr);
                        GridManagerDlg.this.getList().select(grid);
                        GridManagerDlg.this.updateActions();
                    }
                    catch (Throwable t) {
                        PyroTaskManager tMan = domain.getTaskManager();
                        ((TaskManager)tMan).undo();
                        throw t;
                    }
                }
                catch (Throwable t) {
                    resolution = false;
                    defCellSz *= 1.5;
                }
            }
        }
    }
}

