/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IModelObj;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class ModelDialogsUtil {
    public static final Composite.IObjectProp colorProp = new Composite.AObjectProp<IModelObj, Color[]>(IModelObj.class){

        @Override
        public void set(IModelObj obj, Color[] prop) {
            if (obj instanceof FDSObject) {
                FDSObject.colorProp.set(obj, prop);
            } else if (obj instanceof GenericGeomSrc) {
                GenericGeomSrc.colorProp.set(obj, prop);
            }
        }

        @Override
        public Object get(IModelObj obj) {
            if (obj instanceof FDSObject) {
                return FDSObject.colorProp.get(obj);
            }
            if (obj instanceof GenericGeomSrc) {
                return GenericGeomSrc.colorProp.get(obj);
            }
            return Composite.NOT_SUPPORTED;
        }

        @Override
        public boolean equal(Color[] arg0, Color[] arg1) {
            return Arrays.equals(arg0, arg1);
        }
    };

    public static void loadName(Collection<? extends IPyroObject> shallowObjs, guiTextField nameField) {
        if (shallowObjs.size() == 1) {
            nameField.setText(Util.getName(shallowObjs.iterator().next()));
        } else {
            nameField.setText("<" + shallowObjs.size() + " Objects Selected>");
        }
    }

    public static void saveName(PyroMod domain, boolean isNew, Collection<? extends IPyroObject> shallowObjs, guiTextField nameField) {
        if (!isNew && !nameField.isModified()) {
            return;
        }
        IFilteredCollection<INamed> named = theUtil.filter(shallowObjs, INamed.class, n -> TVEntryPoints.ep(n).canRename(domain, (INamed)n));
        if (named.isEmpty()) {
            return;
        }
        String newName = nameField.getText();
        List<String> newNames = domain.getNames().generateValidNames(named, newName, !isNew);
        int m = 0;
        for (INamed nobj : named) {
            nobj.setName(newNames.get(m++));
        }
    }

    public static void validateName(PyroMod domain, boolean isNew, Collection<? extends IPyroObject> shallowObjs, guiTextField nameField) throws Exception {
        IFilteredCollection<INamed> named = theUtil.filter(shallowObjs, INamed.class);
        if (named.size() == 1 && (isNew || nameField.isModified())) {
            String newName = nameField.getText();
            INamed nobj = (INamed)named.iterator().next();
            if (!isNew && newName.equals(nobj.getName())) {
                return;
            }
            if (newName.isEmpty()) {
                throw new Exception(Intl.intl("Name must not be empty"));
            }
            if (domain.getNames(nobj).isRegistered(newName)) {
                throw new Exception(Intl.intl("Name is already in use. Choose a different name."));
            }
        }
    }

    public static void loadString(Collection<? extends IModelObj> objs, guiTextField textbox, Composite.IObjectProp<IModelObj, String> prop) {
        Object result = Composite.getProperty(prop, objs);
        if (result == Composite.NON_UNIFORM) {
            textbox.setValue(Intl.intl("<multiple>"));
        } else if (result instanceof String) {
            textbox.setValue((String)result);
        }
    }

    public static void saveString(Collection<? extends IModelObj> objs, guiTextField textbox, Composite.IObjectProp<IModelObj, String> prop) {
        if (textbox.isModified()) {
            Composite.setProperty(prop, textbox.getValue().trim(), objs);
        }
    }

    public static <ObjT extends IModelObj> void loadBoolean(Collection<? extends ObjT> objs, guiMultiStateCheckBox checkBox, Composite.IObjectProp<ObjT, Boolean> prop) {
        Object result = Composite.getProperty(prop, objs);
        if (result == Composite.NON_UNIFORM) {
            checkBox.setState(2);
        } else if (result instanceof Boolean) {
            checkBox.setSelected((Boolean)result);
        }
    }

    public static <ObjT extends IModelObj> void saveBoolean(PyroMod mediator, Collection<? extends ObjT> objs, guiMultiStateCheckBox cb, Composite.IObjectProp<ObjT, Boolean> prop) {
        if (cb.getState() != 2) {
            Composite.setProperty(prop, cb.isSelected(), objs);
        }
    }

    public static <ObjT extends IModelObj> void bakeTransforms(PyroMod mediator, Collection<? extends ObjT> objs) {
        for (IModelObj obj : objs) {
            IGeomNode geom = obj.getGeom();
            geom = geom.bakeIfRecommended();
            obj.setGeom(geom);
        }
    }

    public static void loadColor(Collection<? extends IModelObj> objs, guiMultiStateCheckBox checkBox, ColorButton button) {
        Object result = Composite.getProperty(colorProp, objs);
        if (result == Composite.NON_UNIFORM) {
            checkBox.setState(2);
        } else if (result != Composite.NOT_SUPPORTED) {
            boolean uniform;
            Color[] colors = (Color[])result;
            boolean bl = uniform = colors != null ? GeomUtil.isUniform(colors) : true;
            if (uniform) {
                checkBox.setSelected(colors[0] != null);
                if (colors[0] != null) {
                    button.setColor(colors[0]);
                }
            } else {
                checkBox.setState(2);
            }
        }
    }

    public static void saveColor(PyroMod mediator, Collection<? extends IModelObj> objs, guiMultiStateCheckBox checkBox, ColorButton button) {
        if (checkBox.getState() != 2) {
            Color color = checkBox.isSelected() ? button.getColor() : null;
            Composite.setProperty(colorProp, new Color[]{color}, objs);
        }
    }

    private static void setDFValue(ValueField<Double> field, double value, boolean uniform) {
        if (uniform) {
            field.setValue(value);
        } else {
            field.setText("");
        }
    }

    public static <T extends IModelObj> void loadDoubles(Collection<? extends T> deepObjs, Field<double[], T> loader, ValueField<Double> ... fields) {
        if (deepObjs.isEmpty()) {
            return;
        }
        Iterator<T> it = deepObjs.iterator();
        IModelObj first = (IModelObj)it.next();
        double[] vals = new double[fields.length];
        double[] firstVals = loader.getValue(first);
        assert (firstVals.length == fields.length);
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = firstVals[m];
        }
        boolean[] valsUniform = new boolean[vals.length];
        Arrays.fill(valsUniform, true);
        while (it.hasNext()) {
            IModelObj next = (IModelObj)it.next();
            double[] vals2 = loader.getValue(next);
            assert (vals2.length == vals.length);
            for (int m = 0; m < vals.length; ++m) {
                if (!valsUniform[m] || vals2[m] == vals[m]) continue;
                valsUniform[m] = false;
            }
        }
        for (int m = 0; m < fields.length; ++m) {
            ModelDialogsUtil.setDFValue(fields[m], vals[m], valsUniform[m]);
        }
    }

    public static <T extends IModelObj> void saveDoubles(PyroMod mediator, Collection<? extends T> deepObjs, Field<double[], T> saver, ValueField<Double> ... fields) {
        mediator.pauseUpdates();
        for (IModelObj obj : deepObjs) {
            double[] val = saver.getValue(obj);
            assert (val.length == fields.length);
            for (int m = 0; m < val.length; ++m) {
                if (fields[m].isEmpty()) continue;
                val[m] = (Double)fields[m].getValue();
            }
            saver.setValue(obj, val);
        }
        mediator.resumeUpdates();
    }

    public static <T extends IModelObj> void loadDouble(Collection<? extends T> deepObjs, Field<Double, T> loader, ValueField<Double> field) {
        if (deepObjs.isEmpty()) {
            return;
        }
        Iterator<T> it = deepObjs.iterator();
        Double val = loader.getValue((IModelObj)it.next());
        while (it.hasNext()) {
            IModelObj next = (IModelObj)it.next();
            Double val2 = loader.getValue(next);
            if (val.equals(val2)) continue;
            ModelDialogsUtil.setDFValue(field, val, false);
            return;
        }
        ModelDialogsUtil.setDFValue(field, val, true);
    }

    public static <T extends IModelObj> void saveDouble(PyroMod mediator, Collection<? extends T> deepObjs, Field<Double, T> saver, ValueField<Double> field) {
        if (field.isEmpty()) {
            return;
        }
        mediator.pauseUpdates();
        for (IModelObj obj : deepObjs) {
            saver.setValue((T)obj, (Double)field.getValue());
        }
        mediator.resumeUpdates();
    }

    public static interface Field<DataType, ObjType extends IModelObj> {
        public DataType getValue(ObjType var1);

        public void setValue(ObjType var1, DataType var2);
    }
}

