/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.Grid;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.FDSObject;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class EvacPanel
extends guiPanel {
    private static final long serialVersionUID = 2541253062723710927L;
    private static final List<Integer> evacuationOpts = Arrays.asList(0, 2, 1);
    private static final Object MULTIPLE = new Object();
    private guiComboBox d_cbEvacuation;
    private guiComboBox d_cbMeshId;
    public static final Composite.IObjectProp evacPropEvacuation = new Composite.AObjectProp<FDSObject, Integer>(FDSObject.class){

        @Override
        public void set(FDSObject obj, Integer prop) {
            throw new UnsupportedOperationException(Intl.intl("Use the direct setter to avoid cluttering the EvacProps pool."));
        }

        public Integer get(FDSObject obj) {
            return obj.getEvac().evacuation;
        }
    };
    public static final Composite.IObjectProp evacPropMeshId = new Composite.AObjectProp<FDSObject, Grid>(FDSObject.class){

        @Override
        public void set(FDSObject obj, Grid prop) {
            throw new UnsupportedOperationException(Intl.intl("Use the direct setter to avoid cluttering the EvacProps pool."));
        }

        public Grid get(FDSObject obj) {
            return obj.getEvac().mesh;
        }
    };

    public EvacPanel() {
        guiLabel lblEvacuation = new guiLabel(Intl.intl("Use In:"));
        lblEvacuation.setToolTipText("EVACUATION");
        this.d_cbEvacuation = new guiComboBox();
        this.d_cbEvacuation.setRenderer(new CbRendererEvacuation());
        guiLabel lblMeshId = new guiLabel("Mesh:");
        lblMeshId.setToolTipText("MESH_ID");
        this.d_cbMeshId = new guiComboBox();
        this.d_cbMeshId.setRenderer(new CbRendererMeshId());
        this.setLayout(new GridBagLayout());
        int r = 0;
        GridBagUtil.add(this, lblEvacuation, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_cbEvacuation, 1, r, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, lblMeshId, 0, ++r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_cbMeshId, 1, r, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(this);
    }

    public void load(PyroMod domain, Collection<? extends FDSObject> objs) {
        Vector<Integer> vEvacuation = new Vector<Integer>(evacuationOpts);
        Vector vMeshId = new Vector(domain.getGridManager().flatten());
        vMeshId.add(0, null);
        Object evacuation = Composite.getProperty(evacPropEvacuation, objs);
        Object meshId = Composite.getProperty(evacPropMeshId, objs);
        this.cbInit(this.d_cbEvacuation, vEvacuation, evacuation);
        this.cbInit(this.d_cbMeshId, vMeshId, meshId);
    }

    private void cbInit(guiComboBox cb, Vector options, Object val) {
        if (val == Composite.NON_UNIFORM) {
            options.add(0, MULTIPLE);
            val = MULTIPLE;
        }
        cb.setModel(new DefaultComboBoxModel(options));
        cb.setSelectedItem(val);
    }

    public void save(PyroMod domain, Collection<? extends FDSObject> objs) {
        Object evacuationObj = this.d_cbEvacuation.getSelectedItem();
        Object meshIdObj = this.d_cbMeshId.getSelectedItem();
        if (evacuationObj != MULTIPLE || meshIdObj != MULTIPLE) {
            if (evacuationObj != MULTIPLE && meshIdObj != MULTIPLE) {
                EvacProps newProps = EvacProps.get((Integer)evacuationObj, (Grid)meshIdObj);
                Composite.setProperty(FDSObject.evacProp, newProps, objs);
            } else {
                for (FDSObject fDSObject : objs) {
                    Integer evacuation = evacuationObj == MULTIPLE ? Integer.valueOf(fDSObject.getEvac().evacuation) : (Integer)evacuationObj;
                    Grid meshId = meshIdObj == MULTIPLE ? fDSObject.getEvac().mesh : (Grid)meshIdObj;
                    EvacProps newProps = EvacProps.get(evacuation, meshId);
                    fDSObject.setEvac(newProps);
                }
            }
        }
    }

    private class CbRendererEvacuation
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 5860300054815079712L;

        private CbRendererEvacuation() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == MULTIPLE) {
                this.setText(Intl.intl("<multiple>"));
            } else {
                switch (Integer.valueOf((Integer)value)) {
                    case 0: {
                        this.setText(Intl.intl("Default"));
                        break;
                    }
                    case 2: {
                        this.setText(Intl.intl("Evac Only"));
                        break;
                    }
                    case 1: {
                        this.setText(Intl.intl("Fire Only"));
                    }
                }
            }
            return this;
        }
    }

    private class CbRendererMeshId
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 8666832609776817309L;

        private CbRendererMeshId() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == MULTIPLE) {
                this.setText(Intl.intl("<multiple>"));
            } else if (value != null) {
                this.setText(((Grid)value).getName());
            } else {
                this.setText(Intl.intl("Default"));
            }
            return this;
        }
    }
}

