/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.devices.NewSprinklerLinkModelDlg;
import pyrosim.gui.devices.SprinklerLinkModelPanel;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class SprinklerLinkModelManagerDlg
extends ManagerDlg {
    private static final long serialVersionUID = -9183950827654889044L;
    private final Action[] d_actions;
    private final IEditor d_editor;
    private SprinklerLinkModelMgr d_sprinklerMgr;
    private JFrame d_owner;

    public SprinklerLinkModelManagerDlg(JFrame owner) {
        super(owner, Intl.intl("Sprinkler Link Models"), true);
        this.d_owner = owner;
        this.d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(this, SprinklerLinkModel.class), new RenameAction(this, Intl.intl("sprinkler link model")), new ManagerDlg.DeleteAction(this)};
        this.d_editor = new SprinklerLinkModelPanel(this);
        this.setPreviewTypes("PROP", "RAMP");
    }

    private void updateActions() {
        int selIx = this.getList().getSelectedIx();
        this.d_actions[0].setEnabled(this.d_sprinklerMgr != null);
        this.d_actions[2].setEnabled(this.d_sprinklerMgr != null && selIx > -1);
        this.d_actions[3].setEnabled(this.d_sprinklerMgr != null && selIx > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.updateActions();
    }

    public void init(SprinklerLinkModelMgr sprinklerMgr, SprinklerLinkModel sprinkler) {
        this.d_sprinklerMgr = sprinklerMgr;
        ((RenameAction)this.d_actions[2]).init(sprinklerMgr);
        super.init(this.d_sprinklerMgr, this.d_editor, this.d_actions, sprinkler);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 9154714627772565686L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!SprinklerLinkModelManagerDlg.this.preSave()) {
                return;
            }
            PyroMod domain = (PyroMod)SprinklerLinkModelManagerDlg.this.d_sprinklerMgr.getDomain();
            NewSprinklerLinkModelDlg dlg = new NewSprinklerLinkModelDlg(domain);
            if (dlg.doModal() == 1) {
                SprinklerLinkModel newSprinklerLinkModel = new SprinklerLinkModel(dlg.getSprinklerLinkName());
                AddTask t = new AddTask((IPyroObject)SprinklerLinkModelManagerDlg.this.d_sprinklerMgr, new IPyroObject[]{newSprinklerLinkModel});
                SelectTask wrapper = new SelectTask(domain, newSprinklerLinkModel);
                wrapper.addTask(t);
                domain.getTaskManager().exec(wrapper, Intl.intl("New Sprinkler Link Model"));
                SprinklerLinkModelManagerDlg.this.getList().updateModelView(SprinklerLinkModelManagerDlg.this.d_sprinklerMgr);
                SprinklerLinkModelManagerDlg.this.getList().select(newSprinklerLinkModel);
                SprinklerLinkModelManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                SprinklerLinkModelManagerDlg.this.updateActions();
            }
        }
    }
}

