/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.devices.HeatLinkModelPanel;
import pyrosim.gui.devices.NewHeatLinkModelDlg;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class HeatLinkModelManagerDlg
extends ManagerDlg {
    private static final long serialVersionUID = -7747337896907429802L;
    private final Action[] d_actions;
    private final IEditor d_editor;
    private HeatLinkModelMgr d_heatMgr;
    private JFrame d_owner;

    public HeatLinkModelManagerDlg(JFrame owner) {
        super(owner, Intl.intl("Heat Detector Models"), true);
        this.d_owner = owner;
        this.d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(this, HeatLinkModel.class), new RenameAction(this, Intl.intl("heat link model")), new ManagerDlg.DeleteAction(this)};
        this.d_editor = new HeatLinkModelPanel(this);
        this.setPreviewTypes("PROP", "RAMP");
    }

    private void updateActions() {
        int selIx = this.getList().getSelectedIx();
        this.d_actions[0].setEnabled(this.d_heatMgr != null);
        this.d_actions[2].setEnabled(this.d_heatMgr != null && selIx > -1);
        this.d_actions[3].setEnabled(this.d_heatMgr != null && selIx > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.updateActions();
    }

    public void init(HeatLinkModelMgr heatMgr, HeatLinkModel heat) {
        this.d_heatMgr = heatMgr;
        ((RenameAction)this.d_actions[2]).init(heatMgr);
        super.init(this.d_heatMgr, this.d_editor, this.d_actions, heat);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 2455904156008757164L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!HeatLinkModelManagerDlg.this.preSave()) {
                return;
            }
            PyroMod domain = (PyroMod)HeatLinkModelManagerDlg.this.d_heatMgr.getDomain();
            NewHeatLinkModelDlg dlg = new NewHeatLinkModelDlg(domain);
            if (dlg.doModal() == 1) {
                HeatLinkModel newHeatLinkModel = new HeatLinkModel(dlg.getHeatLinkName());
                AddTask t = new AddTask((IPyroObject)HeatLinkModelManagerDlg.this.d_heatMgr, new IPyroObject[]{newHeatLinkModel});
                SelectTask wrapper = new SelectTask(domain, newHeatLinkModel);
                wrapper.addTask(t);
                domain.getTaskManager().exec(wrapper, Intl.intl("New Heat Detector Link Model"));
                HeatLinkModelManagerDlg.this.getList().updateModelView(HeatLinkModelManagerDlg.this.d_heatMgr);
                HeatLinkModelManagerDlg.this.getList().select(newHeatLinkModel);
                HeatLinkModelManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                HeatLinkModelManagerDlg.this.updateActions();
            }
        }
    }
}

