/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.gui.controls.ControlDesc;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;

public class TimeActivationPanel
extends guiPanel {
    private static final long serialVersionUID = 7479791470275231189L;
    private final guiTable d_table;
    private ControlDesc.SinkType d_sinkType = ControlDesc.SinkType.ACTIVATE;

    public TimeActivationPanel() {
        Unit tunit = PyroSim.getApp().getUnitSystem().getTimeUnit();
        String[] columnHeaders = new String[]{String.format(Intl.intl("Time (%s)"), tunit), Intl.intl("Event")};
        Class[] columnClasses = new Class[]{UnitDouble.class, String.class};
        this.d_table = guiTableUtil.fixedColumnTable(columnHeaders, columnClasses);
        guiTableEditor editor = new guiTableEditor(this.d_table, 0);
        this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(tunit));
        this.d_table.setColumnOptions(1, new Activation(true), new Activation(false));
        this.setLayout(new BorderLayout());
        this.add((Component)editor, "Center");
    }

    private Map<UnitDouble, Boolean> parseTimes() {
        TreeMap<UnitDouble, Boolean> timeMap = new TreeMap<UnitDouble, Boolean>();
        for (int m = 0; m < this.d_table.getRowCount(); ++m) {
            UnitDouble v = (UnitDouble)this.d_table.getValueAt(m, 0);
            Activation act = (Activation)this.d_table.getValueAt(m, 1);
            if (v == null || act == null) continue;
            timeMap.put(v, act.value);
        }
        return timeMap;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!this.isVisible()) {
            return true;
        }
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        Map<UnitDouble, Boolean> timeMap = this.parseTimes();
        if (timeMap.isEmpty()) {
            if (showWarn) {
                JOptionPane.showMessageDialog(Utils.findParentWindow(this), Intl.intl("You must enter at least one timed event."), Intl.intl("Missing Time Events"), 0);
            }
            return false;
        }
        return true;
    }

    public void setSinkType(ControlDesc.SinkType sinkType) {
        this.d_sinkType = sinkType;
        this.repaint();
    }

    public void load(CustomCtrl ctrl, boolean invert, UnitDouble delay) {
        boolean lastState = ctrl.getInitialState() ^ invert;
        int row = 0;
        this.d_table.clearRows();
        for (UnitDouble val : ctrl.getTripValues()) {
            boolean currentState = !lastState;
            UnitDouble time = val.add(delay);
            this.d_table.getModel().setValueAt(time, row, 0);
            this.d_table.getModel().setValueAt(new Activation(currentState), row, 1);
            ++row;
            lastState = currentState;
        }
        this.d_table.repaint();
    }

    public ILogicOutPin save() {
        boolean initiallyOn;
        Map<UnitDouble, Boolean> timeMap = this.parseTimes();
        if (timeMap.isEmpty()) {
            return null;
        }
        Iterator<Map.Entry<UnitDouble, Boolean>> entryit = timeMap.entrySet().iterator();
        boolean lastActivate = entryit.next().getValue();
        while (entryit.hasNext()) {
            Map.Entry<UnitDouble, Boolean> next = entryit.next();
            if (next.getValue() == lastActivate) {
                entryit.remove();
                continue;
            }
            lastActivate = next.getValue();
        }
        boolean bl = initiallyOn = timeMap.values().iterator().next() == false;
        if (timeMap.size() == 1) {
            Timer timer = new Timer(timeMap.keySet().iterator().next(), initiallyOn);
            return (ILogicOutPin)timer.getOutputPins().get(0);
        }
        CustomCtrl ctrl = new CustomCtrl(initiallyOn, timeMap.keySet());
        Clock clock = Clock.INSTANCE;
        ctrl.getInputPin().connect(clock.getOutputPins().get(0));
        return (ILogicOutPin)ctrl.getOutputPins().get(0);
    }

    private class Activation {
        public final boolean value;

        public Activation(boolean value) {
            this.value = value;
        }

        public String toString() {
            return this.value ? ((TimeActivationPanel)TimeActivationPanel.this).d_sinkType.strings.activate : ((TimeActivationPanel)TimeActivationPanel.this).d_sinkType.strings.deactivate;
        }
    }
}

