/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.boundcond;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.jeuclid.swing.JMathComponent;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IHeatBasedValue;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidReaction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.mat.ReacByproducts;
import pyrosim.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.domain.boundcond.mat.SolidReaction;
import pyrosim.domain.boundcond.mat.ThermalProps;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.RampFuncDlg;
import pyrosim.gui.boundcond.SolidPyrolysisReacDlg;
import pyrosim.unitsystem.PyroUnitSrc;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.format.UnitDoubleFormat;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.ResizableTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.theUtil;

public class MaterialPanel
extends guiPanel
implements IEditor<Material> {
    private static final long serialVersionUID = 4894548341602977042L;
    private final guiTextField d_matID;
    private final guiTextField d_fyi;
    private final guiComboBox<String> d_profileListBox;
    private final JTabbedPane d_tabs;
    private final guiDialog d_parent;
    private final MaterialPanel d_matPanel;
    private final ThermPropsPanel d_thermPropsPanel;
    private final LiquidPyrolysisPanel d_liquidPyrolysisPanel;
    private final SolidPyrolysisPanel d_solidPyrolysisPanel;
    private final CustomFDSPanel d_advancedPnl;
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
    private final MaterialManager d_matMgr;
    private ExSpecList d_exSpecList;
    private Material d_currentMaterial;
    public static final String LIQUID = Intl.intl("Liquid Fuel");
    public static final String SOLID = Intl.intl("Solid");
    public static final String THERMAL_PROPERTIES = Intl.intl("Thermal Properties");
    public static final String PYROLYSIS = Intl.intl("Pyrolysis");

    public MaterialPanel(guiDialog parent) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        this.d_matMgr = pyMod.getMaterialMgr();
        this.d_exSpecList = pyMod.getExSpecList();
        this.d_matPanel = this;
        this.setLayout(new GridBagLayout());
        this.d_parent = parent;
        guiLabel labID = new guiLabel(Intl.intl("Material ID:"));
        this.d_matID = new guiTextField();
        this.d_matID.setEditable(false);
        guiLabel labFYI = new guiLabel(Intl.intl("Description:"));
        this.d_fyi = new guiTextField();
        this.d_fyi.setToolTipText("FYI");
        this.d_thermPropsPanel = new ThermPropsPanel();
        this.d_liquidPyrolysisPanel = new LiquidPyrolysisPanel();
        this.d_solidPyrolysisPanel = new SolidPyrolysisPanel();
        this.d_advancedPnl = new CustomFDSPanel(7);
        int r = 0;
        GridBagUtil.add(this, labID, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_matID, 1, r++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, labFYI, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_fyi, 1, r++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        this.d_profileListBox = new guiComboBox<Object>((T[])new Object[]{SOLID, LIQUID});
        this.d_profileListBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String choice = e.getItem().toString();
                int tabSel = MaterialPanel.this.d_tabs.getSelectedIndex();
                MaterialPanel.this.d_tabs.removeAll();
                MaterialPanel.this.setModified(true);
                if (choice.equals(LIQUID)) {
                    MaterialPanel.this.d_tabs.addTab(THERMAL_PROPERTIES, MaterialPanel.this.d_thermPropsPanel);
                    MaterialPanel.this.d_tabs.addTab(PYROLYSIS, MaterialPanel.this.d_liquidPyrolysisPanel);
                } else if (choice.equals(SOLID)) {
                    MaterialPanel.this.d_tabs.addTab(THERMAL_PROPERTIES, MaterialPanel.this.d_thermPropsPanel);
                    MaterialPanel.this.d_tabs.addTab(PYROLYSIS, MaterialPanel.this.d_solidPyrolysisPanel);
                } else {
                    MaterialPanel.this.d_tabs.addTab(Intl.intl("Properties"), MaterialPanel.this.getEmptyPanel());
                }
                MaterialPanel.this.d_tabs.addTab(Intl.intl("Advanced"), MaterialPanel.this.d_advancedPnl);
                if (MaterialPanel.this.d_tabs.getTabCount() > 1) {
                    MaterialPanel.this.d_tabs.setSelectedIndex(tabSel);
                }
            }
        });
        guiLabel surfTypeLab = new guiLabel(Intl.intl("Material Type") + ":");
        GridBagUtil.add(this, surfTypeLab, 0, r, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_profileListBox, 1, r++, 3, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        this.d_tabs = new JTabbedPane();
        this.d_tabs.addTab(Intl.intl("Properties"), this.getEmptyPanel());
        this.d_tabs.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_thermPropsPanel, this.d_liquidPyrolysisPanel, this.d_solidPyrolysisPanel, this.d_advancedPnl));
        GridBagUtil.add(this, this.d_tabs, 0, r++, 100, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public void init(Material mat) {
        this.setEnabled(mat != null);
        if (mat != null) {
            this.loadSurface(mat);
            this.d_matID.setText(mat.getName());
            this.d_fyi.setText(mat.getFYI());
        }
        this.setModified(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public Material preview(Material mat) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.saveMaterial(mat);
        return mat;
    }

    @Override
    public Material commit(final Material mat) {
        AOneTimeTask t = new AOneTimeTask(){

            @Override
            public void run() {
                MaterialPanel.this.saveMaterial(mat);
                mat.setFYI(MaterialPanel.this.d_fyi.getText());
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Edit Material"));
        this.setModified(false);
        return mat;
    }

    private void saveMaterial(Material mat) {
        String choice = this.d_profileListBox.getSelectedItem();
        mat.setFYI(this.d_fyi.getText());
        if (choice == SOLID) {
            mat.setThermalProps(this.d_thermPropsPanel.saveData());
            mat.setPyrolysis(this.d_solidPyrolysisPanel.saveData());
        } else if (choice == LIQUID) {
            mat.setThermalProps(this.d_thermPropsPanel.saveData());
            mat.setPyrolysis(this.d_liquidPyrolysisPanel.saveData());
        }
        this.d_advancedPnl.save(Collections.singleton(mat));
    }

    private void loadSurface(Material mat) {
        int tabSel = this.d_tabs.getSelectedIndex();
        this.d_tabs.removeAll();
        this.d_currentMaterial = mat;
        this.clearPanels();
        if (mat.isSolid()) {
            this.d_tabs.add(THERMAL_PROPERTIES, this.d_thermPropsPanel);
            this.d_thermPropsPanel.loadData(mat.getThermalProps());
            this.d_tabs.add(PYROLYSIS, this.d_solidPyrolysisPanel);
            this.d_solidPyrolysisPanel.loadData((SolidPyrolysis)mat.getPyrolysis());
            this.d_profileListBox.setSelectedItem(SOLID);
        } else {
            this.d_tabs.add(THERMAL_PROPERTIES, this.d_thermPropsPanel);
            this.d_thermPropsPanel.loadData(mat.getThermalProps());
            this.d_tabs.addTab(PYROLYSIS, this.d_liquidPyrolysisPanel);
            this.d_liquidPyrolysisPanel.loadData((LiquidPyrolysis)mat.getPyrolysis());
            this.d_profileListBox.setSelectedItem(LIQUID);
        }
        this.d_tabs.add(Intl.intl("Advanced"), this.d_advancedPnl);
        this.d_advancedPnl.clear();
        this.d_advancedPnl.load(Collections.singleton(mat), new CustomFDSPanel.AdvPropWrapper<Boolean>(mat.isForceWrite(), 1));
        if (this.d_tabs.getTabCount() > 1) {
            this.d_tabs.setSelectedIndex(tabSel);
        }
    }

    private void clearPanels() {
        this.d_thermPropsPanel.loadData(null);
        this.d_liquidPyrolysisPanel.loadData(null);
        this.d_solidPyrolysisPanel.loadData(null);
        this.d_advancedPnl.clear();
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private guiPanel getEmptyPanel() {
        guiPanel panel = new guiPanel();
        return panel;
    }

    private class RampAction
    implements ActionListener {
        private IRampInput d_defInput;
        private int d_valUnit;
        private String d_valDesc;
        public Ramp d_holdRamp;

        public RampAction(IRampInput input, int valUnit, String valDesc) {
            this.d_defInput = input;
            this.d_valUnit = valUnit;
            this.d_holdRamp = null;
            this.d_valDesc = valDesc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Ramp preRamp = this.d_holdRamp != null ? this.d_holdRamp : new Ramp(Collections.EMPTY_LIST, this.d_defInput, this.d_valUnit);
            assert (preRamp != null);
            RampFuncDlg rampDlg = new RampFuncDlg(preRamp.getDefaultInput(), this.d_valUnit, this.d_valDesc, null);
            rampDlg.loadData(preRamp);
            if (rampDlg.doModal() == 1) {
                Ramp postRamp = rampDlg.getRamp();
                if (preRamp == null && postRamp != null || preRamp != null && postRamp == null || preRamp != null && postRamp != null && !preRamp.equals(postRamp)) {
                    this.d_holdRamp = postRamp;
                    MaterialPanel.this.setModified(true);
                }
            }
        }
    }

    private class SolidPyrolysisPanel
    extends guiPanel
    implements ListSelectionListener {
        private static final long serialVersionUID = 8606409129533740805L;
        private final ValueField<UnitDouble> d_heatOfComb;
        private final guiCheckBox d_heatOfCombCB;
        private final JList d_list;
        private final JScrollPane d_jsp;
        private guiLabel d_reacLab;
        private guiLabel d_dispByprodLab;
        private guiLabel[] d_dispByprodLabList;
        private ByproductsPanel d_byproductsPanel;
        private guiPanel d_reacDispl;
        private final JButton d_addButton;
        private final JButton d_deleteButton;
        private final JButton d_editButton;
        private final JMathComponent d_equation;

        public SolidPyrolysisPanel() {
            this.setLayout(new GridBagLayout());
            int row = 0;
            this.d_heatOfCombCB = new guiCheckBox(Intl.intl("Heat of Combustion") + ":");
            this.d_heatOfComb = ValueFields.udFld(UnitSystem.getSource(48));
            this.d_heatOfComb.setNullAllowed(false);
            GridBagUtil.add(this, this.d_heatOfCombCB, 0, row, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_heatOfComb, 2, row++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            this.d_heatOfCombCB.addActionListener(e -> {
                if (this.d_heatOfComb.isEmpty()) {
                    this.d_heatOfComb.setValue(SIUS.newud(0.0, 48));
                }
                this.d_heatOfComb.requestFocusInWindow();
            });
            TitleSeparator reacTitle = new TitleSeparator(Intl.intl("Reactions"));
            GridBagUtil.add(this, reacTitle, 0, row++, 4, 1, 0, 12, 6, 12, 2, 0.0, 0.0, 17);
            this.d_list = new JList();
            this.d_list.addListSelectionListener(this);
            this.d_list.setSelectionMode(0);
            this.d_list.setModel(new DefaultListModel());
            this.d_list.setCellRenderer(new ListRenderer());
            this.d_jsp = new JScrollPane(this.d_list);
            this.d_jsp.setVerticalScrollBarPolicy(22);
            this.d_jsp.setPreferredSize(new Dimension(80, 120));
            guiPanel left = new guiPanel(new GridBagLayout());
            this.d_reacDispl = new guiPanel();
            GridBagUtil.add(this, left, 0, row, 1, 1, 0, 12, 6, 0, 3, 0.0, 1.0, 17);
            GridBagUtil.add(this, this.d_reacDispl, 1, row, 3, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 18);
            guiPanel buttonPanel = new guiPanel(new GridBagLayout());
            GridBagUtil.add(left, this.d_jsp, 0, 0, 1, 1, 0, 0, 12, 12, 1, 1.0, 1.0);
            GridBagUtil.add(left, buttonPanel, 0, 1, 1, 1, 0, 0, 0, 12, 1, 1.0, 0.0);
            this.d_addButton = new JButton(Intl.intl("Add") + "...");
            this.d_deleteButton = new JButton(Intl.intl("Delete") + "...");
            this.d_editButton = new JButton(Intl.intl("Edit") + "...");
            GridBagUtil.add(buttonPanel, Box.createGlue(), 0, 100, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0);
            GridBagUtil.add(buttonPanel, this.d_addButton, 0, 0, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0);
            GridBagUtil.add(buttonPanel, this.d_deleteButton, 0, 1, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0);
            GridBagUtil.add(buttonPanel, this.d_editButton, 0, 2, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0);
            this.d_reacDispl.setLayout(new GridBagLayout());
            int dispRow = 0;
            this.d_reacLab = new guiLabel("Reac Name");
            guiLabel dispRateLab = new guiLabel(Intl.intl("Rate") + ":");
            this.d_equation = new JMathComponent(){
                private static final long serialVersionUID = 6987145753942876915L;

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    return new Dimension(d.width, d.height + 10);
                }
            };
            this.d_dispByprodLab = new guiLabel(Intl.intl("Byproducts") + ":");
            this.d_dispByprodLabList = new guiLabel[4];
            this.d_dispByprodLabList[0] = new guiLabel("");
            this.d_dispByprodLabList[1] = new guiLabel("");
            this.d_dispByprodLabList[2] = new guiLabel("");
            this.d_dispByprodLabList[3] = new guiLabel("");
            GridBagUtil.add(this.d_reacDispl, this.d_reacLab, 0, dispRow++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, dispRateLab, 0, dispRow++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, this.d_equation, 0, dispRow++, 2, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, this.d_dispByprodLab, 0, dispRow, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, this.d_dispByprodLabList[0], 1, dispRow++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, this.d_dispByprodLabList[1], 1, dispRow++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, this.d_dispByprodLabList[2], 1, dispRow++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_reacDispl, this.d_dispByprodLabList[3], 1, dispRow++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this.d_reacDispl);
            GridBagUtil.addGlue(this);
            LinkStatus.link((AbstractButton)this.d_heatOfCombCB, this.d_heatOfComb);
            this.d_byproductsPanel = new ByproductsPanel(true);
            this.d_addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String num = Intl.intl("Edit Pyrolysis Reaction ");
                    if (!SolidPyrolysisPanel.this.d_list.isSelectionEmpty()) {
                        num = num + Intl.intl("- Reaction ") + (SolidPyrolysisPanel.this.d_list.getModel().getSize() + 1);
                    }
                    SolidPyrolysisReacDlg dlg = new SolidPyrolysisReacDlg(num, SolidPyrolysisPanel.this.d_byproductsPanel);
                    dlg.loadByproducts(null, MaterialPanel.this.d_currentMaterial);
                    if (dlg.doModal() == 1) {
                        SolidReaction newReac = new SolidReaction(dlg.saveRate(), dlg.saveByproducts());
                        ((DefaultListModel)SolidPyrolysisPanel.this.d_list.getModel()).addElement(newReac);
                        SolidPyrolysisPanel.this.d_list.setSelectedValue(newReac, false);
                        MaterialPanel.this.d_matPanel.setModified(true);
                        SolidPyrolysisPanel.this.updateAction();
                    }
                }
            });
            this.d_editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int location = SolidPyrolysisPanel.this.d_list.getSelectedIndex();
                    String num = Intl.intl("Edit Pyrolysis Reaction ");
                    if (SolidPyrolysisPanel.this.d_list.getModel().getSize() > 1) {
                        num = num + Intl.intl("- Reaction ") + (location + 1);
                    }
                    SolidReaction reac = (SolidReaction)SolidPyrolysisPanel.this.d_list.getSelectedValue();
                    SolidPyrolysisReacDlg dlg = new SolidPyrolysisReacDlg(num, SolidPyrolysisPanel.this.d_byproductsPanel);
                    dlg.loadByproducts(reac.d_byproducts, MaterialPanel.this.d_currentMaterial);
                    dlg.loadRate(reac.d_rate);
                    if (dlg.doModal() == 1) {
                        SolidReaction newReac = new SolidReaction(dlg.saveRate(), dlg.saveByproducts());
                        ((DefaultListModel)SolidPyrolysisPanel.this.d_list.getModel()).removeElementAt(location);
                        ((DefaultListModel)SolidPyrolysisPanel.this.d_list.getModel()).add(location, newReac);
                        SolidPyrolysisPanel.this.d_list.setSelectedValue(newReac, false);
                        MaterialPanel.this.d_matPanel.setModified(true);
                        SolidPyrolysisPanel.this.updateAction();
                    }
                }
            });
            this.d_deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int location = SolidPyrolysisPanel.this.d_list.getSelectedIndex();
                    int size = SolidPyrolysisPanel.this.d_list.getModel().getSize();
                    String num = Intl.intl("Reaction ");
                    if (size > 1) {
                        num = Intl.intl("Reaction ") + (location + 1);
                    }
                    String msg = Intl.intl("Delete reaction") + ": " + num;
                    int option = JOptionPane.showConfirmDialog(MaterialPanel.this.d_matPanel, msg, Intl.intl("Confirm Delete"), 2);
                    if (option != 0) {
                        return;
                    }
                    ((DefaultListModel)SolidPyrolysisPanel.this.d_list.getModel()).removeElementAt(location);
                    if (size > 1) {
                        SolidPyrolysisPanel.this.d_list.setSelectedIndex(location - 1);
                    }
                    MaterialPanel.this.d_matPanel.setModified(true);
                    SolidPyrolysisPanel.this.updateAction();
                }
            });
            this.updateAction();
        }

        public void loadData(SolidPyrolysis sp) {
            SolidPyrolysis defsp = new SolidPyrolysis();
            this.d_heatOfCombCB.setSelected(false);
            this.d_heatOfComb.setValue(defsp.d_heatOfCombustion);
            Unit u = ((PyroUnitSrc)((UnitDoubleFormat)this.d_heatOfComb.getFormat()).getUnitType()).getUnit();
            if (defsp.d_heatOfCombustion != null && defsp.d_heatOfCombustion.getValue(u) > 0.0) {
                this.d_heatOfCombCB.setSelected(true);
            }
            ((DefaultListModel)this.d_list.getModel()).removeAllElements();
            this.d_reacDispl.setVisible(false);
            if (sp == null) {
                return;
            }
            if (sp.d_heatOfCombustion != null && sp.d_heatOfCombustion.getValue(u) > 0.0) {
                this.d_heatOfCombCB.setSelected(true);
            }
            this.d_heatOfComb.setValue(sp.d_heatOfCombustion);
            for (SolidReaction sr : sp.getReactions()) {
                ((DefaultListModel)this.d_list.getModel()).addElement(sr);
            }
            int size = this.d_list.getModel().getSize();
            if (size > 0) {
                this.d_list.setSelectedIndex(0);
            }
            this.updateAction();
        }

        public SolidPyrolysis saveData() {
            UnitDouble heatofComb = null;
            if (this.d_heatOfCombCB.isSelected()) {
                heatofComb = (UnitDouble)this.d_heatOfComb.getValue();
            }
            Enumeration reacs = ((DefaultListModel)this.d_list.getModel()).elements();
            ArrayList<SolidReaction> reacsList = new ArrayList<SolidReaction>(this.d_list.getModel().getSize());
            while (reacs.hasMoreElements()) {
                reacsList.add((SolidReaction)reacs.nextElement());
            }
            return new SolidPyrolysis(heatofComb, reacsList);
        }

        public void updateAction() {
            this.d_addButton.setEnabled(this.d_list.getModel().getSize() < 10);
            this.d_deleteButton.setEnabled(this.d_list.getSelectedIndex() > -1);
            this.d_editButton.setEnabled(this.d_list.getSelectedIndex() > -1);
        }

        public void updateReacDisplay() {
            int location = this.d_list.getSelectedIndex();
            this.d_reacDispl.setVisible(false);
            if (location > -1) {
                this.d_reacDispl.setVisible(true);
                int size = this.d_list.getModel().getSize();
                String name = Intl.intl("Reaction ");
                if (size > 1) {
                    name = Intl.intl("Reaction ") + (location + 1);
                }
                this.d_reacLab.setText(name);
                SolidReaction sr = (SolidReaction)((DefaultListModel)this.d_list.getModel()).getElementAt(location);
                this.d_dispByprodLab.setVisible(false);
                int labelNum = 0;
                this.d_dispByprodLabList[0].setVisible(false);
                this.d_dispByprodLabList[1].setVisible(false);
                this.d_dispByprodLabList[2].setVisible(false);
                this.d_dispByprodLabList[3].setVisible(false);
                int maxEntries = this.d_dispByprodLabList.length;
                UnitDouble heat = sr.d_byproducts.d_heat;
                Unit heatUnit = MaterialPanel.this.d_currentUS.getHeatOfCombustion();
                if (heat != null) {
                    Object heatText = "" + heat.getValue(heatUnit);
                    heatText = (String)heatText + " " + heatUnit.toString();
                    this.d_dispByprodLabList[labelNum].setVisible(true);
                    this.d_dispByprodLabList[labelNum++].setText((String)heatText);
                    this.d_dispByprodLab.setVisible(true);
                }
                for (ReacByproducts.Residue r : sr.d_byproducts.getResidues()) {
                    if (labelNum >= maxEntries) break;
                    String str = "" + r.d_fraction + " " + r.d_type.getName();
                    this.d_dispByprodLabList[labelNum].setVisible(true);
                    this.d_dispByprodLabList[labelNum++].setText(str);
                    this.d_dispByprodLab.setVisible(true);
                }
                String Ahold = "A";
                String Ehold = "E";
                String A = "<mstyle mathcolor=\"blue\"><mo>";
                String E = "<mrow><mo>-</mo><mstyle mathcolor=\"blue\"><mo>";
                if (sr.d_rate.d_spec instanceof SolidReaction.Rate.AESpec) {
                    Ahold = "" + ((SolidReaction.Rate.AESpec)sr.d_rate.d_spec).d_a.getValue(MaterialPanel.this.d_currentUS.getUnit(50));
                    Ehold = "" + ((SolidReaction.Rate.AESpec)sr.d_rate.d_spec).d_e.getValue(MaterialPanel.this.d_currentUS.getActivationEnergy());
                }
                A = A + Ahold + "</mo></mstyle>";
                E = E + Ehold + "</mo></mstyle><mo> </mo></mrow>";
                String massFracN = "<mstyle mathcolor=\"blue\"><mo>" + sr.d_rate.d_massFracExponent + "</mo></mstyle>";
                String masFrac = "<mfenced><mfrac><msub><mi>&#961;</mi><mrow><mo>s,i</mo></mrow></msub><msub><mi>&#961;</mi><mrow><mo>s</mo><mi>0</mi></mrow></msub></mfrac></mfenced>";
                String massFracWexp = "<msup>" + masFrac + massFracN + "</msup>";
                String exponent = "<mrow><mo>exp</mo><mfenced><mrow><mfrac>" + E + "<msub><mo>RT</mo><mo>s</mo></msub></mfrac></mrow></mfenced></mrow>";
                String max = "";
                if (sr.d_rate.d_tempExponent != 0.0) {
                    String ignTemp = "<mstyle mathcolor=\"blue\"><mo>" + sr.d_rate.d_thresholdTemp.getValue(MaterialPanel.this.d_currentUS.getTempUnit()) + "</mo></mstyle>";
                    String ignTempN = "<mstyle mathcolor=\"blue\"><mo>" + sr.d_rate.d_tempExponent + "</mo></mstyle>";
                    max = "<mrow><mo>max</mo><msup><mfenced open=\"[\" close=\"]\"><mo>0</mo><mrow><msub><mo>T</mo><mo>s</mo></msub><mo>-</mo>" + ignTemp + "</mrow></mfenced>" + ignTempN + "</msup></mrow>";
                }
                this.d_equation.setContent("<mstyle mathsize=\"4mm\"><mrow>" + massFracWexp + A + exponent + max + "</mrow></mstyle>");
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateReacDisplay();
            this.updateAction();
        }

        public class ListRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 6888896668195028998L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String num = "";
                if (SolidPyrolysisPanel.this.d_list.getModel().getSize() > 1) {
                    num = "" + (index + 1);
                }
                ((JLabel)c).setText(Intl.intl("Reaction ") + num);
                return c;
            }
        }
    }

    private static class AliasedVal<ValType>
    implements Serializable {
        private static final long serialVersionUID = 7935159083378466645L;
        public final ValType value;
        public final String alias;

        public AliasedVal(ValType value) {
            this.value = value;
            String tempStr = "";
            if (value instanceof ExSpec) {
                tempStr = "[" + Intl.intl("Species:") + " SPEC] ";
            } else if (value instanceof Material) {
                tempStr = "[" + Intl.intl("Material:") + " MAT] ";
            }
            this.alias = tempStr + ((NamedPyroObject)value).getName();
        }

        public String toString() {
            return this.alias;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof AliasedVal && theUtil.equal(((AliasedVal)obj).value, this.value);
        }
    }

    public class ByproductsPanel
    extends guiPanel {
        private static final long serialVersionUID = 4255621731721815087L;
        private final guiCheckBox d_heatCB;
        private final guiRadioButton d_endo;
        private final guiRadioButton d_exo;
        private ValueField<UnitDouble> d_heatFld;
        private boolean d_isSolid;
        private final guiTable d_table;

        public ByproductsPanel(boolean isSolid) {
            this.setLayout(new GridBagLayout());
            int row = 0;
            this.d_isSolid = isSolid;
            guiLabel heatLbl = null;
            if (this.d_isSolid) {
                this.d_heatCB = new guiCheckBox(Intl.intl("Heat of Reaction") + ":");
                this.d_heatFld = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(47), UnitSystem.getSource(47));
                this.d_heatFld.setNullAllowed(false);
                this.d_heatCB.addActionListener(e -> {
                    if (this.d_heatFld.isEmpty()) {
                        this.d_heatFld.setValue(SIUS.newud(0.0, 48));
                    }
                    this.d_heatFld.requestFocusInWindow();
                });
            } else {
                this.d_heatCB = null;
                heatLbl = new guiLabel(Intl.intl("Heat of Vaporization") + ":");
                this.d_heatFld = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(46), UnitSystem.getSource(46));
            }
            this.d_endo = new guiRadioButton(Intl.intl("Endothermic"));
            this.d_exo = new guiRadioButton(Intl.intl("Exothermic"));
            ButtonGroup group = new ButtonGroup();
            group.add(this.d_endo);
            group.add(this.d_exo);
            JComponent heatCmp = this.d_heatCB != null ? this.d_heatCB : heatLbl;
            GridBagUtil.add(this, heatCmp, 0, row, 2, 1, 12, 12, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_heatFld, 2, row, 1, 1, 12, 0, 6, 6, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_endo, 4, row, 1, 1, 12, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_exo, 5, row++, 1, 1, 12, 0, 6, 6, 0, 0.0, 0.0, 17);
            String[] headers = new String[]{Intl.intl("Composition"), Intl.intl("Residue")};
            Class[] classes = new Class[]{Double.class, AliasedVal.class};
            this.d_table = guiTableUtil.fixedColumnTable(headers, classes);
            this.setTableOpts();
            this.d_table.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.d_table.getColumnModel().getColumn(1).setPreferredWidth(120);
            int width = this.d_table.autoSizeColumns(10);
            this.d_table.setPreferredScrollableViewportSize(new Dimension(width, 10));
            guiTableEditor editor = new guiTableEditor(this.d_table, 30);
            GridBagUtil.add(this, editor, 0, row++, 6, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
            GridBagUtil.addGlue(this);
            if (this.d_heatCB != null) {
                LinkStatus.link((AbstractButton)this.d_heatCB, this.d_heatFld, this.d_endo, this.d_exo);
            }
        }

        private void setTableOpts() {
            PyroSim pySim = PyroSim.getApp();
            PyroMod pyMod = pySim.getMediator();
            List<Material> mats = Util.sort(pyMod.getMaterialMgr());
            List<ExSpec> specs = Util.sort(pyMod.getExSpecList());
            ArrayList<AliasedVal<NamedPyroObject>> opts = new ArrayList<AliasedVal<NamedPyroObject>>();
            for (Material m : mats) {
                if (m.equals(MaterialPanel.this.d_currentMaterial)) continue;
                opts.add(new AliasedVal<Material>(m));
            }
            for (ExSpec e : specs) {
                opts.add(new AliasedVal<ExSpec>(e));
            }
            this.d_table.setColumnOptions(1, opts);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            double compSum = 0.0;
            ArrayList<NamedPyroObject> uniqueObjs = new ArrayList<NamedPyroObject>();
            for (int row = 0; row < this.d_table.getRowCount(); ++row) {
                Double comp = (Double)this.d_table.getValueAt(row, 0);
                AliasedVal alias = (AliasedVal)this.d_table.getValueAt(row, 1);
                if (comp == null && alias == null) continue;
                if (comp == null || comp < 0.0) {
                    this.procWarning(showWarn, allowModify, Intl.intl("All yield fractions must be greater than zero."));
                    return false;
                }
                if (alias == null) {
                    this.procWarning(showWarn, allowModify, Intl.intl("All yield values must correspond to a valid residue."));
                    return false;
                }
                NamedPyroObject res = (NamedPyroObject)alias.value;
                if (uniqueObjs.contains(res)) {
                    this.procWarning(showWarn, allowModify, String.format(Intl.intl("All residues must be unique. The duplicate residue %s at row %d has been ignored for redundancy."), res.getName(), row + 1));
                    continue;
                }
                compSum += comp.doubleValue();
                uniqueObjs.add(res);
            }
            if (compSum > 1.0) {
                this.procWarning(showWarn, allowModify, Intl.intl("All yield values must sum to one or less."));
                return false;
            }
            return true;
        }

        private void procWarning(boolean showWarn, boolean allowModify, String msg) {
            if (!this.d_isSolid && allowModify) {
                MaterialPanel.this.d_tabs.setSelectedComponent(MaterialPanel.this.d_liquidPyrolysisPanel);
            }
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, msg);
            }
        }

        public void loadData(ReacByproducts rb, Material currentMat) {
            if (this.d_heatCB != null) {
                this.d_heatCB.setSelected(false);
            }
            if (this.d_heatCB != null) {
                this.d_heatCB.setSelected(false);
            }
            this.d_endo.setSelected(true);
            this.d_table.selectAll();
            this.d_table.removeSelectedRows();
            this.d_table.clearSelection();
            this.setTableOpts();
            if (rb == null) {
                return;
            }
            ResizableTableModel mod = (ResizableTableModel)this.d_table.getModel();
            int rowix = 0;
            for (ReacByproducts.Residue r : rb.getResidues()) {
                Object[] row = new Object[]{r.d_fraction, new AliasedVal<NamedPyroObject>(r.d_type)};
                mod.insertRow(rowix++, row);
            }
            Unit u = ((UnitDoubleFormat)this.d_heatFld.getFormat()).getUnitType().getUnit();
            if (rb.d_heat != null) {
                UnitDouble heat;
                if (this.d_heatCB != null) {
                    this.d_heatCB.setSelected(true);
                }
                if (rb.d_heat.getValue(u) < 0.0) {
                    heat = rb.d_heat.negate();
                    this.d_exo.setSelected(true);
                } else {
                    heat = rb.d_heat;
                    this.d_endo.setSelected(true);
                }
                this.d_heatFld.setValue(heat);
            } else {
                this.d_heatFld.setValue(new UnitDouble(0.0, u));
            }
        }

        public ReacByproducts saveData() {
            UnitDouble heat = null;
            if (this.d_heatCB == null || this.d_heatCB.isSelected()) {
                heat = (UnitDouble)this.d_heatFld.getValue();
                if (this.d_exo.isSelected()) {
                    heat = heat.negate();
                }
            }
            ArrayList<Material> mats = new ArrayList<Material>();
            ArrayList<ExSpec> specs = new ArrayList<ExSpec>();
            ArrayList<Double> nuMats = new ArrayList<Double>();
            ArrayList<Double> nuSpecs = new ArrayList<Double>();
            ArrayList<NamedPyroObject> uniqueObjs = new ArrayList<NamedPyroObject>();
            for (int row = 0; row < this.d_table.getRowCount(); ++row) {
                if (this.d_table.getValueAt(row, 0) == null || this.d_table.getValueAt(row, 1) == null) continue;
                double comp = (Double)this.d_table.getValueAt(row, 0);
                NamedPyroObject obj = (NamedPyroObject)((AliasedVal)this.d_table.getValueAt((int)row, (int)1)).value;
                if (!(comp > 0.0) || obj == null || uniqueObjs.contains(obj)) continue;
                if (obj instanceof ExSpec) {
                    specs.add((ExSpec)obj);
                    nuSpecs.add(comp);
                }
                if (obj instanceof Material) {
                    mats.add((Material)obj);
                    nuMats.add(comp);
                }
                uniqueObjs.add(obj);
            }
            return new ReacByproducts(nuMats, mats, nuSpecs, specs, heat);
        }
    }

    private class LiquidPyrolysisPanel
    extends guiPanel {
        private static final long serialVersionUID = -5577229301363921584L;
        private final ValueField<UnitDouble> d_boilTemp;
        private final guiCheckBox d_heatOfCombustCB;
        private final ValueField<UnitDouble> d_heatOfCombust;
        private final ByproductsPanel d_byproductsPanel;

        public LiquidPyrolysisPanel() {
            this.setLayout(new GridBagLayout());
            int row = 0;
            this.d_boilTemp = ValueFields.udFld(UnitSystem.getSource(1));
            guiLabel boilTempLab = new guiLabel(Intl.intl("Boiling Temperature") + ":");
            this.d_heatOfCombustCB = new guiCheckBox(Intl.intl("Heat of Combustion:"));
            this.d_heatOfCombust = ValueFields.udFld(UnitSystem.getSource(48));
            this.d_heatOfCombust.setNullAllowed(false);
            this.d_heatOfCombustCB.addActionListener(e -> {
                if (this.d_heatOfCombust.isEmpty()) {
                    this.d_heatOfCombust.setValue(SIUS.newud(0.0, 48));
                }
                this.d_heatOfCombust.requestFocusInWindow();
            });
            LinkStatus.link((AbstractButton)this.d_heatOfCombustCB, this.d_heatOfCombust);
            GridBagUtil.add(this, this.d_heatOfCombustCB, 0, row, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_heatOfCombust, 2, row++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, boilTempLab, 0, row, 2, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_boilTemp, 2, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            TitleSeparator byproducts = new TitleSeparator(Intl.intl("Byproducts"));
            GridBagUtil.add(this, byproducts, 0, row++, 4, 1, 0, 12, 6, 12, 2, 0.0, 0.0, 17);
            this.d_byproductsPanel = new ByproductsPanel(false);
            GridBagUtil.add(this, this.d_byproductsPanel, 0, row++, 4, 1, -12, 18, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadData(LiquidPyrolysis liqPyro) {
            LiquidPyrolysis defPyro = new LiquidPyrolysis();
            this.d_heatOfCombustCB.setSelected(defPyro.d_heatOfCombust != null);
            this.d_heatOfCombust.setValue(defPyro.d_heatOfCombust);
            this.d_boilTemp.setValue(defPyro.d_reaction.d_rate.d_boilingTemp);
            this.d_byproductsPanel.loadData(defPyro.d_reaction.d_byproducts, MaterialPanel.this.d_currentMaterial);
            if (liqPyro == null) {
                return;
            }
            this.d_heatOfCombustCB.setSelected(liqPyro.d_heatOfCombust != null);
            this.d_heatOfCombust.setValue(liqPyro.d_heatOfCombust);
            this.d_boilTemp.setValue(liqPyro.d_reaction.d_rate.d_boilingTemp);
            this.d_byproductsPanel.loadData(liqPyro.d_reaction.d_byproducts, MaterialPanel.this.d_currentMaterial);
        }

        public LiquidPyrolysis saveData() {
            UnitDouble hoc = this.d_heatOfCombustCB.isSelected() ? (UnitDouble)this.d_heatOfCombust.getValue() : null;
            return new LiquidPyrolysis(hoc, new LiquidReaction(new LiquidReaction.Rate((UnitDouble)this.d_boilTemp.getValue()), this.d_byproductsPanel.saveData()));
        }
    }

    private class ThermPropsPanel
    extends guiPanel {
        private static final long serialVersionUID = 8205694290246682343L;
        private final ValueField<UnitDouble> d_density;
        private final ValueField<UnitDouble> d_specHeat;
        private final ValueField<UnitDouble> d_conductivity;
        private final ValueField<UnitDouble> d_absCoef;
        private final ValueField<Double> d_emissivity;
        private final JButton d_specHeatButton;
        private final JButton d_conductivityButton;
        private final RampAction d_specHeatAction;
        private final RampAction d_condAction;
        private final String d_constantID = Intl.intl("Constant");
        private final String d_fromTableID = Intl.intl("Custom");
        private final guiComboBox d_specHeatComboBox;
        private final guiComboBox d_condComboBox;
        private final guiPanel d_specHeatPanel;
        private final guiPanel d_condPanel;

        public ThermPropsPanel() {
            this.setLayout(new GridBagLayout());
            int row = 0;
            this.d_density = ValueFields.udFld(UnitSystem.getSource(4));
            guiLabel densLab = new guiLabel(Intl.intl("Density") + ":");
            GridBagUtil.add(this, densLab, 0, row, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_density, 2, row++, 1, 1, 12, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_specHeat = ValueFields.udFld(UnitSystem.getSource(11));
            this.d_specHeatButton = new JButton(Intl.intl("Edit table") + "...");
            this.d_specHeatAction = new RampAction(RampInputs.HEAT, 11, Intl.intl("Specific heat"));
            this.d_specHeatButton.addActionListener(this.d_specHeatAction);
            this.d_specHeatPanel = new guiPanel();
            guiLabel specHeatLab = new guiLabel(Intl.intl("Specific Heat"));
            this.d_specHeatPanel.setLayout(new GridBagLayout());
            this.d_specHeatPanel.add(this.d_specHeat);
            this.d_specHeatComboBox = new guiComboBox<Object>((T[])new Object[]{this.d_constantID, this.d_fromTableID});
            this.d_specHeatComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String choice = e.getItem().toString();
                    ThermPropsPanel.this.d_specHeatPanel.removeAll();
                    if (choice.equals(ThermPropsPanel.this.d_constantID)) {
                        ThermPropsPanel.this.d_specHeatPanel.add(ThermPropsPanel.this.d_specHeat);
                    } else {
                        ThermPropsPanel.this.d_specHeatPanel.add(ThermPropsPanel.this.d_specHeatButton);
                    }
                    ThermPropsPanel.this.validate();
                }
            });
            GridBagUtil.add(this, specHeatLab, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_specHeatComboBox, 1, row, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_specHeatPanel, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_conductivity = ValueFields.udFld(UnitSystem.getSource(19));
            this.d_conductivityButton = new JButton(Intl.intl("Edit table") + "...");
            this.d_condAction = new RampAction(RampInputs.HEAT, 19, Intl.intl("Conductivity"));
            this.d_conductivityButton.addActionListener(this.d_condAction);
            this.d_condPanel = new guiPanel();
            this.d_condPanel.setLayout(new GridBagLayout());
            this.d_condPanel.add(this.d_conductivity);
            guiLabel conductivityLab = new guiLabel(Intl.intl("Conductivity"));
            this.d_condComboBox = new guiComboBox<Object>((T[])new Object[]{this.d_constantID, this.d_fromTableID});
            this.d_condComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String choice = e.getItem().toString();
                    ThermPropsPanel.this.d_condPanel.removeAll();
                    if (choice.equals(ThermPropsPanel.this.d_constantID)) {
                        ThermPropsPanel.this.d_condPanel.add(ThermPropsPanel.this.d_conductivity);
                    } else {
                        ThermPropsPanel.this.d_condPanel.add(ThermPropsPanel.this.d_conductivityButton);
                    }
                    ThermPropsPanel.this.validate();
                }
            });
            GridBagUtil.add(this, conductivityLab, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_condComboBox, 1, row, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_condPanel, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_emissivity = ValueFields.doubleFld();
            guiLabel emissivityLab = new guiLabel(Intl.intl("Emissivity") + ":");
            GridBagUtil.add(this, emissivityLab, 0, row, 2, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_emissivity, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            this.d_absCoef = ValueFields.udFld(UnitSystem.getSource(13));
            guiLabel absCoefLab = new guiLabel(Intl.intl("Absorption Coefficient") + ":");
            GridBagUtil.add(this, absCoefLab, 0, row, 2, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_absCoef, 2, row++, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadData(ThermalProps tp) {
            ThermalProps deftp = new ThermalProps();
            this.d_density.setValue(deftp.d_density);
            this.d_specHeatAction.d_holdRamp = null;
            this.d_specHeatComboBox.setSelectedIndex(0);
            this.d_specHeatPanel.removeAll();
            this.d_specHeatPanel.add(this.d_specHeat);
            this.d_specHeat.setValue(((IHeatBasedValue.Constant)deftp.d_specificHeat).value);
            this.d_condAction.d_holdRamp = null;
            this.d_condComboBox.setSelectedIndex(0);
            this.d_condPanel.removeAll();
            this.d_condPanel.add(this.d_conductivity);
            this.d_conductivity.setValue(((IHeatBasedValue.Constant)deftp.d_conductivity).value);
            this.d_emissivity.setValue(deftp.d_emissivity);
            this.d_absCoef.setValue(deftp.d_absorptionCoeff);
            if (tp == null) {
                return;
            }
            this.d_density.setValue(tp.d_density);
            if (tp.d_specificHeat instanceof IHeatBasedValue.Constant) {
                this.d_specHeat.setValue(((IHeatBasedValue.Constant)tp.d_specificHeat).value);
            } else {
                this.d_specHeatAction.d_holdRamp = ((IHeatBasedValue.Custom)tp.d_specificHeat).value;
                this.d_specHeatComboBox.setSelectedIndex(1);
                this.d_specHeatPanel.removeAll();
                this.d_specHeatPanel.add(this.d_specHeatButton);
            }
            if (tp.d_conductivity instanceof IHeatBasedValue.Constant) {
                this.d_conductivity.setValue(((IHeatBasedValue.Constant)tp.d_conductivity).value);
            } else {
                this.d_condAction.d_holdRamp = ((IHeatBasedValue.Custom)tp.d_conductivity).value;
                this.d_condComboBox.setSelectedIndex(1);
                this.d_condPanel.removeAll();
                this.d_condPanel.add(this.d_conductivityButton);
            }
            this.d_emissivity.setValue(tp.d_emissivity);
            this.d_absCoef.setValue(tp.d_absorptionCoeff);
        }

        public ThermalProps saveData() {
            IHeatBasedValue conductivity = null;
            IHeatBasedValue specificheat = null;
            specificheat = this.d_specHeatComboBox.getSelectedIndex() == 0 ? new IHeatBasedValue.Constant((UnitDouble)this.d_specHeat.getValue()) : new IHeatBasedValue.Custom(this.d_specHeatAction.d_holdRamp);
            conductivity = this.d_condComboBox.getSelectedIndex() == 0 ? new IHeatBasedValue.Constant((UnitDouble)this.d_conductivity.getValue()) : new IHeatBasedValue.Custom(this.d_condAction.d_holdRamp);
            return new ThermalProps(conductivity, (UnitDouble)this.d_density.getValue(), specificheat, (Double)this.d_emissivity.getValue(), (UnitDouble)this.d_absCoef.getValue());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.validateRampData(Intl.intl("Specific Heat"), this.d_specHeatComboBox, this.d_specHeatButton, this.d_specHeatAction, showWarn, allowModify) && this.validateRampData(Intl.intl("Conductivity"), this.d_condComboBox, this.d_conductivityButton, this.d_condAction, showWarn, allowModify);
        }

        private boolean validateRampData(String desc, guiComboBox cb, JButton button, RampAction action, boolean showWarn, boolean allowModify) {
            if (cb.getSelectedIndex() == 1 && action.d_holdRamp == null && button.isEnabled() && button.isVisible()) {
                if (showWarn) {
                    String msg = String.format(Intl.intl("Custom %s table must not be empty."), desc);
                    guiDialog.showInvalidEntryMessage(this, msg);
                }
                if (allowModify) {
                    button.requestFocus();
                }
                return false;
            }
            return true;
        }
    }
}

