/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.appearance;

import java.awt.Component;
import java.io.File;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.appearance.MaterialDB;
import thunderheadeng.gui.ImageBtn;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.gui.materialdlg.IImageBtnListener;

public class ImageBtnListener
implements IImageBtnListener {
    public static final ImageBtnListener INSTANCE = new ImageBtnListener();
    private File d_defaultFile;

    @Override
    public void setDefaultFile(File file) {
        this.d_defaultFile = file;
    }

    @Override
    public boolean chooseNewImage(ImageBtn btn, String name) {
        IImage currImg = btn.getImage();
        File defFile = currImg != null && new File(currImg.getFilename()).exists() ? new File(currImg.getFilename()) : this.d_defaultFile;
        File f = PyroSim.getFilenames().getOpenFile((Component)SwingUtilities.getWindowAncestor(btn), String.format(Intl.intl("Choose %s Image"), name), defFile, PyroSim.getApp().getMediator().getAppearances().getFileFilters());
        if (f == null) {
            return false;
        }
        this.d_defaultFile = f;
        IImage img = MaterialDB.loadImage(f.getAbsolutePath());
        if (img == null) {
            return false;
        }
        if (img != btn.getImage()) {
            btn.setImage(img);
            btn.setModified(true);
        }
        return true;
    }
}

