/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.EventQueue;
import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.domain.GridProcessUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.actions.ARunFDSValidation;
import pyrosim.io.fds.FDSRenderer;

public class MPIProcessConflictValidation
extends ARunFDSValidation {
    private boolean d_shouldTest;

    public MPIProcessConflictValidation(PyroSim app, PyroMod mod, FDSRenderer.RENDER_ORIGIN callRoot) {
        super(app, mod);
        this.d_shouldTest = callRoot.equals((Object)FDSRenderer.RENDER_ORIGIN.RUN_FDS_MPI) && app.getFDSRenderProps().getMPIProcessRule().equals((Object)GridProcessUtil.PROC_COUNT.PER_CORE) && app.getFDSRenderProps().getGridProcessSetting().equals((Object)GridProcessUtil.PREF.BASIC);
    }

    @Override
    public Collection<IPyroObject> validateModel() {
        if (!this.d_shouldTest) {
            return Collections.emptyList();
        }
        HashSet<IPyroObject> naughtyGrids = new HashSet<IPyroObject>();
        for (Grid g : this.d_pyroMod.getGridManager().flatten()) {
            Map<String, String> customs;
            if (!g.isEnabled() || !(customs = g.getCustomFDSProps().getProps()).containsKey("MPI_PROCESS")) continue;
            naughtyGrids.add(g);
        }
        return naughtyGrids;
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        String instructions = String.format(Intl.intl("Unable to optimize processor utilization.\n\nPyroSim is unable to automatically optimze processor\nutilization for models containing %S records with\n%s records defined.\n\nPress OK to continue without optimized processor utilization."), "MESH", "MPI_PROCESS");
        return new ARunFDSValidation.Prompt(owner, instructions);
    }

    @Override
    public Supplier<Boolean> getResponse(int button, Collection<IPyroObject> conflicts) {
        if (button == 1) {
            return () -> {
                this.d_app.getFDSRenderProps().setGridProcessSetting(GridProcessUtil.PREF.NONE);
                return true;
            };
        }
        if (button == 8) {
            return () -> {
                SelectTask tsk = new SelectTask(this.d_pyroMod, conflicts);
                EventQueue.invokeLater(() -> this.d_pyroMod.getTaskManager().exec(tsk, this.getValidationDescription()));
                return false;
            };
        }
        return () -> true;
    }

    @Override
    public String getValidationDescription() {
        return Intl.intl("MPI Process Conflict Validation");
    }
}

