/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.INamed;
import pyrosim.domain.tasks.SetNameTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.util.Util;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.gui.guiAction;

public class RenameAction<T extends INamed, MgrT extends Composite<T>>
extends guiAction {
    private static final long serialVersionUID = -3997701728956750319L;
    private final ManagerDlg<T, MgrT> d_owner;
    private MgrT d_mgr;
    private final String d_desc;

    public RenameAction(ManagerDlg<T, MgrT> owner, String objDesc) {
        super(Intl.intl("Rename") + "...");
        this.d_owner = owner;
        this.d_desc = objDesc;
    }

    public void init(MgrT mgr) {
        this.d_mgr = mgr;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String newName;
        if (!this.d_owner.preSave()) {
            return;
        }
        PyroMod domain = (PyroMod)((ADomainObject)this.d_mgr).getDomain();
        int selIx = this.d_owner.getList().getSelectedIx();
        INamed rec = (INamed)this.d_owner.getList().getItem(selIx);
        while (true) {
            if ((newName = JOptionPane.showInputDialog(this.d_owner, Intl.intl("Name") + ": ", rec.getName())) == null) {
                return;
            }
            try {
                newName = Util.validateName(domain, rec, newName);
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this.d_owner, exc.getLocalizedMessage(), Intl.intl("Invalid Entry"), 0);
                continue;
            }
            break;
        }
        domain.getTaskManager().exec(new SetNameTask(rec, newName), Intl.intl("Rename"));
        this.d_owner.initItem(rec);
        this.d_owner.getList().updateModelView(this.d_mgr);
    }
}

