/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.gui.RampFuncDlg;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class RampOptEditor {
    public final int IX_DEFAULT;
    public final int IX_FROM_TABLE;
    public static final int DEFAULT = 1;
    public static final int CUSTOM = 2;
    public static final String STR_DEFAULT = Intl.intl("Default");
    public static final String STR_CUSTOM = Intl.intl("Custom");
    private guiComboBox<String> d_combo;
    private guiLabel d_rampLab;
    private ValueField<UnitDouble> d_defaultFld;
    private ValueField<UnitDouble> d_autoFld;
    private JButton d_button;
    private guiPanel d_panel;
    private Hashtable d_tipTable = null;
    private RampAction d_rampAction;

    public RampOptEditor(String label, int comboOptions) {
        int comboIndex = 0;
        this.d_combo = new PreFireComboBox();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.d_rampLab = new guiLabel(label + ":");
        this.d_defaultFld = ValueFields.udFld(UnitSystem.getSource(2));
        this.d_autoFld = ValueFields.udFld(UnitSystem.getSource(2));
        this.d_defaultFld.setEditable(false);
        this.d_autoFld.setEditable(false);
        this.d_button = new JButton(Intl.intl("Edit Values") + "...");
        this.d_defaultFld.setValue((UnitDouble)TimeFunction.newDefault().val);
        Dimension d = this.d_defaultFld.getPreferredSize();
        d.width = this.d_button.getPreferredSize().width;
        this.d_defaultFld.setPreferredSize(d);
        this.d_autoFld.setPreferredSize(d);
        this.d_button.setPreferredSize(d);
        this.d_panel = new guiPanel(gbl);
        this.d_rampAction = new RampAction(this.d_panel);
        this.d_button.addActionListener(this.d_rampAction);
        if ((comboOptions & 1) != 0) {
            this.d_defaultFld.setVisible(comboIndex == 0);
            this.d_combo.addItem((String)STR_DEFAULT);
            this.IX_DEFAULT = comboIndex++;
            this.d_panel.add(this.d_defaultFld, gbc);
        } else {
            this.IX_DEFAULT = -1;
        }
        if ((comboOptions & 2) != 0) {
            this.d_button.setVisible(comboIndex == 0);
            this.d_combo.addItem((String)STR_CUSTOM);
            this.IX_FROM_TABLE = comboIndex++;
            this.d_panel.add((Component)this.d_button, gbc);
        } else {
            this.IX_FROM_TABLE = -1;
        }
        this.d_combo.setMinimumSize(this.d_combo.getPreferredSize());
        this.init(null);
    }

    public void addToPanel(guiPanel panel, int beginCol, int beginRow, int top, int left, int bottom, int right) {
        GridBagUtil.add(panel, this.getLabel(), beginCol + 0, beginRow, 1, 1, top, left, bottom, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.getCombo(), beginCol + 1, beginRow, 1, 1, top, 0, bottom, 6, 2, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.getEditor(), beginCol + 2, beginRow, 1, 1, top, 0, bottom, right, 2, 0.0, 0.0, 17);
    }

    public void updateComponents() {
        boolean def = this.d_combo.getSelectedIndex() == this.IX_DEFAULT;
        boolean table = this.d_combo.getSelectedIndex() == this.IX_FROM_TABLE;
        this.d_defaultFld.setVisible(def);
        this.d_button.setVisible(table);
        if (this.d_tipTable != null && this.d_tipTable.containsKey(this.d_combo.getSelectedIndex())) {
            this.d_rampLab.setToolTipText((String)this.d_tipTable.get(this.d_combo.getSelectedIndex()));
        } else {
            this.d_rampLab.setToolTipText(null);
        }
        this.d_panel.revalidate();
    }

    public Ramp getRamp() {
        Ramp rateRampup = null;
        String selectedItem = this.d_combo.getSelectedItem();
        if (selectedItem == STR_CUSTOM) {
            rateRampup = this.d_rampAction.d_ramp;
        } else if (selectedItem == STR_DEFAULT) {
            rateRampup = null;
        }
        return rateRampup;
    }

    public void init(Ramp r) {
        if (r == null) {
            this.d_combo.setSelectedItem(STR_DEFAULT);
        } else if (r != null) {
            this.d_rampAction.d_ramp = r;
            this.d_combo.setSelectedItem(STR_CUSTOM);
        }
    }

    public Component[] getComponents() {
        return new Component[]{this.d_rampLab, this.d_combo, this.d_panel};
    }

    public guiLabel getLabel() {
        return this.d_rampLab;
    }

    public guiComboBox getCombo() {
        return this.d_combo;
    }

    public guiPanel getEditor() {
        return this.d_panel;
    }

    public JButton getButton() {
        return this.d_button;
    }

    public ValueField getAutoField() {
        return this.d_autoFld;
    }

    public void setToolTipLookUp(Hashtable h) {
        this.d_tipTable = h;
    }

    public static class RampAction
    implements ActionListener {
        private Modifiable d_owner;
        private Ramp d_ramp;

        public RampAction(Modifiable owner) {
            this.d_owner = owner;
            this.d_ramp = new Ramp(Collections.EMPTY_LIST, RampInputs.TIME, 28);
        }

        public Ramp getRamp() {
            return this.d_ramp;
        }

        public void setRamp(Ramp ramp) {
            this.d_ramp = ramp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Ramp postRamp;
            RampFuncDlg rampDlg = RampFuncDlg.newTimeFracDlg(this.d_ramp);
            if (rampDlg.doModal() == 1 && !theUtil.equal(this.d_ramp, postRamp = rampDlg.getRamp())) {
                this.d_ramp = postRamp;
                this.d_owner.setModified(true);
            }
        }
    }

    private class PreFireComboBox
    extends guiComboBox {
        private static final long serialVersionUID = 4742729770060033745L;

        private PreFireComboBox() {
        }

        @Override
        protected void fireActionEvent() {
            RampOptEditor.this.updateComponents();
            super.fireActionEvent();
        }
    }
}

