/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpec;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;

public class ExSpecNewDlg
extends guiDialog {
    private static final long serialVersionUID = -4447950882839500308L;
    private final PyroMod d_domain;
    private guiRadioButton d_rbPredef;
    private guiRadioButton d_rbCustom;
    private guiComboBox d_cbPredef;
    private guiTextField d_custom;
    private guiRadioButton d_rbPrimitive;
    private guiRadioButton d_rbLumped;

    public ExSpecNewDlg(JDialog owner, PyroMod domain) {
        super((Window)owner, Intl.intl("New Species"), 9);
        this.d_domain = domain;
        this.initWidgets(domain);
        this.addWidgets(this.getDialogPane());
    }

    private void initWidgets(PyroMod domain) {
        String suggName = domain.getNames(ExSpec.class).generateName();
        List<String> preDef = domain.getExSpecList().getPredefinedSpeciesNamesFree();
        this.d_rbPredef = new guiRadioButton(Intl.intl("Predefined:"));
        this.d_rbCustom = new guiRadioButton(Intl.intl("Custom:"));
        this.d_cbPredef = new guiComboBox<String>((Collection<String>)preDef);
        this.d_custom = new guiTextField(suggName);
        this.d_rbPrimitive = new guiRadioButton(Intl.intl("Primitive"));
        this.d_rbLumped = new guiRadioButton(Intl.intl("Lumped"));
        LinkStatus.link((AbstractButton)this.d_rbPredef, this.d_cbPredef);
        LinkStatus.link((AbstractButton)this.d_rbCustom, this.d_custom, this.d_rbPrimitive, this.d_rbLumped);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.d_rbPredef);
        bg1.add(this.d_rbCustom);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.d_rbPrimitive);
        bg2.add(this.d_rbLumped);
        this.d_rbPrimitive.setSelected(true);
        if (preDef.size() > 0) {
            this.d_rbPredef.setSelected(true);
        } else {
            this.d_rbPredef.setEnabled(false);
            this.d_cbPredef.setEnabled(false);
            this.d_rbCustom.setSelected(true);
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_rbCustom.isSelected()) {
            String customName = this.d_custom.getText().trim();
            if (customName.isEmpty()) {
                if (showWarn) {
                    String msg = Intl.intl("The name cannot be empty.");
                    this.showMessageBox(msg);
                    this.requestFocusHack();
                }
                return false;
            }
            if (this.d_domain.getNames(ExSpec.class).isRegistered(customName)) {
                if (showWarn) {
                    String msg = Intl.intl("Species name is already in use.\nEach species must have a unique name.");
                    this.showMessageBox(msg);
                    this.requestFocusHack();
                }
                return false;
            }
        }
        return true;
    }

    private void addWidgets(Container c) {
        c.setLayout(new GridBagLayout());
        GridBagUtil.add(c, this.d_rbPredef, 0, 0, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(c, this.d_cbPredef, 1, 0, 1, 1, 0, 0, 12, 0, 2, 0.0, 0.0, 17);
        GridBagUtil.add(c, this.d_rbCustom, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(c, this.d_custom, 1, 1, 1, 1, 0, 0, 0, 0, 2, 0.0, 0.0, 17);
        GridBagUtil.add(c, this.d_rbPrimitive, 0, 2, 2, 1, 12, 18, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(c, this.d_rbLumped, 0, 3, 2, 1, 0, 18, 0, 12, 0, 0.0, 0.0, 17);
    }

    public boolean isPredefined() {
        return this.d_rbPredef.isSelected();
    }

    public boolean isCustom() {
        return this.d_rbCustom.isSelected();
    }

    public String getSpeciesPredef() {
        return this.d_cbPredef.getSelectedItem().toString();
    }

    public String getSpeciesCustom() {
        return this.d_custom.getText().trim();
    }

    public boolean isPrimitive() {
        return this.d_rbPrimitive.isSelected();
    }

    public boolean isLumped() {
        return this.d_rbLumped.isSelected();
    }
}

