/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.quantity;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityCategory;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.util.ANameSorter;
import pyrosim.util.Util;
import thunderheadeng.util.theUtil;

public class QuantityUtil {
    public static final Predicate<Quantity> STATIC_QUANT_FILTER = new Predicate<Quantity>(){

        @Override
        public boolean test(Quantity o) {
            return o.getNumArgs() != 0;
        }
    };
    public static final Predicate<Quantity> OBJ_QUANT_FILTER = new Predicate<Quantity>(){

        @Override
        public boolean test(Quantity o) {
            return o.getNumArgs() <= 0;
        }
    };

    public static boolean isOneOf(Quantity quantity, QuantityType ... quantityTypes) {
        for (QuantityType quantityType : quantityTypes) {
            if (quantity.quantityType != quantityType) continue;
            return true;
        }
        return false;
    }

    public static boolean canOutputAll(Quantity quantity, long types) {
        return (quantity.outputTypes & types) == types;
    }

    public static boolean canOutputAny(Quantity quantity, long types) {
        return (quantity.outputTypes & types) != 0L;
    }

    public static boolean isSpeciesQuantity(Quantity msr) {
        return QuantityUtil.isOfRequiredObjectType(msr, ExSpec.class);
    }

    public static boolean isOfRequiredObjectType(Quantity quant, Class<?> reqClazz) {
        for (Class<? extends IPyroObject> clazz : quant.requiredTypes) {
            if (!clazz.isAssignableFrom(reqClazz)) continue;
            return true;
        }
        return false;
    }

    public static Collection<Quantity> getQuantities(int outputTypes) {
        return QuantityUtil.getQuantities(o -> QuantityUtil.canOutputAll(o, outputTypes));
    }

    public static Collection<Quantity> getQuantities(int outputTypes, QuantityType ... quantityTypes) {
        TypeFilter typeFilter = new TypeFilter(outputTypes, quantityTypes);
        return QuantityUtil.getQuantities(typeFilter);
    }

    public static Collection<Quantity> getQuantities(final Predicate<Quantity> filter) {
        Collection<Quantity> quantities = Arrays.asList(Quantity.values());
        quantities = theUtil.filter(quantities, new Predicate<Quantity>(){

            @Override
            public boolean test(Quantity o) {
                return !o.isDeprecated() && filter.test(o);
            }
        });
        return quantities;
    }

    public static Collection<Quantity> sort(Collection<Quantity> quantities) {
        ArrayList<Quantity> sorted = new ArrayList<Quantity>(quantities);
        Collections.sort(sorted, new ANameSorter<Quantity>(){

            @Override
            protected String getName(Quantity o) {
                return o.name;
            }
        });
        return sorted;
    }

    public static Collection<IQuantity> sortQuantities(Collection<? extends IQuantity> quantities) {
        ArrayList<IQuantity> sorted = new ArrayList<IQuantity>(quantities);
        Collections.sort(sorted, new ANameSorter<IQuantity>(){

            @Override
            protected String getName(IQuantity o) {
                return o.getDescription();
            }
        });
        return sorted;
    }

    public static Map<String, List<Quantity>> groupObjQuantities() {
        HashMap<String, List<Quantity>> categoryMap = new HashMap<String, List<Quantity>>();
        for (Quantity quant : Quantity.values()) {
            if (quant.category == null || quant.getNumArgs() <= 0) continue;
            ArrayList<Quantity> quantities = (ArrayList<Quantity>)categoryMap.get(quant.category);
            if (quantities == null) {
                quantities = new ArrayList<Quantity>();
                categoryMap.put(quant.category, quantities);
            }
            quantities.add(quant);
        }
        return categoryMap;
    }

    public static Quantity getDefaultQuantForCategory(QuantityCategory qc) {
        return QuantityUtil.getDefaultQuantForCategory(qc.category);
    }

    public static Quantity getDefaultQuantForCategory(String category) {
        if (category.equals(QuantityCategory.SPECIES.category)) {
            return Quantity.SPEC_VOLUME_FRACTION;
        }
        return null;
    }

    public static Collection<StaticQuantity> generateStaticQuantities(Predicate<Quantity> filter, boolean sorted) {
        filter = OBJ_QUANT_FILTER.and(filter);
        Collection<Quantity> quants = QuantityUtil.getQuantities(filter);
        Function<Quantity, StaticQuantity> transformer = new Function<Quantity, StaticQuantity>(){

            @Override
            public StaticQuantity apply(Quantity obj) {
                return obj.create();
            }
        };
        Collection<StaticQuantity> quantities = theUtil.map(quants, transformer);
        if (sorted) {
            quantities = Util.sort(quantities, new ANameSorter<StaticQuantity>(){

                @Override
                protected String getName(StaticQuantity o) {
                    return o.getDescription();
                }
            });
        }
        return quantities;
    }

    public static List<ObjectQuantity> generateAllObjectQuanties(PyroMod domain, Predicate<Quantity> filter, boolean sorted) {
        ArrayList<ObjectQuantity> quants = new ArrayList<ObjectQuantity>();
        filter = STATIC_QUANT_FILTER.and(filter);
        for (Quantity quant : QuantityUtil.getQuantities(filter)) {
            Collection<? extends IPyroObject> objs;
            ArrayList<Collection<? extends IPyroObject>> objArgs = new ArrayList<Collection<? extends IPyroObject>>(quant.getNumArgs());
            for (int m = 0; m < quant.getNumArgs() && !(objs = QuantityUtil.getValidArguments(PyroSim.getApp().getMediator(), quant, m)).isEmpty(); ++m) {
                objArgs.add(objs);
            }
            if (objArgs.size() != quant.getNumArgs()) continue;
            IPyroObject[] objs2 = new IPyroObject[quant.getNumArgs()];
            ArrayDeque itStack = new ArrayDeque();
            itStack.push(((Collection)objArgs.get(0)).iterator());
            while (!itStack.isEmpty()) {
                Iterator it = (Iterator)itStack.peek();
                if (it.hasNext()) {
                    objs2[itStack.size() - 1] = (IPyroObject)it.next();
                    if (itStack.size() == quant.getNumArgs()) {
                        quants.add(quant.create(Arrays.copyOf(objs2, objs2.length)));
                        continue;
                    }
                    itStack.push(((Collection)objArgs.get(itStack.size())).iterator());
                    continue;
                }
                itStack.pop();
            }
        }
        if (sorted) {
            Collections.sort(quants, new ANameSorter<ObjectQuantity>(){

                @Override
                protected String getName(ObjectQuantity o) {
                    return o.getDescription();
                }
            });
        }
        return quants;
    }

    public static List<IQuantity> generateAllQuantities(PyroMod domain, Predicate<Quantity> filter, boolean sort) {
        ArrayList<IQuantity> quantities = new ArrayList<IQuantity>();
        quantities.addAll(QuantityUtil.generateAllObjectQuanties(domain, filter, sort));
        quantities.addAll(QuantityUtil.generateStaticQuantities(filter, sort));
        return quantities;
    }

    public static Collection<? extends IPyroObject> getValidArguments(PyroMod domain, Quantity quantity, int arg) {
        Class<? extends IPyroObject> type = quantity.requiredTypes[arg];
        Predicate filter = quantity.typeFilters[arg];
        return Util.getAllObjects(domain, type, filter, true);
    }

    public static void takeDepSnapshot(DepList deps, DLink link, IQuantity ... quantities) {
        for (IQuantity quant : quantities) {
            QuantityUtil.takeDepSnapshot(deps, link, quant);
        }
    }

    public static void takeDepSnapshot(DepList deps, DLink link, Collection<IQuantity> quantities) {
        for (IQuantity quant : quantities) {
            QuantityUtil.takeDepSnapshot(deps, link, quant);
        }
    }

    public static void takeDepSnapshot(DepList deps, DLink link, IQuantity quantity) {
        if (quantity instanceof ObjectQuantity) {
            ObjectQuantity oq = (ObjectQuantity)quantity;
            for (Object o : oq.objects) {
                deps.add(link, (IPyroObject)o);
            }
        }
    }

    public static boolean isQuantityRef(IPyroObject obj, IQuantity ... quantities) {
        for (IQuantity quant : quantities) {
            if (!QuantityUtil.isQuantityRef(obj, quant)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQuantityRef(IPyroObject obj, Collection<? extends IQuantity> quantities) {
        for (IQuantity iQuantity : quantities) {
            if (!QuantityUtil.isQuantityRef(obj, iQuantity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQuantityRef(IPyroObject obj, IQuantity quant) {
        if (quant instanceof ObjectQuantity) {
            for (Object pobj : ((ObjectQuantity)quant).objects) {
                if (pobj != obj) continue;
                return true;
            }
        }
        return false;
    }

    public static class TypeFilter
    implements Predicate<Quantity> {
        private final long outputTypes;
        private final QuantityType[] quantityTypes;

        public TypeFilter(long outputTypes, QuantityType ... quantityTypes) {
            this.outputTypes = outputTypes;
            this.quantityTypes = quantityTypes;
        }

        @Override
        public boolean test(Quantity o) {
            return (this.quantityTypes.length <= 0 || QuantityUtil.isOneOf(o, this.quantityTypes)) && QuantityUtil.canOutputAll(o, this.outputTypes);
        }
    }
}

