/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.output.AMsrStat;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.SetReplacementTask;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SolidMsrStat
extends AMsrStat {
    static final long serialVersionUID = 1L;
    private final Set<Surface> d_surfaces;

    public SolidMsrStat(String name, IQuantity msr) {
        this(name, msr, new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0)), Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public SolidMsrStat(String name, IQuantity msr, IGeom geom, Collection<Surface> surfs, Collection<Long> stats) {
        super(name, msr, stats, geom);
        this.d_surfaces = new LinkedIdentityHashSet<Surface>(surfs);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!(this.d_surfaces instanceof LinkedIdentityHashSet)) {
            try {
                theUtil.assignFinalField(this, SolidMsrStat.class, "d_surfaces", new LinkedIdentityHashSet<Surface>((Collection<Surface>)this.d_surfaces));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof SolidMsrStat && super.equals(obj) && Util.identitySetsEqual(((SolidMsrStat)obj).d_surfaces, this.d_surfaces);
    }

    @Override
    public Predicate<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(1L, QuantityType.SOLID);
    }

    public Set<Surface> getSurfaces() {
        return Collections.unmodifiableSet(this.d_surfaces);
    }

    public void setSurfaces(Collection<Surface> surfs) {
        this.d_surfaces.clear();
        this.d_surfaces.addAll(surfs);
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        deps.add(DLink.WEAK, this.d_surfaces);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        super.removeInvalidReplacements(old, objs);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old instanceof Surface) {
            return new SetReplacementTask<Surface>(this, this.d_surfaces, old, replacement);
        }
        return super.taskReplaceDep(old, replacement);
    }
}

