/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AReplaceRefTask;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class ProfRec
extends NamedPyroObject
implements Serializable,
Cloneable,
IDirectDependent {
    static final long serialVersionUID = 1L;
    public static final int IOR_X = 1;
    public static final int IOR_X_NEG = -1;
    public static final int IOR_Y = 2;
    public static final int IOR_Y_NEG = -2;
    public static final int IOR_Z = 3;
    public static final int IOR_Z_NEG = -3;
    private int d_ior;
    private IQuantity d_q;
    private UnitPoint3D d_pt;

    public ProfRec(String id, int ior, IQuantity q, UnitPoint3D pt) {
        super(id);
        this.d_ior = ior;
        this.d_q = q;
        this.d_pt = pt;
    }

    public ProfRec(ProfRec rec) {
        super(rec.getName());
        this.d_ior = rec.d_ior;
        this.d_q = rec.d_q;
        this.d_pt = rec.d_pt;
    }

    @Override
    public Object clone() {
        return new ProfRec(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProfRec)) {
            return false;
        }
        ProfRec pr = (ProfRec)obj;
        return super.equals(obj) && this.d_ior == pr.d_ior && this.d_q.equals(pr.d_q) && this.d_pt.equals(pr.d_pt);
    }

    public int getIOR() {
        return this.d_ior;
    }

    public IQuantity getQuantity() {
        return this.d_q;
    }

    public UnitPoint3D getPoint() {
        return this.d_pt;
    }

    public void setIOR(int ior) {
        if (this.d_ior == ior) {
            return;
        }
        this.d_ior = ior;
        this.changedEvt(new Object[0]);
    }

    public void setQuantity(IQuantity q) {
        if (this.d_q.equals(q)) {
            return;
        }
        this.d_q = q;
        this.changedEvt(new Object[0]);
    }

    public void setPoint(UnitPoint3D pt) {
        Unit u = this.d_pt.getUnit();
        if (this.d_pt.getValue(u).equals(pt.getValue(u))) {
            return;
        }
        this.d_pt = pt;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, this.getQuantity());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        QuantReplacer replacer = new QuantReplacer();
        replacer.removeInvalidReplacements(old, objs, this.getQuantity());
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        QuantReplacer replacer = new QuantReplacer();
        return replacer.taskReplaceDep(old, replacement, this.getQuantity());
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)ProfRec.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            assert (newMsr != null);
            return new AReplaceRefTask<IQuantity>((Object)oldMsr, (Object)newMsr){

                @Override
                protected void set(IQuantity obj) {
                    ProfRec.this.setQuantity(obj);
                }
            };
        }
    }
}

