/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.quantity.VelocitySign;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public abstract class AMeasurementSet
extends APyroObject
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private final Set<IQuantity> d_measurements = new LinkedHashSet<IQuantity>();
    private VelocitySign d_velocitySign;

    public AMeasurementSet(IQuantity ... measurements) {
        this.setQuantities(measurements);
        this.d_velocitySign = VelocitySign.ALWAYS_POSITIVE;
    }

    public VelocitySign getVelocitySign() {
        return this.d_velocitySign;
    }

    public void setVelocitySign(VelocitySign sign) {
        this.d_velocitySign = sign;
        this.changedEvt(new Object[0]);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_velocitySign == null) {
            this.d_velocitySign = VelocitySign.ALWAYS_POSITIVE;
        }
    }

    public abstract long getOutputType();

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Plot3d)) {
            return false;
        }
        AMeasurementSet p = (AMeasurementSet)o;
        return p.d_measurements.equals(this.d_measurements);
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this.equals(obj);
    }

    public void setQuantities(IQuantity ... measurements) {
        this.setQuantities(Arrays.asList(measurements));
    }

    public void setQuantities(Collection<IQuantity> measurements) {
        this.d_measurements.clear();
        this.d_measurements.addAll(measurements);
        this.changedEvt(new Object[0]);
    }

    public Set<IQuantity> getQuantities() {
        return Collections.unmodifiableSet(this.d_measurements);
    }

    @Override
    public boolean isEnabled() {
        return !this.d_measurements.isEmpty();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        QuantityUtil.takeDepSnapshot(deps, DLink.WEAK, this.d_measurements);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        QuantReplacer replacer = new QuantReplacer();
        replacer.removeInvalidReplacements(old, objs, this.d_measurements);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        QuantReplacer replacer = new QuantReplacer();
        return replacer.taskReplaceDep(old, replacement, this.d_measurements);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)AMeasurementSet.this.getDomain());
        }

        @Override
        protected boolean canReplaceQuant(IQuantity old, IQuantity repl) {
            return QuantityUtil.canOutputAll(repl.get(), AMeasurementSet.this.getOutputType());
        }

        @Override
        protected Task taskReplaceQuant(final IQuantity oldMsr, final IQuantity newMsr) {
            return new AUndoableTask(){
                boolean d_added;

                @Override
                public void undo() {
                    if (this.d_added) {
                        AMeasurementSet.this.d_measurements.remove(newMsr);
                    }
                    AMeasurementSet.this.d_measurements.add(oldMsr);
                    AMeasurementSet.this.changedEvt(new Object[0]);
                }

                @Override
                public void run() {
                    AMeasurementSet.this.d_measurements.remove(oldMsr);
                    if (newMsr != null) {
                        this.d_added = AMeasurementSet.this.d_measurements.add(newMsr);
                    }
                    AMeasurementSet.this.changedEvt(new Object[0]);
                }
            };
        }
    }
}

