/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.variant.DefRampProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class HvacFilter
extends HvacComponent
implements IHvacObject {
    private static final long serialVersionUID = 1L;
    public static final String OPT_LOSS_MODEL = "opt_loss_ramp";
    public static final VariantProfile FUNC_PROF = new VariantProfile(new DefRampProfile(Intl.intl("Custom"), 28, DefRampProfile.Input.MASS));
    private Variant d_func;

    public HvacFilter(String id) {
        super(id);
        HvacFilter.setDefaults(this);
        this.d_func = FUNC_PROF.getDefault();
    }

    public static void setDefaults(HvacFilter obj) {
        obj.setProp("TYPE_ID", "FILTER");
        obj.setProp("CLEAN_LOSS", new UnitDouble(0.0, Unit.ONE));
        obj.setProp("EFFICIENCY", Collections.EMPTY_LIST);
        obj.setProp("LOADING", Collections.EMPTY_LIST);
        obj.setProp("LOADING_MULTIPLIER", Collections.EMPTY_LIST);
        obj.setProp("SPEC_ID", Collections.EMPTY_LIST);
        obj.setProp("LOSS", Collections.EMPTY_LIST);
        obj.setProp(OPT_LOSS_MODEL, (Object)LossModel.LINEAR);
    }

    public Variant getCustomLoss() {
        return this.d_func;
    }

    public void setCustomLoss(Variant loss) {
        if (theUtil.equal(this.d_func, loss)) {
            return;
        }
        this.d_func = loss;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        this.addDep(deps, "SPEC_ID");
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof ExSpec) {
            Util.keepIfNullOr(objs, ExSpec.class);
            List specs = (List)this.getProp("SPEC_ID");
            for (ExSpec s : specs) {
                if (!objs.contains(s)) continue;
                objs.remove(s);
            }
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (old instanceof ExSpec) {
            return new AUndoableTask(){
                private ExSpec d_oldSpec;
                private ExSpec d_replSpec;

                @Override
                public void run() {
                    this.d_oldSpec = (ExSpec)old;
                    this.d_replSpec = (ExSpec)replacement;
                    HvacFilter.this.setExSpec(this.d_oldSpec, this.d_replSpec);
                }

                @Override
                public void undo() {
                    ExSpec hold = this.d_oldSpec;
                    this.d_oldSpec = this.d_replSpec;
                    this.d_replSpec = hold;
                    HvacFilter.this.setExSpec(this.d_oldSpec, this.d_replSpec);
                }
            };
        }
        return super.taskReplaceDep(old, replacement);
    }

    private void setExSpec(ExSpec old, ExSpec replacement) {
        ArrayList<ExSpec> specs = new ArrayList<ExSpec>((Collection)this.getProp("SPEC_ID"));
        ArrayList<UnitDouble> loading = new ArrayList<UnitDouble>((Collection)this.getProp("LOADING"));
        ArrayList<UnitDouble> loadMult = new ArrayList<UnitDouble>((Collection)this.getProp("LOADING_MULTIPLIER"));
        int i = specs.indexOf(old);
        if (i >= 0) {
            UnitDouble load = (UnitDouble)loading.get(i);
            UnitDouble mult = (UnitDouble)loadMult.get(i);
            specs.remove(i);
            loading.remove(i);
            loadMult.remove(i);
            if (replacement != null) {
                specs.add(replacement);
                loading.add(load);
                loadMult.add(mult);
            }
        }
        this.setProp("SPEC_ID", specs);
        this.setProp("LOADING", loading);
        this.setProp("LOADING_MULTIPLIER", loadMult);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        HvacFilter clone = (HvacFilter)super.clone();
        clone.d_func = this.d_func.clone();
        return clone;
    }

    public static enum LossModel {
        LINEAR,
        CUSTOM;

    }
}

