/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.particle.ConstColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class PartCloud
extends AFDSObject
implements IDirectDependent,
ICustomFDSPropsContainer {
    static final long serialVersionUID = 1L;
    private static final int VOLUME_ALPHA = 51;
    private static final Color DEF_COLOR = new Color(0.7f, 0.7f, 0.9f, 0.2f);
    private IGeom d_geom;
    private Particle d_particle;
    private IDropletCount d_initDropCount;
    private IInsertion d_insertion;
    private UnitDouble d_density;
    public static final Composite.IObjectProp insertionProp;
    public static final Composite.IObjectProp initDropsProp;
    public static final Composite.IObjectProp partProp;

    public PartCloud() {
        this(Intl.intl("Particle Cloud"), null, new AABoxGeom(GeomConstants.PNT3D_ORIGIN, GeomConstants.PNT3D_ORIGIN));
    }

    public PartCloud(String description, Particle particle, IGeom geom) {
        super(description);
        this.d_geom = geom;
        this.d_particle = particle;
        this.d_initDropCount = new DropDensityCount();
        this.d_insertion = new InsertOnce();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PartCloud)) {
            return false;
        }
        PartCloud partCloud = (PartCloud)obj;
        return this.d_initDropCount.equals(partCloud.getInitDrops()) && this.d_particle.equals(partCloud.getParticle()) && this.d_insertion.equals(partCloud.d_insertion) && this.getCustomFDSProps().equals(partCloud.getCustomFDSProps());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_density != null) {
            this.d_insertion = new InsertOnce(this.d_density);
            this.d_density = null;
        }
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("INIT");
    }

    @Override
    public boolean isControllable() {
        return true;
    }

    public Particle getParticle() {
        return this.d_particle;
    }

    public void setParticle(Particle particle) {
        this.d_particle = particle;
        this.changedEvt(new Object[0]);
    }

    public IDropletCount getInitDrops() {
        return this.d_initDropCount;
    }

    public void setInitDrops(IDropletCount numInitDrops) {
        this.d_initDropCount = numInitDrops;
        this.changedEvt(new Object[0]);
    }

    public IInsertion getInsertion() {
        return this.d_insertion;
    }

    public void setInsertion(IInsertion insert) {
        this.d_insertion = insert;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setColors(Color ... c) {
    }

    @Override
    public Color[] getColors() {
        return this.getColors(this.getPartCloudGeom());
    }

    public Color[] getColors(IGeom geom) {
        Color color = DEF_COLOR;
        if (this.d_particle != null) {
            color = this.d_particle.getDefaultColor();
            IColoring partColoring = this.d_particle.getColoring();
            if (partColoring != null && partColoring instanceof ConstColoring) {
                color = ((ConstColoring)partColoring).color;
            }
        }
        if (!(geom instanceof Point)) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 51);
        }
        return new Color[]{color};
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        deps.add(DLink.STRONG, (IPyroObject)this.d_particle);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old == this.d_particle) {
            Util.keepIfNullOr(objs, Particle.class);
        } else {
            super.removeInvalidReplacements(old, objs);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (!(old instanceof Particle)) {
            return super.taskReplaceDep(old, replacement);
        }
        assert (replacement != null);
        return new AReplaceRefTask<Particle>((Object)old, (Object)replacement){

            @Override
            protected void set(Particle obj) {
                PartCloud.this.setParticle(obj);
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        if (!(dep instanceof Particle)) {
            return super.taskUpdateDep(dep, changes);
        }
        return GeomUtil.taskChanged(this);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        IGeom geom = this.getPartCloudGeom();
        Color[] colors = this.getColors(geom);
        IPrimProps.AProps sprops = geom instanceof Point ? new IPrimProps.Vertex(colors[0], 10.0) : new IPrimProps.Face(colors[0], null, 2);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(geom), (IPrimProps)sprops);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getPartCloudGeom());
    }

    public IGeom getPartCloudGeom() {
        if (this.d_geom instanceof AABoxGeom && !(this.d_geom instanceof BlockGeom)) {
            AABoxGeom aabox = (AABoxGeom)this.d_geom;
            return new BlockGeom(aabox.min, aabox.max);
        }
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (this.getGeomTypeFilter().test(geom.getClass())) {
            this.d_geom = geom;
            this.changedEvt(new Object[0]);
        }
    }

    public Predicate<Class<? extends IGeom>> getGeomTypeFilter() {
        return type -> Point.class.isAssignableFrom((Class<?>)type) || AABoxGeom.class.isAssignableFrom((Class<?>)type);
    }

    public UnitDouble getVolume() {
        AABox bounds = this.d_geom.getBoundingBox(new AABox());
        double dx = bounds.getWidth();
        double dy = bounds.getDepth();
        double dz = bounds.getHeight();
        return new UnitDouble(dx * dy * dz, SIUS.unit(56));
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Particle.class);
        insertionProp = new Composite.AObjectProp<PartCloud, IInsertion>(PartCloud.class){

            @Override
            public void set(PartCloud obj, IInsertion prop) {
                obj.setInsertion(prop);
            }

            @Override
            public Object get(PartCloud obj) {
                return obj.getInsertion();
            }
        };
        initDropsProp = new Composite.AObjectProp<PartCloud, IDropletCount>(PartCloud.class){

            @Override
            public void set(PartCloud obj, IDropletCount prop) {
                obj.setInitDrops(prop);
            }

            @Override
            public Object get(PartCloud obj) {
                return obj.getInitDrops();
            }
        };
        partProp = new Composite.AObjectProp<PartCloud, Particle>(PartCloud.class){

            @Override
            public void set(PartCloud obj, Particle prop) {
                obj.setParticle(prop);
            }

            @Override
            public Object get(PartCloud obj) {
                return obj.getParticle();
            }

            @Override
            public boolean equal(Particle obj1, Particle obj2) {
                return obj1 == obj2;
            }
        };
    }

    public static class InsertPeriodically
    implements IInsertion {
        private static final long serialVersionUID = 1L;
        public final UnitDouble dt;
        public final UnitDouble massPerTime;

        public InsertPeriodically() {
            this(new UnitDouble(0.01, SI.SECOND), SIUS.newud(1.0, 76));
        }

        public InsertPeriodically(UnitDouble dt, UnitDouble massPerTime) {
            this.dt = dt;
            this.massPerTime = massPerTime;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof InsertPeriodically)) {
                return false;
            }
            InsertPeriodically insert = (InsertPeriodically)obj;
            return this.dt.equals(insert.dt) && theUtil.equal(this.massPerTime, insert.massPerTime);
        }
    }

    public static class InsertOnce
    implements IInsertion {
        private static final long serialVersionUID = 1L;
        public final UnitDouble massPerVolume;

        public InsertOnce() {
            this(SIUS.newud(1.0, 4));
        }

        public InsertOnce(UnitDouble massPerVolume) {
            this.massPerVolume = massPerVolume;
        }

        public boolean equals(Object obj) {
            return obj instanceof InsertOnce && theUtil.equal(((InsertOnce)obj).massPerVolume, this.massPerVolume);
        }
    }

    public static interface IInsertion
    extends Serializable {
    }

    public static class DropDensityCount
    implements IDropletCount {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_density;

        public DropDensityCount() {
            this(SIUS.newud(10.0, 55));
        }

        public DropDensityCount(UnitDouble density) {
            this.d_density = density;
        }

        @Override
        public int getNumDrops(PartCloud cloud) {
            double volume = cloud.getVolume().getValue(SIUS.unit(56));
            double dropDens = this.d_density.getValue(SIUS.unit(55));
            return (int)Math.round(volume * dropDens);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DropDensityCount)) {
                return false;
            }
            DropDensityCount ddc = (DropDensityCount)obj;
            return this.d_density.equals(ddc.d_density);
        }
    }

    public static class PerCellCount
    implements IDropletCount {
        static final long serialVersionUID = 1L;
        public final int partPerCell;
        public final boolean cellCentered;

        public PerCellCount() {
            this(1, false);
        }

        public PerCellCount(int count, boolean cellCentered) {
            this.partPerCell = count;
            this.cellCentered = cellCentered;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PerCellCount)) {
                return false;
            }
            PerCellCount cpc = (PerCellCount)obj;
            return this.partPerCell == cpc.partPerCell && this.cellCentered == cpc.cellCentered;
        }

        @Override
        public int getNumDrops(PartCloud cloud) {
            return 0;
        }
    }

    public static class ConstDropletCount
    implements IDropletCount {
        static final long serialVersionUID = 1L;
        public final int d_dropCount;

        public ConstDropletCount() {
            this(100);
        }

        public ConstDropletCount(int count) {
            this.d_dropCount = count;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConstDropletCount)) {
                return false;
            }
            ConstDropletCount cdc = (ConstDropletCount)obj;
            return this.d_dropCount == cdc.d_dropCount;
        }

        @Override
        public int getNumDrops(PartCloud cloud) {
            return this.d_dropCount;
        }
    }

    public static interface IDropletCount
    extends Serializable {
        public int getNumDrops(PartCloud var1);
    }
}

