/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.geom.Geometry;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;

public class InitRegion
extends AFDSObject
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private static final int ALPHA = 51;
    private static final Color DEF_COLOR = new Color(0.3f, 0.7f, 0.9f, 0.2f);
    private AABoxGeom d_geom;
    private UnitDouble d_density;
    private UnitDouble d_temperature;
    private Map<ExSpec, UnitDouble> d_specMassFrac;
    private SpecFractionType d_specFracType;
    public static final Composite.IObjectProp densityProp = new Composite.AObjectProp<InitRegion, UnitDouble>(InitRegion.class){

        @Override
        public void set(InitRegion obj, UnitDouble prop) {
            obj.setDensity(prop);
        }

        @Override
        public Object get(InitRegion obj) {
            return obj.getDensity();
        }
    };
    public static final Composite.IObjectProp tempProp = new Composite.AObjectProp<InitRegion, UnitDouble>(InitRegion.class){

        @Override
        public void set(InitRegion obj, UnitDouble prop) {
            obj.setTemperature(prop);
        }

        @Override
        public Object get(InitRegion obj) {
            return obj.getTemperature();
        }
    };
    public static final Composite.IObjectProp specTypeProp = new Composite.AObjectProp<InitRegion, SpecFractionType>(InitRegion.class){

        @Override
        public void set(InitRegion obj, SpecFractionType type) {
            obj.setExtraSpeciesType(type);
        }

        @Override
        public Object get(InitRegion obj) {
            return obj.getExtraSpeciesType();
        }
    };

    public InitRegion() {
        this(Intl.intl("Init Region"), new AABoxGeom(GeomConstants.PNT3D_ORIGIN, GeomConstants.PNT3D_ORIGIN));
    }

    public InitRegion(String name, AABoxGeom geom) {
        super(name);
        this.d_geom = geom.optimize(Geometry.P3D_POOL);
        this.d_density = null;
        this.d_temperature = null;
        this.d_specMassFrac = Collections.emptyMap();
        this.d_specFracType = SpecFractionType.MASS_FRACTION;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!this.d_specMassFrac.isEmpty() && !(this.d_specMassFrac instanceof LinkedIdentityHashMap)) {
            this.d_specMassFrac = new LinkedIdentityHashMap<ExSpec, UnitDouble>(this.d_specMassFrac);
        }
        if (this.d_specFracType == null) {
            this.d_specFracType = SpecFractionType.MASS_FRACTION;
        }
    }

    @Override
    public Object clone() {
        InitRegion init = (InitRegion)super.clone();
        if (init.d_specMassFrac != Collections.EMPTY_MAP) {
            init.d_specMassFrac = new LinkedIdentityHashMap<ExSpec, UnitDouble>(init.d_specMassFrac);
        }
        return init;
    }

    @Override
    public boolean isControllable() {
        return false;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("INIT");
    }

    @Override
    public void setColors(Color ... c) {
    }

    @Override
    public Color[] getColors() {
        return new Color[]{DEF_COLOR};
    }

    public UnitDouble getDensity() {
        return this.d_density;
    }

    public void setDensity(UnitDouble density) {
        this.d_density = density;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getTemperature() {
        return this.d_temperature;
    }

    public void setTemperature(UnitDouble temp) {
        this.d_temperature = temp;
        this.changedEvt(new Object[0]);
    }

    public Map<ExSpec, UnitDouble> getExtraSpecies() {
        return Collections.unmodifiableMap(this.d_specMassFrac);
    }

    public void setExtraSpeciesType(SpecFractionType type) {
        LinkedIdentityHashMap<ExSpec, UnitDouble> updatedSpecFracs = new LinkedIdentityHashMap<ExSpec, UnitDouble>();
        for (Map.Entry<ExSpec, UnitDouble> kvPair : this.d_specMassFrac.entrySet()) {
            UnitDouble oldUnitUD = kvPair.getValue();
            double rawVal = oldUnitUD.getRawValue();
            UnitSystem us = PyroSim.getApp().getUnitSystem();
            Unit newUnit = us.getMassFractionUnit();
            if (type.equals((Object)SpecFractionType.VOLUME_FRACTION)) {
                newUnit = us.getVolumeFractionUnit();
            }
            UnitDouble newVal = new UnitDouble(rawVal, newUnit);
            updatedSpecFracs.put(kvPair.getKey(), newVal);
        }
        this.setExtraSpecies(updatedSpecFracs, type);
    }

    public SpecFractionType getExtraSpeciesType() {
        return this.d_specFracType;
    }

    public void setExtraSpecies(Map<ExSpec, UnitDouble> specs, SpecFractionType type) {
        this.d_specMassFrac = specs.isEmpty() ? Collections.EMPTY_MAP : specs;
        this.d_specFracType = type;
        this.changedEvt(new Object[0]);
    }

    public void setSpecFrac(ExSpec spec, UnitDouble value) {
        if (value == null || value.getValueNoUnit() == 0.0) {
            if (this.d_specMassFrac.containsKey(spec)) {
                this.d_specMassFrac.remove(spec);
                if (this.d_specMassFrac.isEmpty()) {
                    this.d_specMassFrac = Collections.EMPTY_MAP;
                }
                this.changedEvt(new Object[0]);
            }
        } else {
            if (this.d_specMassFrac == Collections.EMPTY_MAP) {
                this.d_specMassFrac = new LinkedIdentityHashMap<ExSpec, UnitDouble>();
            }
            this.d_specMassFrac.put(spec, value);
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        deps.add(DLink.WEAK, this.d_specMassFrac.keySet());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof ExSpec) {
            Util.keepIfNullOr(objs, ExSpec.class);
        } else {
            super.removeInvalidReplacements(old, objs);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (!(old instanceof ExSpec)) {
            return super.taskReplaceDep(old, replacement);
        }
        final ExSpec specOld = (ExSpec)old;
        final ExSpec specRepl = (ExSpec)replacement;
        return new AUndoableTask(){
            private UnitDouble d_oldVal;
            private UnitDouble d_replVal;

            @Override
            public void run() {
                assert (InitRegion.this.d_specMassFrac.containsKey(specOld));
                this.d_oldVal = (UnitDouble)InitRegion.this.d_specMassFrac.remove(specOld);
                if (specRepl != null) {
                    if (InitRegion.this.d_specMassFrac.containsKey(specRepl)) {
                        this.d_replVal = (UnitDouble)InitRegion.this.d_specMassFrac.get(specRepl);
                        InitRegion.this.d_specMassFrac.put(specRepl, this.d_replVal.add(this.d_oldVal));
                    } else {
                        this.d_replVal = null;
                        InitRegion.this.d_specMassFrac.put(specRepl, this.d_oldVal);
                    }
                } else if (InitRegion.this.d_specMassFrac.isEmpty()) {
                    InitRegion.this.d_specMassFrac = Collections.EMPTY_MAP;
                }
                InitRegion.this.changedEvt(new Object[0]);
            }

            @Override
            public void undo() {
                if (InitRegion.this.d_specMassFrac == Collections.EMPTY_MAP) {
                    InitRegion.this.d_specMassFrac = new LinkedIdentityHashMap();
                }
                InitRegion.this.d_specMassFrac.put(specOld, this.d_oldVal);
                if (specRepl != null) {
                    if (this.d_replVal == null) {
                        InitRegion.this.d_specMassFrac.remove(specRepl);
                    } else {
                        InitRegion.this.d_specMassFrac.put(specRepl, this.d_replVal);
                    }
                }
                InitRegion.this.changedEvt(new Object[0]);
            }
        };
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        Color[] colors = this.getColors();
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Face(colors[0], null, 2));
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getBoxGeom());
    }

    public AABoxGeom getBoxGeom() {
        return this.d_geom instanceof BlockGeom ? this.d_geom : new BlockGeom(this.d_geom.min, this.d_geom.max);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof AABoxGeom) {
            this.d_geom = (AABoxGeom)geom;
            this.changedEvt(new Object[0]);
        }
    }

    public static class SpecFracProp
    extends Composite.AObjectProp<InitRegion, UnitDouble> {
        public ExSpec currSpec;

        public SpecFracProp() {
            super(InitRegion.class);
        }

        @Override
        public void set(InitRegion obj, UnitDouble prop) {
            obj.setSpecFrac(this.currSpec, prop);
        }

        @Override
        public Object get(InitRegion obj) {
            SpecFractionType type = obj.getExtraSpeciesType();
            int u = type.equals((Object)SpecFractionType.MASS_FRACTION) ? 18 : 87;
            UnitDouble val = (UnitDouble)obj.d_specMassFrac.get(this.currSpec);
            return val == null ? SIUS.newud(0.0, u) : val;
        }
    }

    public static enum SpecFractionType {
        MASS_FRACTION,
        VOLUME_FRACTION;

    }
}

