/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.ISurfObj;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public interface IObstruction
extends ISurfObj {
    public static final int OPTION_THICKEN = 1;
    public static final int OPTION_PERMIT_HOLE = 4;
    public static final int OPTION_ALLOW_VENT = 8;
    public static final int OPTION_BNDF_OBST = 16;
    public static final int OPTION_OUTLINE = 32;
    public static final int OPTION_REMOVABLE = 64;
    public static final int OPTION_WRITEGEOM = 128;
    public static final int ALL_OPTIONS = 253;
    public static final int DEF_OPTIONS = 92;
    public static final Composite.IObjectProp bulkDensityProp = new Composite.AObjectProp<IObstruction, UnitDouble>(IObstruction.class){

        @Override
        public void set(IObstruction obj, UnitDouble prop) {
            obj.setBulkDensity(prop);
        }

        @Override
        public Object get(IObstruction obj) {
            return obj.getBulkDensity();
        }
    };

    public UnitDouble getBulkDensity();

    public void setBulkDensity(UnitDouble var1);

    public void setOptions(int var1, boolean var2);

    public boolean getOptions(int var1);

    public int getSetOptions();

    public List<Pair<IObstruction, IHole>> intersectHoles(Supplier<Collection<? extends IHole>> var1, Predicate<IHole> var2, Surface var3);

    default public Surface getDefaultFillSurface() {
        PyroMod domain = (PyroMod)this.getDomain();
        if (domain == null) {
            return null;
        }
        return domain.getDefaultSurface();
    }

    default public IPropsSrc getDisplayProps() {
        return this.getDisplayProps(false);
    }

    default public IPropsSrc getDisplayProps(boolean surfsAsMats) {
        return IObstruction.getDisplayProps(this.getSurfaces(), this.getColors(), surfsAsMats, GeomUtil.isCullGeom(this.getGeom()));
    }

    public static IPropsSrc getDisplayProps(Surface[] surfs, Color[] colors, boolean surfsAsMats, boolean isCullGeom) {
        int options = isCullGeom ? 2 : 0;
        BiFunction<Color, Surface, IPrimProps> newProps = surfsAsMats ? (c, s) -> new IPrimProps.Face((Color)c, (IMaterial)s, options) : (c, s) -> FDSUtil.newObstFaceProps(c, s, options);
        if (surfs.length == 1 && colors.length == 1) {
            IPrimProps prop = newProps.apply(colors[0], surfs[0]);
            return new UniformProps(prop);
        }
        int numProps = Math.max(surfs.length, colors.length);
        IPrimProps[] props = new IPrimProps[numProps];
        for (int m = 0; m < numProps; ++m) {
            Surface surf = surfs.length == 1 ? surfs[0] : surfs[m];
            Color color = colors.length == 1 ? colors[0] : colors[m];
            props[m] = newProps.apply(color, surf);
        }
        return new FlattenedProps(props);
    }

    public static class OptionProp
    extends Composite.AObjectProp<IObstruction, Boolean> {
        private final int d_option;

        public OptionProp(int option) {
            super(IObstruction.class);
            this.d_option = option;
        }

        @Override
        public void set(IObstruction obj, Boolean prop) {
            obj.setOptions(this.d_option, prop);
        }

        @Override
        public Object get(IObstruction obj) {
            return obj.getOptions(this.d_option);
        }
    }
}

