/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.jscience.physics.units.SI;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.devices.IDeviceModel;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class SprinklerLinkModel
extends NamedPyroObject
implements IDeviceModel {
    static final long serialVersionUID = 1L;
    private String d_fyi;
    private UnitDouble d_rti;
    private UnitDouble d_activationTemp;
    private UnitDouble d_initTemp;
    private UnitDouble d_cFactor;
    private CustomFDSProps d_customProps;

    public SprinklerLinkModel(String name) {
        this(name, new UnitDouble(100.0, SIUS.getInstance().getRtiUnit()), new UnitDouble(74.0, SI.CELSIUS));
    }

    public SprinklerLinkModel(String name, UnitDouble rti, UnitDouble activationTemp) {
        this(name, rti, null, activationTemp, SIUS.newud(0.0, 60));
    }

    public SprinklerLinkModel(String name, UnitDouble rti, UnitDouble initTemp, UnitDouble activationTemp, UnitDouble cFactor) {
        super(name);
        this.d_rti = rti;
        this.d_activationTemp = activationTemp;
        this.d_initTemp = initTemp;
        this.d_cFactor = cFactor;
        this.d_customProps = CustomFDSProps.EMPTY;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_customProps == null) {
            this.d_customProps = CustomFDSProps.EMPTY;
        }
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customProps;
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        this.d_customProps = props;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return super.equals(obj) && this.propEquals(obj);
    }

    public boolean propEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SprinklerLinkModel)) {
            return false;
        }
        SprinklerLinkModel desc = (SprinklerLinkModel)obj;
        return this.d_cFactor.equals(desc.d_cFactor) && this.d_rti.equals(desc.d_rti) && this.d_activationTemp.equals(desc.d_activationTemp) && theUtil.equal(this.d_initTemp, desc.d_initTemp) && this.d_customProps.equals(desc.d_customProps);
    }

    public int propHash() {
        return this.d_cFactor.hashCode() + this.d_rti.hashCode() + this.d_activationTemp.hashCode() + theUtil.hashCode(this.d_initTemp) + this.d_customProps.hashCode();
    }

    public UnitDouble getRti() {
        return this.d_rti;
    }

    public void setRti(UnitDouble rti) {
        this.d_rti = rti;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getInitialTemp() {
        return this.d_initTemp;
    }

    public void setInitialTemp(UnitDouble initTemp) {
        this.d_initTemp = initTemp;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getActivationTemp() {
        return this.d_activationTemp;
    }

    public void setActivationTemp(UnitDouble actTemp) {
        this.d_activationTemp = actTemp;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getCFactor() {
        return this.d_cFactor;
    }

    public void setCFactor(UnitDouble cFactor) {
        this.d_cFactor = cFactor;
        this.changedEvt(new Object[0]);
    }
}

