/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.mat;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.boundcond.mat.IPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.Reaction;
import pyrosim.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.domain.boundcond.mat.ThermalProps;
import thunderheadeng.util.LinkedIdentityHashSet;

public class Material
extends NamedPyroObject
implements ICustomFDSPropsContainer {
    static final long serialVersionUID = 1L;
    public static final Object EVT_FYI = new Object();
    private ThermalProps d_thermalProps;
    private IPyrolysis d_pyrolysis;
    private String d_fyi;
    private CustomFDSProps d_customFDSProps;

    public Material(String name) {
        this(name, new SolidPyrolysis(), new ThermalProps());
    }

    public Material(String name, IPyrolysis pyrolysis, ThermalProps thermalProps) {
        super(name);
        this.d_pyrolysis = pyrolysis;
        this.d_thermalProps = thermalProps;
        this.d_fyi = "";
        this.d_customFDSProps = CustomFDSProps.EMPTY;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = CustomFDSProps.EMPTY;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Material)) {
            return false;
        }
        Material mat = (Material)obj;
        return super.equals(obj) && this.d_thermalProps.equals(mat.d_thermalProps) && this.d_pyrolysis.equals(mat.d_pyrolysis) && this.d_customFDSProps.equals(mat.d_customFDSProps);
    }

    @Override
    public boolean isEquiv(Object obj) {
        if (!(obj instanceof Material)) {
            return false;
        }
        Material mat = (Material)obj;
        return super.equals(obj) && this.d_thermalProps.equals(mat.d_thermalProps) && this.d_pyrolysis.equals(mat.d_pyrolysis) && this.d_customFDSProps.equals(mat.d_customFDSProps);
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("MATL");
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customFDSProps;
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        this.d_customFDSProps = props;
        this.changedEvt(new Object[0]);
    }

    public boolean isValidResidue(Material mat) {
        return !mat.getResidueMaterials().contains(this);
    }

    public boolean hasValidResidues() {
        return this.getResidueMaterials() != null;
    }

    public Set<Material> getResidueMaterials() {
        return Material.getResidueMaterials(this);
    }

    private static Set<Material> getResidueMaterials(Material root) {
        LinkedIdentityHashSet<Material> closed = new LinkedIdentityHashSet<Material>();
        Stack<Material> open = new Stack<Material>();
        open.push(root);
        while (!open.isEmpty()) {
            Material mat = (Material)open.pop();
            if (!closed.add(mat)) {
                return null;
            }
            for (Reaction reaction : mat.d_pyrolysis.getReactions()) {
                List<Material> materials = reaction.d_byproducts.getMaterials();
                for (Material residue : materials) {
                    if (residue == null) continue;
                    open.push(residue);
                }
            }
        }
        return closed;
    }

    public Set<ExSpec> getResidueSpecies() {
        return Material.getResidueSpecies(this);
    }

    private static Set<ExSpec> getResidueSpecies(Material root) {
        LinkedIdentityHashSet<ExSpec> specs = new LinkedIdentityHashSet<ExSpec>();
        for (Reaction reaction : root.d_pyrolysis.getReactions()) {
            List<ExSpec> residue = reaction.d_byproducts.getSpecies();
            if (residue == null) continue;
            specs.addAll(residue);
        }
        return specs;
    }

    public boolean isSolid() {
        return this.d_pyrolysis instanceof SolidPyrolysis;
    }

    public boolean isLiquid() {
        return this.d_pyrolysis instanceof LiquidPyrolysis;
    }

    public String getFYI() {
        return this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    public IPyrolysis getPyrolysis() {
        return this.d_pyrolysis;
    }

    public void setPyrolysis(IPyrolysis pyrolysis) {
        this.d_pyrolysis = pyrolysis;
        this.changedEvt(new Object[0]);
    }

    public ThermalProps getThermalProps() {
        return this.d_thermalProps;
    }

    public void setThermalProps(ThermalProps props) {
        this.d_thermalProps = props;
        this.changedEvt(new Object[0]);
    }
}

