/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pyrosim.Accelerators;
import pyrosim.AdditionalLogParams;
import pyrosim.CrashHandler;
import pyrosim.FDSVersion;
import pyrosim.FloatingWaitDlg;
import pyrosim.Intl;
import pyrosim.OpenModelTask;
import pyrosim.PSMBackupHandler;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSimColors;
import pyrosim.PyroSimLM;
import pyrosim.ResetModelTask;
import pyrosim.ScriptAction;
import pyrosim.Version;
import pyrosim.domain.FDSRun;
import pyrosim.domain.GridProcessUtil;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.rasterization.FDSObjectRasterization;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.scenario.EditScenariosAction;
import pyrosim.domain.scenario.ExportScenariosAction;
import pyrosim.domain.scenario.ScenarioGui;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewMode;
import pyrosim.event.EventUtil;
import pyrosim.gui.FDSRunMonitor;
import pyrosim.gui.PreferencesDialog;
import pyrosim.gui.PromptingFDSRenderProps;
import pyrosim.gui.PyroCheckForUpdatesDlg;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.SnapshotDialog;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.actions.ExportPyroFloorsAction;
import pyrosim.gui.actions.ExportPyroViewsAction;
import pyrosim.gui.actions.ExportSmokeINIFileAction;
import pyrosim.gui.actions.FdsIoUtil;
import pyrosim.gui.actions.PyroActionMap;
import pyrosim.gui.actions.RunFdsActions;
import pyrosim.gui.actions.UnitsAction;
import pyrosim.io.ImportFDSFile;
import pyrosim.io.PyroSimObjectOutputStream;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.mv.ModelView;
import pyrosim.recordview.RecordView;
import pyrosim.treeview.PyroTreeView;
import pyrosim.unitsystem.EnglishUS;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.CrashCatcher;
import thunderheadeng.gui.Document;
import thunderheadeng.gui.DropDownButton;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.MRUListener;
import thunderheadeng.gui.MRUMenu;
import thunderheadeng.gui.ModelBackup;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.MutuallyExclusiveAction;
import thunderheadeng.gui.OutputLog;
import thunderheadeng.gui.ResourcePaths;
import thunderheadeng.gui.SelectableActionListener;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.colorscheme.ColorMgrMenu;
import thunderheadeng.gui.colorscheme.ColorScheme;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiExceptionError;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMenu;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiURLLabel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.KeyboardAcceleratorIO;
import thunderheadeng.io.MRUFileList;
import thunderheadeng.license3.ActivationDlg;
import thunderheadeng.license3.LicensePrompt;
import thunderheadeng.scene3d.gui.GPUInfoPnl;
import thunderheadeng.scene3d.gui.RenderPrefs;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.util.Disposable;
import thunderheadeng.util.DisposableCounter;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.VersionUtil;
import thunderheadeng.util.theUtil;

public class PyroSim
extends Application
implements Disposable {
    public static final boolean FDS7_DEBUG = System.getProperty("FDS7.debug") != null;
    private static final Logger LOGGER = Logger.getLogger(PyroSim.class.getSimpleName());
    private final ResourcePaths d_docPaths;
    private PyroSimLM d_licenseMgr;
    private PyroMod d_mediator;
    private String d_filename;
    private boolean d_forceSavePrompt;
    private MRUFileList d_mruModelFiles;
    private MRUMenu d_mruModelMenu;
    private MRUFileList d_mruFDSFiles;
    private MRUMenu d_mruFDSMenu;
    private PyroSimColors d_colorManager;
    private ColorMgrMenu d_colorMenu;
    private ModifiedDomainListener d_modifiedTracker;
    private PyroTreeView d_treeView;
    private ModelView d_3dView;
    private RecordView d_recordView;
    private JTabbedPane d_mainView;
    private static final int VIEW_3D = 0;
    private static final int VIEW_2D = 1;
    private static final int VIEW_RECORD = 2;
    private JPanel d_3DPanel;
    private JPanel d_recordPanel;
    private ViewChangeListener d_viewChangeListener;
    private NewAction d_newAction;
    private OpenAction d_openAction;
    private SaveAction d_saveAction;
    private SaveAsAction d_saveAsAction;
    private PreferencesAction d_prefsAction;
    private ScreenShotAction d_screenShotAction;
    private ExportFDSFileAction d_writeFDSFileAction;
    private ExportSmokeINIFileAction d_writeSmokeviewINIFileAction;
    private ExportPyroViewsAction d_exportPyroViewsAction;
    private ExportPyroFloorsAction d_exportPyroFloorsAction;
    private ExportSurfaceDatabaseFileAction d_exportMatDBFileAction;
    private ExportReactionDatabaseFileAction d_exportReacDBFileAction;
    private Collection<Action> d_customActions;
    private JMenuBar d_mainMenuBar;
    private JMenu d_fileMenu;
    private JMenu d_editMenu;
    private JMenu d_modelMenu;
    private JMenu d_deviceMenu;
    private JMenu d_outputMenu;
    private JMenu d_fdsMenu;
    private JMenu d_viewMenu;
    private JMenu d_helpMenu;
    private JToolBar d_mainToolbar;
    private DropDownButton d_fdsRunDropdown;
    private UnitSystem d_unitSystem;
    public static final String SKETCH_GRID_NAME = Intl.intl("Sketch Grid");
    private Pair<Integer, Integer> size = null;
    private Pair<Integer, Integer> location = null;
    private static String file = null;
    private static final int TRIAL_VER = 8;
    private static final int DATE_LEVEL = 24;
    private DisposableCounter d_dc = new DisposableCounter();
    private final ModelBackup d_backup = new ModelBackup("PyroSim", "psm", new PSMBackupHandler());
    private BackupEvtListener d_autosaveListener;
    private final FDSRenderProps d_fdsRenderProps = new FDSRenderProps();
    private final FilenameManager d_filenames;
    private int d_fdsFullLength;

    public static void main(final String[] args) {
        final PyroSim imAPyro = new PyroSim(args, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < args.length; ++i) {
                    try {
                        imAPyro.procArgs(args[i]);
                        continue;
                    }
                    catch (Throwable t) {
                        String msg = Intl.intl("Error processing command line parameter:\n") + args[i] + "\n" + String.format("%s%s", t.getClass().getSimpleName(), t.getMessage() == null ? "" : "- " + t.getMessage());
                        JOptionPane.showMessageDialog(null, msg);
                        t.printStackTrace();
                    }
                }
                imAPyro.showApp();
                if (file != null) {
                    Runnable openArgFile = new Runnable(){

                        @Override
                        public void run() {
                            PyroMod pyMod = imAPyro.getMediator();
                            OpenModelTask tsk = new OpenModelTask(imAPyro, pyMod, file);
                            pyMod.getTaskManager().exec((Task)tsk, Intl.intl("Open PyroSim File"), 10);
                        }
                    };
                    SwingUtilities.invokeLater(openArgFile);
                }
                EventQueue.invokeLater(() -> imAPyro.d_3dView.showIntelWarning());
            }
        });
    }

    public PyroSim() {
        this(false);
    }

    public PyroSim(boolean autosave) {
        this(new String[]{"-DShowSplash=false"}, autosave);
    }

    public PyroSim(String appName, String installDir, JFrame mainFrame) {
        super(appName, installDir, mainFrame);
        this.d_filenames = new FilenameManager();
        this.d_docPaths = new ResourcePaths(this, new String[0]);
    }

    @Override
    public boolean isInstallFolder(File folder) {
        return IOUtil.testFolderContainsAll(folder, "lib", "fds", "third-party");
    }

    private static native void setNativeInstallDir(String var0);

    private static native void addNativeResourceDir(String var0);

    public static <T> boolean setPref(TypedProp<T> prop, T val, boolean saveFile) {
        TeciProps prefs = PyroSim.getApp().getPrefs();
        T existing = prefs.get(prop);
        if (Objects.equals(val, existing)) {
            return false;
        }
        PyroPrefs.set(prop, val, saveFile);
        PyroMod mod = PyroSim.getApp().getMediator();
        mod.getEvents().changed(mod, PyroMod.EVT_PREFS_CHANGED);
        return true;
    }

    public static <T> void setPrefs(TeciProps prefs, boolean saveFile) {
        boolean modified = false;
        for (Map.Entry<Object, Object> entry : prefs.entrySet()) {
            Object oldVal = PyroPrefs.instance().put(entry.getKey(), entry.getValue());
            modified = modified || !Objects.equals(oldVal, entry.getValue());
        }
        PyroSim app = PyroSim.getApp();
        if (modified) {
            PyroMod mod = app.getMediator();
            mod.getEvents().changed(mod, PyroMod.EVT_PREFS_CHANGED);
        }
        if (saveFile) {
            app.superSavePreferences();
        }
    }

    @Override
    public String getInstallDir() {
        return super.getInstallDir();
    }

    public ResourcePaths getDocPaths() {
        return this.d_docPaths;
    }

    private static String getFrameTitleBase() {
        boolean is64Bit = PyroSim.is64Bit();
        return "PyroSim" + (is64Bit ? " x64 Edition" : "");
    }

    public PyroSim(String[] cmdLineArgs, boolean autosave) {
        super("PyroSim", cmdLineArgs, PyroSim.class.getResource("PyroSimSplash.png"), 1);
        File workingDir;
        PyroSim.setNativeInstallDir(this.getInstallDir());
        this.d_docPaths = new ResourcePaths(this, "", "doc/en", "../Results/doc/PyroSim");
        Stream.of("../Results/lib", "../thunderheadeng/lib").forEach(d -> {
            this.getResourcePaths().addDir((String)d);
            PyroSim.addNativeResourceDir(d);
        });
        this.getMainFrame().setTitle(PyroSim.getFrameTitleBase());
        String unitSystemPref = PyroPrefs.getString(PyroPrefs.UnitSystemProp);
        this.d_unitSystem = unitSystemPref.equals(EnglishUS.getInstance().getSystemName()) ? EnglishUS.getInstance() : SIUS.getInstance();
        this.d_mruModelFiles = new MRUFileList();
        this.d_mruModelFiles.load(this.d_props);
        this.d_mruFDSFiles = new MRUFileList();
        this.d_mruFDSFiles.setEntryPrefix("MRU_FDS.");
        this.d_mruFDSFiles.load(this.d_props);
        String strWorkingDir = this.getWorkingDir();
        File file = workingDir = strWorkingDir != null ? new File(strWorkingDir) : null;
        while (workingDir != null && !workingDir.exists()) {
            workingDir = workingDir.getParentFile();
        }
        this.d_filenames = new FilenameManager(workingDir);
        this.d_colorManager = new PyroSimColors();
        this.d_colorManager.load(this.d_props);
        this.d_modifiedTracker = new ModifiedDomainListener();
        this.d_mediator.getEvents().addObserver(this.d_modifiedTracker);
        Actions.init(this.d_mediator);
        this.d_newAction = new NewAction();
        this.d_openAction = new OpenAction();
        this.d_saveAction = new SaveAction();
        this.d_saveAsAction = new SaveAsAction();
        this.d_prefsAction = new PreferencesAction();
        this.d_screenShotAction = new ScreenShotAction();
        this.d_writeFDSFileAction = new ExportFDSFileAction();
        this.d_exportPyroViewsAction = new ExportPyroViewsAction();
        this.d_exportPyroFloorsAction = new ExportPyroFloorsAction();
        this.d_writeSmokeviewINIFileAction = new ExportSmokeINIFileAction();
        this.d_exportMatDBFileAction = new ExportSurfaceDatabaseFileAction();
        this.d_exportReacDBFileAction = new ExportReactionDatabaseFileAction();
        this.d_customActions = null;
        this.synchronizeRenderProps();
        Actions.applicationActivated(this);
        this.getMainFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                PyroSim.this.windowActivated(e);
            }
        });
        if (autosave) {
            this.d_autosaveListener = new BackupEvtListener();
            this.d_mediator.getEvents().addObserver(this.d_autosaveListener);
            this.updateBackup();
        }
        if (!Application.isDev()) {
            String version = String.format("%s %s", "2022.3.1208", PyroSim.is64Bit() ? "x64" : "x86");
            CrashCatcher.install("PyroSim", version, CrashHandler.INSTANCE, AdditionalLogParams.INSTANCE, 2, new Thread[0]);
        }
    }

    public void synchronizeRenderProps() {
        this.d_fdsRenderProps.setDecimalFormatter(PyroSim.getFormatterFromProps());
        this.d_fdsRenderProps.setGridProcessSetting(PyroSim.getGridProcessPrefFromProps());
        this.d_fdsRenderProps.setMPIProcessRule(PyroSim.getMPIProcessRuleFromProps());
    }

    private static GridProcessUtil.PREF getGridProcessPrefFromProps() {
        String fromProps = PyroPrefs.getString(PyroPrefs.PREF_OPTIMIZE_FDS_PROCS);
        return GridProcessUtil.getPrefForString(fromProps);
    }

    private static GridProcessUtil.PROC_COUNT getMPIProcessRuleFromProps() {
        String fromProps = PyroPrefs.getString(PyroPrefs.PREF_MPI_PROC_COUNT);
        return GridProcessUtil.getProcCountForString(fromProps);
    }

    private static FDSRenderProps.IDecimalFormatter getFormatterFromProps() {
        int precision;
        int formatterType = PyroPrefs.getInt(PyroPrefs.FDSFormatProp);
        if (formatterType == 1) {
            int width = PyroPrefs.getInt(PyroPrefs.FDSFormatAlignedWidth);
            int decs = PyroPrefs.getInt(PyroPrefs.FDSFormatAlignedDec);
            int minDecs = 1;
            int minWidth = decs + 3;
            if (width >= minWidth && decs >= minDecs) {
                return new FDSRenderProps.AlignedFormatter(width, decs);
            }
        } else if (formatterType == 2 && (precision = PyroPrefs.getInt(PyroPrefs.FDSFormatGenPrecision)) > 2) {
            return new FDSRenderProps.GeneralFormatter(precision);
        }
        return new FDSRenderProps.ScientificFormatter();
    }

    private static void setFormatterToProps(FDSRenderProps.IDecimalFormatter formatter) {
        if (formatter instanceof FDSRenderProps.AlignedFormatter) {
            FDSRenderProps.AlignedFormatter aligned = (FDSRenderProps.AlignedFormatter)formatter;
            PyroPrefs.set(PyroPrefs.FDSFormatProp, 1, false);
            PyroPrefs.set(PyroPrefs.FDSFormatAlignedWidth, aligned.width, false);
            PyroPrefs.set(PyroPrefs.FDSFormatAlignedDec, aligned.numDecimals, false);
        } else if (formatter instanceof FDSRenderProps.GeneralFormatter) {
            FDSRenderProps.GeneralFormatter general = (FDSRenderProps.GeneralFormatter)formatter;
            PyroPrefs.set(PyroPrefs.FDSFormatProp, 2, false);
            PyroPrefs.set(PyroPrefs.FDSFormatGenPrecision, general.precision, false);
        } else {
            PyroPrefs.set(PyroPrefs.FDSFormatProp, 0, false);
        }
    }

    public static boolean isFDSGeomEnabled() {
        return PyroPrefs.getBoolean(PyroPrefs.PROP_ENABLE_FDS_GEOM);
    }

    @Override
    protected void loadSafeModeProps(TeciProps props) {
        super.loadSafeModeProps(props);
        for (PyroPrefs.SafeModeProp prop : PyroPrefs.getSafeModeProps()) {
            System.out.printf("Setting preference \"%s\"=%s%n", prop.key, prop.safeVal);
            props.set(prop, prop.safeVal);
        }
        RenderPrefs.loadSafeModeProps(props);
    }

    public FilenameManager getFilenameManager() {
        return this.d_filenames;
    }

    public static FilenameManager getFilenames() {
        return PyroSim.getApp().getFilenameManager();
    }

    public void procArgs(String arg) {
        if (arg.substring(0, 3).equals("-sz") && this.size == null) {
            StringTokenizer st = new StringTokenizer(arg.substring(3, arg.length()), ",");
            this.size = new Pair<Integer, Integer>(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
            return;
        }
        if (arg.substring(0, 4).equals("-loc") && this.location == null) {
            StringTokenizer st = new StringTokenizer(arg.substring(4, arg.length()), ",");
            this.location = new Pair<Integer, Integer>(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
            return;
        }
        if (file == null && !arg.startsWith("-")) {
            File f = new File(arg);
            if (f.exists()) {
                file = arg;
                return;
            }
            System.out.println("Invalid File Name: " + arg);
            return;
        }
        if (arg.startsWith("-D")) {
            return;
        }
        System.out.println("Unused Parameter: " + arg);
    }

    @Override
    public void acquire() {
        this.d_dc.acquire(this);
    }

    @Override
    public void release() {
        this.d_dc.release(this);
    }

    @Override
    public void dispose() {
        theUtil.release(this.d_mediator);
        theUtil.release(this.d_3dView);
    }

    public static PyroSim getApp() {
        return (PyroSim)Application.getApp();
    }

    public void setFDSCompability(FDSVersion comp) {
        this.getPrefs().set(PyroPrefs.PREF_FDSCOMPABILITY, comp.toString());
    }

    public FDSVersion getFDSCompability() {
        String comp = this.getPrefs().getString(PyroPrefs.PREF_FDSCOMPABILITY);
        try {
            return FDSVersion.parse(comp);
        }
        catch (Exception e) {
            return Version.FDS_DESIGN;
        }
    }

    public File getDatabaseDir() {
        String fdsPath = this.getInstallDir() + "\\fds";
        File fdsFolder = new File(fdsPath);
        if (!fdsFolder.exists()) {
            System.err.println("PyroMod Warning: unable to loacate DB directory: /fds");
            String tempPath = System.getProperty("java.io.tmpdir");
            fdsFolder = new File(tempPath);
        }
        return fdsFolder;
    }

    public File getTextureDBDir() {
        String dir = this.getPreference("texture.dir");
        if (dir != null) {
            File altDir = new File(dir);
            if (altDir.isDirectory() && altDir.canRead()) {
                return altDir;
            }
            System.err.println("rejecting invalid texture dir: " + dir);
        }
        return this.getDatabaseDir();
    }

    public ModelBackup getBackup() {
        return this.d_backup;
    }

    public FDSRenderProps getFDSRenderProps() {
        return this.d_fdsRenderProps;
    }

    public void showApp() {
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JFrame frame = this.getMainFrame();
        if (this.size != null) {
            Dimension dimension = new Dimension((Integer)this.size.v1, (Integer)this.size.v2);
            frame.setSize(dimension);
        }
        if (this.location != null) {
            Point point = new Point((Integer)this.location.v1, (Integer)this.location.v2);
            frame.setLocation(point);
        }
        try {
            frame.setIconImages(Arrays.asList(ImageIO.read(this.getClass().getResource("/pyrosim/icons/PyroSimIcon16.png")), ImageIO.read(this.getClass().getResource("/pyrosim/icons/PyroSimIcon32.png"))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.d_mediator.getEvents().addObserver(new FrameDomainListener());
        Component leftView = this.createTreeView();
        Component rightView = this.createViewModes();
        KeyboardAcceleratorIO.loadHotKeys(new PyroActionMap.PyroShortcutIOHelper(this));
        this.d_mediator.updateGeomSearchesEnabled(this.d_3dView.isHoleCuttingEnabled());
        Container framePane = frame.getContentPane();
        framePane.setLayout(new BorderLayout());
        JSplitPane sp = new JSplitPane(1, true, leftView, rightView);
        framePane.add((Component)sp, "Center");
        sp.setDividerLocation(250);
        sp.setDividerSize(9);
        this.nowCreateMenuBar();
        framePane.add((Component)this.createToolbar(), "North");
        frame.setVisible(true);
        this.initActiveView();
        Calendar cal = Calendar.getInstance();
        cal.set(2005, 10, 1);
        try {
            this.d_licenseMgr = PyroSimLM.getInstance();
            boolean status = this.d_licenseMgr.startFromPrefs(this.getPrefs(), PyroPrefs.LicenseDirProp, PyroPrefs.LicenseServerProp);
            if (!status) {
                this.showActivationDialog();
            }
            if (this.d_licenseMgr.inQueue()) {
                FloatingWaitDlg queueDlg = new FloatingWaitDlg(this.getMainFrame(), this.d_licenseMgr);
                queueDlg.doModal();
            }
        }
        catch (Throwable everything) {
            everything.printStackTrace();
            System.exit(-1);
        }
        if (!this.d_licenseMgr.isAuthorized()) {
            this.quit(false);
        }
        LicensePrompt.checkRenewPrompt(this.getMainFrame(), this.d_licenseMgr, "PyroSim", "www.pyrosim.com", PyroGuiUtil.loadPyroSimIcon("PyroSplash2.jpg"), new RegisterAction(), 30, this.getSplash());
        VersionUtil.checkForUpdatesOnStartup("PyroSim", this.getPrefs(), PyroPrefs.PREF_CHECKLATEST, PyroPrefs.SKIP_UPDATE, PyroPrefs.SKIP_UPDATE_VERSION, VersionUtil.getVersionSupplier(PyroSimLM.getInstance()), versionSource -> new PyroCheckForUpdatesDlg(PyroSim.getApp(), true, CompletableFuture.completedFuture(versionSource)), checkOnStartup -> PyroPrefs.set(PyroPrefs.PREF_CHECKLATEST, checkOnStartup, true));
        this.updateFDSMenu();
        this.updateToolbar();
        this.checkFDSVersions();
    }

    /*
     * WARNING - void declaration
     */
    private void checkFDSVersions() {
        String lastVersion = PyroPrefs.getLastVersion();
        if (!lastVersion.equals("2022.3.1208")) {
            void var6_9;
            String[] fdsLocKeys = new String[]{"location", "sv.location"};
            ArrayList<Pair<String, String>> customExes = new ArrayList<Pair<String, String>>();
            String[] stringArray = fdsLocKeys;
            int n = stringArray.length;
            boolean bl = false;
            while (var6_9 < n) {
                String string = stringArray[var6_9];
                String lastLoc = PyroPrefs.getFDSLoc(lastVersion, string, false);
                if (lastLoc != null) {
                    customExes.add(new Pair<String, String>(string, lastLoc));
                }
                ++var6_9;
            }
            if (!customExes.isEmpty()) {
                String msg = String.format(Intl.intl("Your previous PyroSim installation (%s) used custom FDS executables.%nWould you like to continue using these?"), lastVersion);
                for (Pair pair : customExes) {
                    msg = msg + "\n\t" + (String)pair.v2;
                }
                int option = JOptionPane.showConfirmDialog(this.getActiveFrame(), msg, Intl.intl("Use Custom FDS Executables?"), 0);
                if (option == 0) {
                    for (Pair pair : customExes) {
                        PyroPrefs.setFDSLoc((String)pair.v1, (String)pair.v2);
                    }
                }
            }
        }
        PyroPrefs.updateLastVersion();
    }

    public File getLastDir(String prefName) {
        String pref = this.getPreference(prefName);
        if (pref == null) {
            return null;
        }
        return new File(pref);
    }

    public void setLastDir(String prefName, File childFile) {
        File parentFile;
        if (childFile != null && (parentFile = childFile.getParentFile()) != null) {
            this.setPreference(prefName, parentFile.getAbsolutePath());
        }
    }

    public void setCurrentDir(File file) {
        if (file != null) {
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            if (file != null) {
                this.getFilenameManager().getFileChooser().setCurrentDirectory(file);
            }
        }
    }

    private void windowActivated(WindowEvent e) {
        Actions.applicationActivated(this);
    }

    private JToolBar createToolbar() {
        JToolBar tb = new JToolBar();
        tb.setMinimumSize(new Dimension(0, 0));
        tb.setFloatable(false);
        this.d_mainToolbar = tb;
        this.updateToolbar();
        return tb;
    }

    private void updateToolbar() {
        JToolBar tb = this.d_mainToolbar;
        tb.removeAll();
        tb.add(this.getNewAction());
        tb.add(this.getOpenAction());
        tb.add(this.getSaveAction());
        tb.addSeparator();
        tb.add(Actions.IMPORT_ACTION);
        tb.add(this.getWriteFDSFileAction());
        tb.addSeparator();
        tb.add(Actions.getUndoAction());
        tb.add(Actions.getRedoAction());
        tb.add(Actions.getCutAction());
        tb.add(Actions.getCopyAction());
        tb.add(Actions.getPasteAction());
        tb.add(Actions.getDeleteAction());
        tb.addSeparator();
        tb.add(Actions.getEditNodeAction());
        tb.addSeparator();
        guiUtil.addMEToolbarItems(tb, UnitsAction.SI_ACTION, UnitsAction.NON_SI_UNITS_ACTION);
        tb.addSeparator();
        tb.add(Actions.getAddWallAction());
        tb.add(Actions.getAddHoleAction());
        tb.add(Actions.getAddVentAction());
        tb.add(Actions.getAddSlabAction());
        tb.add(Actions.getAddPartCloudAction());
        tb.add(Actions.ADD_PART_LOC_ACTION);
        tb.add(Actions.ADD_INIT_REGION_ACTION);
        tb.add(Actions.GLOBAL_ADD_GROUP_ACTION);
        tb.addSeparator();
        tb.add(new EditScenariosAction());
        tb.add(ScenarioGui.createScenariosBox(this.d_mediator));
        this.d_fdsRunDropdown = new DropDownButton(RunFdsActions.RUN_FDS_ACTION, RunFdsActions.RUN_FDS_MPI_ACTION, RunFdsActions.RUN_FDS_CLUSTER_ACTION);
        this.d_fdsRunDropdown.setHideActionText(true);
        tb.addSeparator();
        tb.add(this.d_fdsRunDropdown);
        DropDownButton timeHistoryBtn = new DropDownButton(Actions.VIEW_HRR_RESULTS_ACTION, Actions.VIEW_DEVC_RESULTS_ACTION, Actions.VIEW_CTRL_RESULTS_ACTION, Actions.TC_PLOTS_ACTION);
        timeHistoryBtn.setHideActionText(true);
        tb.add(timeHistoryBtn);
        tb.add(Actions.VIEW_RESULTS_ACTION);
        if (this.d_customActions == null) {
            this.d_customActions = this.getCustomActions();
        }
        if (!this.d_customActions.isEmpty()) {
            tb.addSeparator();
            for (Action custom : this.d_customActions) {
                tb.add(custom);
            }
        }
        Component[] c = tb.getComponents();
        for (int i = 0; i < c.length; ++i) {
            c[i].setFocusable(false);
            if (!(c[i] instanceof JButton)) continue;
            ((JButton)c[i]).setMnemonic(0);
        }
    }

    private Collection<Action> getCustomActions() {
        File installDir = new File(this.getInstallDir());
        File plugins = new File(installDir, "plugins");
        FilenameFilter js = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".js");
            }
        };
        ArrayList<Action> actions = new ArrayList<Action>();
        File[] files = plugins.listFiles(js);
        if (files == null) {
            return Collections.emptyList();
        }
        for (File f : files) {
            try {
                ScriptAction a = new ScriptAction(f);
                actions.add(a);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return actions;
    }

    public void quitScriptSafe() {
        EventQueue.invokeLater(() -> {
            this.d_modifiedTracker.reset();
            this.quit(false);
        });
    }

    @Override
    public void quit(boolean allowCancel) {
        if (this.promptSaveIfModified(allowCancel) && this.promptComfirmIfRunning(allowCancel) || !allowCancel) {
            this.d_licenseMgr.closeLM();
            super.quit(allowCancel);
        }
    }

    public void superSavePreferences() {
        PyroPrefs.save();
        super.savePreferences();
    }

    @Override
    public void savePreferences() {
        this.d_mruModelFiles.store(this.d_props);
        this.d_mruFDSFiles.store(this.d_props);
        this.d_colorManager.store(this.d_props);
        PyroPrefs.set(PyroPrefs.UnitSystemProp, this.d_unitSystem.getSystemName(), false);
        this.d_3dView.savePreferences();
        PyroSim.setFormatterToProps(this.d_fdsRenderProps.getDecimalFormatter());
        this.superSavePreferences();
    }

    @Override
    public void readPreferences() {
        super.readPreferences();
        PyroPrefs.Version ver = PyroPrefs.getVersion();
        if (ver.ordinal() < PyroPrefs.Version.VER_0002.ordinal() && this.d_props.get(RenderPrefs.PREF_ANISOTROPIC_FILTERING) == 16.0) {
            this.d_props.set(RenderPrefs.PREF_ANISOTROPIC_FILTERING, RenderPrefs.PREF_ANISOTROPIC_FILTERING.defVal);
        }
    }

    @Override
    public void saveKeyboardAccelerators() {
        KeyboardAcceleratorIO.exportHotKeys(new PyroActionMap.PyroShortcutIOHelper(this));
    }

    public boolean promptSaveIfModified(boolean allowCancel) {
        if (this.d_modifiedTracker.isModified()) {
            int availOptions = allowCancel ? 1 : 0;
            int opt = JOptionPane.showConfirmDialog(this.getMainFrame(), Intl.intl("Save file now") + "?", Intl.intl("File Modified"), availOptions);
            if (opt == 0) {
                return this.doSave(!allowCancel);
            }
            return opt == 1;
        }
        return true;
    }

    private boolean promptComfirmIfRunning(boolean allowCancel) {
        if (FDSRunMonitor.isFDSRunning()) {
            String title = Intl.intl("Simulation in Progress");
            if (allowCancel) {
                String msg = Intl.intl("Exit and terminate FDS simulation?");
                int options = 2;
                return JOptionPane.showConfirmDialog(this.getMainFrame(), msg, title, options) == 0;
            }
            String msg = Intl.intl("FDS Simulation will be terminated.");
            JOptionPane.showMessageDialog(this.getMainFrame(), msg, title, 2);
            return true;
        }
        return true;
    }

    @Override
    public Document createDocument() {
        theUtil.release(this.d_mediator);
        this.d_mediator = new PyroMod(true);
        File texDBDir = this.getTextureDBDir();
        this.d_mediator.initializeDatabases(texDBDir);
        return null;
    }

    public PyroMod getMediator() {
        return this.d_mediator;
    }

    public ModelView get3DView() {
        return this.d_3dView;
    }

    public PyroTreeView getTreeView() {
        return this.d_treeView;
    }

    public ColorScheme getColorScheme() {
        return this.d_colorManager.getCurrentColorScheme();
    }

    public PyroSimColors getColorManager() {
        return this.d_colorManager;
    }

    @Override
    public JMenuBar createMenuBar() {
        return new JMenuBar();
    }

    public JMenuBar nowCreateMenuBar() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.createFileMenu();
        this.createEditMenu();
        this.createModelMenu();
        this.createDeviceMenu();
        this.createOutputMenu();
        this.updateFDSMenu();
        this.d_viewMenu = new JMenu();
        this.createHelpMenu();
        this.updateMainMenuBar();
        return this.d_mainMenuBar;
    }

    private JMenuBar updateMainMenuBar() {
        this.d_mainMenuBar = new JMenuBar();
        this.d_mainMenuBar.add(this.d_fileMenu);
        this.d_mainMenuBar.add(this.d_editMenu);
        this.d_mainMenuBar.add(this.d_modelMenu);
        this.d_mainMenuBar.add(this.d_deviceMenu);
        this.d_mainMenuBar.add(this.d_outputMenu);
        this.d_mainMenuBar.add(this.d_fdsMenu);
        this.d_mainMenuBar.add(this.d_viewMenu);
        this.d_mainMenuBar.add(this.d_helpMenu);
        JFrame frame = this.getMainFrame();
        frame.setJMenuBar(this.d_mainMenuBar);
        frame.getRootPane().getInputMap(1).put(Accelerators.CRASH, Actions.CRASH_PYROSIM);
        frame.getRootPane().getActionMap().put(Actions.CRASH_PYROSIM, Actions.CRASH_PYROSIM);
        frame.setVisible(true);
        return this.d_mainMenuBar;
    }

    public JMenu createFileMenu() {
        this.d_fileMenu = new guiMenu(Intl.intl("&File"));
        this.d_fileMenu.add(this.d_newAction);
        this.d_fileMenu.add(this.d_openAction);
        this.d_fileMenu.add(this.d_saveAction);
        this.d_fileMenu.add(this.d_saveAsAction);
        this.d_fileMenu.addSeparator();
        this.d_fileMenu.add(Actions.getProtectAction());
        this.d_fileMenu.add(this.d_prefsAction);
        this.d_fileMenu.addSeparator();
        this.d_fileMenu.add(Actions.IMPORT_ACTION);
        guiMenu exportMenu = new guiMenu(Intl.intl("Export"));
        exportMenu.add(this.d_writeFDSFileAction);
        exportMenu.add(new ExportScenariosAction(this));
        exportMenu.add(this.d_exportPyroViewsAction);
        exportMenu.add(this.d_exportPyroFloorsAction);
        exportMenu.add(this.d_writeSmokeviewINIFileAction);
        exportMenu.add(this.d_exportMatDBFileAction);
        exportMenu.add(this.d_exportReacDBFileAction);
        this.d_fileMenu.add(exportMenu);
        this.d_fileMenu.add(this.d_screenShotAction);
        this.d_fileMenu.addSeparator();
        this.d_mruModelMenu = new MRUMenu(Intl.intl("Recent PyroSim Files"), this.d_mruModelFiles, new MRUListener(){

            @Override
            public boolean itemSelected(int index, String name) {
                if (!PyroSim.this.promptSaveIfModified(true)) {
                    return true;
                }
                PyroMod pyMod = PyroSim.this.getMediator();
                OpenModelTask tsk = new OpenModelTask(PyroSim.this, pyMod, name);
                pyMod.getTaskManager().exec((Task)tsk, Intl.intl("Open PyroSim File"), 10);
                return tsk.success();
            }
        });
        this.d_fileMenu.add(this.d_mruModelMenu);
        this.d_mruFDSMenu = new MRUMenu(Intl.intl("Recent FDS Files"), this.d_mruFDSFiles, new MRUListener(){

            @Override
            public boolean itemSelected(int index, String name) {
                if (!PyroSim.this.promptSaveIfModified(true)) {
                    return true;
                }
                PyroMod pyMod = PyroSim.this.getMediator();
                ImportFDSFile tsk = new ImportFDSFile(PyroSim.this, pyMod, name);
                pyMod.getTaskManager().exec((Task)tsk, Intl.intl("Import FDS File"), 2);
                return tsk.getSuccess();
            }
        });
        this.d_fileMenu.add(this.d_mruFDSMenu);
        this.d_fileMenu.addSeparator();
        this.d_fileMenu.add(new ExitAction());
        return this.d_fileMenu;
    }

    public JMenu createEditMenu() {
        this.d_editMenu = new guiMenu(Intl.intl("&Edit"));
        this.d_editMenu.add(Actions.getUndoAction());
        this.d_editMenu.add(Actions.getRedoAction());
        this.d_editMenu.addSeparator();
        this.d_editMenu.add(Actions.getCutAction());
        this.d_editMenu.add(Actions.getCopyAction());
        this.d_editMenu.add(Actions.getCopyFDSAction());
        this.d_editMenu.add(Actions.getPasteAction());
        Actions.getDeleteAction().addToMenu(this.d_editMenu);
        this.d_editMenu.add(Actions.getFindAction());
        return this.d_editMenu;
    }

    public JMenu createModelMenu() {
        this.d_modelMenu = new guiMenu(Intl.intl("&Model"));
        this.d_modelMenu.add(Actions.EDIT_LIBRARIES_ACTION);
        this.d_modelMenu.add(Actions.APPEARANCE_MANAGER_ACTION);
        this.d_modelMenu.addSeparator();
        this.d_modelMenu.add(Actions.getGridAction());
        this.d_modelMenu.add(Actions.ZONES_ACTION);
        this.d_modelMenu.add(Actions.getExSpecListAction());
        this.d_modelMenu.add(Actions.getReactionManagerAction());
        this.d_modelMenu.add(Actions.getMaterialManagerAction());
        this.d_modelMenu.add(Actions.getSurfaceManagerAction());
        this.d_modelMenu.add(Actions.getParticleAction());
        this.d_modelMenu.add(Actions.getHvacListAction());
        this.d_modelMenu.addSeparator();
        this.d_modelMenu.add(Actions.getAddWallAction());
        this.d_modelMenu.add(Actions.getAddHoleAction());
        this.d_modelMenu.add(Actions.getAddVentAction());
        this.d_modelMenu.add(Actions.getAddSlabAction());
        this.d_modelMenu.add(Actions.getAddPartCloudAction());
        this.d_modelMenu.add(Actions.ADD_PART_LOC_ACTION);
        this.d_modelMenu.add(Actions.ADD_INIT_REGION_ACTION);
        this.d_modelMenu.add(Actions.ADD_HVAC_NODE_ACTION);
        this.d_modelMenu.add(Actions.ADD_HVAC_DUCT_ACTION);
        this.d_modelMenu.add(Actions.GLOBAL_ADD_GROUP_ACTION);
        this.d_modelMenu.addSeparator();
        this.d_modelMenu.add(Actions.CHANGE_GROUP);
        this.d_modelMenu.add(Actions.getTranslateAction());
        this.d_modelMenu.add(Actions.getMirrorAction());
        this.d_modelMenu.add(Actions.getScaleAction());
        this.d_modelMenu.add(Actions.getRotateAction());
        this.d_modelMenu.add(Actions.getRasterizeAction());
        this.d_modelMenu.addSeparator();
        this.d_modelMenu.add(Actions.getEditNodeAction());
        return this.d_modelMenu;
    }

    public JMenu createDeviceMenu() {
        this.d_deviceMenu = new guiMenu(Intl.intl("&Devices"));
        this.d_deviceMenu.add(Actions.CONTROLS_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_SIMCTRL_ACTION);
        this.d_deviceMenu.add(Actions.NEW_TIME_DEVC_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_ASPIRATOR_SAMPLER_ACTION);
        this.d_deviceMenu.add(Actions.NEW_ASPIRATOR_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_GAS_POINT_DEVICES_ACTION);
        this.d_deviceMenu.add(Actions.NEW_SOLID_POINT_DEVICES_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_THERMOCOUPLE_ACTION);
        this.d_deviceMenu.add(Actions.NEW_FLOW_MEASURER_ACTION);
        this.d_deviceMenu.add(Actions.NEW_HEAT_RELEASE_RATE_MEASURER_ACTION);
        this.d_deviceMenu.add(Actions.NEW_LAYER_INFORMATION_MEASURER_ACTION);
        this.d_deviceMenu.add(Actions.NEW_PATH_OBSCURATION_MEASURER_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_HEAT_DETECTOR_DEVICE_ACTION);
        this.d_deviceMenu.add(Actions.getHeatLinkModelManagerAction());
        this.d_deviceMenu.add(Actions.NEW_SMOKE_DETECTOR_ACTION);
        this.d_deviceMenu.add(Actions.getSmokeDetectorModelsAction());
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_HVAC_DUCT_DEVICE_ACTION);
        this.d_deviceMenu.add(Actions.NEW_HVAC_NODE_DEVICE_ACTION);
        this.d_deviceMenu.addSeparator();
        this.d_deviceMenu.add(Actions.NEW_SPRINKLER_DEVICE_ACTION);
        this.d_deviceMenu.add(Actions.NEW_NOZZLE_ACTION);
        this.d_deviceMenu.add(Actions.NEW_SPRINKLER_LINK_ACTION);
        this.d_deviceMenu.add(Actions.getSprayModelManagerAction());
        this.d_deviceMenu.add(Actions.getSprinklerLinkModelManagerAction());
        this.d_deviceMenu.add(Actions.NEW_DRY_PIPE_ACTION);
        return this.d_deviceMenu;
    }

    public JMenu createOutputMenu() {
        this.d_outputMenu = new guiMenu(Intl.intl("&Output"));
        this.d_outputMenu.add(Actions.getProfListAction());
        this.d_outputMenu.add(Actions.getSliceAction());
        this.d_outputMenu.add(Actions.getSlice3DAction());
        this.d_outputMenu.add(Actions.getBoundaryConditionAction());
        this.d_outputMenu.add(Actions.getIsosurfaceAction());
        this.d_outputMenu.add(Actions.getPlot3DAction());
        this.d_outputMenu.add(Actions.MSR_STATS_ACTION);
        return this.d_outputMenu;
    }

    public JMenu updateFDSMenu() {
        if (this.d_fdsMenu == null) {
            this.d_fdsMenu = new guiMenu(Intl.intl("&Analysis"));
        } else {
            this.d_fdsMenu.removeAll();
        }
        this.d_fdsMenu.add(Actions.getEditSimulationPropertiesAction());
        this.d_fdsMenu.add(Actions.getEditOpenMpAction());
        this.d_fdsMenu.addSeparator();
        this.d_fdsMenu.add(RunFdsActions.RUN_FDS_ACTION);
        this.d_fdsMenu.add(RunFdsActions.RESUME_FDS_ACTION);
        this.d_fdsMenu.add(RunFdsActions.RUN_FDS_MPI_ACTION);
        this.d_fdsMenu.add(RunFdsActions.RESUME_FDS_MPI_ACTION);
        this.d_fdsMenu.addSeparator();
        this.d_fdsMenu.add(RunFdsActions.RUN_FDS_CLUSTER_ACTION);
        this.d_fdsMenu.add(RunFdsActions.RESUME_FDS_CLUSTER_ACTION);
        guiMenu cloudMenu = new guiMenu(Intl.intl("Manage Cloud Simulations"));
        OpenExternalUrlAction openCloudPortalAction = new OpenExternalUrlAction(Intl.intl("CFD FEA"), null, "https://cloud.cfdfeaservice.it/");
        cloudMenu.add(openCloudPortalAction);
        this.d_fdsMenu.add(new JPopupMenu.Separator());
        this.d_fdsMenu.add(RunFdsActions.RUN_FDS_CLOUD_ACTION);
        this.d_fdsMenu.add(Actions.VIEW_FDS_CLOUD_JOBS_ACTION);
        this.d_fdsMenu.add(cloudMenu);
        this.d_fdsMenu.addSeparator();
        this.d_fdsMenu.add(Actions.getResultsPreviewAction());
        this.d_fdsMenu.add(Actions.RUN_RESULTS_ACTION);
        this.d_fdsMenu.add(Actions.RUN_SMOKEVIEW_ACTION);
        this.d_fdsMenu.add(Actions.getTCPlotsAction());
        this.d_fdsMenu.add(Actions.OPEN_RESULTS_FOLDER);
        this.d_fdsMenu.addSeparator();
        this.d_fdsMenu.add(Actions.ARCHIVE_RESULTS);
        this.d_fdsMenu.add(Actions.RESTORE_RESULTS);
        this.d_fdsFullLength = this.d_fdsMenu.getItemCount();
        return this.d_fdsMenu;
    }

    public JMenu updateViewMenu(ViewMode selectedView) {
        this.d_viewMenu = new guiMenu(Intl.intl("&View"));
        JRadioButtonMenuItem show3DViewItem = new JRadioButtonMenuItem(new SelectViewModeAction(Intl.intl("Show 3D View"), ViewMode.MV_3D));
        JRadioButtonMenuItem show2DViewItem = new JRadioButtonMenuItem(new SelectViewModeAction(Intl.intl("Show 2D View"), ViewMode.MV_2D));
        JRadioButtonMenuItem showRecordViewItem = new JRadioButtonMenuItem(new SelectViewModeAction(Intl.intl("Show Record View"), ViewMode.RECORD));
        ButtonGroup viewGroup = new ButtonGroup();
        viewGroup.add(show3DViewItem);
        viewGroup.add(show2DViewItem);
        viewGroup.add(showRecordViewItem);
        this.d_viewMenu.add(show3DViewItem);
        this.d_viewMenu.add(show2DViewItem);
        this.d_viewMenu.add(showRecordViewItem);
        switch (selectedView) {
            case MV_2D: {
                show2DViewItem.setSelected(true);
                break;
            }
            case MV_3D: {
                show3DViewItem.setSelected(true);
                break;
            }
            case RECORD: {
                showRecordViewItem.setSelected(true);
            }
        }
        this.d_viewMenu.addSeparator();
        if (selectedView.isModelView) {
            this.d_viewMenu.add(Actions.GLOBAL_ADD_VIEW);
            this.d_viewMenu.add(Actions.GLOBAL_ADD_SECTION_BOX);
            this.d_viewMenu.add(Actions.GLOBAL_RESET_SECTION_BOX);
            this.d_viewMenu.add(Actions.GLOBAL_SAVE_VIEW_CAMERA);
            this.d_viewMenu.add(Actions.GLOBAL_SHOW_VIEW_CAMERA);
            this.d_viewMenu.addSeparator();
            for (BooleanAction action : this.d_3dView.getClipFilterActions()) {
                this.d_viewMenu.add(new JCheckBoxMenuItem(action));
            }
            this.d_viewMenu.addSeparator();
        }
        if (selectedView == ViewMode.MV_3D) {
            BooleanAction useSVNavAction = this.d_3dView.getUseSVNavAction();
            JCheckBoxMenuItem smokeViewNavItem = new JCheckBoxMenuItem(useSVNavAction);
            useSVNavAction.addPropertyChangeListener(new SelectableActionListener(smokeViewNavItem, useSVNavAction));
            this.d_viewMenu.add(smokeViewNavItem);
            this.d_viewMenu.addSeparator();
        }
        if (selectedView.isModelView) {
            ModelView.CutHolesAction cutAction = this.d_3dView.getCutHolesAction();
            JCheckBoxMenuItem cutItem = new JCheckBoxMenuItem(cutAction);
            cutAction.addPropertyChangeListener(new SelectableActionListener(cutItem, cutAction));
            this.d_viewMenu.add(cutItem);
            this.d_viewMenu.addSeparator();
        }
        if (selectedView == ViewMode.MV_2D) {
            MutuallyExclusiveAction noGridAction = this.d_3dView.getNoGridAction();
            JRadioButtonMenuItem noGridBtn = new JRadioButtonMenuItem(noGridAction);
            noGridBtn.addItemListener(noGridAction);
            MutuallyExclusiveAction sketchAction = this.d_3dView.getSketchGridAction();
            JRadioButtonMenuItem sketchBtn = new JRadioButtonMenuItem(sketchAction);
            sketchBtn.addItemListener(sketchAction);
            MutuallyExclusiveAction modelGridAction = this.d_3dView.getModelGridsAction();
            JRadioButtonMenuItem modelGridsBtn = new JRadioButtonMenuItem(modelGridAction);
            modelGridsBtn.addItemListener(modelGridAction);
            this.d_viewMenu.add(sketchBtn);
            this.d_viewMenu.add(modelGridsBtn);
            this.d_viewMenu.add(noGridBtn);
            this.d_viewMenu.add(this.d_3dView.getEditSnapSizeAction());
            JCheckBoxMenuItem showOrigin = new JCheckBoxMenuItem(this.d_3dView.getShowOriginAction());
            this.d_3dView.getShowOriginAction().addPropertyChangeListener(new SelectableActionListener(showOrigin, this.d_3dView.getShowOriginAction()));
            this.d_viewMenu.add(showOrigin);
            this.d_viewMenu.addSeparator();
        }
        if (selectedView.isModelView) {
            JCheckBoxMenuItem showGuides = new JCheckBoxMenuItem(this.d_3dView.getShowGuidesAction());
            this.d_3dView.getShowGuidesAction().addPropertyChangeListener(new SelectableActionListener(showGuides, this.d_3dView.getShowGuidesAction()));
            this.d_viewMenu.add(showGuides);
            JCheckBoxMenuItem showPointer = new JCheckBoxMenuItem(this.d_3dView.getShowPointerAction());
            this.d_3dView.getShowPointerAction().addPropertyChangeListener(new SelectableActionListener(showPointer, this.d_3dView.getShowPointerAction()));
            this.d_viewMenu.add(showPointer);
            this.d_viewMenu.addSeparator();
        }
        if (selectedView == ViewMode.RECORD) {
            // empty if block
        }
        if (selectedView.isModelView) {
            this.d_colorMenu = new ColorMgrMenu(Intl.intl("&Color Scheme"), this.d_colorManager);
            this.d_viewMenu.add(this.d_colorMenu);
        }
        guiMenu unitsMenu = new guiMenu(Intl.intl("&Units"));
        guiUtil.addMEMenuItems((JMenu)unitsMenu, UnitsAction.SI_ACTION, UnitsAction.NON_SI_UNITS_ACTION);
        this.d_viewMenu.add(unitsMenu);
        this.d_viewMenu.addSeparator();
        this.d_viewMenu.add(Actions.getHideNodeAction());
        this.d_viewMenu.add(Actions.getShowNodeAction());
        this.d_viewMenu.add(Actions.getHideUnselectedNodeAction());
        this.d_viewMenu.add(Actions.getShowAllNodesAction());
        if (selectedView.isModelView) {
            this.d_viewMenu.addSeparator();
            this.d_viewMenu.add(this.d_3dView.getResetToAllAction());
            this.d_viewMenu.add(this.d_3dView.getResetToSelectedAction());
            this.d_viewMenu.add(this.d_3dView.getFillViewAction());
        }
        return this.d_viewMenu;
    }

    public void showActivationDialog() {
        ActivationDlg dlg = new ActivationDlg(this.getMainFrame(), this.d_licenseMgr, "PyroSim", null, this.getPrefs(), PyroPrefs.LicenseDirProp, PyroPrefs.LicenseServerProp, new Color(0.61f, 0.76f, 0.93f));
        dlg.doModal();
        this.updateFDSMenu();
        this.updateToolbar();
        this.savePreferences();
    }

    public JMenu createHelpMenu() {
        this.d_helpMenu = new guiMenu(Intl.intl("&Help"));
        String urlVerSlug = Version.getDocsVersion();
        OpenExternalUrlAction openManualAction = new OpenExternalUrlAction(Intl.intl("Pyrosim &User Manual"), null, String.format("https://support.thunderheadeng.com/docs/pyrosim/%s/user-manual/", urlVerSlug));
        OpenExternalUrlAction openResultsManual = new OpenExternalUrlAction(Intl.intl("PyroSim &Results Manual"), null, String.format("https://support.thunderheadeng.com/docs/pyrosim/%s/results-user-manual/", urlVerSlug));
        OpenExternalUrlAction openWebDocsAction = new OpenExternalUrlAction(Intl.intl("More Help &Online"), null, "https://support.thunderheadeng.com/pyrosim/");
        String urlFdsSlug = String.format("https://github.com/firemodels/fds/releases/download/FDS%d.%d.%d/", Version.FDS_DESIGN.major, Version.FDS_DESIGN.minor, Version.FDS_DESIGN.maintenance);
        String urlFdsGuide = urlFdsSlug + "FDS_User_Guide.pdf";
        String urlFdsTechRef = urlFdsSlug + "FDS_Technical_Reference_Guide.pdf";
        String urlSmvGuide = urlFdsSlug + "SMV_User_Guide.pdf";
        guiMenu moreHelp = new guiMenu(Intl.intl("More &Help"));
        moreHelp.add(new OpenExternalUrlAction(Intl.intl("&FDS User Guide"), null, urlFdsGuide));
        moreHelp.add(new OpenExternalUrlAction(Intl.intl("FDS &Technical Reference"), null, urlFdsTechRef));
        moreHelp.add(new OpenExternalUrlAction(Intl.intl("&Smokeview User Guide"), null, urlSmvGuide));
        this.d_helpMenu.add(openManualAction);
        this.d_helpMenu.add(openResultsManual);
        this.d_helpMenu.add(openWebDocsAction);
        this.d_helpMenu.add(moreHelp);
        this.d_helpMenu.addSeparator();
        RegisterAction registerItem = new RegisterAction();
        this.d_helpMenu.add(registerItem);
        this.d_helpMenu.add(new RemoveLicenseAction());
        this.d_helpMenu.add(new CheckForUpdatesAction());
        if (PyroSim.isDev()) {
            guiAction runGC = new guiAction(Intl.intl("Run Java Garbage Collector")){
                private static final long serialVersionUID = 4614702983731840826L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.gc();
                }
            };
            runGC.putValue("AcceleratorKey", Accelerators.GARBAGE_COLLECTOR);
            this.d_helpMenu.addSeparator();
            this.d_helpMenu.add(runGC);
        }
        this.d_helpMenu.addSeparator();
        this.d_helpMenu.add(new SaveOutputLogAction());
        this.d_helpMenu.add(new HelpAboutAction());
        return this.d_helpMenu;
    }

    private void setMode(ViewMode newMode) {
        if (newMode == ViewMode.RECORD) {
            this.d_viewChangeListener.updateActiveView(newMode);
        } else {
            this.d_viewChangeListener.updateActiveView(newMode);
            this.d_3dView.setMode(newMode);
        }
    }

    private void initActiveView() {
        ViewMode vm = this.d_mediator.getViews().getActiveView().getViewMode().orElse(ViewMode.getDefault());
        this.d_viewChangeListener.updateActiveView(vm);
    }

    private void updateActiveView() {
        this.d_mediator.getViews().getActiveView().getViewMode().ifPresent(vm -> this.d_viewChangeListener.updateActiveView((ViewMode)((Object)vm)));
    }

    public void setView(CameraState cstate, View.NavTool ntool) {
        this.d_viewChangeListener.updateActiveView(cstate.getViewMode());
        this.d_3dView.setView(cstate, ntool);
    }

    public Component createTreeView() {
        this.d_treeView = new PyroTreeView(this.getMediator());
        JScrollPane pane = new JScrollPane(this.d_treeView);
        pane.setHorizontalScrollBarPolicy(32);
        guiPanel panel = new guiPanel();
        JToolBar tb = new JToolBar();
        JToolBar tbTree = new JToolBar(0);
        tbTree.add(this.d_treeView.getAutoExpandButton());
        tbTree.addSeparator();
        tbTree.add(this.d_treeView.getCollapseAllButton());
        tbTree.add(this.d_treeView.getExpandAllButton());
        tbTree.setFloatable(false);
        Utils.noToolBarFocus(tbTree);
        tb.add(tbTree);
        tb.setFloatable(false);
        panel.add((Component)tb, "North");
        panel.add((Component)pane, "Center");
        return panel;
    }

    public Component createViewModes() {
        this.d_3dView = new ModelView(this.d_mediator, this.d_colorManager);
        this.d_3dView.reset();
        this.d_modifiedTracker.addTarget(this.d_3dView.getSketchGrid());
        this.d_3DPanel = this.d_3dView.getViewComponent();
        this.d_recordView = new RecordView(this.d_mediator);
        this.d_colorManager.addColorChangedListener(this.d_recordView);
        this.d_modifiedTracker.addTarget(this.d_recordView);
        this.d_mainView = new JTabbedPane(3);
        this.d_mainView.setBorder(BorderFactory.createEmptyBorder(-2, -2, -1, -4));
        this.d_mainView.add(Intl.intl("3D View"), this.d_3DPanel);
        this.d_mainView.add(Intl.intl("2D View"), null);
        this.d_mainView.add(Intl.intl("Record View"), this.d_recordView);
        this.d_viewChangeListener = new ViewChangeListener();
        this.d_mainView.addChangeListener(this.d_viewChangeListener);
        this.d_mediator.getEvents().addObserver(this.d_viewChangeListener);
        return this.d_mainView;
    }

    public RecordView getRecordView() {
        return this.d_recordView;
    }

    public void setUnitSystem(UnitSystem system) {
        this.d_unitSystem = system;
    }

    public UnitSystem getUnitSystem() {
        return this.d_unitSystem;
    }

    public static PyroSimLM getLicenseManager() {
        return ((PyroSim)Application.getApp()).d_licenseMgr;
    }

    public static boolean is64Bit() {
        String bits = System.getProperty("sun.arch.data.model", null);
        if (bits == null) {
            return System.getProperty("java.vm.name").toLowerCase().indexOf("64") >= 0;
        }
        return bits.equals("64");
    }

    @Override
    protected void loadLibraries() {
        PyroSim.loadLib("FreeImage", "FreeImaged");
        PyroSim.loadLib("PyroSim", new String[0]);
    }

    private void updateTitle() {
        String title = PyroSim.getFrameTitleBase() + " - ";
        if (this.d_modifiedTracker.isModified()) {
            title = title + "*";
        }
        title = this.d_filename == null ? title + "Untitled" : title + this.d_filename;
        if (this.d_mediator.isWriteProtected()) {
            title = title + " " + Intl.intl("(write-protected)");
        }
        this.getMainFrame().setTitle(title);
    }

    public void setFDSRunMode(FDSRun.Mode type) {
        RunFdsActions.ARunFDSAction defAction;
        switch (type) {
            case PARALLEL: {
                defAction = RunFdsActions.RUN_FDS_MPI_ACTION;
                break;
            }
            case CLUSTER: {
                defAction = RunFdsActions.RUN_FDS_CLUSTER_ACTION;
                break;
            }
            case CLOUD: {
                defAction = RunFdsActions.RUN_FDS_CLOUD_ACTION;
                break;
            }
            default: {
                defAction = RunFdsActions.RUN_FDS_ACTION;
            }
        }
        this.d_fdsRunDropdown.setSelectedAction(defAction);
    }

    public DropDownButton getFDSRunDropdown() {
        return this.d_fdsRunDropdown;
    }

    private void resetView() {
        double spacing = PyroPrefs.getDouble(PyroPrefs.DefaultSnapSpacing);
        this.d_3dView.setSketchGridSpacing(spacing);
        this.d_3dView.getShowBGImagesAction().setSelected(true);
        this.d_3dView.setActiveSnapper(1);
        this.setFilename(null, false);
    }

    public void setFilename(String fn, boolean scheduleSave) {
        this.d_filename = fn;
        this.d_forceSavePrompt = scheduleSave;
        if (this.d_filename != null) {
            this.setCurrentDir(new File(fn));
        }
    }

    public void setSnapToSpacing(double spacing) {
        this.d_3dView.setSketchGridSpacing(spacing);
    }

    public ModelView getModelView() {
        return this.d_3dView;
    }

    public MRUMenu getMRUMenu() {
        return this.d_mruModelMenu;
    }

    public MRUMenu getFDSMRUMenu() {
        return this.d_mruFDSMenu;
    }

    public String getFilename() {
        return this.d_filename;
    }

    public boolean getPromptOnNextSave() {
        return this.d_filename == null || this.d_forceSavePrompt;
    }

    public File suggestFile(String ext) {
        String fn = this.d_filename;
        return fn == null ? new File(String.format(Intl.intl("untitled.%s"), ext)) : new File(FilenameManager.changeExtension(fn, ext));
    }

    public File getFDSSaveFile() {
        File defFn = this.suggestFile("fds");
        if (Objects.nonNull(this.getFilename())) {
            String chid = FDSRenderer.generateChid(new File(this.getFilename()).getName(), FDSRenderer.getDefaultScenarioNameForChid(this.getMediator().getScenarios()));
            defFn = new File(defFn.getParentFile(), String.format("%s.fds", chid));
        }
        File file = PyroSim.getFilenames().getSaveFile((Component)PyroSim.getApp().getMainFrame(), Intl.intl("Choose a Location to Save the FDS Data File"), defFn, "fds", Intl.intl("FDS 6 Input Files"));
        return file;
    }

    public boolean writeFDSFile(File file, boolean silent, FDSRenderer.RENDER_ORIGIN origin) {
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new IOException(Intl.intl("Unable to create new file"));
            }
            this.beginWaitCursor();
            FDSRenderer writer = FDS.newRenderer(this.getMediator(), silent ? this.d_fdsRenderProps : new PromptingFDSRenderProps(this.d_mediator, this.d_fdsRenderProps), origin);
            writer.renderFile(file);
            this.endWaitCursor();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.getMainFrame(), Intl.intl("An error occurred creating the file") + ":\n" + e.getMessage(), Intl.intl("File Error"), 0);
            return false;
        }
    }

    public boolean saveIfModified() {
        if (this.d_modifiedTracker.isModified()) {
            return this.doSave(false);
        }
        return true;
    }

    public File promptSaveFile() {
        return PyroSim.getFilenames().getSaveFile((Component)PyroSim.getApp().getMainFrame(), this.suggestFile("psm"), "psm", Intl.intl("PyroSim Model Files"));
    }

    public boolean doSave(boolean bForcePrompt) {
        File saveFile;
        if (bForcePrompt || this.getPromptOnNextSave()) {
            saveFile = this.promptSaveFile();
            if (saveFile == null) {
                return false;
            }
        } else {
            saveFile = new File(this.d_filename);
        }
        return this.doSave(saveFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doSave(File saveFile) {
        this.beginWaitCursor();
        this.d_recordView.applyChanges();
        ObjectOutputStream oos = null;
        try {
            oos = new PyroSimObjectOutputStream(new BufferedOutputStream(new FileOutputStream(saveFile)));
            this.writeModel(this.d_mediator, oos);
            this.d_forceSavePrompt = false;
            this.d_mruModelMenu.usedFile(saveFile.getAbsolutePath());
            this.d_filename = saveFile.getAbsolutePath();
            this.d_mediator.getEvents().changed(this.d_mediator, PyroMod.EVT_FILENAME_CHANGED);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.error(new guiExceptionError(ex));
            boolean bl = false;
            return bl;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    this.error(ex.getMessage());
                    return false;
                }
            }
            this.endWaitCursor();
        }
    }

    public void writeModel(PyroMod pyMod, ObjectOutputStream oos) throws IOException {
        if (this.d_3dView == null) {
            throw new IOException("ModelView required for saving model.");
        }
        pyMod.saveModel(oos);
        oos.writeDouble(this.d_3dView.getSketchGridSpacing());
        oos.writeBoolean(this.d_3dView.getShowBGImagesAction().isSelected());
        int snapper = this.d_3dView.getCurrentSnapper();
        oos.writeInt(snapper);
        oos.writeObject(this.d_3dView.getFilterProps());
    }

    private void editPreferences(PreferencesDialog.Tabs tab) {
        PreferencesDialog dlg = new PreferencesDialog(this.d_3dView::getDefaultPrefs, RenderPrefs::getPreferredPrefs, RenderPrefs::getCompatibilityPrefs, tab);
        if (dlg.doModal() == 1) {
            dlg.saveData();
        }
    }

    private void updateViewLayout(ViewMode mode) {
        if (mode == ViewMode.RECORD) {
            this.d_3DPanel.setVisible(false);
            return;
        }
        this.d_recordView.setVisible(false);
        this.d_3DPanel.setVisible(true);
    }

    public NewAction getNewAction() {
        return this.d_newAction;
    }

    public OpenAction getOpenAction() {
        return this.d_openAction;
    }

    public SaveAction getSaveAction() {
        return this.d_saveAction;
    }

    public ScreenShotAction getScreenShotAction() {
        return this.d_screenShotAction;
    }

    public SaveAsAction getSaveAsAction() {
        return this.d_saveAsAction;
    }

    public ExportFDSFileAction getWriteFDSFileAction() {
        return this.d_writeFDSFileAction;
    }

    private void updateBackup() {
        TeciProps prefs = this.getPrefs();
        this.d_backup.setFilename(this.d_filename);
        this.d_backup.setAutosaveEnabled(prefs.getBoolean(PyroPrefs.PREF_USEAUTOSAVE));
        this.d_backup.setAutosavePeriod(PyroPrefs.getUnitDouble(PyroPrefs.PREF_AUTOSAVE_INTERVAL));
        this.d_backup.setBackupEnabled(PyroPrefs.getBoolean(PyroPrefs.PREF_CREATE_BACKUP_ON_OPEN));
    }

    private class BackupEvtListener
    implements IEventObserver {
        private BackupEvtListener() {
        }

        @Override
        public void update(Events events) {
            if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_MODEL_CHANGED, PyroMod.EVT_FILENAME_CHANGED, PyroMod.EVT_PREFS_CHANGED)) {
                PyroSim.this.updateBackup();
            }
        }
    }

    private static class HelpAboutAction
    extends guiAction {
        private static final long serialVersionUID = 7878803891449394855L;

        public HelpAboutAction() {
            super(Intl.intl("About..."));
        }

        private static void addEmptyRow(GridBagHelper gb) {
            gb.addRow(Box.createVerticalStrut(12), 0);
        }

        private static JComponent lbl(String msg) {
            msg = "<html>" + msg.replaceAll("[\n]", "<br>");
            return new guiLabel(msg);
        }

        private static <T extends Component> T init(T comp) {
            comp.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
            return comp;
        }

        private static guiPanel newCanvas(boolean indentBorder) {
            guiPanel overlay = new guiPanel();
            overlay.setBackground(Color.WHITE);
            Border border = BorderFactory.createLineBorder(Color.BLACK);
            if (indentBorder) {
                border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(6, 6, 6, 6));
            }
            overlay.setBorder(border);
            return overlay;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim pySim = PyroSim.getApp();
            guiDialog dlg = new guiDialog((Window)pySim.getMainFrame(), "PyroSim - Version 2022.3.1208", 1);
            guiPanel overlay = HelpAboutAction.newCanvas(false);
            guiPanel contentPnl = new guiPanel();
            contentPnl.setBackground(new Color(0, 0, 0, 0));
            overlay.add(contentPnl);
            GridBagHelper gb = new GridBagHelper(contentPnl, true);
            gb.rowSpace = 0;
            gb.addRow(Intl.intl("Revision:  ") + "2022.3.1208", 0);
            HelpAboutAction.addEmptyRow(gb);
            JLabel bgImage = new JLabel(PyroGuiUtil.loadPyroSimIcon("PyroSimLogo60.png"));
            gb.addRow(bgImage, 0);
            HelpAboutAction.addEmptyRow(gb);
            gb.addRow(String.format(Intl.intl("PyroSim is a preprocessor for FDS %s and later."), Version.FDS_DESIGN), 0);
            HelpAboutAction.addEmptyRow(gb);
            gb.addRow(Intl.intl("Developed by Thunderhead Engineering Consultants, Inc."), 0);
            gb.addRow(HelpAboutAction.init(new guiURLLabel("http://www.thunderheadeng.com")), 0);
            HelpAboutAction.addEmptyRow(gb);
            String localizationCredit = Intl.intl("Localization Credit");
            if (!localizationCredit.equals("Localization Credit")) {
                gb.addFilledRow(HelpAboutAction.lbl(localizationCredit));
                HelpAboutAction.addEmptyRow(gb);
            }
            int thisYear = Calendar.getInstance().get(1);
            gb.addRow(String.format(Intl.intl("Copyright (c) 2002-%d All Rights Reserved."), thisYear), 0);
            gb.addFilledRow(HelpAboutAction.lbl(PyroSim.getLicenseManager().getDescription()));
            HelpAboutAction.addEmptyRow(gb);
            Runtime rt = Runtime.getRuntime();
            String rtLbl = String.format(Intl.intl("Free Java Memory:  %d MB\nJava Memory Limit: %d MB\nJava Max Memory:   %d MB"), rt.freeMemory() / 1024L / 1024L, rt.totalMemory() / 1024L / 1024L, rt.maxMemory() / 1024L / 1024L);
            gb.addFilledRow(HelpAboutAction.lbl(rtLbl));
            HelpAboutAction.addEmptyRow(gb);
            gb.addTitle(Intl.intl("GPU Information"));
            HelpAboutAction.addEmptyRow(gb);
            Supplier<IRenderSurface.OpenGLInfo> getRenderInfo = () -> PyroSim.getApp().get3DView().getRenderComp().getOpenGLInfo();
            GPUInfoPnl gpuPnl = new GPUInfoPnl(getRenderInfo, true);
            gb.addIdentRow(gpuPnl, 0, 1.0);
            HelpAboutAction.addEmptyRow(gb);
            gb.addRow(new guiLabel(guiUtil.loadTeciIcon("teci_logo.png")), 0);
            dlg.getDialogPane().add((Component)overlay, "Center");
            JButton ok = dlg.getButton(1);
            JButton legal = new JButton(Intl.intl("Disclaimer"));
            legal.addActionListener(evt -> {
                String msg = "Thunderhead Engineering makes no warranty, expressed or implied, to \nusers of PyroSim, and accepts no responsibility for its use. Users of PyroSim\nassume sole responsibility under Federal law for determining the appropriateness\nof its use in any particular application, for any conclusions drawn from the\nresults of its use, and for any actions taken or not taken as a result of\nanalyses performed using these tools.\n\nThe US Department of Commerce makes no warranty, expressed or \nimplied, to users of the Fire Dynamics Simulator (FDS), and accepts no \nresponsibility for its use. Users of FDS assume sole responsibility under\nFederal law for determining the appropriateness of its use in any \nparticular application; for any conclusions drawn from the results of \nits use; and for any actions taken or not taken as a result of analyses \nperformed using these tools.";
                JOptionPane.showMessageDialog(dlg, "Thunderhead Engineering makes no warranty, expressed or implied, to \nusers of PyroSim, and accepts no responsibility for its use. Users of PyroSim\nassume sole responsibility under Federal law for determining the appropriateness\nof its use in any particular application, for any conclusions drawn from the\nresults of its use, and for any actions taken or not taken as a result of\nanalyses performed using these tools.\n\nThe US Department of Commerce makes no warranty, expressed or \nimplied, to users of the Fire Dynamics Simulator (FDS), and accepts no \nresponsibility for its use. Users of FDS assume sole responsibility under\nFederal law for determining the appropriateness of its use in any \nparticular application; for any conclusions drawn from the results of \nits use; and for any actions taken or not taken as a result of analyses \nperformed using these tools.", Intl.intl("Disclaimer"), 1);
            });
            JButton credits = new JButton(Intl.intl("Credits"));
            credits.addActionListener(e1 -> {
                String[] libs = new String[]{"FreeImage v3.18.0", "FreeType v2.2.1", "FTGL v2.15", "JSON.simple v1.1.1"};
                StringBuilder libStr = new StringBuilder(Intl.intl("PyroSim uses the following open source libraries:\n"));
                for (String lib : libs) {
                    libStr.append('\n');
                    libStr.append("        ");
                    libStr.append(lib);
                }
                JOptionPane.showMessageDialog(dlg, libStr.toString(), Intl.intl("Credits"), 1);
            });
            dlg.setButtons(legal, credits, ok);
            dlg.getRootPane().setDefaultButton(ok);
            dlg.pack();
            dlg.doModal();
        }
    }

    private static class CheckForUpdatesAction
    extends guiAction {
        private static final long serialVersionUID = -7743518332575962275L;

        public CheckForUpdatesAction() {
            super(Intl.intl("Check for Updates..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim pySim = PyroSim.getApp();
            CompletableFuture<VersionUtil.URLVersionSource> versionSource = VersionUtil.getDefaultSrc("PyroSim");
            PyroCheckForUpdatesDlg dlg = new PyroCheckForUpdatesDlg(pySim, PyroPrefs.getBoolean(PyroPrefs.PREF_CHECKLATEST), versionSource);
            if (dlg.doModal() == 1) {
                PyroPrefs.set(PyroPrefs.PREF_CHECKLATEST, dlg.isCheckOnStart(), true);
            }
        }
    }

    private static class SaveOutputLogAction
    extends guiAction {
        private static final long serialVersionUID = 8839198657863594353L;

        public SaveOutputLogAction() {
            super(Intl.intl("Save Output Log..."));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (PyroSim.getApp() == null) {
                return;
            }
            PyroSim pySim = PyroSim.getApp();
            FilenameManager fman = pySim.getFilenameManager();
            guiFileChooser gfc = fman.getFileChooser("TXT", "Text Document");
            if (gfc.showSaveDialog(pySim.getMainFrame()) == 0) {
                File f = gfc.getSelectedFile();
                if (f == null) {
                    return;
                }
                try {
                    System.out.printf("Copying log file to: %s%n", f);
                    CopyFile.copy(OutputLog.logFile, f);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(pySim.getMainFrame(), e.getLocalizedMessage());
                }
            }
        }
    }

    private static class OpenExternalUrlAction
    extends guiAction {
        private static final long serialVersionUID = 5010076194463905665L;
        private String d_target;

        public OpenExternalUrlAction(String name, Icon icon, String target) {
            super(name, icon);
            this.putValue("ShortDescription", target);
            this.d_target = target;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                Desktop.getDesktop().browse(URI.create(this.d_target));
            }
            catch (Exception e) {
                JFrame mainFrame = null;
                if (PyroSim.getApp() != null) {
                    mainFrame = PyroSim.getApp().getMainFrame();
                }
                e.printStackTrace();
                JOptionPane.showMessageDialog(mainFrame, e.getLocalizedMessage(), Intl.intl("Error Opening URL"), 0);
            }
        }
    }

    class SelectViewModeAction
    extends guiAction {
        private static final long serialVersionUID = 490338083450292036L;
        private final ViewMode d_mode;

        public SelectViewModeAction(String name, ViewMode mode) {
            super(name);
            this.d_mode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim.this.setMode(this.d_mode);
        }
    }

    private class ExitAction
    extends guiAction {
        private static final long serialVersionUID = 1505224990952234402L;

        public ExitAction() {
            super(Intl.intl("E&xit"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim.this.quit(true);
        }
    }

    private class RemoveLicenseAction
    extends guiAction {
        private static final long serialVersionUID = 3921008626534333576L;

        public RemoveLicenseAction() {
            super(Intl.intl("&Remove License..."), Actions.createIcon("pyrosim/icons/blank16.gif"));
        }

        private void redirectStream(final InputStream in, final OutputStream out) {
            new Thread(){

                @Override
                public void run() {
                    FDSRunMonitor.redirectStream(out, in);
                }
            }.start();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            block7: {
                String strFiles = PyroSim.this.d_licenseMgr.getLicenseLocation();
                if (strFiles.contains("@")) {
                    JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Unable to remove floating license."), Intl.intl("Invalid License Type"), 0);
                    return;
                }
                int result = JOptionPane.showConfirmDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Permenantly remove license?"), Intl.intl("Remove License"), 2);
                if (result == 0) {
                    try {
                        String[] files = strFiles.split(";");
                        String[] procArgs = new String[files.length + 1];
                        procArgs[0] = String.format("\"%s\"", PyroSim.getApp().getInstallDir() + File.separator + "uacAwareDelete.exe");
                        System.arraycopy(files, 0, procArgs, 1, files.length);
                        Process p = Runtime.getRuntime().exec(procArgs, null, null);
                        this.redirectStream(p.getInputStream(), System.out);
                        this.redirectStream(p.getErrorStream(), System.err);
                        int code = p.waitFor();
                        System.out.printf("uacAwareDelete.exe returned with exit code: %s%n", code);
                        boolean deleted = true;
                        for (String fn : files) {
                            File f = new File(fn);
                            deleted &= !f.exists();
                        }
                        if (deleted) {
                            String[] ccCodes = new String[]{"4180 0800 79", "F702 9441 09", "0596 6901 89", "6397 3748 90", "0862 9511 36", "7803 8309 91", "E728 9052 64", "4941 0445 46", "D956 2798 04", "D469 5095 05"};
                            int i = (int)((double)ccCodes.length * Math.random()) % ccCodes.length;
                            JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("License successfully removed.\n\nConfirmation code:  " + ccCodes[i]), Intl.intl("Remove License"), 2);
                            PyroSim.this.d_licenseMgr.closeLM();
                            PyroSim.this.d_licenseMgr.startFromPrefs(PyroSim.this.getPrefs(), PyroPrefs.LicenseDirProp, PyroPrefs.LicenseServerProp);
                            if (!PyroSim.this.d_licenseMgr.isAuthorized()) {
                                JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("PyroSim is not Licensed and will close."), Intl.intl("PyroSim (Unlicensed)"), 0);
                                PyroSim.getApp().quit();
                                System.exit(0);
                            }
                            break block7;
                        }
                        JOptionPane.showMessageDialog(PyroSim.getApp().getMainFrame(), Intl.intl("Unable to remove license."), Intl.intl("Operation Failed"), 0);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    class PreferencesAction
    extends guiAction {
        private static final long serialVersionUID = -4195888250080653592L;

        public PreferencesAction() {
            super(Intl.intl("&Preferences..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim.this.editPreferences(PreferencesDialog.Tabs.PYROSIM);
        }
    }

    class ExportReactionDatabaseFileAction
    extends guiAction
    implements IEventObserver {
        private static final long serialVersionUID = -3794092544985096221L;

        public ExportReactionDatabaseFileAction() {
            super(Intl.intl("Reaction Database") + "...", PyroGuiUtil.loadPyroSimIcon("reaction16.gif"));
            this.putValue("ShortDescription", Intl.intl("Export Reaction Database"));
            this.setEnabledUpdator(() -> !PyroSim.this.d_mediator.getReactions().flatten().isEmpty());
            PyroSim.this.d_mediator.getEvents().addObserver(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mod = PyroSim.this.getMediator();
            ReactionList man = mod.getReactions();
            Actions.exportToFile(PyroSim.this.getMainFrame(), null, mod, man.flatten(), PyroPrefs.LastFDSDatabaseDirProp.key.toString());
        }

        @Override
        public void update(Events events) {
            if (!events.getAffectedChannels(Reaction.class, new Class[0]).isEmpty()) {
                this.updateEnabled();
            }
        }
    }

    class ExportSurfaceDatabaseFileAction
    extends guiAction
    implements IEventObserver {
        private static final long serialVersionUID = 8282010341995972716L;

        public ExportSurfaceDatabaseFileAction() {
            super(Intl.intl("Surface Database") + "...", PyroGuiUtil.loadPyroSimIcon("surf2.gif"));
            this.putValue("ShortDescription", Intl.intl("Export Surface Database"));
            this.setEnabledUpdator(() -> !PyroSim.this.d_mediator.getSurfaceMgr().flatten().isEmpty());
            PyroSim.this.d_mediator.getEvents().addObserver(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod mod = PyroSim.this.getMediator();
            SurfaceManager man = mod.getSurfaceMgr();
            Actions.exportToFile(PyroSim.this.getMainFrame(), null, mod, man.flatten(), PyroPrefs.LastFDSDatabaseDirProp.key.toString());
        }

        @Override
        public void update(Events events) {
            if (!events.getAffectedChannels(Surface.class, new Class[0]).isEmpty()) {
                this.updateEnabled();
            }
        }
    }

    class ExportFDSFileAction
    extends guiAction {
        private static final long serialVersionUID = -9165823869304520671L;

        public ExportFDSFileAction() {
            super(Intl.intl("FDS File") + "...", PyroGuiUtil.loadTeciIcon("Export16.gif"));
            this.putValue("ShortDescription", Intl.intl("Write FDS File"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroMod pyMod;
            PyroSim app = PyroSim.getApp();
            if (!FdsIoUtil.validateModel(app, pyMod = app.getMediator(), FDSRenderer.RENDER_ORIGIN.DEFAULT)) {
                return;
            }
            File outFile = app.getFDSSaveFile();
            if (outFile == null) {
                return;
            }
            PyroSim.this.writeFDSFile(outFile, false, FDSRenderer.RENDER_ORIGIN.DEFAULT);
        }
    }

    class SaveAsAction
    extends guiAction {
        private static final long serialVersionUID = -5573502808869847714L;

        public SaveAsAction() {
            super(Intl.intl("S&ave As") + "...", PyroGuiUtil.loadTeciIcon("SaveAs16.gif"));
            this.putValue("ShortDescription", Intl.intl("Save As"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim.this.doSave(true);
        }
    }

    class SaveAction
    extends guiAction {
        private static final long serialVersionUID = -3394671309391787050L;

        public SaveAction() {
            super(Intl.intl("&Save"), PyroGuiUtil.loadTeciIcon("Save16.gif"));
            this.putValue("AcceleratorKey", Accelerators.SAVE);
            this.putValue("ShortDescription", Intl.intl("Save"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroSim.this.doSave(false);
        }
    }

    private class OpenAction
    extends guiAction {
        private static final long serialVersionUID = -314777515582078033L;

        public OpenAction() {
            super(Intl.intl("&Open") + "...", Actions.createIcon("thunderheadeng/gui/graphics/Open16.gif"));
            this.putValue("AcceleratorKey", Accelerators.OPEN);
            this.putValue("ShortDescription", Intl.intl("Open"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PyroSim.this.promptSaveIfModified(true)) {
                return;
            }
            File file = PyroSim.getFilenames().getOpenFile((Component)PyroSim.getApp().getMainFrame(), "psm", Intl.intl("PyroSim Model Files"));
            if (file == null) {
                return;
            }
            PyroMod pyMod = PyroSim.this.getMediator();
            OpenModelTask tsk = new OpenModelTask(PyroSim.this, pyMod, file.getAbsolutePath());
            pyMod.getTaskManager().exec((Task)tsk, Intl.intl("Open Model"), 14);
        }
    }

    public class ScreenShotAction
    extends guiAction {
        private static final long serialVersionUID = -4214631769979609605L;

        public ScreenShotAction() {
            super(Intl.intl("Snapshot") + "...", (Icon)null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = PyroSim.getFilenames().getSaveFile((Component)PyroSim.this.getActiveFrame(), PyroSim.getApp().suggestFile("png"), "jpg", Intl.intl("JPEG Files"), "bmp", Intl.intl("BMP Files"), "png", "Portable Network Graphics", "tif", Intl.intl("TIFF Files"), "tga", Intl.intl("TARGA Files"), "gif", "Graphics Interchange Format", "ppm", Intl.intl("PPM Files"));
            if (file == null) {
                return;
            }
            SnapshotDialog dlg = new SnapshotDialog(PyroSim.this.getActiveFrame(), (PyroSim)Application.getApp(), PyroSim.this.d_3dView, file);
            dlg.doModal();
        }
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -1379000806342902795L;

        public NewAction() {
            super(Intl.intl("&New"), PyroGuiUtil.loadTeciIcon("New16.gif"));
            this.putValue("AcceleratorKey", Accelerators.NEW);
            this.putValue("ShortDescription", Intl.intl("New"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PyroSim.this.promptSaveIfModified(true)) {
                PyroSim.this.getMediator().pauseUpdates(false);
                PyroSim.this.resetView();
                PyroMod pyMod = PyroSim.this.getMediator();
                ResetModelTask tsk = new ResetModelTask(pyMod);
                pyMod.getTaskManager().exec((Task)tsk, Intl.intl("New Model"), 6);
                PyroSim.this.getMediator().resumeUpdates();
                PyroSim.this.getMediator().getEvents().changed(PyroSim.this.getMediator(), PyroMod.EVT_MODEL_CHANGED, PyroMod.EVT_FILENAME_CHANGED);
            }
        }
    }

    private class ModifiedDomainListener
    implements IEventObserver {
        private boolean d_modified = false;
        private Vector<Modifiable> d_targets = new Vector();

        private boolean isModifiedEvt(IEventRecord<?> oevts) {
            return oevts.hasAddedObjs() || oevts.hasRemovedObjs() || oevts.hasChangedObjs() && oevts.areChangesExclusiveTo(EventUtil.acceptOnlyModifying());
        }

        @Override
        public void update(Events events) {
            boolean reset = false;
            boolean modified = false;
            IEventRecord<PyroMod> pyromodEvts = events.getEvents(PyroMod.class, new Class[0]);
            reset = reset || pyromodEvts.containsChange(PyroMod.EVT_FILENAME_CHANGED);
            boolean bl = modified = modified || this.isModifiedEvt(pyromodEvts);
            if (pyromodEvts.containsChange(PyroMod.EVT_FDS_RUN_CHANGED) || pyromodEvts.containsChange(PyroMod.EVT_MODEL_CHANGED)) {
                PyroSim.this.setFDSRunMode(((PyroSim)PyroSim.this).d_mediator.getLastFDSRun().mode);
            }
            IEventRecord<Object> otherEvts = events.getEvents(Object.class, FDSObjectRasterization.class, PyroMod.class);
            boolean bl2 = modified = modified || this.isModifiedEvt(otherEvts);
            if (reset) {
                this.reset();
            } else if (modified) {
                this.setModified();
            }
        }

        private void reset() {
            this.d_modified = PyroSim.this.d_forceSavePrompt;
            for (Modifiable target : this.d_targets) {
                target.setModified(false);
            }
            PyroSim.this.updateTitle();
            PyroSim.this.d_backup.setModified(false);
        }

        private void setModified() {
            this.d_modified = true;
            PyroSim.this.d_backup.setModified(true);
            PyroSim.this.updateTitle();
        }

        public void addTarget(Modifiable target) {
            this.d_targets.add(target);
        }

        public boolean isModified() {
            if (this.d_modified) {
                return true;
            }
            for (Modifiable target : this.d_targets) {
                if (!target.isModified()) continue;
                return true;
            }
            return false;
        }
    }

    class FrameDomainListener
    implements IEventObserver {
        public FrameDomainListener() {
            PyroSim.this.updateTitle();
        }

        @Override
        public void update(Events events) {
            for (EventChannel<PyroMod> channel : events.getAffectedChannels(PyroMod.class, new Class[0])) {
                if (!channel.containsChange(PyroMod.EVT_FILENAME_CHANGED)) continue;
                PyroSim.this.updateTitle();
                break;
            }
        }
    }

    class ViewChangeListener
    implements ChangeListener,
    IEventObserver {
        private final Semaphore d_tabLock = new Semaphore(1);

        ViewChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!this.d_tabLock.tryAcquire()) {
                return;
            }
            switch (PyroSim.this.d_mainView.getSelectedIndex()) {
                case 0: {
                    PyroSim.this.setMode(ViewMode.MV_3D);
                    break;
                }
                case 1: {
                    PyroSim.this.setMode(ViewMode.MV_2D);
                    break;
                }
                default: {
                    PyroSim.this.setMode(ViewMode.RECORD);
                }
            }
            this.d_tabLock.release();
        }

        @Override
        public void update(Events events) {
            if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_MODEL_CHANGED)) {
                PyroSim.this.initActiveView();
            } else if (View.isCamChanged(PyroSim.this.d_mediator, events)) {
                PyroSim.this.updateActiveView();
            }
        }

        public void updateActiveView(ViewMode mode) {
            PyroSim.this.updateViewMenu(mode);
            PyroSim.this.updateMainMenuBar();
            PyroSim.this.updateViewLayout(mode);
            if (this.d_tabLock.tryAcquire()) {
                switch (mode) {
                    case MV_2D: {
                        PyroSim.this.d_mainView.setSelectedIndex(1);
                        break;
                    }
                    case MV_3D: {
                        PyroSim.this.d_mainView.setSelectedIndex(0);
                        break;
                    }
                    case RECORD: {
                        PyroSim.this.d_mainView.setSelectedIndex(2);
                    }
                }
                this.d_tabLock.release();
            }
        }
    }

    private class RegisterAction
    extends guiAction {
        private static final long serialVersionUID = -223740323501920782L;

        public RegisterAction() {
            super(Intl.intl("&License") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PyroSim.this.d_licenseMgr == null) {
                System.err.println("null license manager");
                return;
            }
            PyroSim.this.showActivationDialog();
        }
    }
}

