/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import pyrosim.PyroSim;
import pyrosim.domain.GridProcessUtil;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.ModelBackup;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public class PyroPrefs {
    public static final TypedProp<Integer> VERSION = new TypedProp<Integer>((Object)"PyroSim.version", Version.VER_0000.ordinal());
    public static final TypedProp<Boolean> PREF_CHECKLATEST = new TypedProp<Boolean>((Object)"CheckLatest", true);
    public static final TypedProp<String> PREF_LASTLIBRARY = new TypedProp<String>((Object)"LastLib", PyroPrefs.defDatabase());
    public static final TypedProp<Boolean> PREF_FDSPARALLEL_USEMPI = new TypedProp<Boolean>((Object)"FDSParallelUseMpi", true);
    public static final TypedProp<String> PREF_FDSCOMPABILITY = new TypedProp<String>((Object)"FDS.Compability", pyrosim.Version.FDS_DESIGN.toString());
    public static final TypedProp<String> PREF_MPOVLOCATION = new TypedProp<String>((Object)"MPOVLocation", "C:\\Documents and Settings\\birkey\\My Documents\\megapov-1.2.1-windows\\bin\\megapov.exe");
    public static final TypedProp<String> PREF_DXFLOCATION = new TypedProp<String>((Object)"DXFLocation", Application.getApp().getInstallDir() + File.separator + "dxf2fds" + File.separator + "DXF2FDS.exe");
    public static final TypedProp<Boolean> PREF_RUNSV = new TypedProp<Boolean>((Object)"RunSV", true);
    public static final TypedProp<Boolean> PREF_CUT_HOLES = new TypedProp<Boolean>((Object)"Display.cutHoles", true);
    public static final TypedProp<String> PREF_OPTIMIZE_FDS_PROCS = new TypedProp<String>((Object)"FDS.gridProcesses", GridProcessUtil.PREF.BASIC.getPropName());
    public static final TypedProp<String> PREF_MPI_PROC_COUNT = new TypedProp<String>((Object)"FDS.mpiProcCount", GridProcessUtil.PROC_COUNT.PER_CORE.getPropName());
    public static final TypedProp<Boolean> PREF_USEAUTOSAVE = new TypedProp<Boolean>((Object)"UseAutosave", true);
    public static final TypedProp<Boolean> PREF_CREATE_BACKUP_ON_OPEN = new TypedProp<Boolean>((Object)"CreateBackupOnOpen", true);
    public static final UDProp PREF_AUTOSAVE_INTERVAL = new UDProp("AutosaveInterval", ModelBackup.DEF_AUTOSAVE_PERIOD, NonSI.MINUTE);
    public static final TypedProp<Boolean> AUTOSAVE_ON_RUN_FDS = new TypedProp<Boolean>((Object)"AutosaveOnRunFDS", false);
    public static final TypedProp<Boolean> SKIP_UPDATE = new TypedProp<Boolean>((Object)"Update.skip", false);
    public static final TypedProp<String> SKIP_UPDATE_VERSION = new TypedProp<String>((Object)"Update.skipVersion", "");
    public static final TypedProp<Boolean> PROP_ENABLE_FDS_GEOM = new TypedProp<Boolean>((Object)"FDSGeomEnabled", false);
    public static final TypedProp<Boolean> VALIDATE_GEOM = new TypedProp<Boolean>((Object)"PyroPrefs.ValidateGeom", true);
    public static final TypedProp<Boolean> PREF_RECORD_PREVIEW = new TypedProp<Boolean>((Object)"EnableRecordPreview", true);
    public static final TypedProp<Integer> PREF_CLUSTER_NUMHOSTS = new TypedProp<Integer>((Object)"NumHosts", 0);
    public static final TypedProp<Boolean> PREF_DRAWCOLORBUFFER = new SafeModeProp<Boolean>("EnableColorBufferDrawing", false, false);
    public static final TypedProp<Boolean> PREF_DRAWDEPTHBUFFER = new SafeModeProp<Boolean>("EnableDepthBufferDrawing", false, false);
    public static final TypedProp<Boolean> ShowGridProp = new TypedProp<Boolean>((Object)"3D.showGrid", true);
    public static final TypedProp<Boolean> ShowBoundaryProp = new TypedProp<Boolean>((Object)"3D.showBoundary", true);
    public static final TypedProp<Boolean> ShowBoundaryLinesProp = new TypedProp<Boolean>((Object)"3D.showBoundaryLines", false);
    public static final TypedProp<Boolean> UseSVNavProp = new TypedProp<Boolean>((Object)"3D.useSVNav", false);
    public static final TypedProp<Double> DefaultSnapSpacing = new TypedProp<Double>((Object)"FPE.snap.defaultSpacing", 1.0);
    public static final TypedProp<Boolean> ShowSystemMouseProp = new TypedProp<Boolean>((Object)"FPE.mouse.showSystem", true);
    public static final TypedProp<Boolean> ShowGuidesProp = new TypedProp<Boolean>((Object)"FPE.mouse.showGuides", true);
    public static final TypedProp<Boolean> ShowOriginProp = new TypedProp<Boolean>((Object)"FPE.showOrigin", true);
    public static final TypedProp<Boolean> ShowAppearancesProp2D = new TypedProp<Boolean>((Object)"FPE.showTextures", true);
    public static final TypedProp<Boolean> ShowAppearancesProp3D = new TypedProp<Boolean>((Object)"3D.showTextures", true);
    public static final TypedProp<Boolean> ShowOutlinesProp2D = new TypedProp<Boolean>((Object)"FPE.showOutlines", true);
    public static final TypedProp<Boolean> ShowOutlinesProp3D = new TypedProp<Boolean>((Object)"3D.showOutlines", true);
    public static final TypedProp<Boolean> DrawWireframeProp2D = new TypedProp<Boolean>((Object)"FPE.drawWireframe", false);
    public static final TypedProp<Boolean> DrawWireframeProp3D = new TypedProp<Boolean>((Object)"3D.drawWireframe", false);
    public static final TypedProp<Boolean> UseSmoothLightingProp2D = new TypedProp<Boolean>((Object)"FPE.useSmoothLighting", false);
    public static final TypedProp<Boolean> UseSmoothLightingProp3D = new TypedProp<Boolean>((Object)"3D.useSmoothLighting", true);
    public static final TypedProp<Float> RECORD_VIEW_FONTSIZE = new TypedProp<Float>((Object)"RecordViewFontsize", Float.valueOf(12.0f));
    public static final TypedProp<Boolean> SYNTAX_HIGHLIGHT_ENABLE = new TypedProp<Boolean>((Object)"SyntaxHighlightEnable", Boolean.TRUE);
    public static final TypedProp<Integer> SYNTAX_HIGHLIGHT_OBSTHOLELIMIT = new TypedProp<Integer>((Object)"SyntaxHighlightObstHoleLimit", 4000);
    public static final TypedProp<Boolean> RESULTS_DISPLAYGE1 = new TypedProp<Boolean>((Object)"InitSmokeViewGE1", false);
    public static final TypedProp<Boolean> RESULTS_MESHBOUNDS = new TypedProp<Boolean>((Object)"WriteGE1Meshes", true);
    public static final TypedProp<Boolean> RESULTS_WRITEGE1 = new TypedProp<Boolean>((Object)"WriteGE1", false);
    public static final TypedProp<Boolean> RESULTS_WRITEPYROGEOM = new TypedProp<Boolean>((Object)"WritePyroGeom", true);
    public static final TypedProp<Boolean> RESULTS_WRITESMVINI = new TypedProp<Boolean>((Object)"WriteINI", true);
    public static final TypedProp<Boolean> RESULTS_WRITEVIEWS = new TypedProp<Boolean>((Object)"WriteViews", true);
    public static final TypedProp<Boolean> RESULTS_WRITEFLOORS = new TypedProp<Boolean>((Object)"WriteFloors", true);
    public static final TypedProp<Double> DISPLAY_EDGE_ERROR = new TypedProp<Double>((Object)"Display.edgeError", 0.01);
    public static final TypedProp<Double> DISPLAY_FACE_ERROR = new TypedProp<Double>((Object)"Display.faceError", 0.1);
    public static final TypedProp<Integer> LastSlcfDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.slcf", -1);
    public static final TypedProp<Integer> LastSlcfDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.y.slcf", -1);
    public static final TypedProp<Integer> LastPl3dDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.pl3d", -1);
    public static final TypedProp<Integer> LastPl3dDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.y.pl3d", -1);
    public static final TypedProp<Integer> LastBndfDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.bndf", -1);
    public static final TypedProp<Integer> LastBndfDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.y.bndf", -1);
    public static final TypedProp<Integer> LastIsofDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.isof", -1);
    public static final TypedProp<Integer> LastIsofDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.y.isof", -1);
    public static final TypedProp<Integer> LastRampDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.ramp", -1);
    public static final TypedProp<Integer> LastRampDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.y.ramp", -1);
    public static final TypedProp<Integer> LastManageFloorsDlgSizeX = new TypedProp<Integer>((Object)"Dialog.size.x.manageFloors", -1);
    public static final TypedProp<Integer> LastManageFloorsDlgSizeY = new TypedProp<Integer>((Object)"Dialog.size.x.manageFloors", -1);
    public static final TypedProp<Integer> LastHotkeyDlgSizeX = new TypedProp<Integer>((Object)"", -1);
    public static final TypedProp<Integer> LastHotkeyDlgSizeY = new TypedProp<Integer>((Object)"", -1);
    public static final int FDSFORMAT_SCIENTIFIC = 0;
    public static final int FDSFORMAT_ALIGNED = 1;
    public static final int FDSFORMAT_GENERAL = 2;
    public static final TypedProp<Integer> FDSFormatProp = new TypedProp<Integer>((Object)"FDS.format", 2);
    public static final TypedProp<Integer> FDSFormatGenPrecision = new TypedProp<Integer>((Object)"FDS.format.general.precision", 6);
    public static final TypedProp<Integer> FDSFormatAlignedDec = new TypedProp<Integer>((Object)"FDS.format.aligned.numDecimals", 2);
    public static final TypedProp<Integer> FDSFormatAlignedWidth = new TypedProp<Integer>((Object)"FDS.format.aligned.width", 10);
    public static final TypedProp<String> UnitSystemProp = new TypedProp<String>((Object)"PyroSim.UnitSystem", SIUS.getInstance().getSystemName());
    public static final TypedProp<String> LicenseDirProp = new TypedProp<String>((Object)"PyroSim.licenseDir", PyroPrefs.defLicenseDir());
    public static final TypedProp<String> LicenseServerProp = new TypedProp<String>((Object)"PyroSim.licenseServer", "");
    public static final TypedProp<String> LastFDSDatabaseDirProp = new TypedProp<String>((Object)"File.lastDir.FDSDatabase", Application.getApp().getInstallDir() + File.separator + "fds");
    public static final TypedProp<Integer> LastScreenShotWidth = new TypedProp<Integer>((Object)"File.screenShot.width", 1024);
    public static final TypedProp<Integer> LastScreenShotHeight = new TypedProp<Integer>((Object)"File.screenShot.height", 768);
    public static final TypedProp<Boolean> LastScreenShotPyroButton = new TypedProp<Boolean>((Object)"File.screenShot.pyroButton", true);
    public static final TypedProp<Boolean> POVScreenShotAntiAlias = new TypedProp<Boolean>((Object)"File.screenShot.AntiAlias", true);
    public static final TypedProp<Boolean> POVScreenShotShadows = new TypedProp<Boolean>((Object)"File.screenShot.Shadows", true);
    public static final TypedProp<Boolean> POVScreenShotPOVFile = new TypedProp<Boolean>((Object)"File.screenShot.POVFile", false);
    public static final TypedProp<String> FDSFEA_ApiKey = new TypedProp<String>((Object)"FDS.FEA.apiKey", "");
    public static final String FDS_SINGLE = "location";
    public static final String FDS_OPENMP = "openMPLocation";
    public static final String FDS_RUNFDS = "runFDSLocation";
    public static final String FDS_MPIEXEC = "mpiExecLocation";
    public static final String FDS_SMOKEVIEW = "sv.location";
    public static final String FDS_SMPDPORT = "SMPDPort";
    public static final String FDS_CLUSTERPORT = "clusterPort";
    public static final TypedProp<Boolean> RESULTS_OPEN_THROUGH_SOCKET = new TypedProp<Boolean>((Object)"Results.openThroughSocket", true);
    private static final Map<String, String> s_fdsLocPrefs = new HashMap<String, String>();

    private static String installRootPath(String subFolder, String name) {
        File parent = new File(Application.getApp().getInstallDir(), subFolder);
        return new File(parent, name).getAbsolutePath();
    }

    private static String defDatabase() {
        String defDatabaseFilename = "property_library.fds";
        String installDir = Application.getApp().getInstallDir();
        StringBuffer sb = new StringBuffer(installDir);
        sb.append(File.separator);
        sb.append(defDatabaseFilename);
        return sb.toString().replaceAll("/", Matcher.quoteReplacement(File.separator));
    }

    private static String defLicenseDir() {
        String dirSep = File.separator;
        String programData = System.getenv("ALLUSERSPROFILE");
        return programData + dirSep + "Application Data" + dirSep + "PyroSim" + dirSep + "license";
    }

    public static TeciProps instance() {
        return PyroSim.getApp().getPrefs();
    }

    public static double getDouble(TypedProp<Double> prop) {
        return PyroPrefs.instance().getDouble(prop);
    }

    public static UnitDouble getUnitDouble(UDProp prop) {
        return new UnitDouble(PyroPrefs.instance().getDouble(prop), prop.d_storeUnit);
    }

    public static float getFloat(TypedProp<Float> prop) {
        return PyroPrefs.instance().getFloat(prop);
    }

    public static String getString(TypedProp<String> prop) {
        return PyroPrefs.instance().getString(prop);
    }

    public static int getInt(TypedProp<Integer> prop) {
        return PyroPrefs.instance().getInt(prop);
    }

    public static boolean getBoolean(TypedProp<Boolean> prop) {
        return PyroPrefs.instance().getBoolean(prop);
    }

    public static <T> void set(TypedProp<T> prop, T val, boolean saveOnComplete) {
        PyroSim psm = PyroSim.getApp();
        psm.getPrefs().set(prop, val);
        if (saveOnComplete) {
            psm.superSavePreferences();
        }
    }

    public static void set(UDProp prop, UnitDouble val, boolean saveOnComplete) {
        PyroPrefs.set(prop, val.getValue(prop.d_storeUnit), saveOnComplete);
    }

    public static List<SafeModeProp> getSafeModeProps() {
        ArrayList<SafeModeProp> props = new ArrayList<SafeModeProp>();
        try {
            for (Field field : PyroPrefs.class.getFields()) {
                Object val = field.get(null);
                if (!(val instanceof SafeModeProp)) continue;
                props.add((SafeModeProp)val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    public static String getLastVersion() {
        String key = PyroSim.is64Bit() ? "LastVersion.64" : "LastVersion.32";
        return PyroPrefs.instance().getString(key, "2022.3.1208");
    }

    public static void updateLastVersion() {
        String key = PyroSim.is64Bit() ? "LastVersion.64" : "LastVersion.32";
        PyroPrefs.instance().set(key, "2022.3.1208");
    }

    private static String getToolPref(TypedProp<String> key32, TypedProp<String> key64) {
        TypedProp<String> key = PyroPrefs.getToolPrefKey(key32, key64);
        return PyroPrefs.getString(key);
    }

    private static <T> TypedProp<T> getToolPrefKey(TypedProp<T> key32, TypedProp<T> key64) {
        return PyroSim.is64Bit() ? key64 : key32;
    }

    public static String getFDSLocation() {
        return PyroPrefs.getFDSLoc(FDS_SINGLE, true);
    }

    public static String getRunFDSLocation() {
        return PyroPrefs.getFDSLoc(FDS_RUNFDS, true);
    }

    public static String getMPIExecLocation() {
        return PyroPrefs.getFDSLoc(FDS_MPIEXEC, true);
    }

    public static String getSmokeviewLocation() {
        return PyroPrefs.getFDSLoc(FDS_SMOKEVIEW, true);
    }

    public static String getResultsLocation() {
        String installDir = Application.getApp().getInstallDir();
        String resultsLoc = ".";
        if (installDir != null) {
            resultsLoc = installDir;
        }
        ArrayList<String> resultsNames = new ArrayList<String>();
        boolean debug = Application.isDebug();
        if (debug) {
            resultsNames.add("bin/x64/Debug/PyroSimResults/PyroSimResults64_d.exe");
        }
        resultsNames.add("bin/x64/Release/PyroSimResults/PyroSimResults64.exe");
        resultsNames.add("PyroSimResults.exe");
        for (String behemothName : resultsNames) {
            File f = new File(resultsLoc, behemothName);
            if (!f.exists()) continue;
            System.out.println("Results Loc: " + f.getAbsolutePath());
            return f.getAbsolutePath();
        }
        assert (false);
        return null;
    }

    public static String getFDSLoc(String locKey, boolean getDefaultIfUnset) {
        return PyroPrefs.getFDSLoc("2022.3.1208", locKey, getDefaultIfUnset);
    }

    public static String getFDSLoc(String pyroRevision, String locKey, boolean getDefaultIfUnset) {
        String key = PyroPrefs.fdsKey(pyroRevision, locKey, PyroSim.is64Bit());
        String value = PyroPrefs.instance().getString(key, null);
        if (value == null && getDefaultIfUnset) {
            value = s_fdsLocPrefs.get(key);
            assert (value != null);
        }
        return value;
    }

    public static void setFDSLoc(String locKey, String value) {
        PyroPrefs.setFDSLoc("2022.3.1208", locKey, value);
    }

    public static void setFDSLoc(String pyroRevision, String locKey, String value) {
        String key = PyroPrefs.fdsKey(pyroRevision, locKey, PyroSim.is64Bit());
        if (value == null || value.equals(s_fdsLocPrefs.get(key))) {
            PyroPrefs.instance().remove(key);
        } else {
            PyroPrefs.instance().set(key, value);
        }
    }

    private static String fdsKey(String key, boolean is64Bit) {
        return PyroPrefs.fdsKey("2022.3.1208", key, is64Bit);
    }

    private static String fdsKey(String pyroRevision, String fdsKey, boolean is64Bit) {
        String bit = is64Bit ? "64" : "32";
        String key = "PyroSim_" + pyroRevision + ".FDS." + bit + "." + fdsKey;
        return key;
    }

    public static Version getVersion() {
        int ver = PyroPrefs.instance().getInt(VERSION);
        return ver < Version.values().length && ver >= 0 ? Version.values()[ver] : Version.VER_0000;
    }

    public static void save() {
        PyroPrefs.instance().set(VERSION, Integer.valueOf(Version.curr().ordinal()));
    }

    static {
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SINGLE, false), PyroPrefs.installRootPath("fds", "fds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SINGLE, true), PyroPrefs.installRootPath("fds", "fds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_RUNFDS, false), PyroPrefs.installRootPath("fds", "runfds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_RUNFDS, true), PyroPrefs.installRootPath("fds", "runfds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_MPIEXEC, false), PyroPrefs.installRootPath("fds/mpi", "mpiexec.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_MPIEXEC, true), PyroPrefs.installRootPath("fds/mpi", "mpiexec.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SMOKEVIEW, false), PyroPrefs.installRootPath("fds", "smokeview.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SMOKEVIEW, true), PyroPrefs.installRootPath("fds", "smokeview.exe"));
    }

    public static class UDProp
    extends TypedProp<Double> {
        public final Unit d_storeUnit;

        public UDProp(String key, UnitDouble defVal, Unit storeUnit) {
            super((Object)key, defVal.getValue(storeUnit));
            this.d_storeUnit = storeUnit;
        }
    }

    public static class SafeModeProp<T>
    extends TypedProp<T> {
        public final T safeVal;

        public SafeModeProp(String key, T defVal, T safeVal) {
            super((Object)key, defVal);
            this.safeVal = safeVal;
        }
    }

    public static enum Version {
        VER_0000,
        VER_0001,
        VER_0002;


        static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

