/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSimSelectionModel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.treeview.PyroTreeCellEditor;
import pyrosim.treeview.PyroTreeCellRenderer;
import pyrosim.treeview.PyroTreeModel;
import pyrosim.treeview.PyroTreeSelectionHandler;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.AbstractDnDTree;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.ContextMenuListener;
import thunderheadeng.gui.ContextMenuModel;
import thunderheadeng.gui.IDnDTreeModel;
import thunderheadeng.gui.SecondClickRenameListener;
import thunderheadeng.gui.guiAction;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;

public class PyroTreeView
extends AbstractDnDTree
implements ContextMenuModel,
IEventObserver {
    private static final long serialVersionUID = 7688413797899563539L;
    private final PyroMod d_mediator;
    private final PyroTreeModel d_model = (PyroTreeModel)this.getModel();
    private final PyroTreeSelectionHandler d_selectionHandler;
    private final FriendlyExpansionHack d_expansionHack;
    private final SelectionScroller d_selScroll;
    private AutoExpandAction d_autoExpandAction;
    private CollapseAllAction d_collapseAllAction;
    private ExpandAllAction d_expandAllAction;

    public PyroTreeView(PyroMod mediator) {
        super(new PyroTreeModel(mediator));
        this.d_mediator = mediator;
        this.setExpandsSelectedPaths(false);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setScrollsOnExpand(true);
        this.setLargeModel(true);
        this.setSelectNodeOnCollapse(false);
        this.setCellRenderer(new PyroTreeCellRenderer(this, this.d_mediator));
        this.setToggleClickCount(0);
        this.setEditable(true);
        this.setCellEditor(new PyroTreeCellEditor(this.d_mediator, this, (PyroTreeCellRenderer)this.getCellRenderer()));
        this.d_selectionHandler = new PyroTreeSelectionHandler(this.d_mediator, this.getSelectionModel(), (PyroTreeModel)this.getModel());
        this.d_expansionHack = new FriendlyExpansionHack(this, this.d_mediator);
        this.d_selScroll = new SelectionScroller(this, this.d_model);
        this.addMouseListener(new MouseEditListener());
        this.addMouseListener(new PyroSecondClickRenameListener(this));
        this.addMouseListener(new SelectionRemovalListener());
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "EditNode");
        this.getActionMap().put("EditNode", Actions.getEditNodeAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(113, 0), "Rename");
        this.getActionMap().put("Rename", new guiAction(""){
            private static final long serialVersionUID = -5343334185151088404L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Action a = PyroTreeView.this.getRenameAction();
                if (a != null) {
                    a.actionPerformed(e);
                }
            }
        });
        this.addMouseListener(new ContextMenuListener(this));
        this.expandRootNodes();
        this.getInputMap().put((KeyStroke)Actions.getCopyAction().getValue("AcceleratorKey"), "none");
        this.getInputMap().put((KeyStroke)Actions.getPasteAction().getValue("AcceleratorKey"), "none");
        this.getInputMap().put((KeyStroke)Actions.getCutAction().getValue("AcceleratorKey"), "none");
        ToolTipManager.sharedInstance().registerComponent(this);
        this.d_mediator.getEvents().addObserver(this);
    }

    @Override
    public JPopupMenu getContextMenu(MouseEvent e) {
        if (!this.isEnabled()) {
            return null;
        }
        TreePath clickPath = this.getPathForLocation(e.getX(), e.getY());
        if (clickPath == null) {
            this.clearSelection();
            return null;
        }
        if (!this.isPathSelected(clickPath)) {
            this.setSelectionPath(clickPath);
        }
        LinkedIdentityHashSet selSet = new LinkedIdentityHashSet();
        TreePath[] selPaths = this.getSelectionModel().getSelectionPaths();
        for (int i = 0; i < selPaths.length; ++i) {
            selSet.add(selPaths[i].getLastPathComponent());
        }
        return Actions.getContextMenu(selSet);
    }

    private void expandRootNodes() {
        Object root = this.getModel().getRoot();
        for (int m = this.getModel().getChildCount(root) - 1; m >= 0; --m) {
            this.expandRow(m);
        }
    }

    @Override
    public void update(Events events) {
        if (this.d_selectionHandler.lock()) {
            this.d_selectionHandler.unlock();
            this.d_selectionHandler.preUpdate(events);
            this.d_selectionHandler.lock();
            this.d_model.update(events);
            this.d_expansionHack.update(events);
            this.d_selectionHandler.unlock();
            this.d_selectionHandler.update(events);
        }
    }

    public Action getRenameAction() {
        if (this.getSelectionCount() == 1) {
            return this.getRenameAction(this.getSelectionPath());
        }
        return null;
    }

    public Action getRenameAction(TreePath tp) {
        TVEntryPoint<Object> ep = TVEntryPoints.ep(tp.getLastPathComponent());
        if (ep.canRename(this.d_mediator, tp.getLastPathComponent())) {
            return new BeginRenameAction(tp);
        }
        return null;
    }

    private boolean objectsParentIsSelected(Object obj) {
        obj = ((PyroTreeModel)this.getModel()).parentForObject(obj);
        if (obj != null) {
            return this.d_mediator.getSelectionModel().isSelected(obj);
        }
        return false;
    }

    public JToggleButton getAutoExpandButton() {
        if (this.d_autoExpandAction == null) {
            this.d_autoExpandAction = new AutoExpandAction(this);
        }
        return PyroGuiUtil.createToolbarToggleButton(this.d_autoExpandAction);
    }

    public JButton getCollapseAllButton() {
        if (this.d_collapseAllAction == null) {
            this.d_collapseAllAction = new CollapseAllAction();
        }
        return PyroGuiUtil.createToolbarButton(this.d_collapseAllAction);
    }

    public JButton getExpandAllButton() {
        if (this.d_expandAllAction == null) {
            this.d_expandAllAction = new ExpandAllAction();
        }
        return PyroGuiUtil.createToolbarButton(this.d_expandAllAction);
    }

    public int getMaxExpandedLevel() {
        int maxExpandedLevel = 0;
        Enumeration<TreePath> expandedDescendents = this.getExpandedDescendants(this.d_model.pathForObject(this.d_mediator));
        while (expandedDescendents.hasMoreElements()) {
            TreePath path = expandedDescendents.nextElement();
            int level = path.getPathCount();
            if (level <= maxExpandedLevel) continue;
            maxExpandedLevel = level;
        }
        return maxExpandedLevel;
    }

    public void collapseAll(Object obj) {
        this.collapseAll(obj, 2);
    }

    public void collapseAll(Object obj, int minLevel) {
        TVEntryPoint<Object> ep = TVEntryPoints.ep(obj);
        Collection<?> children = ep.getTreeviewChildren(this.d_mediator, obj);
        if (!children.isEmpty()) {
            TreePath path;
            for (Object child : children) {
                this.collapseAll(child, minLevel);
            }
            if (obj != this.d_mediator && (path = this.d_model.pathForObject(obj)) != null && path.getPathCount() >= minLevel) {
                this.collapsePath(path);
            }
        }
    }

    public void expandAll(Object obj) {
        this.expandAll(obj, Integer.MAX_VALUE);
    }

    public void expandAll(Object obj, int maxLevel) {
        TreePath path;
        TVEntryPoint<Object> ep = TVEntryPoints.ep(obj);
        if (ep == null) {
            return;
        }
        Collection<?> children = ep.getTreeviewChildren(this.d_mediator, obj);
        if (!children.isEmpty() && (path = this.d_model.pathForObject(obj)) != null && path.getPathCount() <= maxLevel) {
            this.expandPath(path);
            for (Object child : children) {
                this.expandAll(child, maxLevel);
            }
        }
    }

    private static class AutoExpandAction
    extends BooleanAction {
        private static final long serialVersionUID = -4692230488579176836L;
        private PyroTreeView d_tv;
        public static final Icon ICON = PyroGuiUtil.loadTeciIcon("Refresh16.gif");

        public AutoExpandAction(PyroTreeView tv) {
            super(Intl.intl("Auto Expand Selection"), true, ICON);
            this.d_tv = tv;
            this.d_tv.d_expansionHack.setEnableSelectionTracking(true);
            this.d_tv.d_selScroll.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            boolean newState = !this.d_tv.d_expansionHack.isEnabledSelectionTracking();
            this.d_tv.d_expansionHack.setEnableSelectionTracking(newState);
            this.d_tv.d_selScroll.setEnabled(newState);
            if (newState) {
                PyroMod md = this.d_tv.d_mediator;
                PyroSimSelectionModel sel = md.getSelectionModel();
                Set<?> selObjs = sel.getSelection();
                for (Object o : selObjs) {
                    TreePath path = this.d_tv.d_model.pathForObject(o);
                    if (path == null) continue;
                    this.d_tv.scrollPathToVisible(path);
                }
            }
        }
    }

    private class ExpandAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -1711911466070010077L;

        public ExpandAllAction() {
            super(Intl.intl("Expand"), ((BasicTreeUI)PyroTreeView.this.getUI()).getCollapsedIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroTreeView.this.expandAll(PyroTreeView.this.d_mediator, this.getMaxExpand());
        }

        private int getMaxExpand() {
            int maxExpandedLevel = PyroTreeView.this.getMaxExpandedLevel();
            return maxExpandedLevel < 2 ? 2 : Integer.MAX_VALUE;
        }
    }

    private class CollapseAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -8659650226613495788L;

        public CollapseAllAction() {
            super(Intl.intl("Collapse"), ((BasicTreeUI)PyroTreeView.this.getUI()).getExpandedIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PyroTreeView.this.collapseAll(PyroTreeView.this.d_mediator, this.getMinCollapse());
        }

        private int getMinCollapse() {
            int maxExpandedLevel = PyroTreeView.this.getMaxExpandedLevel();
            return maxExpandedLevel > 2 ? 3 : 2;
        }
    }

    private class DescendentComp
    implements Comparator<TreePath> {
        private final boolean d_forward;

        public DescendentComp() {
            this(true);
        }

        public DescendentComp(boolean forward) {
            this.d_forward = forward;
        }

        @Override
        public int compare(TreePath o1, TreePath o2) {
            int pos;
            if (o1.equals(o2)) {
                return 0;
            }
            int n = pos = this.d_forward ? 1 : -1;
            if (o2.isDescendant(o1)) {
                return pos;
            }
            if (o1.isDescendant(o2)) {
                return -pos;
            }
            return 0;
        }
    }

    private class BeginRenameAction
    extends guiAction {
        private static final long serialVersionUID = 1435889790484787750L;
        private TreePath d_tp;

        private BeginRenameAction(TreePath tp) {
            super(Intl.intl("Rename"));
            this.d_tp = tp;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PyroTreeView.this.startEditingAtPath(this.d_tp);
        }
    }

    private class PyroSecondClickRenameListener
    extends SecondClickRenameListener {
        PyroSecondClickRenameListener(JTree tree) {
            super(tree);
        }

        @Override
        protected boolean canRename(MouseEvent evt, int mouseButtonNumber, TreePath clickPath, TreePath secondClickPath) {
            return PyroTreeView.this.getSelectionModel().isPathSelected(clickPath) && PyroTreeView.this.getPathBounds(clickPath).contains(evt.getPoint()) && mouseButtonNumber == evt.getButton() && evt.getButton() == 1 && evt.getClickCount() == 1 && clickPath.equals(secondClickPath);
        }

        @Override
        protected Action getRenameAction(TreePath pth) {
            return PyroTreeView.this.getRenameAction();
        }
    }

    private class MouseEditListener
    extends MouseAdapter {
        private MouseEditListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            TreePath clickPath = PyroTreeView.this.getPathForLocation(evt.getX(), evt.getY());
            if (clickPath != null && PyroTreeView.this.getSelectionModel().isPathSelected(clickPath) && PyroTreeView.this.getPathBounds(clickPath).contains(evt.getPoint()) && evt.getButton() == 1 && evt.getClickCount() == 2) {
                ActionEvent e = new ActionEvent(evt.getSource(), evt.getID(), evt.paramString());
                guiAction defAction = Actions.getDefaultAction(PyroTreeView.this.d_mediator);
                if (defAction != null) {
                    defAction.actionPerformed(e);
                }
            }
        }
    }

    private class SelectionRemovalListener
    extends MouseAdapter {
        private SelectionRemovalListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            Pair<TreePath, Boolean> path = PyroTreeView.this.getExtendedPathForLocationEx(evt.getX(), evt.getY());
            if (path == null) {
                PyroTreeView.this.d_mediator.getSelectionModel().clearSelection();
            } else if (!(((Boolean)path.v2).booleanValue() || evt.getButton() != 1 || evt.isControlDown() || evt.isShiftDown())) {
                PyroTreeView.this.d_mediator.pauseUpdates();
                PyroTreeView.this.d_mediator.getSelectionModel().clearSelection();
                PyroTreeView.this.d_mediator.getSelectionModel().select(((TreePath)path.v1).getLastPathComponent());
                PyroTreeView.this.d_mediator.resumeUpdates();
            }
        }
    }

    private static class SelectionScroller
    implements TreeSelectionListener {
        private final JTree d_tree;
        private final IDnDTreeModel d_model;
        private boolean d_enabled;

        public SelectionScroller(JTree tree, IDnDTreeModel model) {
            this.d_tree = tree;
            this.d_model = model;
            this.d_tree.addTreeSelectionListener(this);
            this.d_enabled = false;
        }

        public void setEnabled(boolean enabled) {
            this.d_enabled = enabled;
        }

        public boolean isEnabled() {
            return this.d_enabled;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.d_enabled && e.isAddedPath() && !this.d_model.isDragging()) {
                this.d_tree.scrollPathToVisible(e.getNewLeadSelectionPath());
            }
        }
    }

    private class FriendlyExpansionHack {
        private final PyroTreeView d_ptv;
        private boolean d_enableAutoExpand;

        public FriendlyExpansionHack(PyroTreeView ptv, PyroMod mediator) {
            this.d_ptv = ptv;
            this.d_enableAutoExpand = false;
        }

        public void setEnableSelectionTracking(boolean enabled) {
            this.d_enableAutoExpand = enabled;
        }

        public boolean isEnabledSelectionTracking() {
            return this.d_enableAutoExpand;
        }

        public void update(Events events) {
            PyroTreeModel model = (PyroTreeModel)this.d_ptv.getModel();
            if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_MODEL_CHANGED)) {
                TreePath rootPath = model.pathForObject(model.getRoot());
                model.fireTreeStructureChanged(new TreeModelEvent((Object)this, rootPath));
                PyroTreeView.this.expandRootNodes();
                return;
            }
            if (this.d_enableAutoExpand) {
                LinkedIdentityHashSet toExpand = new LinkedIdentityHashSet();
                Set<Object> allAdded = events.getEvents(Object.class, PyroMod.class).getAddedObjs();
                for (EventChannel<Object> channel : events.getAffectedChannels(Object.class, PyroMod.class)) {
                    TVEntryPoint<Class<Object>> ep = TVEntryPoints.ep(channel.getObjectType());
                    if (ep == null) continue;
                    for (Object o : channel.getAddedObjs()) {
                        Object parent = ep.getTreeviewParent(PyroTreeView.this.d_mediator, (Class<Object>)o);
                        if (parent == null || allAdded.contains(parent)) continue;
                        toExpand.add(parent);
                    }
                    PyroSimSelectionModel selModel = PyroTreeView.this.d_mediator.getSelectionModel();
                    Set<Object> changed = channel.getChangedObjs(PyroMod.EVT_SEL);
                    for (Object obj : changed) {
                        Object parent;
                        if (!selModel.isSelected(obj) || selModel.isSelected(parent = ep.getTreeviewParent(PyroTreeView.this.d_mediator, (Class<Object>)obj))) continue;
                        toExpand.add(parent);
                    }
                }
                for (EventChannel<Object> obj : toExpand) {
                    TreePath path = PyroTreeView.this.d_model.pathForObject(obj);
                    if (path == null) continue;
                    PyroTreeView.this.expandPath(path);
                }
            }
        }
    }
}

